
<!-- This code generates the base URL for the website by combining the protocol, domain name, and directory path -->
<?php
session_start();
include('../config.php');
require_once 'includes/check-permission.php';
$currentPage = basename(__FILE__);
checkPageAccessOrRedirect($currentPage, $conn_sa);
?>
<!-- This code generates the base URL for the website by combining the protocol, domain name, and directory path -->

<!-- This code is useful for internal styles  -->
<?php ob_start(); ?>

        <link rel="stylesheet" href="<?php echo $baseUrl; ?>/assets/libs/filepond/filepond.min.css">
        <link rel="stylesheet" href="<?php echo $baseUrl; ?>/assets/libs/filepond-plugin-image-preview/filepond-plugin-image-preview.min.css">
        <link rel="stylesheet" href="<?php echo $baseUrl; ?>/assets/libs/filepond-plugin-image-edit/filepond-plugin-image-edit.min.css">

        <link rel="stylesheet" href="<?php echo $baseUrl; ?>/assets/libs/dragula/dragula.min.css">

<?php $styles = ob_get_clean(); ?>
<!-- This code is useful for internal styles  -->

<!-- This code is useful for content -->
<?php ob_start(); ?>
	
                    <!-- Start::page-header -->
                    <div class="page-header-breadcrumb mb-3">
                        <div class="d-flex align-center justify-content-between flex-wrap">
                            <h1 class="page-title fw-medium fs-18 mb-0">Kanban Board</h1>
                            <ol class="breadcrumb mb-0">
                                <li class="breadcrumb-item"><a href="javascript:void(0);">Apps</a></li>
                                <li class="breadcrumb-item"><a href="javascript:void(0);">Task</a></li>
                                <li class="breadcrumb-item active" aria-current="page">Kanban Board</li>
                            </ol>
                        </div>
                    </div>
                    <!-- End::page-header -->

                    <!-- Start:: row-1 -->
                    <div class="row">
                        <div class="col-xl-12">
                            <div class="card custom-card">
                                <div class="card-body p-3">
                                    <div class="d-sm-flex align-items-center flex-wrap gap-3 kanban-header justify-content-between">
                                        <div class="d-sm-flex align-items-center flex-wrap gap-3 w-sm-50 mb-sm-0 mb-3">
                                            <div class="mb-sm-0 mb-3">
                                                <button class="btn btn-primary me-2" data-bs-toggle="modal" data-bs-target="#add-board"><i class="ri-add-line me-1 fw-medium align-middle"></i>New Board</button>
                                            </div>
                                            <div>
                                                <div class="avatar-list-stacked">
                                                    <span class="avatar avatar-sm avatar-rounded">
                                                        <img src="<?php echo $baseUrl; ?>/assets/images/faces/2.jpg" alt="img">
                                                    </span>
                                                    <span class="avatar avatar-sm avatar-rounded">
                                                        <img src="<?php echo $baseUrl; ?>/assets/images/faces/8.jpg" alt="img">
                                                    </span>
                                                    <span class="avatar avatar-sm avatar-rounded">
                                                        <img src="<?php echo $baseUrl; ?>/assets/images/faces/2.jpg" alt="img">
                                                    </span>
                                                    <span class="avatar avatar-sm avatar-rounded">
                                                        <img src="<?php echo $baseUrl; ?>/assets/images/faces/10.jpg" alt="img">
                                                    </span>
                                                    <span class="avatar avatar-sm avatar-rounded">
                                                        <img src="<?php echo $baseUrl; ?>/assets/images/faces/4.jpg" alt="img">
                                                    </span>
                                                    <span class="avatar avatar-sm avatar-rounded">
                                                        <img src="<?php echo $baseUrl; ?>/assets/images/faces/13.jpg" alt="img">
                                                    </span>
                                                    <a class="avatar avatar-sm bg-primary avatar-rounded text-fixed-white" href="javascript:void(0);">
                                                        +8
                                                    </a>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="d-sm-flex align-items-center flex-wrap justify-content-end gap-3">
                                            <select class="form-control kanban-sortby" data-trigger name="choices-single-default" id="choices-single-default">
                                                <option value="">Sort By</option>
                                                <option value="Newest">Newest</option>
                                                <option value="Date Added">Date Added</option>
                                                <option value="Type">Type</option>
                                                <option value="A - Z">A - Z</option>
                                            </select>
                                            <div class="d-flex mt-sm-0 mt-3" role="search">
                                                <input class="form-control me-2" type="search" placeholder="Search" aria-label="Search">
                                                <button class="btn btn-light" type="submit">Search</button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- End:: row-1 -->

                    <!-- Start::row-2 -->
                    <div class="VYZOR-kanban-board">
                        <div class="kanban-tasks-type new">
                            <div class="pe-3 mb-3">
                                <div class="d-flex justify-content-between align-items-center">
                                    <span class="d-block fw-medium fs-15">New - 04</span>
                                    <div>
                                        <a aria-label="anchor" href="javascript:void(0)" class="btn btn-sm bg-white text-default border btn-wave" data-bs-toggle="modal" data-bs-target="#add-task">
                                            <i class="ri-add-line align-middle me-1 fw-medium"></i>Add Task
                                        </a>
                                    </div>
                                </div>
                            </div>
                            <div class="kanban-tasks" id="new-tasks">
                                <div id="new-tasks-draggable" data-view-btn="new-tasks">
                                    <div class="task-null-background" draggable="false">
                                        <img src="<?php echo $baseUrl; ?>/assets/images/media/media-81.svg" alt="">
                                    </div>
                                    <div class="card custom-card">
                                        <div class="card-body p-0">
                                            <div class="p-3 kanban-board-head">
                                                <div class="d-flex text-muted justify-content-between mb-1 fs-12 fw-medium">
                                                    <div><i class="ri-time-line me-1 align-middle d-inline-block"></i>Created - 28 May</div>
                                                    <div>2 days left</div>
                                                </div>
                                                <div class="d-flex align-items-center justify-content-between">
                                                    <div class="task-badges"><span class="badge">#SPK - 11</span><span class="ms-1 badge">UI/UX</span></div>
                                                    <div class="dropdown">
                                                        <a aria-label="anchor" href="javascript:void(0);" class="btn btn-icon btn-sm btn-white border" data-bs-toggle="dropdown" aria-expanded="false">
                                                            <i class="fe fe-more-vertical"></i>
                                                        </a>
                                                        <ul class="dropdown-menu dropdown-menu-end">
                                                            <li><a class="dropdown-item" href="javascript:void(0);"><i class="ri-eye-line me-1 align-middle d-inline-block"></i>View</a></li>
                                                            <li><a class="dropdown-item" href="javascript:void(0);"><i class="ri-delete-bin-line me-1 align-middle d-inline-block"></i>Delete</a></li>
                                                            <li><a class="dropdown-item" href="javascript:void(0);"><i class="ri-edit-line me-1 align-middle d-inline-block"></i>Edit</a></li>
                                                        </ul>
                                                    </div>
                                                </div>
                                                <div class="kanban-content mt-2">
                                                    <h6 class="fw-medium mb-1 fs-15">New Dashboard design.</h6>
                                                    <div class="kanban-task-description">Lorem ipsum dolor sit amet consectetur adipisicing elit, Nulla soluta consectetur sit amet elit dolor sit amet.</div>
                                                </div>
                                            </div>
                                            <div class="p-3 border-top border-block-start-dashed">
                                                <div class="d-flex align-items-center justify-content-between">
                                                    <div>
                                                        <a href="javascript:void(0);" class="me-2 text-primary">
                                                            <span class="me-1"><i class="ri-thumb-up-fill align-middle fw-normal"></i></span><span class="fw-medium fs-12">12</span>
                                                        </a>
                                                        <a href="javascript:void(0);" class="text-muted">
                                                            <span class="me-1"><i class="ri-message-2-line align-middle fw-normal"></i></span><span class="fw-medium fs-12">02</span>
                                                        </a>
                                                    </div>
                                                    <div class="avatar-list-stacked">
                                                        <span class="avatar avatar-sm avatar-rounded">
                                                            <img src="<?php echo $baseUrl; ?>/assets/images/faces/11.jpg" alt="img">
                                                        </span>
                                                        <span class="avatar avatar-sm avatar-rounded">
                                                            <img src="<?php echo $baseUrl; ?>/assets/images/faces/12.jpg" alt="img">
                                                        </span>
                                                        <span class="avatar avatar-sm avatar-rounded">
                                                            <img src="<?php echo $baseUrl; ?>/assets/images/faces/7.jpg" alt="img">
                                                        </span>
                                                        <span class="avatar avatar-sm avatar-rounded">
                                                            <img src="<?php echo $baseUrl; ?>/assets/images/faces/8.jpg" alt="img">
                                                        </span>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="card custom-card">
                                        <div class="card-body p-0">
                                            <div class="p-3 kanban-board-head">
                                                <div class="d-flex text-muted justify-content-between mb-1 fs-12 fw-medium">
                                                    <div><i class="ri-time-line me-1 align-middle d-inline-block"></i>Created - 30 May</div>
                                                    <div>2 days left</div>
                                                </div>
                                                <div class="d-flex align-items-center justify-content-between">
                                                    <div class="task-badges"><span class="badge">#SPK - 05</span><span class="ms-1 badge">Marketing</span><span class="ms-1 badge">Finance</span></div>
                                                    <div class="dropdown">
                                                        <a aria-label="anchor" href="javascript:void(0);" class="btn btn-icon btn-sm btn-white border" data-bs-toggle="dropdown" aria-expanded="false">
                                                            <i class="fe fe-more-vertical"></i>
                                                        </a>
                                                        <ul class="dropdown-menu dropdown-menu-end">
                                                            <li><a class="dropdown-item" href="javascript:void(0);"><i class="ri-eye-line me-1 align-middle d-inline-block"></i>View</a></li>
                                                            <li><a class="dropdown-item" href="javascript:void(0);"><i class="ri-delete-bin-line me-1 align-middle d-inline-block"></i>Delete</a></li>
                                                            <li><a class="dropdown-item" href="javascript:void(0);"><i class="ri-edit-line me-1 align-middle d-inline-block"></i>Edit</a></li>
                                                        </ul>
                                                    </div>
                                                </div>
                                                <div class="kanban-content mt-2">
                                                    <h6 class="fw-medium mb-1 fs-15">Marketing next projects.</h6>
                                                    <div class="kanban-task-description">Lorem ipsum dolor sit amet consectetur adipisicing elit. Nulla soluta </div>
                                                </div>
                                            </div>
                                            <div class="p-3 border-top border-block-start-dashed">
                                                <div class="d-flex align-items-center justify-content-between">
                                                    <div>
                                                        <a href="javascript:void(0);" class="me-2 text-primary">
                                                            <span class="me-1"><i class="ri-thumb-up-fill align-middle fw-normal"></i></span><span class="fw-medium fs-12">40</span>
                                                        </a>
                                                        <a href="javascript:void(0);" class="text-muted">
                                                            <span class="me-1"><i class="ri-message-2-line align-middle fw-normal"></i></span><span class="fw-medium fs-12">08</span>
                                                        </a>
                                                    </div>
                                                    <div class="avatar-list-stacked">
                                                        <span class="avatar avatar-sm avatar-rounded">
                                                            <img src="<?php echo $baseUrl; ?>/assets/images/faces/13.jpg" alt="img">
                                                        </span>
                                                        <span class="avatar avatar-sm avatar-rounded">
                                                            <img src="<?php echo $baseUrl; ?>/assets/images/faces/6.jpg" alt="img">
                                                        </span>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="card custom-card">
                                        <div class="card-body p-0">
                                            <div class="p-3 kanban-board-head">
                                                <div class="d-flex text-muted justify-content-between mb-1 fs-12 fw-medium">
                                                    <div><i class="ri-time-line me-1 align-middle d-inline-block"></i>Created - 02 Jun</div>
                                                    <div>1 days left</div>
                                                </div>
                                                <div class="d-flex align-items-center justify-content-between">
                                                    <div class="task-badges"><span class="badge">#SPK - 08</span><span class="ms-1 badge">Designing</span></div>
                                                    <div class="dropdown">
                                                        <a aria-label="anchor" href="javascript:void(0);" class="btn btn-icon btn-sm btn-white border" data-bs-toggle="dropdown" aria-expanded="false">
                                                            <i class="fe fe-more-vertical"></i>
                                                        </a>
                                                        <ul class="dropdown-menu dropdown-menu-end">
                                                            <li><a class="dropdown-item" href="javascript:void(0);"><i class="ri-eye-line me-1 align-middle d-inline-block"></i>View</a></li>
                                                            <li><a class="dropdown-item" href="javascript:void(0);"><i class="ri-delete-bin-line me-1 align-middle d-inline-block"></i>Delete</a></li>
                                                            <li><a class="dropdown-item" href="javascript:void(0);"><i class="ri-edit-line me-1 align-middle d-inline-block"></i>Edit</a></li>
                                                        </ul>
                                                    </div>
                                                </div>
                                                <div class="kanban-content mt-2">
                                                    <div class="task-image mt-2">
                                                        <img src="<?php echo $baseUrl; ?>/assets/images/media/media-36.jpg" class="img-fluid rounded kanban-image" alt="">
                                                    </div>
                                                    <h6 class="fw-medium mb-0 mt-2">Design multi usage landing.</h6>
                                                </div>
                                            </div>
                                            <div class="p-3 border-top border-block-start-dashed">
                                                <div class="d-flex align-items-center justify-content-between">
                                                    <div>
                                                        <a href="javascript:void(0);" class="me-2 text-primary">
                                                            <span class="me-1"><i class="ri-thumb-up-fill align-middle fw-normal"></i></span><span class="fw-medium fs-12">16</span>
                                                        </a>
                                                        <a href="javascript:void(0);" class="text-muted">
                                                            <span class="me-1"><i class="ri-message-2-line align-middle fw-normal"></i></span><span class="fw-medium fs-12">28</span>
                                                        </a>
                                                    </div>
                                                    <div class="avatar-list-stacked">
                                                        <span class="avatar avatar-sm avatar-rounded">
                                                            <img src="<?php echo $baseUrl; ?>/assets/images/faces/2.jpg" alt="img">
                                                        </span>
                                                        <span class="avatar avatar-sm avatar-rounded">
                                                            <img src="<?php echo $baseUrl; ?>/assets/images/faces/8.jpg" alt="img">
                                                        </span>
                                                        <span class="avatar avatar-sm avatar-rounded">
                                                            <img src="<?php echo $baseUrl; ?>/assets/images/faces/5.jpg" alt="img">
                                                        </span>
                                                        <span class="avatar avatar-sm avatar-rounded">
                                                            <img src="<?php echo $baseUrl; ?>/assets/images/faces/10.jpg" alt="img">
                                                        </span>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="d-grid view-more-button mt-3">
                                <button class="btn btn-primary-light btn-wave">View More</button>
                            </div>
                        </div>
                        <div class="kanban-tasks-type todo">
                            <div class="pe-3 mb-3">
                                <div class="d-flex justify-content-between align-items-center">
                                    <span class="d-block fw-medium fs-15">Todo - 36</span>
                                    <div>
                                        <a aria-label="anchor" href="javascript:void(0)" class="btn btn-sm bg-white text-default border btn-wave" data-bs-toggle="modal" data-bs-target="#add-task">
                                            <i class="ri-add-line align-middle me-1 fw-medium"></i>Add Task
                                        </a>
                                    </div>
                                </div>
                            </div>
                            <div class="kanban-tasks" id="todo-tasks">
                                <div id="todo-tasks-draggable" data-view-btn="todo-tasks">
                                    <div class="task-null-background" draggable="false">
                                        <img src="<?php echo $baseUrl; ?>/assets/images/media/media-81.svg" alt="">
                                    </div>
                                    <div class="card custom-card">
                                        <div class="card-body p-0">
                                            <div class="p-3 kanban-board-head">
                                                <div class="d-flex text-muted justify-content-between mb-1 fs-12 fw-medium">
                                                    <div><i class="ri-time-line me-1 align-middle d-inline-block"></i>Created - 01 Jun</div>
                                                    <div>10 days left</div>
                                                </div>
                                                <div class="d-flex align-items-center justify-content-between">
                                                    <div class="task-badges"><span class="badge">#SPK - 07</span><span class="ms-1 badge">Admin</span><span class="ms-1 badge">Authentication</span></div>
                                                    <div class="dropdown">
                                                        <a aria-label="anchor" href="javascript:void(0);" class="btn btn-icon btn-sm btn-white border" data-bs-toggle="dropdown" aria-expanded="false">
                                                            <i class="fe fe-more-vertical"></i>
                                                        </a>
                                                        <ul class="dropdown-menu dropdown-menu-end">
                                                            <li><a class="dropdown-item" href="javascript:void(0);"><i class="ri-eye-line me-1 align-middle d-inline-block"></i>View</a></li>
                                                            <li><a class="dropdown-item" href="javascript:void(0);"><i class="ri-delete-bin-line me-1 align-middle d-inline-block"></i>Delete</a></li>
                                                            <li><a class="dropdown-item" href="javascript:void(0);"><i class="ri-edit-line me-1 align-middle d-inline-block"></i>Edit</a></li>
                                                        </ul>
                                                    </div>
                                                </div>
                                                <div class="kanban-content mt-2">
                                                    <h6 class="fw-medium mb-1 fs-15">Adding Authentication Pages.</h6>
                                                    <div class="kanban-task-description">Lorem ipsum dolor sit amet consectetur adipisicing elit. Nulla soluta </div>
                                                </div>
                                            </div>
                                            <div class="p-3 border-top border-block-start-dashed">
                                                <div class="d-flex align-items-center justify-content-between">
                                                    <div>
                                                        <a href="javascript:void(0);" class="me-2 text-primary">
                                                            <span class="me-1"><i class="ri-thumb-up-fill align-middle fw-normal"></i></span><span class="fw-medium fs-12">06</span>
                                                        </a>
                                                        <a href="javascript:void(0);" class="text-muted">
                                                            <span class="me-1"><i class="ri-message-2-line align-middle fw-normal"></i></span><span class="fw-medium fs-12">02</span>
                                                        </a>
                                                    </div>
                                                    <div class="avatar-list-stacked">
                                                        <span class="avatar avatar-sm avatar-rounded">
                                                            <img src="<?php echo $baseUrl; ?>/assets/images/faces/9.jpg" alt="img">
                                                        </span>
                                                        <span class="avatar avatar-sm avatar-rounded">
                                                            <img src="<?php echo $baseUrl; ?>/assets/images/faces/8.jpg" alt="img">
                                                        </span>
                                                        <span class="avatar avatar-sm avatar-rounded">
                                                            <img src="<?php echo $baseUrl; ?>/assets/images/faces/14.jpg" alt="img">
                                                        </span>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="card custom-card">
                                        <div class="card-body p-0">
                                            <div class="p-3 kanban-board-head">
                                                <div class="d-flex text-muted justify-content-between mb-1 fs-12 fw-medium">
                                                    <div><i class="ri-time-line me-1 align-middle d-inline-block"></i>Created - 05 Jun</div>
                                                    <div>14 days left</div>
                                                </div>
                                                <div class="d-flex align-items-center justify-content-between">
                                                    <div class="task-badges"><span class="badge">#SPK - 15</span><span class="ms-1 badge">Planning</span></div>
                                                    <div class="dropdown">
                                                        <a aria-label="anchor" href="javascript:void(0);" class="btn btn-icon btn-sm btn-white border" data-bs-toggle="dropdown" aria-expanded="false">
                                                            <i class="fe fe-more-vertical"></i>
                                                        </a>
                                                        <ul class="dropdown-menu dropdown-menu-end">
                                                            <li><a class="dropdown-item" href="javascript:void(0);"><i class="ri-eye-line me-1 align-middle d-inline-block"></i>View</a></li>
                                                            <li><a class="dropdown-item" href="javascript:void(0);"><i class="ri-delete-bin-line me-1 align-middle d-inline-block"></i>Delete</a></li>
                                                            <li><a class="dropdown-item" href="javascript:void(0);"><i class="ri-edit-line me-1 align-middle d-inline-block"></i>Edit</a></li>
                                                        </ul>
                                                    </div>
                                                </div>
                                                <div class="kanban-content mt-2">
                                                    <div class="task-image mt-2">
                                                        <img src="<?php echo $baseUrl; ?>/assets/images/media/media-41.jpg" class="img-fluid rounded kanban-image" alt="">
                                                    </div>
                                                    <h6 class="fw-medium mb-0 mt-2">New Project Discussion.</h6>
                                                </div>
                                            </div>
                                            <div class="p-3 border-top border-block-start-dashed">
                                                <div class="d-flex align-items-center justify-content-between">
                                                    <div>
                                                        <a href="javascript:void(0);" class="me-2 text-primary">
                                                            <span class="me-1"><i class="ri-thumb-up-fill align-middle fw-normal"></i></span><span class="fw-medium fs-12">17</span>
                                                        </a>
                                                        <a href="javascript:void(0);" class="text-muted">
                                                            <span class="me-1"><i class="ri-message-2-line align-middle fw-normal"></i></span><span class="fw-medium fs-12">06</span>
                                                        </a>
                                                    </div>
                                                    <div class="avatar-list-stacked">
                                                        <span class="avatar avatar-sm avatar-rounded">
                                                            <img src="<?php echo $baseUrl; ?>/assets/images/faces/2.jpg" alt="img">
                                                        </span>
                                                        <span class="avatar avatar-sm avatar-rounded">
                                                            <img src="<?php echo $baseUrl; ?>/assets/images/faces/8.jpg" alt="img">
                                                        </span>
                                                        <span class="avatar avatar-sm avatar-rounded">
                                                            <img src="<?php echo $baseUrl; ?>/assets/images/faces/5.jpg" alt="img">
                                                        </span>
                                                        <span class="avatar avatar-sm avatar-rounded">
                                                            <img src="<?php echo $baseUrl; ?>/assets/images/faces/10.jpg" alt="img">
                                                        </span>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="d-grid view-more-button mt-3">
                                <button class="btn btn-warning-light btn-wave">View More</button>
                            </div>
                        </div>
                        <div class="kanban-tasks-type in-progress">
                            <div class="pe-3 mb-3">
                                <div class="d-flex justify-content-between align-items-center">
                                    <span class="d-block fw-medium fs-15">On Going - 25</span>
                                    <div>
                                        <a aria-label="anchor" href="javascript:void(0)" class="btn btn-sm bg-white text-default border btn-wave" data-bs-toggle="modal" data-bs-target="#add-task">
                                            <i class="ri-add-line align-middle me-1 fw-medium"></i>Add Task
                                        </a>
                                    </div>
                                </div>
                            </div>
                            <div class="kanban-tasks" id="inprogress-tasks">
                                <div id="inprogress-tasks-draggable" data-view-btn="inprogress-tasks">
                                    <div class="task-null-background" draggable="false">
                                        <img src="<?php echo $baseUrl; ?>/assets/images/media/media-81.svg" alt="">
                                    </div>
                                    <div class="card custom-card">
                                        <div class="card-body p-0">
                                            <div class="p-3 kanban-board-head">
                                                <div class="d-flex text-muted justify-content-between mb-1 fs-12 fw-medium">
                                                    <div><i class="ri-time-line me-1 align-middle d-inline-block"></i>Created - 02 Jun</div>
                                                    <div>5 days left</div>
                                                </div>
                                                <div class="d-flex align-items-center justify-content-between">
                                                    <div class="task-badges"><span class="badge">#SPK - 13</span><span class="ms-1 badge">UI Design</span><span class="ms-1 badge">Development</span></div>
                                                    <div class="dropdown">
                                                        <a aria-label="anchor" href="javascript:void(0);" class="btn btn-icon btn-sm btn-white border" data-bs-toggle="dropdown" aria-expanded="false">
                                                            <i class="fe fe-more-vertical"></i>
                                                        </a>
                                                        <ul class="dropdown-menu dropdown-menu-end">
                                                            <li><a class="dropdown-item" href="javascript:void(0);"><i class="ri-eye-line me-1 align-middle d-inline-block"></i>View</a></li>
                                                            <li><a class="dropdown-item" href="javascript:void(0);"><i class="ri-delete-bin-line me-1 align-middle d-inline-block"></i>Delete</a></li>
                                                            <li><a class="dropdown-item" href="javascript:void(0);"><i class="ri-edit-line me-1 align-middle d-inline-block"></i>Edit</a></li>
                                                        </ul>
                                                    </div>
                                                </div>
                                                <div class="kanban-content mt-2">
                                                    <h6 class="fw-medium mb-1 fs-15">Create Calendar & Mail pages.</h6>
                                                    <div class="kanban-task-description">Lorem ipsum dolor sit amet consectetur adipisicing elit. Nulla soluta </div>
                                                </div>
                                            </div>
                                            <div class="p-3 border-top border-block-start-dashed">
                                                <div class="d-flex align-items-center justify-content-between">
                                                    <div>
                                                        <a href="javascript:void(0);" class="me-2 text-primary">
                                                            <span class="me-1"><i class="ri-thumb-up-fill align-middle fw-normal"></i></span><span class="fw-medium fs-12">05</span>
                                                        </a>
                                                        <a href="javascript:void(0);" class="text-muted">
                                                            <span class="me-1"><i class="ri-message-2-line align-middle fw-normal"></i></span><span class="fw-medium fs-12">13</span>
                                                        </a>
                                                    </div>
                                                    <div class="avatar-list-stacked">
                                                        <span class="avatar avatar-sm avatar-rounded">
                                                            <img src="<?php echo $baseUrl; ?>/assets/images/faces/13.jpg" alt="img">
                                                        </span>
                                                        <span class="avatar avatar-sm avatar-rounded">
                                                            <img src="<?php echo $baseUrl; ?>/assets/images/faces/6.jpg" alt="img">
                                                        </span>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="card custom-card">
                                        <div class="card-body p-0">
                                            <div class="p-3 kanban-board-head">
                                                <div class="d-flex text-muted justify-content-between mb-1 fs-12 fw-medium">
                                                    <div><i class="ri-time-line me-1 align-middle d-inline-block"></i>Created - 03 Jun</div>
                                                    <div>12 days left</div>
                                                </div>
                                                <div class="d-flex align-items-center justify-content-between">
                                                    <div class="task-badges"><span class="badge ms-1">#SPK - 09</span><span class="ms-1">Product</span></div>
                                                    <div class="dropdown"> 
                                                        <a aria-label="anchor" href="javascript:void(0);" class="btn btn-icon btn-sm btn-white border" data-bs-toggle="dropdown" aria-expanded="false">
                                                            <i class="fe fe-more-vertical"></i>
                                                        </a>
                                                        <ul class="dropdown-menu dropdown-menu-end">
                                                            <li><a class="dropdown-item" href="javascript:void(0);"><i class="ri-eye-line me-1 align-middle d-inline-block"></i>View</a></li>
                                                            <li><a class="dropdown-item" href="javascript:void(0);"><i class="ri-delete-bin-line me-1 align-middle d-inline-block"></i>Delete</a></li>
                                                            <li><a class="dropdown-item" href="javascript:void(0);"><i class="ri-edit-line me-1 align-middle d-inline-block"></i>Edit</a></li>
                                                        </ul>
                                                    </div>
                                                </div>
                                                <div class="kanban-content mt-2">
                                                    <h6 class="fw-medium mb-1 fs-15">Project design Figma,Sketch.</h6>
                                                    <div class="kanban-task-description">Lorem ipsum dolor sit amet consectetur adipisicing elit. Nulla soluta </div>
                                                </div>
                                            </div>
                                            <div class="p-3 border-top border-block-start-dashed">
                                                <div class="d-flex align-items-center justify-content-between">
                                                    <div>
                                                        <a href="javascript:void(0);" class="me-2 text-primary">
                                                            <span class="me-1"><i class="ri-thumb-up-fill align-middle fw-normal"></i></span><span class="fw-medium fs-12">02</span>
                                                        </a>
                                                        <a href="javascript:void(0);" class="text-muted">
                                                            <span class="me-1"><i class="ri-message-2-line align-middle fw-normal"></i></span><span class="fw-medium fs-12">0</span>
                                                        </a>
                                                    </div>
                                                    <div class="avatar-list-stacked">
                                                        <span class="avatar avatar-sm avatar-rounded">
                                                            <img src="<?php echo $baseUrl; ?>/assets/images/faces/12.jpg" alt="img">
                                                        </span>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="d-grid view-more-button mt-3">
                                <button class="btn btn-info-light btn-wave">View More</button>
                            </div>
                        </div>
                        <div class="kanban-tasks-type inreview">
                            <div class="pe-3 mb-3">
                                <div class="d-flex justify-content-between align-items-center">
                                    <span class="d-block fw-medium fs-15">In Review - 02</span>
                                    <div>
                                        <a aria-label="anchor" href="javascript:void(0)" class="btn btn-sm bg-white text-default border btn-wave" data-bs-toggle="modal" data-bs-target="#add-task">
                                            <i class="ri-add-line align-middle me-1 fw-medium"></i>Add Task
                                        </a>
                                    </div>
                                </div>
                            </div>
                            <div class="kanban-tasks" id="inreview-tasks">
                                <div id="inreview-tasks-draggable" data-view-btn="inreview-tasks">
                                    <div class="task-null-background" draggable="false">
                                        <img src="<?php echo $baseUrl; ?>/assets/images/media/media-81.svg" alt="">
                                    </div>
                                    <div class="card custom-card">
                                        <div class="card-body p-0">
                                            <div class="p-3 kanban-board-head">
                                                <div class="d-flex text-muted justify-content-between mb-1 fs-12 fw-medium">
                                                    <div><i class="ri-time-line me-1 align-middle d-inline-block"></i>Created - 05 Jun</div>
                                                    <div>14 days left</div>
                                                </div>
                                                <div class="d-flex align-items-center justify-content-between">
                                                    <div class="task-badges"><span class="badge">#SPK - 15</span><span class="ms-1 badge">Review</span></div>
                                                    <div class="dropdown">
                                                        <a aria-label="anchor" href="javascript:void(0);" class="btn btn-icon btn-sm btn-white border" data-bs-toggle="dropdown" aria-expanded="false">
                                                            <i class="fe fe-more-vertical"></i>
                                                        </a>
                                                        <ul class="dropdown-menu dropdown-menu-end">
                                                            <li><a class="dropdown-item" href="javascript:void(0);"><i class="ri-eye-line me-1 align-middle d-inline-block"></i>View</a></li>
                                                            <li><a class="dropdown-item" href="javascript:void(0);"><i class="ri-delete-bin-line me-1 align-middle d-inline-block"></i>Delete</a></li>
                                                            <li><a class="dropdown-item" href="javascript:void(0);"><i class="ri-edit-line me-1 align-middle d-inline-block"></i>Edit</a></li>
                                                        </ul>
                                                    </div>
                                                </div>
                                                <div class="kanban-content mt-2">
                                                    <div class="task-image mt-2">
                                                        <img src="<?php echo $baseUrl; ?>/assets/images/media/media-43.jpg" class="img-fluid rounded kanban-image" alt="">
                                                    </div>
                                                    <h6 class="fw-medium mb-0 mt-2">Design Architecture strategy.</h6>
                                                </div>
                                            </div>
                                            <div class="p-3 border-top border-block-start-dashed">
                                                <div class="d-flex align-items-center justify-content-between">
                                                    <div>
                                                        <a href="javascript:void(0);" class="me-2 text-primary">
                                                            <span class="me-1"><i class="ri-thumb-up-fill align-middle fw-normal"></i></span><span class="fw-medium fs-12">09</span>
                                                        </a>
                                                        <a href="javascript:void(0);" class="text-muted">
                                                            <span class="me-1"><i class="ri-message-2-line align-middle fw-normal"></i></span><span class="fw-medium fs-12">35</span>
                                                        </a>
                                                    </div>
                                                    <div class="avatar-list-stacked">
                                                        <span class="avatar avatar-sm avatar-rounded">
                                                            <img src="<?php echo $baseUrl; ?>/assets/images/faces/3.jpg" alt="img">
                                                        </span>
                                                        <span class="avatar avatar-sm avatar-rounded">
                                                            <img src="<?php echo $baseUrl; ?>/assets/images/faces/5.jpg" alt="img">
                                                        </span>
                                                        <span class="avatar avatar-sm avatar-rounded">
                                                            <img src="<?php echo $baseUrl; ?>/assets/images/faces/7.jpg" alt="img">
                                                        </span>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="d-grid view-more-button mt-3">
                                <button class="btn btn-danger-light btn-wave">View More</button>
                            </div>
                        </div>
                        <div class="kanban-tasks-type completed">
                            <div class="pe-3 mb-3">
                                <div class="d-flex justify-content-between align-items-center">
                                    <span class="d-block fw-medium fs-15">Completed - 36</span>
                                    <div>
                                        <a aria-label="anchor" href="javascript:void(0)" class="btn btn-sm bg-white text-default border btn-wave" data-bs-toggle="modal" data-bs-target="#add-task">
                                            <i class="ri-add-line align-middle me-1 fw-medium"></i>Add Task
                                        </a>
                                    </div>
                                </div>
                            </div>
                            <div class="kanban-tasks" id="completed-tasks">
                                <div id="completed-tasks-draggable" data-view-btn="completed-tasks">
                                    <div class="task-null-background" draggable="false">
                                        <img src="<?php echo $baseUrl; ?>/assets/images/media/media-81.svg" alt="">
                                    </div>
                                    <div class="card custom-card">
                                        <div class="card-body p-0">
                                            <div class="p-3 kanban-board-head">
                                                <div class="d-flex text-muted justify-content-between mb-1 fs-12 fw-medium">
                                                    <div><i class="ri-time-line me-1 align-middle d-inline-block"></i>Created - 12 Jun</div>
                                                    <div class="text-success"><i class="ri-check-fill me-1 align-middle d-inline-block"></i>Done</div>
                                                </div>
                                                <div class="d-flex align-items-center justify-content-between">
                                                    <div class="task-badges"><span class="badge">#SPK - 04</span><span class="ms-1 badge">UI/UX</span></div>
                                                    <div class="dropdown">
                                                        <a aria-label="anchor" href="javascript:void(0);" class="btn btn-icon btn-sm btn-white border" data-bs-toggle="dropdown" aria-expanded="false">
                                                            <i class="fe fe-more-vertical"></i>
                                                        </a>
                                                        <ul class="dropdown-menu dropdown-menu-end">
                                                            <li><a class="dropdown-item" href="javascript:void(0);"><i class="ri-eye-line me-1 align-middle d-inline-block"></i>View</a></li>
                                                            <li><a class="dropdown-item" href="javascript:void(0);"><i class="ri-delete-bin-line me-1 align-middle d-inline-block"></i>Delete</a></li>
                                                            <li><a class="dropdown-item" href="javascript:void(0);"><i class="ri-edit-line me-1 align-middle d-inline-block"></i>Edit</a></li>
                                                        </ul>
                                                    </div>
                                                </div>
                                                <div class="kanban-content mt-2">
                                                    <h6 class="fw-medium mb-1 fs-15">Sash project update.</h6>
                                                    <div class="kanban-task-description">Lorem ipsum dolor sit amet consectetur adipisicing elit. Nulla soluta </div>
                                                </div>
                                            </div>
                                            <div class="p-3 border-top border-block-start-dashed">
                                                <div class="d-flex align-items-center justify-content-between">
                                                    <div>
                                                        <a href="javascript:void(0);" class="me-2 text-primary">
                                                            <span class="me-1"><i class="ri-thumb-up-fill align-middle fw-normal"></i></span><span class="fw-medium fs-12">18</span>
                                                        </a>
                                                        <a href="javascript:void(0);" class="text-muted">
                                                            <span class="me-1"><i class="ri-message-2-line align-middle fw-normal"></i></span><span class="fw-medium fs-12">03</span>
                                                        </a>
                                                    </div>
                                                    <div class="avatar-list-stacked">
                                                        <span class="avatar avatar-sm avatar-rounded">
                                                            <img src="<?php echo $baseUrl; ?>/assets/images/faces/6.jpg" alt="img">
                                                        </span>
                                                        <span class="avatar avatar-sm avatar-rounded">
                                                            <img src="<?php echo $baseUrl; ?>/assets/images/faces/13.jpg" alt="img">
                                                        </span>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="card custom-card">
                                        <div class="card-body p-0">
                                            <div class="p-3 kanban-board-head">
                                                <div class="d-flex text-muted justify-content-between mb-1 fs-12 fw-medium">
                                                    <div><i class="ri-time-line me-1 align-middle d-inline-block"></i>Created - 10 Jun</div>
                                                    <div class="text-success"><i class="ri-check-fill me-1 align-middle d-inline-block"></i>Done</div>
                                                </div>
                                                <div class="d-flex align-items-center justify-content-between">
                                                    <div class="task-badges"><span class="badge">#SPK - 10</span><span class="ms-1 badge">Development</span></div>
                                                    <div class="dropdown">
                                                        <a aria-label="anchor" href="javascript:void(0);" class="btn btn-icon btn-sm btn-white border" data-bs-toggle="dropdown" aria-expanded="false">
                                                            <i class="fe fe-more-vertical"></i>
                                                        </a>
                                                        <ul class="dropdown-menu dropdown-menu-end">
                                                            <li><a class="dropdown-item" href="javascript:void(0);"><i class="ri-eye-line me-1 align-middle d-inline-block"></i>View</a></li>
                                                            <li><a class="dropdown-item" href="javascript:void(0);"><i class="ri-delete-bin-line me-1 align-middle d-inline-block"></i>Delete</a></li>
                                                            <li><a class="dropdown-item" href="javascript:void(0);"><i class="ri-edit-line me-1 align-middle d-inline-block"></i>Edit</a></li>
                                                        </ul>
                                                    </div>
                                                </div>
                                                <div class="kanban-content mt-2">
                                                    <h6 class="fw-medium mb-1 fs-15">React JS new version update.</h6>
                                                    <div class="kanban-task-description">Lorem ipsum dolor sit amet consectetur adipisicing elit. Nulla soluta </div>
                                                </div>
                                            </div>
                                            <div class="p-3 border-top border-block-start-dashed">
                                                <div class="d-flex align-items-center justify-content-between">
                                                    <div>
                                                        <a href="javascript:void(0);" class="me-2 text-primary">
                                                            <span class="me-1"><i class="ri-thumb-up-fill align-middle fw-normal"></i></span><span class="fw-medium fs-12">22</span>
                                                        </a>
                                                        <a href="javascript:void(0);" class="text-muted">
                                                            <span class="me-1"><i class="ri-message-2-line align-middle fw-normal"></i></span><span class="fw-medium fs-12">12</span>
                                                        </a>
                                                    </div>
                                                    <div class="avatar-list-stacked">
                                                        <span class="avatar avatar-sm avatar-rounded">
                                                            <img src="<?php echo $baseUrl; ?>/assets/images/faces/10.jpg" alt="img">
                                                        </span>
                                                        <span class="avatar avatar-sm avatar-rounded">
                                                            <img src="<?php echo $baseUrl; ?>/assets/images/faces/11.jpg" alt="img">
                                                        </span>
                                                        <span class="avatar avatar-sm avatar-rounded">
                                                            <img src="<?php echo $baseUrl; ?>/assets/images/faces/1.jpg" alt="img">
                                                        </span>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="card custom-card">
                                        <div class="card-body p-0">
                                            <div class="p-3 kanban-board-head">
                                                <div class="d-flex text-muted justify-content-between mb-1 fs-12 fw-medium">
                                                    <div><i class="ri-time-line me-1 align-middle d-inline-block"></i>Created - 07 Jun</div>
                                                    <div class="text-success"><i class="ri-check-fill me-1 align-middle d-inline-block"></i>Done</div>
                                                </div>
                                                <div class="d-flex align-items-center justify-content-between">
                                                    <div class="task-badges"><span class="badge">#SPK - 16</span><span class="ms-1 badge">Discussion</span></div>
                                                    <div class="dropdown">
                                                        <a aria-label="anchor" href="javascript:void(0);" class="btn btn-icon btn-sm btn-white border" data-bs-toggle="dropdown" aria-expanded="false">
                                                            <i class="fe fe-more-vertical"></i>
                                                        </a>
                                                        <ul class="dropdown-menu dropdown-menu-end">
                                                            <li><a class="dropdown-item" href="javascript:void(0);"><i class="ri-eye-line me-1 align-middle d-inline-block"></i>View</a></li>
                                                            <li><a class="dropdown-item" href="javascript:void(0);"><i class="ri-delete-bin-line me-1 align-middle d-inline-block"></i>Delete</a></li>
                                                            <li><a class="dropdown-item" href="javascript:void(0);"><i class="ri-edit-line me-1 align-middle d-inline-block"></i>Edit</a></li>
                                                        </ul>
                                                    </div>
                                                </div>
                                                <div class="kanban-content mt-2">
                                                    <div class="task-image mt-2">
                                                        <img src="<?php echo $baseUrl; ?>/assets/images/media/media-69.jpg" class="img-fluid rounded kanban-image bg-light" alt="">
                                                    </div>
                                                    <h6 class="fw-medium mb-0 mt-2">Project discussion with client.</h6>
                                                </div>
                                            </div>
                                            <div class="p-3 border-top border-block-start-dashed">
                                                <div class="d-flex align-items-center justify-content-between">
                                                    <div>
                                                        <a href="javascript:void(0);" class="me-2 text-primary">
                                                            <span class="me-1"><i class="ri-thumb-up-fill align-middle fw-normal"></i></span><span class="fw-medium fs-12">11</span>
                                                        </a>
                                                        <a href="javascript:void(0);" class="text-muted">
                                                            <span class="me-1"><i class="ri-message-2-line align-middle fw-normal"></i></span><span class="fw-medium fs-12">05</span>
                                                        </a>
                                                    </div>
                                                    <div class="avatar-list-stacked">
                                                        <span class="avatar avatar-sm avatar-rounded">
                                                            <img src="<?php echo $baseUrl; ?>/assets/images/faces/4.jpg" alt="img">
                                                        </span>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="d-grid view-more-button mt-3">
                                <button class="btn btn-success-light btn-wave">View More</button>
                            </div>
                        </div>
                    </div>
                    <!--End::row-2 -->

                    <!-- Start::add board modal -->
                    <div class="modal fade" id="add-board" tabindex="-1" aria-hidden="true">
                        <div class="modal-dialog modal-dialog-centered">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h6 class="modal-title">Add Board</h6>
                                    <button type="button" class="btn-close" data-bs-dismiss="modal"
                                        aria-label="Close"></button>
                                </div>
                                <div class="modal-body px-4">
                                    <div class="row">
                                        <div class="col-xl-12">
                                            <label for="board-title" class="form-label">Task Board Title</label>
                                            <input type="text" class="form-control" id="board-title" placeholder="Board Title">
                                        </div>
                                    </div>
                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-light"
                                        data-bs-dismiss="modal">Cancel</button>
                                    <button type="button" class="btn btn-primary">Add Board</button>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- End::add board modal -->

                    <!-- Start::add task modal -->
                    <div class="modal fade" id="add-task" tabindex="-1" aria-hidden="true">
                        <div class="modal-dialog modal-dialog-centered">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h6 class="modal-title">Add Task</h6>
                                    <button type="button" class="btn-close" data-bs-dismiss="modal"
                                        aria-label="Close"></button>
                                </div>
                                <div class="modal-body px-4">
                                    <div class="row gy-2">
                                        <div class="col-xl-6">
                                            <label for="task-name" class="form-label">Task Name</label>
                                            <input type="text" class="form-control" id="task-name" placeholder="Task Name">
                                        </div>
                                        <div class="col-xl-6">
                                            <label for="task-id" class="form-label">Task ID</label>
                                            <input type="text" class="form-control" id="task-id" placeholder="Task ID">
                                        </div>
                                        <div class="col-xl-12">
                                            <label for="text-area" class="form-label">Task Description</label>
                                            <textarea class="form-control" id="text-area" rows="2" placeholder="Write Description"></textarea>
                                        </div>
                                        <div class="col-xl-12">
                                            <label for="text-area" class="form-label">Task Images</label>
                                            <input type="file" class="multiple-filepond" name="filepond" multiple data-allow-reorder="true" data-max-file-size="3MB" data-max-files="6">
                                        </div>
                                        <div class="col-xl-12">
                                            <label class="form-label">Assigned To</label>
                                            <select class="form-control" name="choices-multiple-remove-button1" id="choices-multiple-remove-button1" multiple>
                                                <option value="Choice 1">Angelina May</option>
                                                <option value="Choice 2">Kiara advain</option>
                                                <option value="Choice 3">Hercules Jhon</option>
                                                <option value="Choice 4">Mayor Kim</option>
                                            </select>
                                        </div>
                                        <div class="col-xl-6">
                                            <label class="form-label">Target Date</label>
                                            <div class="form-group">
                                                <div class="input-group">
                                                    <div class="input-group-text text-muted"> <i class="ri-calendar-line"></i> </div>
                                                    <input type="text" class="form-control" id="targetDate" placeholder="Choose date and time">
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-xl-6">
                                            <label class="form-label">Tags</label>
                                            <select class="form-control" name="choices-multiple-remove-button2" id="choices-multiple-remove-button2" multiple>
                                                <option value="">Select Tag</option>
                                                <option value="UI/UX">UI/UX</option>
                                                <option value="Marketing">Marketing</option>
                                                <option value="Finance">Finance</option>
                                                <option value="Designing">Designing</option>
                                                <option value="Admin">Admin</option>
                                                <option value="Authentication">Authentication</option>
                                                <option value="Product">Product</option>
                                                <option value="Development">Development</option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-light"
                                        data-bs-dismiss="modal">Cancel</button>
                                    <button type="button" class="btn btn-primary">Add Task</button>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- End::add task modal -->

<?php $content = ob_get_clean(); ?>
<!-- This code is useful for content -->

<!-- This code is useful for internal scripts  -->
<?php ob_start(); ?>
	
        <!-- Filepond JS -->
        <script src="<?php echo $baseUrl; ?>/assets/libs/filepond/filepond.min.js"></script>
        <script src="<?php echo $baseUrl; ?>/assets/libs/filepond-plugin-image-preview/filepond-plugin-image-preview.min.js"></script>
        <script src="<?php echo $baseUrl; ?>/assets/libs/filepond-plugin-image-exif-orientation/filepond-plugin-image-exif-orientation.min.js"></script>
        <script src="<?php echo $baseUrl; ?>/assets/libs/filepond-plugin-file-validate-size/filepond-plugin-file-validate-size.min.js"></script>
        <script src="<?php echo $baseUrl; ?>/assets/libs/filepond-plugin-file-encode/filepond-plugin-file-encode.min.js"></script>
        <script src="<?php echo $baseUrl; ?>/assets/libs/filepond-plugin-image-edit/filepond-plugin-image-edit.min.js"></script>
        <script src="<?php echo $baseUrl; ?>/assets/libs/filepond-plugin-file-validate-type/filepond-plugin-file-validate-type.min.js"></script>
        <script src="<?php echo $baseUrl; ?>/assets/libs/filepond-plugin-file-validate-type/filepond-plugin-file-validate-type.min.js"></script>
        <script src="<?php echo $baseUrl; ?>/assets/libs/filepond-plugin-image-crop/filepond-plugin-image-crop.min.js"></script>
        <script src="<?php echo $baseUrl; ?>/assets/libs/filepond-plugin-image-resize/filepond-plugin-image-resize.min.js"></script>
        <script src="<?php echo $baseUrl; ?>/assets/libs/filepond-plugin-image-transform/filepond-plugin-image-transform.min.js"></script>

        <!-- Flat Picker JS -->
        <script src="<?php echo $baseUrl; ?>/assets/libs/flatpickr/flatpickr.min.js"></script>

        <!-- Dragula JS -->
        <script src="<?php echo $baseUrl; ?>/assets/libs/dragula/dragula.min.js"></script>

        <!-- Internal Task  JS -->
        <script src="<?php echo $baseUrl; ?>/assets/js/task-kanban-board.js"></script>

<?php $scripts = ob_get_clean(); ?>
<!-- This code is useful for internal scripts  -->

<!-- This code use for render base file -->
<?php include 'layouts/base.php'; ?>
<!-- This code use for render base file -->
