<?php
/* =============================================================================
 * File: unit_view.php
 * Purpose: Themed read-only details view for a Unit
 * Stack  : Core PHP + MySQLi (NO PDO). DB in /broker-config.php. Collation: utf8mb4_general_ci
 * ============================================================================= */

date_default_timezone_set('Asia/Kolkata');
@session_start();

/* ---- DB config (ABSOLUTE from docroot) ---- */
require_once 'broker-config.php';
if (!isset($conn) || !($conn instanceof mysqli)) { die('DB connection missing.'); }
include('../config.php');
require_once 'includes/check-permission.php';
$currentPage = basename(__FILE__);
checkPageAccessOrRedirect($currentPage, $conn_sa);
/* ---- Charset & Collation ---- */
mysqli_set_charset($conn,'utf8mb4');
@mysqli_query($conn,"SET NAMES 'utf8mb4' COLLATE 'utf8mb4_general_ci'");
@mysqli_query($conn,"SET collation_connection='utf8mb4_general_ci'");

/* ---- Helpers ---- */
if (!function_exists('h')) { function h($s){ return htmlspecialchars((string)$s, ENT_QUOTES, 'UTF-8'); } }
function format_inr($num){ $num=(float)$num; $sign=$num<0?'-':''; $num=abs($num); $p=explode('.',number_format($num,2,'.','')); $i=$p[0]; $d=$p[1]; if(strlen($i)<=3)return $sign.$i.'.'.$d; $l3=substr($i,-3); $r=substr($i,0,-3); $r=preg_replace('/\B(?=(\d{2})+(?!\d))/',',',$r); return $sign.$r.','.$l3.'.'.$d; }
function inr($n){ return '₹ '.format_inr($n); }

/* ---- Load unit ---- */
$id = isset($_GET['id']) ? (int)$_GET['id'] : 0;
$unit = null;
if ($id>0) {
  $rs = mysqli_query($conn,"SELECT u.*, p.name AS project_name, t.name AS tower_name
                            FROM units u
                            LEFT JOIN projects p ON p.id=u.project_id
                            LEFT JOIN towers t ON t.id=u.tower_id
                            WHERE u.id=$id LIMIT 1");
  if ($rs && mysqli_num_rows($rs)) { $unit = mysqli_fetch_assoc($rs); }
}

/* ---- Base URL ---- */
// $baseUrl = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS']==='on' ? 'https://' : 'http://')
//          . $_SERVER['HTTP_HOST']
//          . str_replace('/pages', '', dirname($_SERVER['SCRIPT_NAME']));

/* ================================ $styles ================================ */
ob_start(); ?>
<link rel="stylesheet" href="<?php echo $baseUrl; ?>/assets/libs/sweetalert2/sweetalert2.min.css">
<style>
  .kv th { width: 42%; }
  .badge-status{ font-size:.8rem; }
</style>
<?php $styles = ob_get_clean();

/* =============================== $content =============================== */
ob_start(); ?>
<div class="page-header-breadcrumb mb-3">
  <div class="d-flex align-center justify-content-between flex-wrap">
    <h1 class="page-title fw-medium fs-18 mb-0">View Unit</h1>
    <ol class="breadcrumb mb-0">
      <li class="breadcrumb-item"><a href="javascript:void(0);">Dashboards</a></li>
      <li class="breadcrumb-item"><a href="javascript:void(0);">Real Estate</a></li>
      <li class="breadcrumb-item active" aria-current="page">Unit Details</li>
    </ol>
  </div>
</div>

<div class="row">
  <div class="col-xl-12">
    <div class="card custom-card">
      <div class="card-header justify-content-between">
        <div class="card-title"><i class="fa fa-info-circle me-2"></i>Unit Details</div>
        <div class="ms-auto">
          <a href="units.php" class="btn btn-outline-secondary btn-sm"><i class="fa fa-arrow-left me-2"></i>Back to Units</a>
        </div>
      </div>
      <div class="card-body">
        <?php if(!$unit): ?>
          <div class="alert alert-warning mb-0">Unit not found.</div>
        <?php else: ?>
          <div class="row">
            <div class="col-md-6">
              <table class="table table-sm kv">
                <tr><th>Project</th><td><?php echo h($unit['project_name']); ?></td></tr>
                <tr><th>Tower</th><td><?php echo h($unit['tower_name']); ?></td></tr>
                <tr><th>Unit No</th><td><span class="badge bg-primary"><?php echo h($unit['unit_no']); ?></span></td></tr>
                <tr><th>Floor</th><td><?php echo h($unit['floor']); ?></td></tr>
                <tr><th>Type</th><td><?php echo h($unit['unit_type']); ?></td></tr>
                <tr><th>Facing</th><td><?php echo h($unit['facing']); ?></td></tr>
                <tr><th>Aspect</th><td><?php echo h($unit['aspect']); ?></td></tr>
                <tr><th>Furnishing</th><td><?php echo h($unit['furnishing']); ?></td></tr>
                <tr><th>Bedrooms</th><td><?php echo h($unit['bedrooms']); ?></td></tr>
                <tr><th>Bathrooms</th><td><?php echo h($unit['bathrooms']); ?></td></tr>
                <tr><th>Balconies</th><td><?php echo h($unit['balconies']); ?></td></tr>
                <tr><th>Parking Slots</th><td><?php echo h($unit['parking_slots']); ?></td></tr>
                <tr><th>Status</th><td>
                  <?php
                    $badge='bg-secondary';
                    if($unit['status']==='Available') $badge='bg-success';
                    elseif($unit['status']==='Hold')  $badge='bg-warning';
                    elseif($unit['status']==='Booked')$badge='bg-danger';
                    elseif($unit['status']==='Blocked')$badge='bg-dark';
                  ?>
                  <span class="badge <?php echo $badge; ?> badge-status"><?php echo h($unit['status']); ?></span>
                </td></tr>
              </table>
            </div>
            <div class="col-md-6">
              <table class="table table-sm kv">
                <tr><th>Saleable Area</th><td><?php echo h($unit['saleable_area']); ?> sqft</td></tr>
                <tr><th>Carpet Area</th><td><?php echo h($unit['carpet_area']); ?> sqft</td></tr>
                <tr><th>Plot Area</th><td><?php echo h($unit['plot_area']); ?> sqyd</td></tr>
                <tr><th>Base Rate</th><td><?php echo inr($unit['base_rate']); ?> /sqft</td></tr>
                <tr><th>PLC Amount</th><td><?php echo inr($unit['plc_amount']); ?></td></tr>
                <tr><th>Other Charges</th><td><?php echo inr($unit['other_charges']); ?></td></tr>
                <tr><th>GST Rate</th><td><?php echo h($unit['gst_rate']); ?>%</td></tr>
                <tr><th>Total Price</th><td><span class="fw-semibold"><?php echo inr($unit['total_price']); ?></span></td></tr>
                <tr><th>Payment Plan</th><td><?php echo h($unit['payment_plan']); ?></td></tr>
                <tr><th>Agreement No</th><td><?php echo h($unit['agreement_no']); ?></td></tr>
                <tr><th>Possession Date</th><td><?php echo h($unit['possession_date']); ?></td></tr>
                <tr><th>Hold Expires At</th><td><?php echo h($unit['hold_expires_at']); ?></td></tr>
                <tr><th>Hold Reason</th><td><?php echo h($unit['hold_reason']); ?></td></tr>
              </table>
            </div>
          </div>

          <div class="mt-3">
            <div class="card-title fs-14 fw-semibold">Customer / Booking</div>
            <table class="table table-sm kv">
              <tr><th>Booking Date</th><td><?php echo h($unit['booking_date']); ?></td></tr>
              <tr><th>Customer Name</th><td><?php echo h($unit['customer_name']); ?></td></tr>
              <tr><th>Customer Mobile</th><td><?php echo h($unit['customer_mobile']); ?></td></tr>
              <tr><th>Token Amount</th><td><?php echo inr($unit['token_amount']); ?></td></tr>
              <tr><th>Booked By (Broker)</th><td><?php echo h($unit['booked_by_broker']); ?></td></tr>
              <tr><th>Remarks</th><td><?php echo nl2br(h($unit['remarks'])); ?></td></tr>
            </table>
          </div>
        <?php endif; ?>
      </div>
    </div>
  </div>
</div>
<?php $content = ob_get_clean();

/* =============================== $scripts =============================== */
ob_start(); ?>
<script src="<?php echo $baseUrl; ?>/assets/libs/sweetalert2/sweetalert2.min.js"></script>
<?php $scripts = ob_get_clean();

/* ------------------------------ Render base ------------------------------ */
include 'layouts/base.php';
