<?php
session_start();
/* ------------------------- Centralized config ------------------------- */
$cfgs = [
  __DIR__ . '../config.php',
  __DIR__ . '/../config.php',
  __DIR__ . '/../../config.php'
];
$cfgFound = false;
foreach ($cfgs as $c) { if (file_exists($c)) { require_once $c; $cfgFound = true; break; } }
if (!$cfgFound) { http_response_code(500); die('config.php not found'); }

/* -------------------------- Pick a mysqli link ------------------------ */
$DB = null;
if (isset($conn_onb)        && $conn_onb instanceof mysqli)        $DB = $conn_onb;
elseif (isset($conn_user)      && $conn_sa instanceof mysqli)        $DB = $conn_user;
if (!$DB instanceof mysqli) { http_response_code(500); exit('DB connection not found - check config.php'); }

require_once 'includes/check-permission.php';
$currentPage = basename(__FILE__);
checkPageAccessOrRedirect($currentPage, $conn_user);

/* -------------------------- Handle Form Submission -------------------- */
$errors = [];
$success = false;

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $role_name = trim($_POST['role_name'] ?? '');
    if ($role_name === '') {
        $errors[] = "Role Name is required.";
    } elseif (strlen($role_name) > 50) {
        $errors[] = "Role Name cannot exceed 50 characters.";
    }
    if (empty($errors)) {
        $stmt = $conn_user->prepare("INSERT INTO roles (role_name, created_at, updated_at) VALUES (?, NOW(), NOW())");
        $stmt->bind_param("s", $role_name);
        if ($stmt->execute()) {
            $success = true;
            header("Location: user-roles.php?msg=Role created successfully");
            exit;
        } else {
            $errors[] = "Database error: " . $conn_user->error;
        }
    }
}
?>

<?php ob_start(); ?>
<link rel="stylesheet" href="<?= $baseUrl; ?>/assets/libs/prismjs/themes/prism-coy.min.css">
<style>
    .form-container { max-width: 500px; margin: 50px auto; }
</style>
<?php $styles = ob_get_clean(); ?>

<?php ob_start(); ?>
<div class="container py-5">
        <div class="d-flex justify-content-between align-items-center mb-4">
            <h2>Create New Role</h2>
            <a href="user-roles.php" class="btn btn-primary">Role List</a>
        </div>
    <div class="form-container">
        <?php if (!empty($errors)): ?>
            <div class="alert alert-danger">
                <?php foreach ($errors as $err): ?>
                    <div><?= htmlspecialchars($err); ?></div>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>

        <form method="POST" action="">
            <div class="mb-3">
                <label for="role_name" class="form-label">Role Name</label>
                <input type="text" name="role_name" id="role_name" class="form-control" value="<?= htmlspecialchars($_POST['role_name'] ?? '') ?>" required maxlength="50">
            </div>

            <button type="submit" class="btn btn-success">Create Role</button>
            <a href="user-roles.php" class="btn btn-secondary">Cancel</a>
        </form>
    </div>
</div>
<?php $content = ob_get_clean(); ?>

<?php ob_start(); ?>
<?php $scripts = ob_get_clean(); ?>

<?php include 'layouts/base.php'; ?>
