<?php
/* admin/applications/view-mou.php
 * Purpose: Display/download MOU file for a given application.
 */

session_start();

require_once __DIR__ . '/../config.php';
require_once 'includes/check-permission.php';
$currentPage = basename(__FILE__);
checkPageAccessOrRedirect($currentPage, $conn_sa);

function h($v){ return htmlspecialchars((string)($v??''), ENT_QUOTES, 'UTF-8'); }

$appId = isset($_GET['id']) ? (int)$_GET['id'] : 0;
if ($appId <= 0) {
    echo 'Invalid application.';
    exit;
}

$stmt = mysqli_prepare($conn, "SELECT mou_file FROM employee_applications WHERE id = ?");
if (!$stmt) {
    echo 'DB error.';
    exit;
}
mysqli_stmt_bind_param($stmt, 'i', $appId);
mysqli_stmt_execute($stmt);
mysqli_stmt_bind_result($stmt, $mouFile);
mysqli_stmt_fetch($stmt);
mysqli_stmt_close($stmt);

if (empty($mouFile)) {
    echo 'No MOU uploaded for this application.';
    exit;
}

// $mouFile is stored as something like "uploads/mou/filename.ext"
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>MOU View</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
</head>
<body style="margin:0;padding:10px;font-family:Arial, sans-serif;">
    <h3>MOU Document</h3>
    <p>
        <a href="/<?= h($mouFile); ?>" target="_blank">Open MOU in new tab</a>
    </p>
    <hr>
    <div style="width:100%;height:80vh;">
        <iframe src="/<?= h($mouFile); ?>" style="width:100%;height:100%;border:1px solid #ccc;"></iframe>
    </div>
</body>
</html>
