<?php
session_start();
include('../config.php');
require_once 'includes/check-permission.php';
$currentPage = basename(__FILE__);
checkPageAccessOrRedirect($currentPage, $conn_sa);
?>
<?php ob_start(); ?>

<?php $styles = ob_get_clean(); ?>
<?php ob_start(); ?>
	
	<!-- Start::page-header -->
	<div class="page-header-breadcrumb mb-3">
		<div class="d-flex align-center justify-content-between flex-wrap">
			<h1 class="page-title fw-medium fs-18 mb-0">Enter Employee Details</h1>
			<ol class="breadcrumb mb-0">
				<li class="breadcrumb-item"><a href="javascript:void(0);">Pages</a></li>
				<li class="breadcrumb-item active" aria-current="page">New Employee</li>
			</ol>
		</div>
	</div>
	<!-- End::page-header -->
	
	<!-- Start::row-1 -->
	<div class="row">
		<div class="col-xl-12">
			<div class="card custom-card">
				<div class="card-body">
					<?php
						$sql = "SELECT empid FROM hr_dump WHERE empid LIKE 'RE%' ORDER BY empid DESC LIMIT 1";
						$result = $conn_ic->query($sql);
						if (!$result) die("Query failed: " . $conn_ic->error);
						$new_empid = $result->num_rows ? "RE" . sprintf("%03d", (int)substr($result->fetch_assoc()['empid'], 2) + 1) : "RE001";
					?>
					<h6>New Employee Code : <?php echo $new_empid; ?></h6>
					
<?php
if (isset($_POST['addEmp'])) {

    // Sanitize inputs (Optional: add more validation as needed)
    $empid = trim($_POST['Employee_Number']);
    $created_by = trim($_POST['created_by']);

    // Prepare INSERT query for `hr_dump`
    $stmt1 = $conn_ic->prepare("
        INSERT INTO hr_dump (
            Employee_Number, empid, Status, Employee_Full_Name, Member_Type, Employment_Status, 
            Date_of_Joining, Team_Name, Role, Department, AMS_Location, Location_of_Work, 
            Functional_Reporting, Functional_Reporting_Name, Reporting_Head_Code, Reporting_Head_Name, 
            Team_Head_Code, Team_Head_Name, Official_Email_Address_Long, Official_Mobile_1, 
            Weekely_Off_Day, Password, created_by
        ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)
    ");

    $stmt1->bind_param("sssssssssssssssssssssss",
        $_POST['Employee_Number'], $empid, $_POST['Status'], $_POST['Employee_Full_Name'], $_POST['Member_Type'],
        $_POST['Employment_Status'], $_POST['Date_of_Joining'], $_POST['Team_Name'], $_POST['Role'],
        $_POST['Department'], $_POST['AMS_Location'], $_POST['Location_of_Work'], $_POST['Functional_Reporting'],
        $_POST['Functional_Reporting_Name'], $_POST['Reporting_Head_Code'], $_POST['Reporting_Head_Name'],
        $_POST['Team_Head_Code'], $_POST['Team_Head_Name'], $_POST['Official_Email_Address_Long'],
        $_POST['Official_Mobile_1'], $_POST['Weekely_Off_Day'], $_POST['Password'], $created_by
    );

    // Prepare INSERT query for `emp_weekoff`
    $stmt2 = $conn_ic->prepare("
        INSERT INTO emp_weekoff (
            empid, Employee_Full_Name, Date_of_Joining, Team_Name, Department, 
            Location_of_Work, Weekely_Off_Day, created_by
        ) VALUES (?, ?, ?, ?, ?, ?, ?, ?)
    ");

    $stmt2->bind_param("ssssssss",
        $empid, $_POST['Employee_Full_Name'], $_POST['Date_of_Joining'],
        $_POST['Team_Name'], $_POST['Department'], $_POST['Location_of_Work'],
        $_POST['Weekely_Off_Day'], $created_by
    );

    // Execute both statements
    $success1 = $stmt1->execute();
    $success2 = $stmt2->execute();

    if ($success1 && $success2) {
        echo "<script>window.location.href='ams-employee-list.php';</script>";
        exit;
    } else {
        echo "<div class='col-md-12 text-center btn btn-danger'><strong>Error:</strong> Unable to submit details. ";
        if (!$success1) echo "HR Dump Error: " . $stmt1->error . " ";
        if (!$success2) echo "Weekoff Error: " . $stmt2->error;
        echo "</div>";
    }

    // Close statements
    $stmt1->close();
    $stmt2->close();
}
?>

					<form class="form-horizontal" name="kyc-form" action="" method="post" enctype="multipart/form-data" autocomplete="off">
						<div class="row">
							<input class="form-control" type="hidden" name="Employee_Number" value="<?php echo $new_empid; ?>" required>
							
							<input class="form-control" type="hidden" name="Status" value="Active"  >
							<div class="col-md-3 col-sm-3 mt-3"><label>Employee Full Name<span class="text-danger">*</span> :</label>
								<input class="form-control" type="text" name="Employee_Full_Name" placeholder="Employee Name" maxlength="55" required >
							</div>
							<div class="col-md-3 col-sm-3 mt-3"><label>Member Type<span class="text-danger">*</span> :</label>
								<select name="Member_Type" class="form-control" required>
									<option value="">-Select-</option>
									<option value="Intern">Intern</option>
									<option value="Retainer">Retainer</option>
									<option value="Salaried">Salaried</option>
								</select>
							</div>
							<div class="col-md-3 col-sm-3 mt-3"><label>Employment Status<span class="text-danger">*</span> :</label>
								<select name="Employment_Status" class="form-control" required>
									<option value="" >-Select-</option>
									<option value="Off Roll">Off Roll</option>
									<option value="On Roll">On Roll</option>
								</select>
							</div>
							<div class="col-md-3 col-sm-3 mt-3"><label>Date of Joining<span class="text-danger">*</span> :</label>
								<input type="date" name="Date_of_Joining" class = "form-control wd8" required>
							</div>
							
							<div class="col-md-3 col-sm-3 mt-3"><label>Team Name<span class="text-danger">*</span> :</label>
								<select class="form-control" name="Team_Name" required>
									<option value="">- Select -</option>
									<?php
									$cat_q = $conn_ic->query("select * from ic_team_name where status='Active' ORDER BY team_name ASC");
									$catCount = $cat_q->num_rows;
									if ($catCount > 0) {
										while ($rowcat = $cat_q->fetch_assoc()) {
											echo '<option value="' . $rowcat['team_name'] . '">' . $rowcat['team_name'] . '</option>';
										}
									} else { echo '<option value="">No catagory available</option>'; }
									?>
								</select>
							</div>
							<div class="col-md-3 col-sm-3 mt-3"><label>Roles<span class="text-danger">*</span> :</label>
								<select name="Role" class="form-control" required>
									<option value="">-Select-</option>
									<option value="Back Office">Back Office</option>
									<option value="Sales">Sales</option>
								</select>
							</div>
							<div class="col-md-3 col-sm-3 mt-3"><label>Department<span class="text-danger">*</span> :</label>
								<select name="Department" class="form-control" required>
									<option value="">-Select-</option>
									<option value="Accounts">Accounts</option>
									<option value="Administration">Administration</option>
									<option value="Billing">Billing</option>
									<option value="Builder Empanelment">Builder Empanelment</option>
									<option value="CRM">CRM</option>
									<option value="Customer Service">Customer Service</option>
									<option value="Digital Media">Digital Media</option>
									<option value="Finance & Accounts">Finance & Accounts</option>
									<option value="Human Resources">Human Resources</option>
									<option value="Legal">Legal</option>
									<option value="Management">Management</option>
									<option value="Operations">Operations</option>
									<option value="Revenue Assurance">Revenue Assurance</option>
									<option value="Sales">Sales</option>
									<option value="Sales Operations">Sales Operations</option>
									<option value="Support">Support</option>
									<option value="Technology">Technology</option>
									<option value="Training & Development">Training & Development</option>
								</select>
								<input class="form-control" type="hidden" name="AMS_Location" value="ALL">
							</div>
							<div class="col-md-3 col-sm-3 mt-3"><label>Location of Work<span class="text-danger">*</span> :</label>
								<select name="Location_of_Work" class="form-control" required>
									<option value="">-Select-</option>
									<option value="Noida-Astralis">Noida-Astralis</option>
									<option value="Noida-Prateek">Noida-Prateek</option>
								</select>
							</div>
							<div class="col-md-3 col-sm-3 mt-3"><label>Functional Reporting Code<span class="text-danger">*</span> :</label>
								<input class="form-control" type="text" name="Functional_Reporting" placeholder="RE000" maxlength="11" required >
							</div>
							<div class="col-md-3 col-sm-3 mt-3"><label>Functional Reporting Name<span class="text-danger">*</span> :</label>
								<input class="form-control" type="text" name="Functional_Reporting_Name" placeholder="Name" maxlength="55" required >
							</div>
							<div class="col-md-3 col-sm-3 mt-3"><label>Reporting Head Code<span class="text-danger">*</span> :</label>
								<input class="form-control" type="text" name="Reporting_Head_Code" placeholder="RE000" maxlength="11" required >
							</div>
							<div class="col-md-3 col-sm-3 mt-3"><label>Reporting Head Name<span class="text-danger">*</span> :</label>
								<input class="form-control" type="text" name="Reporting_Head_Name" placeholder="Name" maxlength="55" required >
							</div>
							<div class="col-md-3 col-sm-3 mt-3"><label>Team Head Code<span class="text-danger">*</span> :</label>
								<input class="form-control" type="text" name="Team_Head_Code" placeholder="RE000" maxlength="11" required >
							</div>
							<div class="col-md-3 col-sm-3 mt-3"><label>Team Head Name<span class="text-danger">*</span> :</label>
								<input class="form-control" type="text" name="Team_Head_Name" placeholder="Name" maxlength="55" required >
							</div>
							<div class="col-md-3 col-sm-3 mt-3"><label>Mobile Number<span class="text-danger">*</span> :</label>
								<input type="tel" class="form-control" name="Official_Mobile_1" pattern="\d{10}" minlength="10" maxlength="10" oninput="this.value = this.value.replace(/\D/g, '').slice(0, 10);" placeholder="Only 10 Digits Mobile No" required>		
							</div>
							<div class="col-md-3 col-sm-3 mt-3"><label>Official Email Address:</label>
								<input class="form-control" type="email" name="Official_Email_Address_Long" placeholder="example@investors-clinic.com" maxlength="55" >
								<input class="form-control" type="hidden" name="Weekely_Off_Day" value="All Tuesday">
							</div>
							<div class="col-md-2 col-sm-2 mt-3"><label>Password<span class="text-danger">*</span> :</label>
								<input class="form-control" type="text" id="Password" name="Password" placeholder="Without Starting 0" maxlength="6" required>
							</div>
							<div class="col-md-2 col-sm-2 mt-3"><label>Generate Password<span class="text-danger">*</span> :</label>
								<input class="form-control btn btn-warning" type="button" onclick="Random();" value="Click Here"><br>
								<input class="form-control" type="hidden" name="created_by" value="<?= isset($_SESSION['user_email']) ? htmlspecialchars($_SESSION['user_email']) : ''; ?>">
							</div>
							<div class="col-md-12 col-sm-12 text-center mt-4">
								<button class="btn btn-success" name="addEmp">Submit Details</button>
							</div>
						</div>
					</form>
				</div>
			</div>
		</div>
	</div>
	<!--End::row-1 -->

<script>
	function Random() {
		var rnd = Math.floor(Math.random() * 1000000);
		document.getElementById('Password').value = rnd;
	}
</script>


<?php $content = ob_get_clean(); ?>
<?php ob_start(); ?>

<?php $scripts = ob_get_clean(); ?>
<?php include 'layouts/base.php'; ?>