<?php
session_start();
include('../config.php');
require_once 'includes/check-permission.php';
$currentPage = basename(__FILE__);
checkPageAccessOrRedirect($currentPage, $conn_sa);
?>
<?php ob_start(); ?>

<?php $styles = ob_get_clean(); ?>
<?php ob_start(); ?>
	
	<!-- Start::page-header -->
	<div class="page-header-breadcrumb mb-3">
		<div class="d-flex align-center justify-content-between flex-wrap">
			<h1 class="page-title fw-medium fs-18 mb-0">Last Month AMS Report</h1>
			<ol class="breadcrumb mb-0">
				<li class="breadcrumb-item"><a href="javascript:void(0);">Pages</a></li>
				<li class="breadcrumb-item active" aria-current="page">Last Month AMS Final Report</li>
			</ol>
		</div>
	</div>
	<!-- End::page-header -->
	
	<!-- Start::row-1 -->
	<div class="row">
		<div class="col-xl-12">
		<div class="card custom-card">
			<div class="card-body table-responsive">
				<a href="ams-final-lm-export.php" class="btn btn-outline-secondary">Export Data</a>
				<div class="card-body table-responsive">
				<table id="hrTable" class="table table-striped table-bordered">
					<thead>
					<tr>
						<th>Emp ID</th>
						<th>Office Date</th>
						<th>In Location</th>
						<th>In Time</th>
						<th>Out Location</th>
						<th>Out Time</th>
						<th>Approval Status</th>
						<th>Status</th>
						<th>Final Status</th>
					</thead>
					<tbody>
					    <?php
                            // Get the first day of last month
                            $start_date = date('Y-m-01', strtotime('first day of last month'));
                            
                            // Get the last day of last month
                            $end_date = date('Y-m-t', strtotime('last day of last month'));
                            
                            $query = "SELECT * FROM ams_final WHERE OfficeDate BETWEEN '$start_date' AND '$end_date' ORDER BY OfficeDate DESC";
                            
                            $result = mysqli_query($conn_ic, $query);
                            $sn = 1; // Start serial number
                            while($data = mysqli_fetch_assoc($result))
                            {
                        ?>
						<tr>
							<td><?php echo $data['empid'] ?></td>
							<td><?php echo $data['OfficeDate'] ?></td>
							<td><?php echo $data['location'] ?></td>
							<td><?php echo $data['InTime'] ?></td>
							<td><?php echo $data['out_location'] ?></td>
							<td><?php echo $data['OutTime'] ?></td>
							<td><?php echo $data['Approval_Status'] ?></td>
							<td><?php echo $data['Status'] ?></td>
							<td><?php echo $data['FinalStatus'] ?></td>
						</tr>
						<?php } ?> 
					</tbody>
				</table>
				</div>
			</div>
		</div>
		</div>
	</div>
	<!--End::row-1 -->
<?php $content = ob_get_clean(); ?>
<?php ob_start(); ?>
<?php $scripts = ob_get_clean(); ?>
<?php include 'layouts/base.php'; ?>