<?php
/* =============================================================================
 * File: boot.php  (place in /home/broriserin/public_html/vyzor/)
 * Purpose: One include to load config, helpers, charset/collation, and baseUrl
 * Stack  : Core PHP + MySQLi (no PDO)
 * DB     : Connection must be in config.php (utf8mb4_general_ci)
 * Usage  : Put this as the FIRST line of any page under /pages:
 *          <?php require_once __DIR__ . '/../boot.php'; ?>
 * ============================================================================= */

@session_start();
date_default_timezone_set('Asia/Kolkata');

/* -- 1) Load DB config (must be alongside this file) -- */
require_once __DIR__ . '/config.php';  // $conn must be defined here (MySQLi)

/* -- 2) Load shared helpers (h(), valid_hex(), slugify()) -- */
require_once __DIR__ . '/app_helpers.php';

/* -- 3) Enforce UTF-8 everywhere (utf8mb4_general_ci) -- */
if (isset($conn) && $conn instanceof mysqli) {
    mysqli_set_charset($conn, 'utf8mb4');
    @mysqli_query($conn, "SET NAMES 'utf8mb4' COLLATE 'utf8mb4_general_ci'");
    @mysqli_query($conn, "SET collation_connection = 'utf8mb4_general_ci'");
}

/* -- 4) Compute $baseUrl once (used by your templates) -- */
if (!isset($baseUrl)) {
    $scheme  = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on') ? 'https://' : 'http://';
    $host    = $_SERVER['HTTP_HOST'] ?? '';
    $dir     = rtrim(str_replace('\\', '/', dirname($_SERVER['SCRIPT_NAME'] ?? '/')), '/');
    $baseUrl = $scheme . $host . ($dir === '' ? '' : $dir);
}
