<?php
session_start();
include('../config.php');
require_once 'includes/check-permission.php';
$currentPage = basename(__FILE__);
checkPageAccessOrRedirect($currentPage, $conn_sa);

/* =============================================================================
 * File: projects.php
 * Purpose: Projects list (Melody theme) with filters & actions
 * Stack  : Core PHP + MySQLi (NO PDO). DB via broker-config.php. Collation: utf8mb4_general_ci
 * Notes  : Uses base layout slots: $styles, $content, $scripts (layouts/base.php)
 * ============================================================================= */

if (session_status() === PHP_SESSION_NONE) { session_start(); }
date_default_timezone_set('Asia/Kolkata');

/* ---- Required includes (as requested) ---- */
require_once 'broker-config.php';
require_once 'functions.php';

/* ---- Ensure DB ready & charset/collation ---- */
if (!isset($conn) || !($conn instanceof mysqli)) { die('DB connection missing.'); }
mysqli_set_charset($conn,'utf8mb4');
@mysqli_query($conn,"SET NAMES 'utf8mb4' COLLATE 'utf8mb4_general_ci'");
@mysqli_query($conn,"SET collation_connection='utf8mb4_general_ci'");

/* ---- Helpers (fallbacks) ---- */
if (!function_exists('h')) { function h($s){ return htmlspecialchars((string)$s,ENT_QUOTES,'UTF-8'); } }
if (!function_exists('getv')) { function getv($k,$d=''){ return isset($_GET[$k]) ? trim($_GET[$k]) : $d; } }

/* ---- Filters ---- */
$q      = getv('q');
$status = getv('status');
$where  = 'WHERE 1=1';
if ($q!==''){
  $q2 = mysqli_real_escape_string($conn,$q);
  $where .= " AND (name LIKE '%$q2%' OR code LIKE '%$q2%' OR city LIKE '%$q2%')";
}
if ($status!==''){
  $st = mysqli_real_escape_string($conn,$status);
  $where .= " AND status='$st'";
}

/* ---- Fetch ---- */
$sql = "SELECT id, code, name, project_type, city, status FROM projects $where ORDER BY updated_at DESC";
$rs  = mysqli_query($conn,$sql);


/* ---- Flash (optional) ---- */
$flash_error = !empty($_SESSION['flash_error']) ? (string)$_SESSION['flash_error'] : '';
$flash_success = !empty($_SESSION['flash_success']) ? (string)$_SESSION['flash_success'] : '';
unset($_SESSION['flash_error'], $_SESSION['flash_success']);

/* ================================ $styles ================================ */
ob_start(); ?>
<link rel="stylesheet" href="<?php echo $baseUrl; ?>/assets/libs/sweetalert2/sweetalert2.min.css">
<style>
  .projects-table .table td, .projects-table .table th { white-space:nowrap; vertical-align:middle; }
</style>
<?php $styles = ob_get_clean();

/* =============================== $content =============================== */
ob_start(); ?>
<!-- Page Header (Melody) -->
<div class="page-header-breadcrumb mb-3">
  <div class="d-flex align-center justify-content-between flex-wrap">
    <h1 class="page-title fw-medium fs-18 mb-0">Projects</h1>
    <ol class="breadcrumb mb-0">
      <li class="breadcrumb-item"><a href="javascript:void(0);">Dashboards</a></li>
      <li class="breadcrumb-item"><a href="javascript:void(0);">Inventory</a></li>
      <li class="breadcrumb-item active" aria-current="page">Projects</li>
    </ol>
  </div>
</div>

<?php if ($flash_error): ?><div class="alert alert-danger"><?php echo h($flash_error); ?></div><?php endif; ?>
<?php if ($flash_success): ?><div class="alert alert-success"><?php echo h($flash_success); ?></div><?php endif; ?>

<div class="card custom-card projects-table">
  <div class="card-header justify-content-between border-bottom-0">
    <div class="card-title">Manage Projects</div>
    <a href="project_form.php" class="btn btn-primary btn-sm"><i class="fa fa-plus me-2"></i>Add Project</a>
  </div>
  <div class="card-body">
    <!-- Filters -->
    <form class="row gy-2 mb-3 align-items-end" method="get">
      <div class="col-md-6">
        <label class="form-label mb-1 text-muted small">Search</label>
        <div class="input-group">
          <span class="input-group-text"><i class="fa fa-search"></i></span>
          <input type="text" name="q" class="form-control" placeholder="Search by name / code / city" value="<?php echo h($q); ?>">
        </div>
      </div>
      <div class="col-md-3">
        <label class="form-label mb-1 text-muted small">Status</label>
        <select name="status" class="form-control">
          <option value="">All Status</option>
          <option value="Active"   <?php echo $status==='Active'?'selected':''; ?>>Active</option>
          <option value="Inactive" <?php echo $status==='Inactive'?'selected':''; ?>>Inactive</option>
        </select>
      </div>
      <div class="col-md-3 d-grid">
        <button class="btn btn-primary"><i class="fa fa-filter me-1"></i>Filter</button>
      </div>
    </form>

    <!-- Table -->
    <div class="table-responsive">
      <table class="table table-hover">
        <thead>
          <tr>
            <th>Code</th>
            <th>Name</th>
            <th>Type</th>
            <th>City</th>
            <th>Status</th>
            <th class="text-end">Actions</th>
          </tr>
        </thead>
        <tbody>
          <?php while($r = $rs && mysqli_fetch_assoc($rs) ? $r = mysqli_fetch_assoc($rs) : null) { /* empty */ } ?>
          <?php if ($rs && mysqli_num_rows($rs)>0): ?>
            <?php mysqli_data_seek($rs, 0); while($r = mysqli_fetch_assoc($rs)): ?>
              <?php
                $badge = ($r['status']==='Active') ? 'bg-success' : 'bg-secondary';
              ?>
              <tr>
                <td><?php echo h($r['code']); ?></td>
                <td><?php echo h($r['name']); ?></td>
                <td><?php echo h($r['project_type']); ?></td>
                <td><?php echo h($r['city']); ?></td>
                <td><span class="badge <?php echo $badge; ?>"><?php echo h($r['status']); ?></span></td>
                <td class="text-end">
                  <a class="btn btn-sm btn-outline-primary me-2" href="project_form.php?id=<?php echo (int)$r['id']; ?>"><i class="fa fa-edit me-1"></i>Edit</a>
                  <a class="btn btn-sm btn-outline-danger" href="project_delete.php?id=<?php echo (int)$r['id']; ?>" onclick="return confirm('Delete project?')"><i class="fa fa-trash me-1"></i>Delete</a>
                </td>
              </tr>
            <?php endwhile; ?>
          <?php else: ?>
            <tr><td colspan="6" class="text-center text-muted">No projects found.</td></tr>
          <?php endif; ?>
        </tbody>
      </table>
    </div>
  </div>
</div>
<?php $content = ob_get_clean();

/* =============================== $scripts =============================== */
ob_start(); ?>
<script src="<?php echo $baseUrl; ?>/assets/libs/sweetalert2/sweetalert2.min.js"></script>
<?php $scripts = ob_get_clean();

/* ------------------------------ Render base ------------------------------ */
include 'layouts/base.php';
