
<!-- This code generates the base URL for the website by combining the protocol, domain name, and directory path -->
<?php
session_start();
include('../config.php');
require_once 'includes/check-permission.php';
$currentPage = basename(__FILE__);
checkPageAccessOrRedirect($currentPage, $conn_sa);
?>
<!-- This code generates the base URL for the website by combining the protocol, domain name, and directory path -->

<!-- This code is useful for internal styles  -->
<?php ob_start(); ?>

        <link rel="stylesheet" href="<?php echo $baseUrl; ?>/assets/libs/nouislider/nouislider.min.css">

<?php $styles = ob_get_clean(); ?>
<!-- This code is useful for internal styles  -->

<!-- This code is useful for content -->
<?php ob_start(); ?>
	
                    <!-- Start::page-header -->
                    <div class="page-header-breadcrumb mb-3">
                        <div class="d-flex align-center justify-content-between flex-wrap">
                            <h1 class="page-title fw-medium fs-18 mb-0">Search Jobs</h1>
                            <ol class="breadcrumb mb-0">
                                <li class="breadcrumb-item"><a href="javascript:void(0);">Dashboards</a></li>
                                <li class="breadcrumb-item"><a href="javascript:void(0);">Jobs</a></li>
                                <li class="breadcrumb-item active" aria-current="page">Search Jobs</li>
                            </ol>
                        </div>
                    </div>
                    <!-- End::page-header -->

                    <!-- Start::row-2 -->
                    <div class="row">
                        <div class="col-xxl-3">
                            <div class="card custom-card products-navigation-card">
                                <div class="card-body p-0">
                                    <div class="py-4 px-sm-4 p-3 border-bottom">
                                        <h6 class="fw-medium mb-0">Categories</h6>
                                        <div class="px-sm-2 px-0 py-3 pb-0">
                                            <div class="form-check mb-2">
                                                <input class="form-check-input" type="checkbox" value="" id="c-1" checked>
                                                <label class="form-check-label" for="c-1">
                                                    Software Engineer
                                                </label>
                                                <span class="badge bg-light text-default fw-500 float-end">2,712</span>
                                            </div>
                                            <div class="form-check mb-2">
                                                <input class="form-check-input" type="checkbox" value="" id="c-2">
                                                <label class="form-check-label" for="c-2">
                                                    Data Analyst
                                                </label>
                                                <span class="badge bg-light text-default fw-500 float-end">536</span>
                                            </div>
                                            <div class="form-check mb-2">
                                                <input class="form-check-input" type="checkbox" value="" id="c-3" checked>
                                                <label class="form-check-label" for="c-3">
                                                    Product Manager
                                                </label>
                                                <span class="badge bg-light text-default fw-500 float-end">18,289</span>
                                            </div>
                                            <div class="form-check mb-2">
                                                <input class="form-check-input" type="checkbox" value="" id="c-4" checked>
                                                <label class="form-check-label" for="c-4">
                                                    UI/UX Designer
                                                </label>
                                                <span class="badge bg-light text-default fw-500 float-end">3,453</span>
                                            </div>
                                            <div class="form-check mb-2">
                                                <input class="form-check-input" type="checkbox" value="" id="c-5">
                                                <label class="form-check-label" for="c-5">
                                                    Marketing Specialist
                                                </label>
                                                <span class="badge bg-light text-default fw-500 float-end">7,165</span>
                                            </div>
                                            <div class="collapse" id="category-more">
                                                <div class="form-check mb-2">
                                                    <input class="form-check-input" type="checkbox" value="" id="c-6">
                                                    <label class="form-check-label" for="c-6">
                                                        HR Manager
                                                    </label>
                                                    <span class="badge bg-light text-default fw-500 float-end">5,964</span>
                                                </div>
                                                <div class="form-check mb-2">
                                                    <input class="form-check-input" type="checkbox" value="" id="c-7">
                                                    <label class="form-check-label" for="c-7">
                                                        Full Stack Developer
                                                    </label>
                                                    <span class="badge bg-light text-default fw-500 float-end">2,123</span>
                                                </div>
                                                <div class="form-check mb-2">
                                                    <input class="form-check-input" type="checkbox" value="" id="c-8">
                                                    <label class="form-check-label" for="c-8">
                                                        Network Administrator
                                                    </label>
                                                    <span class="badge bg-light text-default fw-500 float-end">2,123</span>
                                                </div>
                                                <div class="form-check mb-2">
                                                    <input class="form-check-input" type="checkbox" value="" id="c-9">
                                                    <label class="form-check-label" for="c-9">
                                                        Sales Manager
                                                    </label>
                                                    <span class="badge bg-light text-default fw-500 float-end">2,123</span>
                                                </div>
                                                <div class="form-check mb-2">
                                                    <input class="form-check-input" type="checkbox" value="" id="c-10">
                                                    <label class="form-check-label" for="c-10">
                                                        Customer Support Lead
                                                    </label>
                                                    <span class="badge bg-light text-default fw-500 float-end">2,123</span>
                                                </div>
                                            </div>
                                            <a class="ecommerce-more-link badge bg-primary-transparent" data-bs-toggle="collapse" href="#category-more" role="button" aria-expanded="false" aria-controls="category-more">More</a>
                                        </div>
                                    </div>
                                    <div class="py-4 px-sm-4 p-3 border-bottom">
                                        <h6 class="fw-medium mb-0">Shift Type</h6>
                                        <div class="px-sm-2 px-0 py-3 pb-0">
                                            <div class="form-check mb-2">
                                                <input class="form-check-input" type="checkbox" value="" id="j-1" checked>
                                                <label class="form-check-label" for="j-1">
                                                    Day Shift
                                                </label>
                                                <span class="badge bg-light text-default fw-500 float-end">512</span>
                                            </div>
                                            <div class="form-check mb-2">
                                                <input class="form-check-input" type="checkbox" value="" id="j-2" checked>
                                                <label class="form-check-label" for="j-2">
                                                    Night Shift
                                                </label>
                                                <span class="badge bg-light text-default fw-500 float-end">2,186</span>
                                            </div>
                                            <div class="form-check mb-2">
                                                <input class="form-check-input" type="checkbox" value="" id="j-3" checked>
                                                <label class="form-check-label" for="j-3">
                                                    Flexible
                                                </label>
                                                <span class="badge bg-light text-default fw-500 float-end">734</span>
                                            </div>
                                            <div class="form-check mb-2">
                                                <input class="form-check-input" type="checkbox" value="" id="j-4">
                                                <label class="form-check-label" for="j-4">
                                                    Rotational
                                                </label>
                                                <span class="badge bg-light text-default fw-500 float-end">16</span>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="py-4 px-sm-4 p-3 border-bottom">
                                        <h6 class="fw-medium mb-0">Salary Range</h6>
                                        <div class="px-sm-2 px-0 py-3 pb-0">
                                            <div id="nonlinear"></div>
                                            <div class="d-flex mt-4 flex-wrap">
                                                <div class="fw-medium h6 mb-0">$<span id="lower-value"></span></div>
                                                &nbsp; -- &nbsp; 
                                                <div class="fw-medium h6 mb-0">$<span id="upper-value"></span></div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="py-4 px-sm-4 p-3 border-bottom">
                                        <h6 class="fw-medium mb-0">Qualification</h6>
                                        <div class="px-sm-2 px-0 py-3 pb-0">
                                            <div class="form-check mb-2">
                                                <input class="form-check-input" type="checkbox" value="" id="q-1">
                                                <label class="form-check-label" for="q-1">
                                                    Computer Science
                                                </label>
                                                <span class="badge bg-light text-default fw-500 float-end">16,563</span>
                                            </div>
                                            <div class="form-check mb-2">
                                                <input class="form-check-input" type="checkbox" value="" id="q-2" checked>
                                                <label class="form-check-label" for="q-2">
                                                    Marketing
                                                </label>
                                                <span class="badge bg-light text-default fw-500 float-end">15,234</span>
                                            </div>
                                            <div class="form-check mb-2">
                                                <input class="form-check-input" type="checkbox" value="" id="q-3">
                                                <label class="form-check-label" for="q-3">
                                                    Design
                                                </label>
                                                <span class="badge bg-light text-default fw-500 float-end">6,278</span>
                                            </div>
                                            <div class="form-check mb-2">
                                                <input class="form-check-input" type="checkbox" value="" id="q-4" checked>
                                                <label class="form-check-label" for="q-4">
                                                    Business
                                                </label>
                                                <span class="badge bg-light text-default fw-500 float-end">4,531</span>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value="" id="q-5">
                                                <label class="form-check-label" for="q-5">
                                                    HR Management
                                                </label>
                                                <span class="badge bg-light text-default fw-500 float-end">2,405</span>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value="" id="q-6">
                                                <label class="form-check-label" for="q-6">
                                                    Product Management
                                                </label>
                                                <span class="badge bg-light text-default fw-500 float-end">453</span>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value="" id="q-7">
                                                <label class="form-check-label" for="q-7">
                                                    Web Development
                                                </label>
                                                <span class="badge bg-light text-default fw-500 float-end">123</span>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value="" id="q-8">
                                                <label class="form-check-label" for="q-8">
                                                    IT
                                                </label>
                                                <span class="badge bg-light text-default fw-500 float-end">422</span>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value="" id="q-9">
                                                <label class="form-check-label" for="q-9">
                                                    Customer Service
                                                </label>
                                                <span class="badge bg-light text-default fw-500 float-end">256</span>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="py-4 px-sm-4 p-3">
                                        <h6 class="fw-medium mb-0">Experience</h6>
                                        <div class="px-sm-2 px-0 py-3 pb-0">
                                            <div class="form-check mb-2">
                                                <input class="form-check-input" type="checkbox" value="" id="e-1" checked>
                                                <label class="form-check-label" for="e-1">
                                                    1-3 years
                                                </label>
                                                <span class="badge bg-light text-default fw-500 float-end">156</span>
                                            </div>
                                            <div class="form-check mb-2">
                                                <input class="form-check-input" type="checkbox" value="" id="e-2">
                                                <label class="form-check-label" for="e-2">
                                                    2-4 years
                                                </label>
                                                <span class="badge bg-light text-default fw-500 float-end">632</span>
                                            </div>
                                            <div class="form-check mb-2">
                                                <input class="form-check-input" type="checkbox" value="" id="e-3" checked>
                                                <label class="form-check-label" for="e-3">
                                                    3-5 years
                                                </label>
                                                <span class="badge bg-light text-default fw-500 float-end">32</span>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value="" id="e-4" checked>
                                                <label class="form-check-label" for="e-4">
                                                    4-6 years
                                                </label>
                                                <span class="badge bg-light text-default fw-500 float-end">54</span>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value="" id="e-5" checked>
                                                <label class="form-check-label" for="e-5">
                                                    5+ years
                                                </label>
                                                <span class="badge bg-light text-default fw-500 float-end">44</span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-xxl-9">
                            <div class="row">
                                <div class="col-lg-12">
                                    <div class="input-group companies-search-input mb-4">
                                        <input type="text" class="form-control form-control-lg w-25" aria-label="Text input with segmented dropdown button" placeholder="Enter your keyword here">
                                        <input type="text" class="form-control form-control-lg w-25" aria-label="Text input with segmented dropdown button" placeholder="Search by location">
                                        <button type="button" class="btn btn-primary z-0"><i class="ri-search-line"></i></button>
                                    </div>
                                </div>
                                <div class="col-xl-12">
                                    <div class="card custom-card">
                                        <div class="card-body p-3">
                                            <div class="row align-items-center">
                                                <div class="col-sm-8">
                                                    <div class="d-flex">
                                                        <h5 class="fw-medium mb-0"><span class="fw-normal">Showing</span> 3456 Jobs</h5>
                                                    </div>
                                                </div>
                                                <div class="col-sm-4 text-sm-end mt-3 mt-sm-0">
                                                    <div class="btn-group">
                                                        <button class="btn btn-outline-light border dropdown-toggle" type="button" data-bs-toggle="dropdown" aria-expanded="false">
                                                            Sort By
                                                        </button>
                                                        <ul class="dropdown-menu">
                                                            <li><a class="dropdown-item" href="javascript:void(0);">Featured</a></li>
                                                            <li><a class="dropdown-item" href="javascript:void(0);">Newest</a></li>
                                                            <li><a class="dropdown-item" href="javascript:void(0);">Most Relevant</a></li>
                                                            <li><a class="dropdown-item" href="javascript:void(0);">Best Rated</a></li>
                                                        </ul>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-xl-12">
                                    <div class="card custom-card border-bottom-0 overflow-hidden">
                                        <div class="card-body p-0">
                                            <div class="table-responsive">
                                                <table class="table text-nowrap">
                                                    <tbody>
                                                        <tr>
                                                            <td>
                                                                <div class="d-flex align-items-center gap-3">
                                                                    <div class="lh-1">
                                                                        <span class="avatar avatar-xl bg-primary-transparent svg-primary">
                                                                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 256 256"><rect width="256" height="256" fill="none"/><path d="M40,176V72A16,16,0,0,1,56,56H200a16,16,0,0,1,16,16V176Z" opacity="0.2"/><path d="M40,176V72A16,16,0,0,1,56,56H200a16,16,0,0,1,16,16V176" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="16"/><path d="M24,176H232a0,0,0,0,1,0,0v16a16,16,0,0,1-16,16H40a16,16,0,0,1-16-16V176A0,0,0,0,1,24,176Z" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="16"/><line x1="144" y1="88" x2="112" y2="88" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="16"/></svg>
                                                                        </span>
                                                                    </div>
                                                                    <div>
                                                                        <h6 class="fw-semibold mb-1">Software Engineer</h6>
                                                                        <span class="d-block fw-medium">Tech Innovations Inc.</span>
                                                                        <span class="d-block text-muted fs-13">New York, NY</span>
                                                                    </div>
                                                                </div>
                                                            </td>
                                                            <td>
                                                                <div class="text-center">
                                                                    <span class="fs-13 d-block text-muted mb-1">Job Vacancies</span>
                                                                    <span class="fw-semibold">5</span>
                                                                </div>
                                                            </td>
                                                            <td>
                                                                <div class="text-center">
                                                                    <span class="fs-13 d-block text-muted mb-1">Qualification</span>
                                                                    <span class="fw-semibold">Computer Science</span>
                                                                </div>
                                                            </td>
                                                            <td>
                                                                <div class="text-center">
                                                                    <span class="fs-13 d-block text-muted mb-1">Experience</span>
                                                                    <span class="fw-semibold">2-4 years</span>
                                                                </div>
                                                            </td>
                                                            <td>
                                                                <div class="text-center">
                                                                    <span class="fs-13 d-block text-muted mb-1">Shift</span>
                                                                    <span class="badge bg-primary-transparent">Day Shift</span>
                                                                </div>
                                                            </td>
                                                            <td>
                                                                <div class="text-center">
                                                                    <span class="fs-13 d-block text-muted mb-1">Salary</span>
                                                                    <span class="fw-semibold">$80,000 - $100,000</span>
                                                                </div>
                                                            </td>
                                                            <td class="text-end">
                                                                <div class="mb-2">
                                                                    <a href="javascript:void(0);" class="btn btn-icon btn-warning-light rounded-circle btn-sm" data-bs-toggle="tooltip" data-bs-placement="top" aria-label="Featured Jobs" data-bs-original-title="Featured Jobs"><span><i class="ti ti-star-filled align-middle"></i></span></a>
                                                                </div>
                                                                <a href="javascript:void(0);" class="text-primary fw-medium d-inline-flex">
                                                                    Apply Now <i class="ti ti-arrow-narrow-right ms-2 lh-base"></i>
                                                                </a>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td>
                                                                <div class="d-flex align-items-center gap-3">
                                                                    <div class="lh-1">
                                                                        <span class="avatar avatar-xl bg-secondary-transparent svg-secondary">
                                                                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 256 256"><rect width="256" height="256" fill="none"/><rect x="152" y="40" width="56" height="168" opacity="0.2"/><polyline points="48 208 48 136 96 136" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="16"/><line x1="224" y1="208" x2="32" y2="208" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="16"/><polyline points="96 208 96 88 152 88" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="16"/><polyline points="152 208 152 40 208 40 208 208" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="16"/></svg>
                                                                        </span>
                                                                    </div>
                                                                    <div>
                                                                        <h6 class="fw-semibold mb-1">Data Analyst</h6>
                                                                        <span class="d-block fw-medium">Creative Solutions Ltd.</span>
                                                                        <span class="d-block text-muted fs-13">London, UK</span>
                                                                    </div>
                                                                </div>
                                                            </td>
                                                            <td>
                                                                <div class="text-center">
                                                                    <span class="fs-13 d-block text-muted mb-1">Job Vacancies</span>
                                                                    <span class="fw-semibold">3</span>
                                                                </div>
                                                            </td>
                                                            <td>
                                                                <div class="text-center">
                                                                    <span class="fs-13 d-block text-muted mb-1">Qualification</span>
                                                                    <span class="fw-semibold">Statistics</span>
                                                                </div>
                                                            </td>
                                                            <td>
                                                                <div class="text-center">
                                                                    <span class="fs-13 d-block text-muted mb-1">Experience</span>
                                                                    <span class="fw-semibold">1-3 years</span>
                                                                </div>
                                                            </td>
                                                            <td>
                                                                <div class="text-center">
                                                                    <span class="fs-13 d-block text-muted mb-1">Shift</span>
                                                                    <span class="badge bg-primary-transparent">Day Shift</span>
                                                                </div>
                                                            </td>
                                                            <td>
                                                                <div class="text-center">
                                                                    <span class="fs-13 d-block text-muted mb-1">Salary</span>
                                                                    <span class="fw-semibold">$60,000 - $75,000</span>
                                                                </div>
                                                            </td>
                                                            <td class="text-end">
                                                                <div class="mb-2">
                                                                    <a href="javascript:void(0);" class="btn btn-icon btn-warning-light rounded-circle btn-sm" data-bs-toggle="tooltip" data-bs-placement="top" aria-label="Featured Jobs" data-bs-original-title="Featured Jobs"><span><i class="ti ti-star-filled align-middle"></i></span></a>
                                                                </div>
                                                                <a href="javascript:void(0);" class="text-primary fw-medium d-inline-flex">
                                                                    Apply Now <i class="ti ti-arrow-narrow-right ms-2 lh-base"></i>
                                                                </a>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td>
                                                                <div class="d-flex align-items-center gap-3">
                                                                    <div class="lh-1">
                                                                        <span class="avatar avatar-xl bg-warning-transparent svg-warning">
                                                                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 256 256"><rect width="256" height="256" fill="none"/><path d="M128,144a191.14,191.14,0,0,1-96-25.68h0V200a8,8,0,0,0,8,8H216a8,8,0,0,0,8-8V118.31A191.08,191.08,0,0,1,128,144Z" opacity="0.2"/><line x1="112" y1="112" x2="144" y2="112" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="16"/><rect x="32" y="64" width="192" height="144" rx="8" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="16"/><path d="M168,64V48a16,16,0,0,0-16-16H104A16,16,0,0,0,88,48V64" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="16"/><path d="M224,118.31A191.09,191.09,0,0,1,128,144a191.14,191.14,0,0,1-96-25.68" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="16"/></svg>
                                                                        </span>
                                                                    </div>
                                                                    <div>
                                                                        <h6 class="fw-semibold mb-1">Product Manager</h6>
                                                                        <span class="d-block fw-medium">GreenTech Solutions</span>
                                                                        <span class="d-block text-muted fs-13">San Francisco, CA</span>
                                                                    </div>
                                                                </div>
                                                            </td>
                                                            <td>
                                                                <div class="text-center">
                                                                    <span class="fs-13 d-block text-muted mb-1">Job Vacancies</span>
                                                                    <span class="fw-semibold">2</span>
                                                                </div>
                                                            </td>
                                                            <td>
                                                                <div class="text-center">
                                                                    <span class="fs-13 d-block text-muted mb-1">Qualification</span>
                                                                    <span class="fw-semibold">Product Management</span>
                                                                </div>
                                                            </td>
                                                            <td>
                                                                <div class="text-center">
                                                                    <span class="fs-13 d-block text-muted mb-1">Experience</span>
                                                                    <span class="fw-semibold">4-6 years</span>
                                                                </div>
                                                            </td>
                                                            <td>
                                                                <div class="text-center">
                                                                    <span class="fs-13 d-block text-muted mb-1">Shift</span>
                                                                    <span class="badge bg-warning-transparent">Flexible</span>
                                                                </div>
                                                            </td>
                                                            <td>
                                                                <div class="text-center">
                                                                    <span class="fs-13 d-block text-muted mb-1">Salary</span>
                                                                    <span class="fw-semibold">$100,000 - $130,000</span>
                                                                </div>
                                                            </td>
                                                            <td class="text-end">
                                                                <div class="mb-2">
                                                                    <a href="javascript:void(0);" class="btn btn-icon btn-warning-light rounded-circle btn-sm" data-bs-toggle="tooltip" data-bs-placement="top" aria-label="Featured Jobs" data-bs-original-title="Featured Jobs"><span><i class="ti ti-star-filled align-middle"></i></span></a>
                                                                </div>
                                                                <a href="javascript:void(0);" class="text-primary fw-medium d-inline-flex">
                                                                    Apply Now <i class="ti ti-arrow-narrow-right ms-2 lh-base"></i>
                                                                </a>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td>
                                                                <div class="d-flex align-items-center gap-3">
                                                                    <div class="lh-1">
                                                                        <span class="avatar avatar-xl bg-info-transparent svg-info">
                                                                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 256 256"><rect width="256" height="256" fill="none"/><path d="M165.36,123.05C192.36,99.43,224,64.81,224,32,191.19,32,156.57,63.64,133,90.64A84.39,84.39,0,0,1,165.36,123.05Z" opacity="0.2"/><path d="M16,216H92a52,52,0,1,0-52-52C40,200,16,216,16,216Z" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="16"/><path d="M112.41,116.16C131.6,90.29,179.46,32,224,32c0,44.54-58.29,92.4-84.16,111.59" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="16"/><path d="M133,90.64a84.39,84.39,0,0,1,32.41,32.41" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="16"/></svg>
                                                                        </span>
                                                                    </div>
                                                                    <div>
                                                                        <h6 class="fw-semibold mb-1">UI/UX Designer</h6>
                                                                        <span class="d-block fw-medium">WebX Enterprises</span>
                                                                        <span class="d-block text-muted fs-13">Berlin, Germany</span>
                                                                    </div>
                                                                </div>
                                                            </td>
                                                            <td>
                                                                <div class="text-center">
                                                                    <span class="fs-13 d-block text-muted mb-1">Job Vacancies</span>
                                                                    <span class="fw-semibold">4</span>
                                                                </div>
                                                            </td>
                                                            <td>
                                                                <div class="text-center">
                                                                    <span class="fs-13 d-block text-muted mb-1">Qualification</span>
                                                                    <span class="fw-semibold">Design</span>
                                                                </div>
                                                            </td>
                                                            <td>
                                                                <div class="text-center">
                                                                    <span class="fs-13 d-block text-muted mb-1">Experience</span>
                                                                    <span class="fw-semibold">2-5 years</span>
                                                                </div>
                                                            </td>
                                                            <td>
                                                                <div class="text-center">
                                                                    <span class="fs-13 d-block text-muted mb-1">Shift</span>
                                                                    <span class="badge bg-primary-transparent">Day Shift</span>
                                                                </div>
                                                            </td>
                                                            <td>
                                                                <div class="text-center">
                                                                    <span class="fs-13 d-block text-muted mb-1">Salary</span>
                                                                    <span class="fw-semibold">$70,000 - $85,000</span>
                                                                </div>
                                                            </td>
                                                            <td class="text-end">
                                                                <div class="mb-2">
                                                                    <a href="javascript:void(0);" class="btn btn-icon btn-warning-light rounded-circle btn-sm" data-bs-toggle="tooltip" data-bs-placement="top" aria-label="Featured Jobs" data-bs-original-title="Featured Jobs"><span><i class="ti ti-star-filled align-middle"></i></span></a>
                                                                </div>
                                                                <a href="javascript:void(0);" class="text-primary fw-medium d-inline-flex">
                                                                    Apply Now <i class="ti ti-arrow-narrow-right ms-2 lh-base"></i>
                                                                </a>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td>
                                                                <div class="d-flex align-items-center gap-3">
                                                                    <div class="lh-1">
                                                                        <span class="avatar avatar-xl bg-success-transparent svg-success">
                                                                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 256 256"><rect width="256" height="256" fill="none"/><path d="M160,160h40a40,40,0,0,0,0-80H160Z" opacity="0.2"/><path d="M160,80V200.67a8,8,0,0,0,3.56,6.65l11,7.33a8,8,0,0,0,12.2-4.72L200,160" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="16"/><path d="M40,200a8,8,0,0,0,13.15,6.12C105.55,162.16,160,160,160,160h40a40,40,0,0,0,0-80H160S105.55,77.84,53.15,33.89A8,8,0,0,0,40,40Z" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="16"/></svg>
                                                                        </span>
                                                                    </div>
                                                                    <div>
                                                                        <h6 class="fw-semibold mb-1">Marketing Specialist</h6>
                                                                        <span class="d-block fw-medium">SmartSolutions Co.</span>
                                                                        <span class="d-block text-muted fs-13">Tokyo, Japan</span>
                                                                    </div>
                                                                </div>
                                                            </td>
                                                            <td>
                                                                <div class="text-center">
                                                                    <span class="fs-13 d-block text-muted mb-1">Job Vacancies</span>
                                                                    <span class="fw-semibold">3</span>
                                                                </div>
                                                            </td>
                                                            <td>
                                                                <div class="text-center">
                                                                    <span class="fs-13 d-block text-muted mb-1">Qualification</span>
                                                                    <span class="fw-semibold">Marketing</span>
                                                                </div>
                                                            </td>
                                                            <td>
                                                                <div class="text-center">
                                                                    <span class="fs-13 d-block text-muted mb-1">Experience</span>
                                                                    <span class="fw-semibold">2-4 years</span>
                                                                </div>
                                                            </td>
                                                            <td>
                                                                <div class="text-center">
                                                                    <span class="fs-13 d-block text-muted mb-1">Shift</span>
                                                                    <span class="badge bg-warning-transparent">Flexible</span>
                                                                </div>
                                                            </td>
                                                            <td>
                                                                <div class="text-center">
                                                                    <span class="fs-13 d-block text-muted mb-1">Salary</span>
                                                                    <span class="fw-semibold">$55,000 - $70,000</span>
                                                                </div>
                                                            </td>
                                                            <td class="text-end">
                                                                <div class="mb-2">
                                                                    <a href="javascript:void(0);" class="btn btn-icon btn-warning-light rounded-circle btn-sm" data-bs-toggle="tooltip" data-bs-placement="top" aria-label="Featured Jobs" data-bs-original-title="Featured Jobs"><span><i class="ti ti-star-filled align-middle"></i></span></a>
                                                                </div>
                                                                <a href="javascript:void(0);" class="text-primary fw-medium d-inline-flex">
                                                                    Apply Now <i class="ti ti-arrow-narrow-right ms-2 lh-base"></i>
                                                                </a>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td>
                                                                <div class="d-flex align-items-center gap-3">
                                                                    <div class="lh-1">
                                                                        <span class="avatar avatar-xl bg-danger-transparent svg-danger">
                                                                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 256 256"><rect width="256" height="256" fill="none"/><circle cx="84" cy="108" r="52" opacity="0.2"/><path d="M10.23,200a88,88,0,0,1,147.54,0" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="16"/><path d="M172,160a87.93,87.93,0,0,1,73.77,40" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="16"/><circle cx="84" cy="108" r="52" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="16"/><path d="M152.69,59.7A52,52,0,1,1,172,160" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="16"/></svg>
                                                                        </span>
                                                                    </div>
                                                                    <div>
                                                                        <h6 class="fw-semibold mb-1">HR Manager</h6>
                                                                        <span class="d-block fw-medium">SoftMinds Technologies</span>
                                                                        <span class="d-block text-muted fs-13">Mumbai, India</span>
                                                                    </div>
                                                                </div>
                                                            </td>
                                                            <td>
                                                                <div class="text-center">
                                                                    <span class="fs-13 d-block text-muted mb-1">Job Vacancies</span>
                                                                    <span class="fw-semibold">1</span>
                                                                </div>
                                                            </td>
                                                            <td>
                                                                <div class="text-center">
                                                                    <span class="fs-13 d-block text-muted mb-1">Qualification</span>
                                                                    <span class="fw-semibold">HR Management</span>
                                                                </div>
                                                            </td>
                                                            <td>
                                                                <div class="text-center">
                                                                    <span class="fs-13 d-block text-muted mb-1">Experience</span>
                                                                    <span class="fw-semibold">5+ years</span>
                                                                </div>
                                                            </td>
                                                            <td>
                                                                <div class="text-center">
                                                                    <span class="fs-13 d-block text-muted mb-1">Shift</span>
                                                                    <span class="badge bg-primary-transparent">Day Shift</span>
                                                                </div>
                                                            </td>
                                                            <td>
                                                                <div class="text-center">
                                                                    <span class="fs-13 d-block text-muted mb-1">Salary</span>
                                                                    <span class="fw-semibold">$85,000 - $110,000</span>
                                                                </div>
                                                            </td>
                                                            <td class="text-end">
                                                                <div class="mb-2">
                                                                    <a href="javascript:void(0);" class="btn btn-icon btn-warning-light rounded-circle btn-sm" data-bs-toggle="tooltip" data-bs-placement="top" aria-label="Featured Jobs" data-bs-original-title="Featured Jobs"><span><i class="ti ti-star-filled align-middle"></i></span></a>
                                                                </div>
                                                                <a href="javascript:void(0);" class="text-primary fw-medium d-inline-flex">
                                                                    Apply Now <i class="ti ti-arrow-narrow-right ms-2 lh-base"></i>
                                                                </a>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td>
                                                                <div class="d-flex align-items-center gap-3">
                                                                    <div class="lh-1">
                                                                        <span class="avatar avatar-xl bg-teal-transparent svg-teal">
                                                                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 256 256"><rect width="256" height="256" fill="none"/><polygon points="192 168 240 128 192 88 64 88 16 128 64 168 192 168" opacity="0.2"/><polyline points="64 88 16 128 64 168" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="16"/><polyline points="192 88 240 128 192 168" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="16"/><line x1="160" y1="40" x2="96" y2="216" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="16"/></svg>
                                                                        </span>
                                                                    </div>
                                                                    <div>
                                                                        <h6 class="fw-semibold mb-1">Full Stack Developer</h6>
                                                                        <span class="d-block fw-medium">DataFusion Labs</span>
                                                                        <span class="d-block text-muted fs-13">Singapore</span>
                                                                    </div>
                                                                </div>
                                                            </td>
                                                            <td>
                                                                <div class="text-center">
                                                                    <span class="fs-13 d-block text-muted mb-1">Job Vacancies</span>
                                                                    <span class="fw-semibold">3</span>
                                                                </div>
                                                            </td>
                                                            <td>
                                                                <div class="text-center">
                                                                    <span class="fs-13 d-block text-muted mb-1">Qualification</span>
                                                                    <span class="fw-semibold">Web Development</span>
                                                                </div>
                                                            </td>
                                                            <td>
                                                                <div class="text-center">
                                                                    <span class="fs-13 d-block text-muted mb-1">Experience</span>
                                                                    <span class="fw-semibold">3-5 years</span>
                                                                </div>
                                                            </td>
                                                            <td>
                                                                <div class="text-center">
                                                                    <span class="fs-13 d-block text-muted mb-1">Shift</span>
                                                                    <span class="badge bg-warning-transparent">Flexible</span>
                                                                </div>
                                                            </td>
                                                            <td>
                                                                <div class="text-center">
                                                                    <span class="fs-13 d-block text-muted mb-1">Salary</span>
                                                                    <span class="fw-semibold">$90,000 - $120,000</span>
                                                                </div>
                                                            </td>
                                                            <td class="text-end">
                                                                <div class="mb-2">
                                                                    <a href="javascript:void(0);" class="btn btn-icon btn-warning-light rounded-circle btn-sm" data-bs-toggle="tooltip" data-bs-placement="top" aria-label="Featured Jobs" data-bs-original-title="Featured Jobs"><span><i class="ti ti-star-filled align-middle"></i></span></a>
                                                                </div>
                                                                <a href="javascript:void(0);" class="text-primary fw-medium d-inline-flex">
                                                                    Apply Now <i class="ti ti-arrow-narrow-right ms-2 lh-base"></i>
                                                                </a>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td>
                                                                <div class="d-flex align-items-center gap-3">
                                                                    <div class="lh-1">
                                                                        <span class="avatar avatar-xl bg-pink-transparent svg-pink">
                                                                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 256 256"><rect width="256" height="256" fill="none"/><rect x="104" y="32" width="48" height="48" rx="8" opacity="0.2"/><rect x="40" y="168" width="48" height="48" rx="8" opacity="0.2"/><rect x="168" y="168" width="48" height="48" rx="8" opacity="0.2"/><rect x="104" y="32" width="48" height="48" rx="8" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="16"/><rect x="40" y="168" width="48" height="48" rx="8" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="16"/><rect x="168" y="168" width="48" height="48" rx="8" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="16"/><line x1="128" y1="80" x2="128" y2="120" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="16"/><line x1="192" y1="120" x2="192" y2="168" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="16"/><line x1="64" y1="168" x2="64" y2="120" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="16"/><line x1="24" y1="120" x2="232" y2="120" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="16"/></svg>
                                                                        </span>
                                                                    </div>
                                                                    <div>
                                                                        <h6 class="fw-semibold mb-1">Network Administrator</h6>
                                                                        <span class="d-block fw-medium">NextGen Systems</span>
                                                                        <span class="d-block text-muted fs-13">Toronto, Canada</span>
                                                                    </div>
                                                                </div>
                                                            </td>
                                                            <td>
                                                                <div class="text-center">
                                                                    <span class="fs-13 d-block text-muted mb-1">Job Vacancies</span>
                                                                    <span class="fw-semibold">2</span>
                                                                </div>
                                                            </td>
                                                            <td>
                                                                <div class="text-center">
                                                                    <span class="fs-13 d-block text-muted mb-1">Qualification</span>
                                                                    <span class="fw-semibold">IT</span>
                                                                </div>
                                                            </td>
                                                            <td>
                                                                <div class="text-center">
                                                                    <span class="fs-13 d-block text-muted mb-1">Experience</span>
                                                                    <span class="fw-semibold">2-4 years</span>
                                                                </div>
                                                            </td>
                                                            <td>
                                                                <div class="text-center">
                                                                    <span class="fs-13 d-block text-muted mb-1">Shift</span>
                                                                    <span class="badge bg-primary-transparent">Day Shift</span>
                                                                </div>
                                                            </td>
                                                            <td>
                                                                <div class="text-center">
                                                                    <span class="fs-13 d-block text-muted mb-1">Salary</span>
                                                                    <span class="fw-semibold">$75,000 - $90,000</span>
                                                                </div>
                                                            </td>
                                                            <td class="text-end">
                                                                <div class="mb-2">
                                                                    <a href="javascript:void(0);" class="btn btn-icon btn-warning-light rounded-circle btn-sm" data-bs-toggle="tooltip" data-bs-placement="top" aria-label="Featured Jobs" data-bs-original-title="Featured Jobs"><span><i class="ti ti-star-filled align-middle"></i></span></a>
                                                                </div>
                                                                <a href="javascript:void(0);" class="text-primary fw-medium d-inline-flex">
                                                                    Apply Now <i class="ti ti-arrow-narrow-right ms-2 lh-base"></i>
                                                                </a>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td>
                                                                <div class="d-flex align-items-center gap-3">
                                                                    <div class="lh-1">
                                                                        <span class="avatar avatar-xl bg-purple-transparent svg-purple">
                                                                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 256 256"><rect width="256" height="256" fill="none"/><path d="M40,184a16,16,0,0,0,16,16H216a8,8,0,0,0,8-8V80a8,8,0,0,0-8-8H56A16,16,0,0,1,40,56Z" opacity="0.2"/><path d="M40,56V184a16,16,0,0,0,16,16H216a8,8,0,0,0,8-8V80a8,8,0,0,0-8-8H56A16,16,0,0,1,40,56h0A16,16,0,0,1,56,40H192" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="16"/><circle cx="180" cy="132" r="12"/></svg>
                                                                        </span>
                                                                    </div>
                                                                    <div>
                                                                        <h6 class="fw-semibold mb-1">Sales Manager</h6>
                                                                        <span class="d-block fw-medium">Innovative Minds Ltd.</span>
                                                                        <span class="d-block text-muted fs-13">Paris, France</span>
                                                                    </div>
                                                                </div>
                                                            </td>
                                                            <td>
                                                                <div class="text-center">
                                                                    <span class="fs-13 d-block text-muted mb-1">Job Vacancies</span>
                                                                    <span class="fw-semibold">2</span>
                                                                </div>
                                                            </td>
                                                            <td>
                                                                <div class="text-center">
                                                                    <span class="fs-13 d-block text-muted mb-1">Qualification</span>
                                                                    <span class="fw-semibold">Business</span>
                                                                </div>
                                                            </td>
                                                            <td>
                                                                <div class="text-center">
                                                                    <span class="fs-13 d-block text-muted mb-1">Experience</span>
                                                                    <span class="fw-semibold">3-5 years</span>
                                                                </div>
                                                            </td>
                                                            <td>
                                                                <div class="text-center">
                                                                    <span class="fs-13 d-block text-muted mb-1">Shift</span>
                                                                    <span class="badge bg-warning-transparent">Flexible</span>
                                                                </div>
                                                            </td>
                                                            <td>
                                                                <div class="text-center">
                                                                    <span class="fs-13 d-block text-muted mb-1">Salary</span>
                                                                    <span class="fw-semibold">$65,000 - $90,000</span>
                                                                </div>
                                                            </td>
                                                            <td class="text-end">
                                                                <div class="mb-2">
                                                                    <a href="javascript:void(0);" class="btn btn-icon btn-warning-light rounded-circle btn-sm" data-bs-toggle="tooltip" data-bs-placement="top" aria-label="Featured Jobs" data-bs-original-title="Featured Jobs"><span><i class="ti ti-star-filled align-middle"></i></span></a>
                                                                </div>
                                                                <a href="javascript:void(0);" class="text-primary fw-medium d-inline-flex">
                                                                    Apply Now <i class="ti ti-arrow-narrow-right ms-2 lh-base"></i>
                                                                </a>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td>
                                                                <div class="d-flex align-items-center gap-3">
                                                                    <div class="lh-1">
                                                                        <span class="avatar avatar-xl bg-warning-transparent svg-warning">
                                                                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 256 256"><rect width="256" height="256" fill="none"/><path d="M32,184a16,16,0,0,0,16,16H64a16,16,0,0,0,16-16V144a16,16,0,0,0-16-16H32Z" opacity="0.2"/><path d="M192,128a16,16,0,0,0-16,16v40a16,16,0,0,0,16,16h32V128Z" opacity="0.2"/><path d="M224,200v8a32,32,0,0,1-32,32H136" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="16"/><path d="M224,128H192a16,16,0,0,0-16,16v40a16,16,0,0,0,16,16h32V128a96,96,0,1,0-192,0v56a16,16,0,0,0,16,16H64a16,16,0,0,0,16-16V144a16,16,0,0,0-16-16H32" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="16"/></svg>
                                                                        </span>
                                                                    </div>
                                                                    <div>
                                                                        <h6 class="fw-semibold mb-1">Flexible</h6>
                                                                        <span class="d-block fw-medium">BlueWave Technologies</span>
                                                                        <span class="d-block text-muted fs-13">Sydney, Australia</span>
                                                                    </div>
                                                                </div>
                                                            </td>
                                                            <td>
                                                                <div class="text-center">
                                                                    <span class="fs-13 d-block text-muted mb-1">Job Vacancies</span>
                                                                    <span class="fw-semibold">5</span>
                                                                </div>
                                                            </td>
                                                            <td>
                                                                <div class="text-center">
                                                                    <span class="fs-13 d-block text-muted mb-1">Qualification</span>
                                                                    <span class="fw-semibold">Customer Service</span>
                                                                </div>
                                                            </td>
                                                            <td>
                                                                <div class="text-center">
                                                                    <span class="fs-13 d-block text-muted mb-1">Experience</span>
                                                                    <span class="fw-semibold">1-3 years</span>
                                                                </div>
                                                            </td>
                                                            <td>
                                                                <div class="text-center">
                                                                    <span class="fs-13 d-block text-muted mb-1">Shift</span>
                                                                    <span class="badge bg-success-transparent">Rotational</span>
                                                                </div>
                                                            </td>
                                                            <td>
                                                                <div class="text-center">
                                                                    <span class="fs-13 d-block text-muted mb-1">Salary</span>
                                                                    <span class="fw-semibold">$45,000 - $55,000</span>
                                                                </div>
                                                            </td>
                                                            <td class="text-end">
                                                                <div class="mb-2">
                                                                    <a href="javascript:void(0);" class="btn btn-icon btn-warning-light rounded-circle btn-sm" data-bs-toggle="tooltip" data-bs-placement="top" aria-label="Featured Jobs" data-bs-original-title="Featured Jobs"><span><i class="ti ti-star-filled align-middle"></i></span></a>
                                                                </div>
                                                                <a href="javascript:void(0);" class="text-primary fw-medium d-inline-flex">
                                                                    Apply Now <i class="ti ti-arrow-narrow-right ms-2 lh-base"></i>
                                                                </a>
                                                            </td>
                                                        </tr>
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <ul class="pagination mb-4 justify-content-end">
                                <li class="page-item disabled">
                                    <a class="page-link" href="javascript:void(0);">
                                        Prev
                                    </a>
                                </li>
                                <li class="page-item active"><a class="page-link" href="javascript:void(0);">1</a></li>
                                <li class="page-item"><a class="page-link" href="javascript:void(0);">2</a></li>
                                <li class="page-item"><a class="page-link" href="javascript:void(0);">3</a></li>
                                <li class="page-item">
                                    <a class="page-link text-primary" href="javascript:void(0);">
                                        next
                                    </a>
                                </li>
                            </ul>
                        </div>
                    </div>
                    <!-- End::row-2 -->

<?php $content = ob_get_clean(); ?>
<!-- This code is useful for content -->

<!-- This code is useful for internal scripts  -->
<?php ob_start(); ?>
	
        <!-- noUiSlider JS -->
        <script src="<?php echo $baseUrl; ?>/assets/libs/nouislider/nouislider.min.js"></script>
        <script src="<?php echo $baseUrl; ?>/assets/libs/wnumb/wNumb.min.js"></script>
        <script src="<?php echo $baseUrl; ?>/assets/js/job-search.js"></script>

<?php $scripts = ob_get_clean(); ?>
<!-- This code is useful for internal scripts  -->

<!-- This code use for render base file -->
<?php include 'layouts/base.php'; ?>
<!-- This code use for render base file -->
