<?php
session_start();
require_once '../config.php';
$bodyClass = 'bg-white';

$error = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email = filter_var(trim($_POST['email']), FILTER_VALIDATE_EMAIL);
    $password = trim($_POST['password']);

    if (!$email) {
        $error = 'Please enter a valid email.';
    } elseif (empty($password)) {
        $error = 'Please enter your password.';
    } else {
        $stmt = $conn_sa->prepare("SELECT id, email, password, role_id, first_name, last_name FROM users WHERE email = ?");
        $stmt->bind_param("s", $email);
        $stmt->execute();
        $result = $stmt->get_result();

        if ($result && $result->num_rows === 1) {
            $user = $result->fetch_assoc();
            if (password_verify($password, $user['password'])) {
                $_SESSION['user_id'] = $user['id'];
                $_SESSION['user_email'] = $user['email'];
                $_SESSION['role_id'] = $user['role_id'];
                $_SESSION['username'] = $user['first_name'] . ' ' . $user['last_name'];
                session_write_close();
                header("Location: onb-dashboard.php");
                exit;
            } else {
                $error = 'Incorrect password.';
            }
        } else {
            $error = 'Email not found.';
        }
        $stmt->close();
    }
}
?>

<?php ob_start(); ?>
<style>
    .login-card {
        max-width: 400px;
        margin: auto;
        margin-top: 8vh;
        box-shadow: 0 0 15px rgba(0,0,0,0.1);
        border-radius: 8px;
    }
    .show-password-button {
        cursor: pointer;
        user-select: none;
    }
    .show-password-button {
        margin-top: 15px;
    }
</style>
<?php $styles = ob_get_clean(); ?>

<?php ob_start(); ?>
<div class="row justify-content-center">
    <div class="col-12 col-md-8 col-lg-6 col-xl-4">
        <div class="card login-card p-4">
            <h3 class="text-center mb-4 fw-semibold">Welcome Back!</h3>
            <p class="text-center text-muted mb-4">Please enter your login credentials</p>

            <?php if ($error): ?>
                <div class="alert alert-danger" role="alert"><?php echo htmlspecialchars($error); ?></div>
            <?php endif; ?>

            <form method="POST" action="">
                <div class="mb-3">
                    <label for="signin-email" class="form-label">Email</label>
                    <input
                        type="email"
                        class="form-control"
                        id="signin-email"
                        name="email"
                        placeholder="Enter your email"
                        required
                        value="<?php echo isset($_POST['email']) ? htmlspecialchars($_POST['email']) : ''; ?>"
                        autofocus
                    >
                </div>

                <div class="mb-3 position-relative">
                    <label for="signin-password" class="form-label">Password</label>
                    <input
                        type="password"
                        class="form-control"
                        id="signin-password"
                        name="password"
                        placeholder="Enter your password"
                        required
                    >
                    <a href="javascript:void(0);" class="show-password-button text-muted position-absolute top-50 end-0 translate-middle-y me-3" onclick="createpassword('signin-password', this)">
                        <i class="ri-eye-off-line"></i>
                    </a>
                </div>

                <div class="mb-3 form-check">
                    <input type="checkbox" class="form-check-input" id="remember-me" name="remember" checked>
                    <label class="form-check-label" for="remember-me">Remember me</label>
                    <!-- <a href="reset-password-basic.php" class="float-end link-danger fw-medium fs-12">Forgot password?</a> -->
                </div>

                <div class="d-grid">
                    <button type="submit" class="btn btn-primary">Sign In</button>
                </div>
            </form>

            <!-- <div class="text-center mt-3">
                Don't have an account? <a href="sign-up-basic.php" class="text-primary">Register Here</a>
            </div> -->
        </div>
    </div>
</div>
<?php $content = ob_get_clean(); ?>

<?php ob_start(); ?>
<script src="<?php echo $baseUrl; ?>/assets/js/show-password.js"></script>
<?php $scripts = ob_get_clean(); ?>

<?php include 'layouts/custom-base.php'; ?>
