<?php
/* =============================================================================
 * File   : project_media_delete.php
 * Goal   : Delete a media row (image/doc/floor/link) from project_media and
 *          remove the local file if it lives under /uploads/projects/{id}/...
 * Stack  : MySQLi only (NO PDO). Uses centralized config.php. Melody flash msgs.
 * ============================================================================= */

if (session_status() === PHP_SESSION_NONE) { session_start(); }
date_default_timezone_set('Asia/Kolkata');

/* ------------------------- Centralized config ------------------------- */
$cfgs = [
  __DIR__ . '/../config.php',
  __DIR__ . '/../../config.php',
  __DIR__ . '/config.php'
];
$cfgFound = false;
foreach ($cfgs as $c) {
  if (file_exists($c)) { require_once $c; $cfgFound = true; break; }
}
if (!$cfgFound) { http_response_code(500); die('config.php not found'); }

/* ------------------------- Pick mysqli handle ------------------------- */
$DB = null;
if (isset($conn_crm)     && $conn_crm     instanceof mysqli) $DB = $conn_crm;
elseif (isset($conn_crmplus) && $conn_crmplus instanceof mysqli) $DB = $conn_crmplus;
elseif (isset($conn)     && $conn     instanceof mysqli) $DB = $conn;
elseif (isset($conn_sa)  && $conn_sa  instanceof mysqli) $DB = $conn_sa;

if (!$DB instanceof mysqli) { http_response_code(500); exit('DB connection not found - check config.php'); }

/* Charset / Collation */
@mysqli_set_charset($DB, 'utf8mb4');
@mysqli_query($DB, "SET NAMES 'utf8mb4'");
@mysqli_query($DB, "SET collation_connection='utf8mb4_general_ci'");

/* ------------------------- Helpers ------------------------- */
if (!function_exists('h')) { function h($s){ return htmlspecialchars((string)$s, ENT_QUOTES|ENT_SUBSTITUTE, 'UTF-8'); } }
function q($s){ global $DB; return mysqli_real_escape_string($DB,(string)$s); }
function table_exists($name){ global $DB; $name=q($name); $r=@mysqli_query($DB,"SHOW TABLES LIKE '{$name}'"); $ok=($r && mysqli_num_rows($r)>0); if($r) @mysqli_free_result($r); return $ok; }

/* Map URL -> local path if it is inside our /uploads/ folder near this script */
function local_path_from_url($url){
  if (!$url) return '';
  $path = parse_url($url, PHP_URL_PATH);
  if ($path === null || $path === false) $path = $url; // maybe it is already relative
  $path = str_replace('\\','/',$path);
  // We only allow deletes if path contains /uploads/projects/
  if (strpos($path, '/uploads/projects/') === false && strpos($path, 'uploads/projects/') !== 0) {
    return '';
  }
  // Build filesystem path relative to this directory (project_save stored using __DIR__/uploads/…)
  $rel = ltrim($path,'/'); // remove leading slash if any
  $full = __DIR__ . '/' . $rel;
  return $full;
}

/* ------------------------- Inputs ------------------------- */
$id  = isset($_GET['id'])  ? (int)$_GET['id']  : 0;   // media row id
$pid = isset($_GET['pid']) ? (int)$_GET['pid'] : 0;   // project id (for redirect)

if ($id <= 0) {
  $_SESSION['flash_error'] = 'Invalid media id.';
  header('Location: project_form.php'.($pid>0?'?id='.$pid:'')); exit;
}

if (!table_exists('project_media')) {
  $_SESSION['flash_error'] = 'project_media table not found.';
  header('Location: project_form.php'.($pid>0?'?id='.$pid:'')); exit;
}

/* ------------------------- Fetch media row ------------------------- */
$rs = @mysqli_query($DB, "SELECT * FROM `project_media` WHERE id={$id} LIMIT 1");
if (!$rs || !mysqli_num_rows($rs)) {
  if ($rs) @mysqli_free_result($rs);
  $_SESSION['flash_error'] = 'Media not found.';
  header('Location: project_form.php'.($pid>0?'?id='.$pid:'')); exit;
}
$row = mysqli_fetch_assoc($rs);
@mysqli_free_result($rs);

if ($pid <= 0) { $pid = isset($row['project_id']) ? (int)$row['project_id'] : 0; }

/* Optional: if pid provided, ensure it matches */
if ($pid > 0 && isset($row['project_id']) && (int)$row['project_id'] !== $pid) {
  $_SESSION['flash_error'] = 'Media does not belong to this project.';
  header('Location: project_form.php'.($pid>0?'?id='.$pid:'')); exit;
}

/* ------------------------- Attempt file delete if local -------------------- */
$url = isset($row['url']) ? (string)$row['url'] : (isset($row['file_url']) ? (string)$row['file_url'] : '');
$mediaType = strtolower(trim((string)($row['media_type'] ?? '')));
if ($url !== '' && $mediaType !== 'link') {
  $local = local_path_from_url($url);
  if ($local) {
    // Only delete if inside uploads/projects directory
    $uploadsRoot = realpath(__DIR__ . '/uploads/projects');
    $candidate   = $local;
    // realpath may fail if file is already missing; fall back to $local guard
    $candDir = realpath(dirname($candidate));
    if (!$candDir) $candDir = dirname($candidate);
    if ($uploadsRoot && strpos($candDir, $uploadsRoot) === 0) {
      if (is_file($candidate)) { @unlink($candidate); }
    }
  }
}

/* ------------------------- Delete DB row ---------------------------------- */
@mysqli_query($DB, "DELETE FROM `project_media` WHERE id={$id} LIMIT 1");
if (mysqli_affected_rows($DB) > 0) {
  $_SESSION['flash_success'] = 'Media removed.';
} else {
  $_SESSION['flash_error'] = 'Failed to remove media: '.h(mysqli_error($DB));
}

/* ------------------------- Redirect back ---------------------------------- */
header('Location: project_form.php'.($pid>0?'?id='.$pid:'')); 
exit;
