<?php
/* =============================================================================
 * projects.php — Melody list using central config.php (same DB as project_add.php)
 * ============================================================================= */

if (session_status() === PHP_SESSION_NONE) { session_start(); }
date_default_timezone_set('Asia/Kolkata');

/* central config */
if (file_exists(__DIR__ . '/../config.php')) require_once __DIR__ . '/../config.php';
elseif (file_exists(__DIR__ . '/config.php')) require_once __DIR__ . '/config.php';
else die('Missing config.php');

/* pick the same $DB used everywhere */
$DB = null;
if (isset($conn_crm) && $conn_crm instanceof mysqli) $DB = $conn_crm;
elseif (isset($conn_crmplus) && $conn_crmplus instanceof mysqli) $DB = $conn_crmplus;
elseif (isset($conn) && $conn instanceof mysqli) $DB = $conn;
elseif (isset($conn_sa) && $conn_sa instanceof mysqli) $DB = $conn_sa;
if (!$DB instanceof mysqli) { http_response_code(500); exit('DB connection not found - check config.php'); }

@mysqli_set_charset($DB, 'utf8mb4');
@mysqli_query($DB, "SET NAMES 'utf8mb4'");
@mysqli_query($DB, "SET collation_connection='utf8mb4_general_ci'");

/* helpers */
if (!function_exists('h')) { function h($s){ return htmlspecialchars((string)$s, ENT_QUOTES|ENT_SUBSTITUTE, 'UTF-8'); } }
function q($s){ global $DB; return mysqli_real_escape_string($DB,(string)$s); }
function getv($k,$d=''){ return isset($_GET[$k]) ? trim($_GET[$k]) : $d; }
function col_exists($tbl,$col){ global $DB; $tbl=q($tbl); $col=q($col);
  $r=@mysqli_query($DB,"SHOW COLUMNS FROM `$tbl` LIKE '$col'"); $ok=$r && mysqli_num_rows($r)>0; if($r) @mysqli_free_result($r); return $ok;
}
function asset_base(){
  if(!empty($GLOBALS['baseUrl'])) return rtrim($GLOBALS['baseUrl'],'/');
  $proto = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS']!=='off') ? 'https' : 'http';
  $host  = $_SERVER['HTTP_HOST'] ?? 'localhost';
  $dir   = rtrim(dirname($_SERVER['SCRIPT_NAME'] ?? '/'),'/');
  return rtrim("$proto://$host$dir",'/');
}

/* filters */
$q      = getv('q','');
$status = getv('status','');
$where  = "WHERE 1=1";
if ($q!==''){
  $q2=q($q);
  $likes=[];
  foreach(['title','city','address','configuration','price_text','website_url'] as $c){
    if(col_exists('projects',$c)) $likes[]="`$c` LIKE '%$q2%'";
  }
  if($likes) $where .= " AND (".implode(' OR ',$likes).")";
}
if ($status!==''){
  if (col_exists('projects','is_active')) $where .= ($status==='Active') ? " AND is_active=1" : " AND is_active=0";
}

/* select */
$sel=['id'];
foreach(['title','city','configuration','price_text','is_active','bedrooms','bathrooms','area_sqft','area_unit','created_at','sort_order'] as $c){
  if(col_exists('projects',$c)) $sel[]="`$c`";
}
$order = col_exists('projects','sort_order') ? 'sort_order ASC'
       : (col_exists('projects','created_at') ? 'created_at DESC' : 'id DESC');
$sql="SELECT ".implode(',',$sel)." FROM `projects` $where ORDER BY $order";
$rs=mysqli_query($DB,$sql);

/* flashes (optional) */
$flash_error   = $_SESSION['flash_error']   ?? '';
$flash_success = $_SESSION['flash_success'] ?? '';
unset($_SESSION['flash_error'], $_SESSION['flash_success']);

/* ========================== $styles ========================== */
ob_start(); ?>
<link rel="stylesheet" href="<?php echo asset_base(); ?>/assets/libs/sweetalert2/sweetalert2.min.css">
<style>.projects-table .table td,.projects-table .table th{white-space:nowrap;vertical-align:middle}</style>
<?php $styles=ob_get_clean();

/* ========================== $content ========================= */
ob_start(); ?>
<div class="page-header-breadcrumb mb-3">
  <div class="d-flex align-center justify-content-between flex-wrap">
    <h1 class="page-title fw-medium fs-18 mb-0">Projects</h1>
    <ol class="breadcrumb mb-0">
      <li class="breadcrumb-item"><a href="javascript:void(0);">Dashboards</a></li>
      <li class="breadcrumb-item"><a href="javascript:void(0);">Inventory</a></li>
      <li class="breadcrumb-item active">Projects</li>
    </ol>
  </div>
</div>

<?php if ($flash_error): ?><div class="alert alert-danger"><?php echo h($flash_error); ?></div><?php endif; ?>
<?php if ($flash_success): ?><div class="alert alert-success"><?php echo h($flash_success); ?></div><?php endif; ?>

<div class="card custom-card projects-table">
  <div class="card-header justify-content-between border-bottom-0">
    <div class="card-title">Manage Projects</div>
    <a href="project_form.php" class="btn btn-primary btn-sm"><i class="fa fa-plus me-2"></i>Add Project</a>
  </div>
  <div class="card-body">
    <form class="row gy-2 mb-3 align-items-end" method="get">
      <div class="col-md-6">
        <label class="form-label mb-1 text-muted small">Search</label>
        <div class="input-group">
          <span class="input-group-text"><i class="fa fa-search"></i></span>
          <input type="text" name="q" class="form-control" placeholder="Search title / city / address / config" value="<?php echo h($q); ?>">
        </div>
      </div>
      <div class="col-md-3">
        <label class="form-label mb-1 text-muted small">Status</label>
        <select name="status" class="form-control">
          <option value="">All Status</option>
          <option value="Active"   <?php echo $status==='Active'?'selected':''; ?>>Active</option>
          <option value="Inactive" <?php echo $status==='Inactive'?'selected':''; ?>>Inactive</option>
        </select>
      </div>
      <div class="col-md-3 d-grid">
        <button class="btn btn-primary"><i class="fa fa-filter me-1"></i>Filter</button>
      </div>
    </form>

    <div class="table-responsive">
      <table class="table table-hover">
        <thead>
          <tr>
            <th>Title</th>
            <th>City</th>
            <th>Config</th>
            <th>Beds</th>
            <th>Baths</th>
            <th>Area</th>
            <th>Price</th>
            <th>Status</th>
            <th class="text-end">Actions</th>
          </tr>
        </thead>
        <tbody>
          <?php if($rs && mysqli_num_rows($rs)>0): while($r=mysqli_fetch_assoc($rs)): ?>
            <?php $active = isset($r['is_active']) ? (int)$r['is_active']===1 : 1; ?>
            <tr>
              <td class="fw-semibold"><?php echo h($r['title'] ?? ''); ?></td>
              <td><?php echo h($r['city'] ?? ''); ?></td>
              <td><?php echo h($r['configuration'] ?? ''); ?></td>
              <td><?php echo h($r['bedrooms'] ?? ''); ?></td>
              <td><?php echo h($r['bathrooms'] ?? ''); ?></td>
              <td>
                <?php
                  $a = $r['area_sqft'] ?? '';
                  $u = $r['area_unit'] ?? '';
                  echo h(($a!==''?$a:'') . ($u!==''?' '.$u:''));
                ?>
              </td>
              <td><?php echo h($r['price_text'] ?? ''); ?></td>
              <td><span class="badge <?php echo $active?'bg-success':'bg-secondary'; ?>"><?php echo $active?'Active':'Inactive'; ?></span></td>
              <td class="text-end">
                <a class="btn btn-sm btn-outline-primary" href="project_form.php?id=<?php echo (int)$r['id']; ?>"><i class="fa fa-edit me-1"></i>Edit</a>
              </td>
            </tr>
          <?php endwhile; else: ?>
            <tr><td colspan="9" class="text-center text-muted">No projects found.</td></tr>
          <?php endif; ?>
        </tbody>
      </table>
    </div>
  </div>
</div>

<?php $content=ob_get_clean();

/* ========================== $scripts ========================= */
ob_start(); ?>
<script src="<?php echo asset_base(); ?>/assets/libs/sweetalert2/sweetalert2.min.js"></script>
<?php $scripts=ob_get_clean();

/* render */
include __DIR__ . '/layouts/base.php';
