
<!-- This code generates the base URL for the website by combining the protocol, domain name, and directory path -->
<?php
session_start();
include('../config.php');
require_once 'includes/check-permission.php';
$currentPage = basename(__FILE__);
checkPageAccessOrRedirect($currentPage, $conn_sa);
?>
<!-- This code generates the base URL for the website by combining the protocol, domain name, and directory path -->

<!-- This code is useful for internal styles  -->
<?php ob_start(); ?>



<?php $styles = ob_get_clean(); ?>
<!-- This code is useful for internal styles  -->

<!-- This code is useful for content -->
<?php ob_start(); ?>
	
                    <!-- Start::page-header -->
                    <div class="page-header-breadcrumb mb-3">
                        <div class="d-flex align-center justify-content-between flex-wrap">
                            <h1 class="page-title fw-medium fs-18 mb-0">Timeline</h1>
                            <ol class="breadcrumb mb-0">
                                <li class="breadcrumb-item"><a href="javascript:void(0);">Pages</a></li>
                                <li class="breadcrumb-item active" aria-current="page">Timeline</li>
                            </ol>
                        </div>
                    </div>
                    <!-- End::page-header -->
                    
                    <!-- Start:: row-1 -->
                    <div class="row mb-5">
                        <div class="col-xl-12">
                            <h6>Timeline 1</h6>
                            <div class="timeline">
                                <div class="container">
                                    <div class="row">
                                        <div class="col-lg-12">
                                            <div class="timeline-container">
                                                <div class="timeline-end">
                                                    <span class="avatar avatar-lg avatar-rounded bg-primary text-center">
                                                        <i class="ri ri-building-line fs-4"></i>
                                                    </span>
                                                </div>
                                                <div class="timeline-continue">
                                                    <div class="row timeline-right">
                                                        <div class="col-md-6">
                                                            <div class="timeline-time-container primary">
                                                                <p class="timeline-date text-primary">
                                                                    Jan 15
                                                                </p>
                                                                <span class="timeline-time fs-12 text-muted fw-medium d-block">
                                                                    2023
                                                                </span>
                                                            </div>
                                                        </div>
                                                        <div class="col-md-6">
                                                            <div class="timeline-box primary">
                                                                <h6 class="fw-semibold">Company Founded</h6>
                                                                <p class="mb-0 text-muted">Our journey began with a vision to revolutionize the industry. On January 15th, 2023, we officially founded the company with a small but dedicated team and big dreams for the future.</p>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="row timeline-left">
                                                        <div class="col-md-6">
                                                            <div class="timeline-box ms-md-auto success">
                                                                <h6 class="fw-semibold">First Product Launch</h6>
                                                                <p class="mb-0 text-muted">After months of hard work and dedication, we launched our first product. It was a pivotal moment in our company's history, setting the stage for everything that was to come.</p>
                                                            </div>
                                                        </div>
                                                        <div class="col-md-6">
                                                            <div class="timeline-time-container success">
                                                                <p class="timeline-date text-success">
                                                                    Feb 20
                                                                </p>
                                                                <span class="timeline-time fs-12 text-muted fw-medium d-block text-start">
                                                                    02:00 PM
                                                                </span>
                                                            </div>    
                                                        </div>
                                                    </div>
                                                    <div class="row">
                                                        <div class="col-12">
                                                            <div class="timeline-year">
                                                                <span class="avatar avatar-lg avatar-rounded bg-success text-center">
                                                                    <i class="ri ri-money-dollar-circle-line fs-4"></i>
                                                                </span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="row timeline-right">
                                                        <div class="col-md-6">
                                                            <div class="timeline-time-container warning">
                                                                <p class="timeline-date text-warning">
                                                                    Apr 5
                                                                </p>
                                                                <span class="timeline-time fs-12 text-muted fw-medium d-block">
                                                                    11:45 AM
                                                                </span>
                                                            </div>
                                                        </div>    
                                                        <div class="col-md-6">
                                                            <div class="timeline-box warning">
                                                                <h6 class="fw-semibold">Secured First Round of Funding</h6>
                                                                <p class="mb-0 text-muted">We secured our first round of funding from angel investors. This was a major milestone that allowed us to scale and bring our product to market faster.</p>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="row timeline-left">
                                                        <div class="col-md-6">
                                                            <div class="timeline-box ms-md-auto info">
                                                                <h6 class="fw-semibold">Expanded Team</h6>
                                                                <p class="mb-0 text-muted">As our business grew, we expanded our team to include experts in various fields, from marketing to engineering. This allowed us to focus on innovation and improve our products.</p>
                                                            </div>
                                                        </div>
                                                        <div class="col-md-6">
                                                            <div class="timeline-time-container info">
                                                                <p class="timeline-date text-info">
                                                                    May 18
                                                                </p>
                                                                <span class="timeline-time fs-12 text-muted fw-medium d-block text-start">
                                                                    04:20 PM
                                                                </span>
                                                            </div>    
                                                        </div>
                                                    </div>
                                                    <div class="row">
                                                        <div class="col-12">
                                                            <div class="timeline-year">
                                                                <span class="avatar avatar-lg avatar-rounded bg-danger text-center">
                                                                    <i class="ri ri-settings-3-line fs-4"></i>
                                                                </span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="row timeline-right">
                                                        <div class="col-md-6">
                                                            <div class="timeline-time-container danger">
                                                                <p class="timeline-date text-danger">
                                                                    Aug 25
                                                                </p>
                                                                <span class="timeline-time fs-12 text-muted fw-medium d-block">
                                                                    09:15 AM
                                                                </span>
                                                            </div>    
                                                        </div>
                                                        <div class="col-md-6">
                                                            <div class="timeline-box danger">
                                                                <h6 class="fw-semibold">Launched New Feature</h6>
                                                                <p class="mb-0 text-muted">A major milestone in our product development, we launched a new feature that was highly anticipated by our users. It garnered positive feedback and improved user engagement.</p>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="row timeline-left">
                                                        <div class="col-md-6">
                                                            <div class="timeline-box ms-md-auto teal">
                                                                <h6 class="fw-semibold">Reached 100k Users</h6>
                                                                <p class="mb-0 text-muted">We hit a major milestone: 100,000 active users. This achievement reflected the hard work of our team and the value our product brings to our users.</p>
                                                            </div>
                                                        </div>
                                                        <div class="col-md-6">
                                                            <div class="timeline-time-container teal">
                                                                <p class="timeline-date text-teal">
                                                                    Oct 10
                                                                </p>
                                                                <span class="timeline-time fs-12 text-muted fw-medium d-block text-start">
                                                                    01:30 PM
                                                                </span>
                                                            </div>    
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="timeline-start">
                                                    <span class="avatar avatar-lg avatar-rounded bg-warning text-center">
                                                        <i class="ri ri-user-star-line fs-4"></i>
                                                    </span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- End:: row-1 -->

                    <!-- Start:: row-2 -->
                    <div class="row mb-5">
                        <div class="col-xl-12">
                            <h6>Timeline 2</h6>
                            <div class="p-5">
                                <div class="timeline-steps">
                                    <div class="timeline-step">
                                        <div class="timeline-content" data-toggle="popover" data-placement="top" title="" data-content="And here's some amazing content. It's very engaging. Right?" data-original-title="2003">
                                            <div class="timeline-date_time-container">
                                                <span class="badge bg-primary">Jan 10, 2024 - 10:00 AM</span>
                                            </div>
                                            <div class="inner-circle primary">
                                            </div>
                                            <p class="fw-medium mt-3 mb-1">Project Kickoff</p>
                                            <p class="text-muted mb-0 mb-lg-0">Our team gathered to discuss project goals, scope, and initial milestones. The roadmap was finalized.</p>
                                        </div>
                                    </div>
                                    <div class="timeline-step">
                                        <div class="timeline-content" data-toggle="popover" data-placement="top" title="" data-content="And here's some amazing content. It's very engaging. Right?" data-original-title="2004">
                                            <div class="timeline-date_time-container">
                                                <span class="badge bg-success">Feb 5, 2024 - 2:30 PM</span>
                                            </div>
                                            <div class="inner-circle success"></div>
                                            <p class="fw-medium mt-3 mb-1">Initial Wireframes Completed</p>
                                            <p class="text-muted mb-0 mb-lg-0">The UI/UX team completed the first set of wireframes, ensuring a smooth user experience.</p>
                                        </div>
                                    </div>
                                    <div class="timeline-step">
                                        <div class="timeline-content" data-toggle="popover" data-placement="top" title="" data-content="And here's some amazing content. It's very engaging. Right?" data-original-title="2005">
                                            <div class="timeline-date_time-container">
                                                <span class="badge bg-warning">Mar 12, 2024 - 11:00 AM</span>
                                            </div>
                                            <div class="inner-circle warning"></div>
                                            <p class="fw-medium mt-3 mb-1">Development Phase Begins</p>
                                            <p class="text-muted mb-0 mb-lg-0">The engineering team started coding, focusing on the core features of the platform.</p>
                                        </div>
                                    </div>
                                    <div class="timeline-step">
                                        <div class="timeline-content" data-toggle="popover" data-placement="top" title="" data-content="And here's some amazing content. It's very engaging. Right?" data-original-title="2010">
                                            <div class="timeline-date_time-container">
                                                <span class="badge bg-info">May 8, 2024 - 4:45 PM</span>
                                            </div>
                                            <div class="inner-circle info"></div>
                                            <p class="fw-medium mt-3 mb-1">Beta Version Released</p>
                                            <p class="text-muted mb-0 mb-lg-0">The first beta version was released for internal testing, and feedback collection began.</p>
                                        </div>
                                    </div>
                                    <div class="timeline-step">
                                        <div class="timeline-content" data-toggle="popover" data-placement="top" title="" data-content="And here's some amazing content. It's very engaging. Right?" data-original-title="2020">
                                            <div class="timeline-date_time-container">
                                                <span class="badge bg-danger">Jun 20, 2024 - 9:15 AM</span>
                                            </div>
                                            <div class="inner-circle danger"></div>
                                            <p class="fw-medium mt-3 mb-1">Security Audit Completed</p>
                                            <p class="text-muted mb-0 mb-lg-0">A comprehensive security review was conducted to ensure data protection and system stability.</p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- End:: row-2 -->

                    <!-- Start:: row-3 -->
                    <div class="row">
                        <div class="col-xl-4">
                            <div class="card custom-card">
                                <div class="card-header">
                                    <div class="card-title">Icons Timeline</div>
                                </div>
                                <div class="card-body p-4">
                                    <ul class="list-unstyled timeline-list-1">
                                        <li>
                                            <span class="fw-semibold d-block fs-15 mb-1">Logged In</span>
                                            <span class="d-block mb-1">User successfully logged into the dashboard from a new device.</span>
                                            <span class="fs-13 text-muted d-block">Mar 17, 2025 - 09:15 AM</span>
                                        </li>
                                        <li>
                                            <span class="fw-semibold d-block fs-15 mb-1">Profile Updated</span>
                                            <span class="d-block mb-1">User updated their profile details, including name and contact information.</span>
                                            <span class="fs-13 text-muted d-block">Mar 17, 2025 - 09:45 AM</span>
                                        </li>
                                        <li>
                                            <span class="fw-semibold d-block fs-15 mb-1">File Uploaded</span>
                                            <span class="d-block mb-1">A new document was uploaded to the project folder.</span>
                                            <span class="fs-13 text-muted d-block">Mar 17, 2025 - 10:10 AM</span>
                                        </li>
                                        <li>
                                            <span class="fw-semibold d-block fs-15 mb-1">Comment Added</span>
                                            <span class="d-block mb-1">User posted a comment on the project discussion board.</span>
                                            <span class="fs-13 text-muted d-block">Mar 17, 2025 - 10:30 AM</span>
                                        </li>
                                        <li>
                                            <span class="fw-semibold d-block fs-15 mb-1">Payment Processed</span>
                                            <span class="d-block mb-1">A payment of $99.99 was successfully processed for the premium plan.</span>
                                            <span class="fs-13 text-muted d-block">Mar 17, 2025 - 11:00 AM</span>
                                        </li>
                                        <!-- <li>
                                            <span class="fw-semibold d-block fs-15 mb-1">Task Assigned</span>
                                            <span class="d-block mb-1">A new task was assigned to the user in the project management module.</span>
                                            <span class="fs-13 text-muted d-block">Mar 17, 2025 - 11:45 AM</span>
                                        </li> -->
                                    </ul>
                                </div>
                            </div>
                        </div>
                        <div class="col-xl-4">
                            <div class="card custom-card">
                                <div class="card-header">
                                    <div class="card-title">
                                        Rounded Timeline
                                    </div>
                                </div>
                                <div class="card-body">
                                    <ul class="list-unstyled timeline-list-2">
                                        <li>
                                            <div class="d-flex align-items-center mb-1 gap-2">
                                                <div class="lh-1">
                                                    <span class="avatar avatar-xs avatar-rounded">
                                                        <img src="<?php echo $baseUrl; ?>/assets/images/faces/10.jpg" alt="">
                                                    </span>
                                                </div>
                                                <div class="fw-semibold flex-fill">Logged In</div>
                                                <div class="fs-13 text-muted">08:45 AM</div>
                                            </div>
                                            <div class="d-flex align-items-center gap-2">
                                                <div class="fs-13 text-muted">John Doe logged into the dashboard</div>
                                            </div>
                                        </li>
                                        <li>
                                            <div class="d-flex align-items-center gap-2 mb-1">
                                                <div class="lh-1">
                                                    <span class="avatar avatar-xs avatar-rounded">
                                                        <img src="<?php echo $baseUrl; ?>/assets/images/faces/1.jpg" alt="">
                                                    </span>
                                                </div>
                                                <div class="fw-semibold flex-fill">Profile Updated</div>
                                                <div class="fs-13 text-muted">09:10 AM</div>
                                            </div>
                                            <div class="d-flex align-items-center gap-2">
                                                <div class="fs-13 text-muted">Emily Johnson updated her profile information</div>
                                            </div>    
                                        </li>
                                        <li>
                                            <div class="d-flex align-items-center gap-2 mb-1">
                                                <div class="lh-1">
                                                    <span class="avatar avatar-xs avatar-rounded">
                                                        <img src="<?php echo $baseUrl; ?>/assets/images/faces/11.jpg" alt="">
                                                    </span>
                                                </div>
                                                <div class="fw-semibold flex-fill">File Uploaded</div>
                                                <div class="fs-13 text-muted">09:35 AM</div>
                                            </div>
                                            <div class="d-flex align-items-center gap-2">
                                                <div class="fs-13 text-muted">Michael Brown uploaded a project report file</div>
                                            </div>   
                                        </li>
                                        <li>
                                            <div class="d-flex align-items-center gap-2 mb-1">
                                                <div class="lh-1">
                                                    <span class="avatar avatar-xs avatar-rounded">
                                                        <img src="<?php echo $baseUrl; ?>/assets/images/faces/2.jpg" alt="">
                                                    </span>
                                                </div>
                                                <div class="fw-semibold flex-fill">Comment Added</div>
                                                <div class="fs-13 text-muted">10:05 AM</div>
                                            </div>
                                            <div class="d-flex align-items-center gap-2">
                                                <div class="fs-13 text-muted">Sarah Davis commented on a task in the project board</div>
                                            </div>   
                                        </li>
                                        <li>
                                            <div class="d-flex align-items-center gap-2 mb-1">
                                                <div class="lh-1">
                                                    <span class="avatar avatar-xs avatar-rounded">
                                                        <img src="<?php echo $baseUrl; ?>/assets/images/faces/14.jpg" alt="">
                                                    </span>
                                                </div>
                                                <div class="fw-semibold flex-fill">Payment Processed</div>
                                                <div class="fs-13 text-muted">10:45 AM</div>
                                            </div>
                                            <div class="d-flex align-items-center gap-2">
                                                <div class="fs-13 text-muted">David Wilson completed the "UI Redesign" task</div>
                                            </div>   
                                        </li>
                                        <li>
                                            <div class="d-flex align-items-center gap-2 mb-1">
                                                <div class="lh-1">
                                                    <span class="avatar avatar-xs avatar-rounded">
                                                        <img src="<?php echo $baseUrl; ?>/assets/images/faces/5.jpg" alt="">
                                                    </span>
                                                </div>
                                                <div class="fw-semibold flex-fill">Task Assigned</div>
                                                <div class="fs-13 text-muted">11:20 AM</div>
                                            </div>
                                            <div class="d-flex align-items-center gap-2">
                                                <div class="fs-13 text-muted">Olivia Harris processed a payment of $120.00</div>
                                            </div>   
                                        </li>
                                        <li>
                                            <div class="d-flex align-items-center gap-2 mb-1">
                                                <div class="lh-1">
                                                    <span class="avatar avatar-xs avatar-rounded">
                                                        <img src="<?php echo $baseUrl; ?>/assets/images/faces/15.jpg" alt="">
                                                    </span>
                                                </div>
                                                <div class="fw-semibold flex-fill">Settings Updated</div>
                                                <div class="fs-13 text-muted">12:00 PM</div>
                                            </div>
                                            <div class="d-flex align-items-center gap-2">
                                                <div class="fs-13 text-muted">James Taylor invited a new team member to the project</div>
                                            </div>   
                                        </li>
                                        <li>
                                            <div class="d-flex align-items-center gap-2 mb-1">
                                                <div class="lh-1">
                                                    <span class="avatar avatar-xs avatar-rounded">
                                                        <img src="<?php echo $baseUrl; ?>/assets/images/faces/16.jpg" alt="">
                                                    </span>
                                                </div>
                                                <div class="fw-semibold flex-fill">Invitation Sent</div>
                                                <div class="fs-13 text-muted">12:50 PM</div>
                                            </div>
                                            <div class="d-flex align-items-center gap-2">
                                                <div class="fs-13 text-muted">Lucas Scott modified security settings in the admin panel</div>
                                            </div>   
                                        </li>
                                        <!-- <li>
                                            <div class="d-flex align-items-center justify-content-between mb-1">
                                                <div class="fw-semibold">Logged Out</div>
                                                <div class="fs-13 text-muted">05:00 PM</div>
                                            </div>
                                            <div class="d-flex align-items-center gap-2">
                                                <div class="lh-1">
                                                    <span class="avatar avatar-xs avatar-rounded">
                                                        <img src="<?php echo $baseUrl; ?>/assets/images/faces/9.jpg" alt="">
                                                    </span>
                                                </div>
                                                <div class="fs-13 text-muted">Daniel Lee logged out from the system</div>
                                            </div>   
                                        </li> -->
                                    </ul>
                                </div>
                            </div>
                        </div>
                        <div class="col-xl-4">
                            <div class="card custom-card">
                                <div class="card-header">
                                    <div class="card-title">
                                        Solid Timeline
                                    </div>
                                </div>
                                <div class="card-body">
                                    <ul class="list-unstyled timeline-list-3">
                                        <li>
                                            <div class="d-flex align-items-center gap-3 mb-1 flex-wrap">
                                                <div class="fw-semibold fs-15">Project Kickoff & Planning</div>
                                                <span class="badge bg-primary-transparent">Jan 10, 2025 - 09:00 AM</span>
                                            </div>
                                            <div class="fs-13 text-muted">Project <span class="fw-medium text-default">"NextGen Web App"</span> was officially created, marking the beginning of development.</div>
                                        </li>
                                        <li>
                                            <div class="d-flex align-items-center gap-3 mb-1 flex-wrap">
                                                <div class="fw-semibold fs-15">Requirement Analysis</div>
                                                <span class="badge bg-success-transparent">Jan 11, 2025 - 10:30 AM</span>
                                            </div>
                                            <div class="fs-13 text-muted">The team finalized the project scope, features, and initial milestones.</div>
                                        </li>
                                        <li>
                                            <div class="d-flex align-items-center gap-3 mb-1 flex-wrap">
                                                <div class="fw-semibold fs-15">Roadmap Planning</div>
                                                <span class="badge bg-warning-transparent">Jan 12, 2025 - 02:15 PM</span>
                                            </div>
                                            <div class="fs-13 text-muted">A detailed roadmap was outlined, including design, development, and release phases.</div>
                                        </li>
                                        <li>
                                            <div class="d-flex align-items-center gap-3 mb-1 flex-wrap">
                                                <div class="fw-semibold fs-15">Team Assignments</div>
                                                <span class="badge bg-secondary-transparent">Jan 14, 2025 - 04:00 PM</span>
                                            </div>
                                            <div class="fs-13 text-muted">Roles and responsibilities were assigned to developers, designers, and project managers.</div>
                                        </li>
                                        <li>
                                            <div class="d-flex align-items-center gap-3 mb-1 flex-wrap">
                                                <div class="fw-semibold fs-15">Wireframe & UI Design</div>
                                                <span class="badge bg-info-transparent">Jan 18, 2025 - 11:45 AM</span>
                                            </div>
                                            <div class="fs-13 text-muted">Initial wireframes and UI mockups were created and shared for review.</div>
                                        </li>
                                        <li>
                                            <div class="d-flex align-items-center gap-3 mb-1 flex-wrap">
                                                <div class="fw-semibold fs-15">UI/UX Feedback & Revisions</div>
                                                <span class="badge bg-danger-transparent">Jan 20, 2025 - 03:30 PM</span>
                                            </div>
                                            <div class="fs-13 text-muted">Stakeholders provided feedback on the design, leading to refinements.</div>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- End:: row-3 -->

<?php $content = ob_get_clean(); ?>
<!-- This code is useful for content -->

<!-- This code is useful for internal scripts  -->
<?php ob_start(); ?>
	


<?php $scripts = ob_get_clean(); ?>
<!-- This code is useful for internal scripts  -->

<!-- This code use for render base file -->
<?php include 'layouts/base.php'; ?>
<!-- This code use for render base file -->
