<?php
/* =============================================================================
 * File: unit_hold_book_save.php
 * Purpose: Processes Hold/Book submission; sets flash + redirects to units.php
 * Stack  : Core PHP + MySQLi (NO PDO). DB in /broker-config.php. Collation: utf8mb4_general_ci
 * ============================================================================= */

@session_start();
require_once 'broker-config.php';
if (!isset($conn) || !($conn instanceof mysqli)) { $_SESSION['flash_error']='DB connection missing.'; header("Location: units.php"); exit; }

mysqli_set_charset($conn,'utf8mb4');
@mysqli_query($conn,"SET NAMES 'utf8mb4' COLLATE 'utf8mb4_general_ci'");
@mysqli_query($conn,"SET collation_connection='utf8mb4_general_ci'");

/* ---- Helpers ---- */
function p($k,$d=''){ return isset($_POST[$k]) ? trim((string)$_POST[$k]) : $d; }

/* ---- CSRF ---- */
if (empty($_SESSION['csrf_token']) || !hash_equals($_SESSION['csrf_token'], p('csrf_token'))) {
  $_SESSION['flash_error'] = 'Invalid session. Please try again.';
  header("Location: units.php"); exit;
}

$role     = isset($_SESSION['role']) ? (string)$_SESSION['role'] : '';
$username = isset($_SESSION['username']) ? (string)$_SESSION['username'] : '';

/* ---- Inputs ---- */
$id   = (int)p('id',0);
$next = p('next_status','');
if ($id<=0 || !in_array($next,['Hold','Booked'],true)) {
  $_SESSION['flash_error'] = 'Invalid action.'; header("Location: units.php"); exit;
}

$booking_date     = p('booking_date','');
$customer_name    = p('customer_name','');
$customer_mobile  = p('customer_mobile','');
$token_amount     = p('token_amount','0');
$booked_by_broker = p('booked_by_broker', $username);
$remarks          = p('remarks','');

$hold_expires_at  = p('hold_expires_at','');
$hold_reason      = p('hold_reason','');

/* ---- Validate ---- */
$errs = [];
if ($customer_name==='')   $errs[] = 'Customer Name is required.';
if ($customer_mobile==='') $errs[] = 'Customer Mobile is required.';
if ($next==='Hold') {
  if ($hold_expires_at==='') $errs[] = 'Hold Expires At is required.';
  if ($hold_reason==='')     $errs[] = 'Hold Reason is required.';
}

/* ---- Defaults ---- */
date_default_timezone_set('Asia/Kolkata');
if ($booking_date==='')     $booking_date = date('Y-m-d');
if ($booked_by_broker==='') $booked_by_broker = $username ?: 'Broker';

/* ---- Fail if validation ---- */
if ($errs) {
  $_SESSION['flash_error'] = implode(' ', $errs);
  header("Location: unit_hold_book.php?id=".$id."&action=".strtolower($next)); exit;
}

/* ---- Update ---- */
$status = $next;

if ($next==='Hold') {
  $sql = "UPDATE units SET
            status=?, booking_date=?, customer_name=?, customer_mobile=?, token_amount=?,
            booked_by_broker=?, remarks=?, hold_expires_at=?, hold_reason=?
          WHERE id=? LIMIT 1";
  $stmt = mysqli_prepare($conn, $sql);
  if (!$stmt) { $_SESSION['flash_error']='Prepare failed: '.mysqli_error($conn); header("Location: unit_hold_book.php?id=".$id."&action=hold"); exit; }
  mysqli_stmt_bind_param($stmt,'sssssssssi',
    $status,$booking_date,$customer_name,$customer_mobile,$token_amount,
    $booked_by_broker,$remarks,$hold_expires_at,$hold_reason,$id
  );
} else {
  $sql = "UPDATE units SET
            status=?, booking_date=?, customer_name=?, customer_mobile=?, token_amount=?,
            booked_by_broker=?, remarks=?
          WHERE id=? LIMIT 1";
  $stmt = mysqli_prepare($conn, $sql);
  if (!$stmt) { $_SESSION['flash_error']='Prepare failed: '.mysqli_error($conn); header("Location: unit_hold_book.php?id=".$id."&action=book"); exit; }
  mysqli_stmt_bind_param($stmt,'sssssssi',
    $status,$booking_date,$customer_name,$customer_mobile,$token_amount,
    $booked_by_broker,$remarks,$id
  );
}

/* ---- Execute ---- */
if (!mysqli_stmt_execute($stmt)) {
  $_SESSION['flash_error'] = 'Update failed: '.mysqli_error($conn);
  mysqli_stmt_close($stmt);
  header("Location: unit_hold_book.php?id=".$id."&action=".($next==='Hold'?'hold':'book')); exit;
}
mysqli_stmt_close($stmt);

/* ---- Success ---- */
$_SESSION['flash_success'] = ($next==='Hold') ? 'Unit put on Hold.' : 'Unit Booked.';
header("Location: units.php"); exit;
