<?php
/* =============================================================================
 * File   : base.php
 * Goal   : Master layout that loads navbar/footer partials from the **same**
 *          directory as this file (fixes "footer.php not getting" issue).
 * Note   : PHP resolves relative include paths from the executing script,
 *          not from the current file. So we always prefix with __DIR__.
 * Stack  : Core PHP (NO PDO). DB config not required here.
 * Charset: utf-8 / COLLATE=utf8mb4_general_ci
 * ============================================================================= */

/* ---------- Assets root (override from caller if you want) ---------- */
if (!isset($static_url) || !$static_url) {
    $static_url = '/mobile/assets';
}

/* ---------- Which header/footer to load (caller may set these) ---------- */
$page  = isset($page)  ? (string)$page  : 'nav';
$fpage = isset($fpage) ? (string)$fpage : 'foot';

/* ---------- Map keys to partial filenames (whitelist) ---------- */
$navbarFiles = [
    'nav'  => 'navbar.php',
    'nav2' => 'navbar2.php',
    'nav3' => 'navbar3.php',
    'nav4' => 'navbar4.php',
    'nav5' => 'navbar5.php',
    'nav6' => 'navbar6.php',
];

$footerFiles = [
    'foot'  => 'footer.php',
    'foot1' => 'footer1.php',
];

/* ---------- Resolve full paths relative to THIS file ---------- */
$partialsDir = __DIR__;

function include_partial_safely(string $fullPath, string $fallback = null): void {
    if (is_file($fullPath)) {
        include $fullPath;
        return;
    }
    if ($fallback && is_file($fallback)) {
        include $fallback;
        return;
    }
    // Silent fail if neither exists (or you can uncomment to debug):
    // trigger_error("Partial not found: $fullPath", E_USER_NOTICE);
}

/* ---------- Compute selected navbar/footer files ---------- */
$navbarFullPath = isset($navbarFiles[$page])
    ? $partialsDir . DIRECTORY_SEPARATOR . $navbarFiles[$page]
    : $partialsDir . DIRECTORY_SEPARATOR . 'no-header.php';

$navbarFallback = $partialsDir . DIRECTORY_SEPARATOR . 'no-header.php';

$footerFullPath = (isset($fpage, $footerFiles[$fpage]))
    ? $partialsDir . DIRECTORY_SEPARATOR . $footerFiles[$fpage]
    : null;

?><!DOCTYPE html>
<html lang="zxx">
<head>
    <meta charset="utf-8">
    <meta http-equiv="x-ua-compatible" content="ie=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">

    <title>Broriser Mobile</title>
    <link rel="icon" href="<?php echo $static_url; ?>/img/favicon.png" type="image/gif" sizes="18x18">

    <!-- Styles -->
    <link href="<?php echo $static_url; ?>/css/styles.css" rel="stylesheet">
    <link href="<?php echo $static_url; ?>/css/colors.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/@mdi/font/css/materialdesignicons.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://unpkg.com/@icon/themify-icons/themify-icons.css">
</head>

<body class="blue-skin">
    <div id="preloader"><div class="preloader"><span></span><span></span></div></div>

    <div id="main-wrapper">

        <?php
        /* -------------------- HEADER / NAVBAR -------------------- */
        include_partial_safely($navbarFullPath, $navbarFallback);
        ?>

        <!-- Main Content -->
        <main>
            <?php
            // Render page-specific content if provided by caller
            if (isset($hero_content)) {
                echo $hero_content;
            } else {
                echo "<!-- Default hero content here -->";
            }
            ?>
        </main>

        <?php
        /* -------------------- FOOTER -------------------- */
        if ($footerFullPath) {
            include_partial_safely($footerFullPath);
        }
        ?>

        <!-- Back to top -->
        <!-- NOTE: ID must match JS (#back-to-top) to work -->
        <a id="back-to-top" class="top-scroll bg-primary" title="Back to top" href="#"><i class="ti ti-arrow-up"></i></a>
        <!-- Back to top -->

    </div><!-- /#main-wrapper -->

    <!-- ============================================================== -->
    <!-- All Jquery -->
    <!-- ============================================================== -->
    <script src="<?php echo $static_url; ?>/js/jquery.min.js"></script>
    <script src="<?php echo $static_url; ?>/js/popper.min.js"></script>
    <script src="<?php echo $static_url; ?>/js/bootstrap.min.js"></script>
    <script src="<?php echo $static_url; ?>/js/rangeslider.js"></script>
    <script src="<?php echo $static_url; ?>/js/select2.min.js"></script>
    <script src="<?php echo $static_url; ?>/js/jquery.magnific-popup.min.js"></script>
    <script src="<?php echo $static_url; ?>/js/slick.js"></script>
    <script src="<?php echo $static_url; ?>/js/slider-bg.js"></script>
    <script src="<?php echo $static_url; ?>/js/lightbox.js"></script>
    <script src="<?php echo $static_url; ?>/js/imagesloaded.js"></script>
    <script src="<?php echo $static_url; ?>/js/custom.js"></script>

    <script src="<?php echo $static_url; ?>/js/dropzone.js"></script>
    <script src="<?php echo $static_url; ?>/js/contact.js"></script>

    <!-- Date Booking Script -->
    <script src="<?php echo $static_url; ?>/js/moment.min.js"></script>
    <script src="<?php echo $static_url; ?>/js/daterangepicker.js"></script>

    <!-- Map (key is intentionally blank) -->
    <script src="https://maps.google.com/maps/api/js?key="></script>
    <script src="<?php echo $static_url; ?>/js/map_infobox.js"></script>
    <script src="<?php echo $static_url; ?>/js/markerclusterer.js"></script>
    <script src="<?php echo $static_url; ?>/js/map.js"></script>

    <script>
        // Check In & Check Out Daterange Script
        $(function () {
            $('input[name="checkout"]').daterangepicker({ singleDatePicker: true });
            $('input[name="checkout"]').val('').attr("placeholder","Check Out");
        });
        $(function () {
            $('input[name="checkin"]').daterangepicker({ singleDatePicker: true });
            $('input[name="checkin"]').val('').attr("placeholder","Check In");
        });
    </script>

    <script>
        // Counter up
        try {
            const counter = document.querySelectorAll('.counter-value');
            const speed = 2500; // The lower the slower

            counter.forEach(cv => {
                const updateCount = () => {
                    const target = +cv.getAttribute('data-target');
                    const count  = +cv.innerText;
                    var inc = target / speed;
                    if (inc < 1) inc = 1;

                    if (count < target) {
                        cv.innerText = (count + inc).toFixed(0);
                        setTimeout(updateCount, 1);
                    } else {
                        cv.innerText = target;
                    }
                };
                updateCount();
            });
        } catch (e) {}
    </script>

    <script>
        // Back to top visibility
        window.onscroll = function () { scrollFunction(); };
        function scrollFunction() {
            var mybutton = document.getElementById("back-to-top");
            if (!mybutton) return;
            if (document.body.scrollTop > 500 || document.documentElement.scrollTop > 500) {
                mybutton.classList.add("block");
                mybutton.classList.remove("hidden");
            } else {
                mybutton.classList.add("hidden");
                mybutton.classList.remove("block");
            }
        }
        function topFunction() {
            document.body.scrollTop = 0;
            document.documentElement.scrollTop = 0;
        }
    </script>

    <script>
        // Simple toggler
        $(document).ready(function(){
            $("#showbutton").on('click', function(){
                $("#showing").slideToggle("slow");
            });
        });
    </script>
</body>
</html>
