<?php
/* =============================================================================
 * File   : navbar.php
 * Goal   : Top navigation with Login linking to CRM pages.
 * Stack  : Core PHP + MySQLi (NO PDO). DB link & $baseUrl from config.php
 * Charset: utf8mb4 / COLLATE=utf8mb4_general_ci
 * ============================================================================= */

if (session_status() === PHP_SESSION_NONE) { session_start(); }
date_default_timezone_set('Asia/Kolkata');

/* ------------------------- Centralized config ------------------------- */
$cfgs = [
  __DIR__ . '/config.php',
  __DIR__ . '/../config.php',
  __DIR__ . '/../../config.php'
];
$cfgFound = false;
foreach ($cfgs as $c) { if (file_exists($c)) { require_once $c; $cfgFound = true; break; } }
if (!$cfgFound) { /* allow rendering without DB if needed */ }

/* ---------- Ensure charset/collation on mysqli if present ---------- */
if (isset($conn) && $conn instanceof mysqli) {
  mysqli_set_charset($conn, 'utf8mb4');
  @mysqli_query($conn, "SET collation_connection='utf8mb4_general_ci'");
}
if (!isset($baseUrl)) { $baseUrl = (defined('BASE_URL') ? rtrim(BASE_URL, '/') : ''); }

/* ---------- CRM login target ---------- */
$crmLoginUrl = "/mobile/login.php";  //(when desktop)
?>
<!-- Start Navigation -->
<div class="header header-light head-shadow">
  <div class="mx-1 mx-sm-5">
    <nav id="navigation" class="navigation navigation-landscape">
      <div class="nav-header">
        <a class="nav-brand text-logo" href="/mobile/index.php">
          <img src="<?php echo $baseUrl; ?>/mobile/assets/img/logo-broriser.png" class="logo" alt="logo">
        </a>
        <div class="nav-toggle"></div>

        <!-- Mobile quick actions -->
        <div class="mobile_nav">
          <ul>
            <li>
              <!-- Login now opens CRM pages -->
              <a href="/mobile/login.php" class="text-muted" aria-label="Login to CRM">
                <span class="svg-icon svg-icon-2hx">
                  <svg width="35" height="35" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path opacity="0.3" d="M16.5 9C16.5 13.125 13.125 16.5 9 16.5C4.875 16.5 1.5 13.125 1.5 9C1.5 4.875 4.875 1.5 9 1.5C13.125 1.5 16.5 4.875 16.5 9Z" fill="currentColor"/>
                    <path d="M9 16.5C10.95 16.5 12.75 15.75 14.025 14.55C13.425 12.675 11.4 11.25 9 11.25C6.6 11.25 4.57499 12.675 3.97499 14.55C5.24999 15.75 7.05 16.5 9 16.5Z" fill="currentColor"/>
                    <rect x="7" y="6" width="4" height="4" rx="2" fill="currentColor"/>
                  </svg>
                </span>
              </a>
            </li>
            <li>
                <a href="logout.php" class="text-primary" aria-label="Logout">
                  <span class="svg-icon svg-icon-2hx">
                    <svg width="35" height="35" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                      <path opacity="0.3" d="M5 3C3.89543 3 3 3.89543 3 5V19C3 20.1046 3.89543 21 5 21H13C14.1046 21 15 20.1046 15 19V16H13V19H5V5H13V8H15V5C15 3.89543 14.1046 3 13 3H5Z" fill="currentColor"/>
                      <path d="M20.2929 11.2929L17.7071 8.70711C17.3166 8.31658 16.6834 8.31658 16.2929 8.70711C15.9024 9.09763 15.9024 9.7308 16.2929 10.1213L17.1716 11H9C8.44772 11 8 11.4477 8 12C8 12.5523 8.44772 13 9 13H17.1716L16.2929 13.8787C15.9024 14.2692 15.9024 14.9024 16.2929 15.2929C16.6834 15.6834 17.3166 15.6834 17.7071 15.2929L20.2929 12.7071C20.6834 12.3166 20.6834 11.6834 20.2929 11.2929Z" fill="currentColor"/>
                    </svg>
                  </span>
                </a>
            </li>
            <!--<li>
              <a href="#" class="text-primary" data-bs-toggle="offcanvas" data-bs-target="#offcanvasScrolling" aria-controls="offcanvasScrolling" aria-label="Open Menu">
                <span class="svg-icon svg-icon-2hx">
                  <svg width="22" height="22" viewBox="0 0 16 15" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <rect y="6" width="16" height="3" rx="1.5" fill="currentColor"/>
                    <rect opacity="0.3" y="12" width="8" height="3" rx="1.5" fill="currentColor"/>
                    <rect opacity="0.3" width="12" height="3" rx="1.5" fill="currentColor"/>
                  </svg>
                </span>
              </a>
            </li>-->
          </ul>
        </div>
      </div>

      <div class="nav-menus-wrapper" style="transition-property: none;">
        <ul class="nav-menu">
          <li><a href="<?php echo $baseUrl; ?>/mobile/index.php" class="sub-menu-item">Home</a></li>
          <li><a href="<?php echo $baseUrl; ?>#" class="sub-menu-item">Why Us?</a></li>
          <li><a href="<?php echo $baseUrl; ?>/mobile/contact.php" class="sub-menu-item">Contact Us</a></li>
          <!--
          <li class="relative parent-parent-menu-item"><a class="home-link" href="JavaScript:Void(0);">More<span class="submenu-indicator"></span></a>
            <ul class="nav-dropdown nav-submenu">
              <li><a href="about-us.php" class="sub-menu-item">About Us</a></li>
              <li><a href="blog.php" class="sub-menu-item">Blogs Page</a></li>
              <li><a href="blog-detail.php" class="sub-menu-item">Blog Detail</a></li>
              <li><a href="component.php" class="sub-menu-item">Shortcodes</a></li>
              <li><a href="pricing.php" class="sub-menu-item">Pricing</a></li>
              <li><a href="faq.php" class="sub-menu-item">faq</a></li>
              <li><a href="404.php" class="sub-menu-item">Error Page</a></li>
              <li><a href="contact.php" class="sub-menu-item">Contacts</a></li>
            </ul>
          </li>
          -->
        </ul>

        <ul class="nav-menu nav-menu-social align-to-right">
          <li>
            <a href="JavaScript:Void(0);" data-bs-toggle="modal" data-bs-target="#call" class="fw-medium text-info d-flex align-items-center">
              <span class="svg-icon svg-icon-2hx me-1">
                <svg width="22" height="22" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                  <path d="M6.62 10.79a15.053 15.053 0 006.59 6.59l2.2-2.2a1 1 0 011.11-.21c1.2.48 2.5.74 3.85.74a1 1 0 011 1v3.5a1 1 0 01-1 1C10.07 21.5 2.5 13.93 2.5 4a1 1 0 011-1h3.5a1 1 0 011 1c0 1.35.25 2.65.74 3.85a1 1 0 01-.22 1.11l-2.2 2.2z" fill="currentColor"/>
                </svg>
              </span>
              <span class="d-flex flex-column">
                <span class="small">Toll Free Number</span>
                <span class="small">+91 9999 999999</span>
              </span>
            </a>
          </li>

          <!--<li>
            <a href="<?php echo $crmLoginUrl; ?>" class="fw-medium text-muted-2" aria-label="Login to CRM">
              <span class="svg-icon svg-icon-2hx me-1">
                <svg width="22" height="22" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
                  <path opacity="0.3" d="M16.5 9C16.5 13.125 13.125 16.5 9 16.5C4.875 16.5 1.5 13.125 1.5 9C1.5 4.875 4.875 1.5 9 1.5C13.125 1.5 16.5 4.875 16.5 9Z" fill="currentColor"/>
                  <path d="M9 16.5C10.95 16.5 12.75 15.75 14.025 14.55C13.425 12.675 11.4 11.25 9 11.25C6.6 11.25 4.57499 12.675 3.97499 14.55C5.24999 15.75 7.05 16.5 9 16.5Z" fill="currentColor"/>
                  <rect x="7" y="6" width="4" height="4" rx="2" fill="currentColor"/>
                </svg>
              </span>
              LogIn
            </a>
          </li>

          <li class="add-listing">
            <a href="/brocrm/mobile/login.php" class="bg-primary">
              <span class="svg-icon svg-icon-muted svg-icon-2hx me-1">
                <svg width="22" height="22" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                  <rect opacity="0.3" width="12" height="2" rx="1" transform="matrix(-1 0 0 1 15.5 11)" fill="currentColor"/>
                  <path d="M13.6313 11.6927L11.8756 10.2297C11.4054 9.83785 11.3732 9.12683 11.806 8.69401C12.1957 8.3043 12.8216 8.28591 13.2336 8.65206L16.1592 11.2526C16.6067 11.6504 16.6067 12.3496 16.1592 12.7474L13.2336 15.3479C12.8216 15.7141 12.1957 15.6957 11.806 15.306C11.3732 14.8732 11.4054 14.1621 11.8756 13.7703L13.6313 12.3073C13.8232 12.1474 13.8232 11.8526 13.6313 11.6927Z" fill="currentColor"/>
                  <path d="M8 5V6C8 6.55228 8.44772 7 9 7C9.55228 7 10 6.55228 10 6C10 5.44772 10.4477 5 11 5H18C18.5523 5 19 5.44772 19 6V18C19 18.5523 18.5523 19 18 19H11C10.4477 19 10 18.5523 10 18C10 17.4477 9.55228 17 9 17C8.44772 17 8 17.4477 8 18V19C8 20.1046 8.89543 21 10 21H19C20.1046 21 21 20.1046 21 19V5C21 3.89543 20.1046 3 19 3H10C8.89543 3 8 3.89543 8 5Z" fill="currentColor"/>
                </svg>
              </span>CRM
            </a>
          </li>

          <li>
            <a href="#" class="text-primary" data-bs-toggle="offcanvas" data-bs-target="#offcanvasScrolling" aria-controls="offcanvasScrolling" aria-label="Open Menu">
              <span class="svg-icon svg-icon-2hx">
                <svg width="24" height="24" viewBox="0 0 16 15" fill="none" xmlns="http://www.w3.org/2000/svg">
                  <rect y="6" width="16" height="3" rx="1.5" fill="currentColor"/>
                  <rect opacity="0.3" y="12" width="8" height="3" rx="1.5" fill="currentColor"/>
                  <rect opacity="0.3" width="12" height="3" rx="1.5" fill="currentColor"/>
                </svg>
              </span>
            </a>
          </li>-->
        </ul>
      </div>
    </nav>
  </div>
</div>
<!-- End Navigation -->
<div class="clearfix"></div>

<!-- compare code  -->
<?php if (isset($base_dir)) { include "$base_dir/Components/Navbar/compare.php"; } ?>

<!-- log-in code (kept for future use, not triggered by header links now) -->
<?php if (isset($base_dir)) { include "$base_dir/Components/Navbar/log-in.php"; } ?>

<script>
  (function () {
    const currentPath = window.location.pathname;

    // Highlight active submenu item by exact path match
    const subMenuItems = document.querySelectorAll('.sub-menu-item');
    subMenuItems.forEach((item) => {
      const href = item.getAttribute('href') || '';
      // Normalize to pathname if absolute URL
      let hrefPath = href;
      try { hrefPath = new URL(href, window.location.origin).pathname; } catch (e) {}

      if (hrefPath === currentPath) {
        item.classList.add('active');

        // Highlight all parent menus recursively
        let parentMenu = item.closest('.parent-menu-item');
        while (parentMenu && !parentMenu.classList.contains('processed')) {
          const parentLink = parentMenu.querySelector('a');
          if (parentLink) parentLink.classList.add('active');
          parentMenu.classList.add('processed');
          parentMenu = parentMenu.closest('.parent-parent-menu-item');
        }

        // Highlight the top-level parent menu
        const topLevelMenu = item.closest('.parent-parent-menu-item');
        if (topLevelMenu) {
          const topLevelLink = topLevelMenu.querySelector('.home-link');
          if (topLevelLink) topLevelLink.classList.add('active');
        }
      }
    });
  })();
</script>
