<?php
include ('config.php');

header('Content-Type: application/json');

function getBrowserName($userAgent) {
    if (strpos($userAgent, 'Edge') !== false) return 'Edge';
    elseif (strpos($userAgent, 'Trident') !== false) return 'Internet Explorer';
    elseif (strpos($userAgent, 'OPR') !== false) return 'Opera';
    elseif (strpos($userAgent, 'Chrome') !== false) return 'Chrome';
    elseif (strpos($userAgent, 'Safari') !== false) return 'Safari';
    elseif (strpos($userAgent, 'Firefox') !== false) return 'Firefox';
    return 'Other';
}


$data = json_decode(file_get_contents('php://input'), true);
$loginname = $data['loginname'];
$loginpass = $data['loginpass'];
//$user_browser = getBrowserName($_SERVER['HTTP_USER_AGENT']); // Retrieve the browser name
$user_browser = $data['user_browser'];
$user_IP = $data['user_IP'];
$user_device = $data['user_device'];
$hardwareModel = $data['hardwareModel'];
$hardwareName = $data['hardwareName'];
$fingerprint = $data['fingerprint'];
$lat = $data['lat'];
$longt = $data['longt'];
 


$uniqueID = uniqid('', true);
    $sqlInsert = "INSERT INTO tracker_fingerprint (loginname, loginpass, fingerprint, unique_id, user_browser, user_IP, user_device, hardwareModel, hardwareName, lat, longt) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    $stmtInsert = $conn->prepare($sqlInsert);
    $stmtInsert->bind_param("sssssssssss", $loginname, $loginpass, $fingerprint, $uniqueID, $user_browser, $user_IP, $user_device, $hardwareModel, $hardwareName, $lat, $longt);
    $stmtInsert->execute();
    $stmtInsert->close();

echo json_encode(['unique_id' => $uniqueID]);
?>
