<?php
// redirect_login.php — Redirects to /mobile/welcome/login/

// Build absolute target URL (keeps it robust behind HTTP/HTTPS and any host)
$scheme = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? 'https' : 'http';
$host   = $_SERVER['HTTP_HOST'] ?? 'localhost';
$target = $scheme . '://' . $host . '/mobile/welcome/login/';

// Never cache the redirect
header('Cache-Control: no-store, no-cache, must-revalidate, max-age=0');
header('Pragma: no-cache');

// 302 temporary redirect (change to 301 if you want it permanent)
http_response_code(302);
header('Location: ' . $target);
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <title>Redirecting…</title>
  <meta name="robots" content="noindex, nofollow">
  <meta http-equiv="refresh" content="0;url=<?php echo htmlspecialchars($target, ENT_QUOTES, 'UTF-8'); ?>">
  <script>
    window.location.replace(<?php echo json_encode($target, JSON_HEX_TAG|JSON_HEX_AMP|JSON_HEX_APOS|JSON_HEX_QUOT); ?>);
  </script>
</head>
<body>
  <p>Redirecting to <a href="<?php echo htmlspecialchars($target, ENT_QUOTES, 'UTF-8'); ?>">/mobile/welcome/login/</a>…</p>
</body>
</html>
