<?php
if (session_status() === PHP_SESSION_NONE) { @session_start(); }

/* Ensure DB connection exists */
if (!isset($conn) || !($conn instanceof mysqli)) {
    $cfgPath = dirname(__DIR__) . '/config.php';
    if (is_file($cfgPath)) { include_once($cfgPath); }
}

/* Charset & collation */
if (isset($conn) && $conn instanceof mysqli) {
    @mysqli_set_charset($conn, 'utf8mb4');
    @mysqli_query($conn, "SET NAMES 'utf8mb4' COLLATE 'utf8mb4_general_ci'");
    @mysqli_query($conn, "SET collation_connection='utf8mb4_general_ci'");
}

/* Load $fetch1 if parent didn’t provide it */
if (!isset($fetch1) || !is_array($fetch1)) {
    $fetch1 = [
        'empid'            => '',
        'Employee_Number'  => '',
        'Employee_Full_Name' => '',
        'Team_Name'        => '',
        'AMS_Location'     => 'ALL',   // default so key always exists
        'Rider_Status'     => ''
    ];
    $uid = isset($_SESSION['user_id1']) ? (string)$_SESSION['user_id1'] : '';
    if ($uid !== '' && isset($conn) && $conn instanceof mysqli) {
        $q = mysqli_query(
            $conn,
            "SELECT empid, Employee_Number, Employee_Full_Name, Team_Name, AMS_Location, Rider_Status
             FROM hr_dump
             WHERE empid='".mysqli_real_escape_string($conn,$uid)."' LIMIT 1"
        );
        if ($q && mysqli_num_rows($q) > 0) {
            $fetch1 = array_merge($fetch1, mysqli_fetch_assoc($q));
        }
    }
}

/* Compute "has team" without relying on $dataFR */
$hasTeam = false;
if (!empty($fetch1['Employee_Number']) && isset($conn) && $conn instanceof mysqli) {
    $empNoEsc = mysqli_real_escape_string($conn, (string)$fetch1['Employee_Number']);
    $qt = mysqli_query($conn, "SELECT COUNT(*) c FROM hr_dump WHERE Functional_Reporting='{$empNoEsc}' AND (Status IS NULL OR Status!='Inactive')");
    if ($qt && ($r = mysqli_fetch_assoc($qt))) { $hasTeam = ((int)$r['c'] > 0); }
}

/* Allowed IP map */
$allowedIPs = [];
$ipMapFile = __DIR__ . '/include/ip_location.php';
if (is_file($ipMapFile)) {
    include $ipMapFile; // should define $allowedIPs (array)
    if (!isset($allowedIPs) || !is_array($allowedIPs)) { $allowedIPs = []; }
}

/* Determine visitor IP (first item if comma-separated) */
$userIP = $_SERVER['HTTP_X_FORWARDED_FOR'] ?? ($_SERVER['REMOTE_ADDR'] ?? '');
if (strpos((string)$userIP, ',') !== false) { $userIP = trim(explode(',', $userIP)[0]); }

/* AMS_Location (safe default) */
$AMS_Location = (string)($fetch1['AMS_Location'] ?? 'ALL');
?>
	<div class="appBottomMenu">
        <a href="dashboard.php" class="item">
            <div class="col"><i class="fas fa-home icon"></i><strong>Home</strong></div>
        </a>
    	<?php
    		/* Auto AMS by IP */
    		if (array_key_exists($userIP, $allowedIPs)) {
    			$getlocation = $allowedIPs[$userIP];
    			echo '<a href="ams_selfie.php" class="item"><div class="col"><i class="fas fa-id-card icon text-success"></i><strong>Auto AMS</strong></div></a>';
    		} else {
    			/* Attendance entry based on AMS_Location */
    			if ($AMS_Location === 'ALL') {
    				echo '<a href="ams_mark.php" class="item"><div class="col"><i class="fas fa-fingerprint icon"></i><strong>Attendance</strong></div></a>';
    			} elseif ($AMS_Location === 'Club') {
    				echo '<a href="ams_mark_club.php" class="item"><div class="col"><i class="fas fa-fingerprint icon"></i><strong>Attendance</strong></div></a>';
    			} else {
    				echo '<a href="ams_mark_selected.php" class="item"><div class="col"><i class="fas fa-fingerprint icon"></i><strong>Attendance</strong></div></a>';
    			}
    		}
    	?>
		 <a href="leave.php" class="item">
            <div class="col"><i class="fas fa-business-time icon"></i><strong>Leave</strong></div>
        </a>
		<?php
			/* Rider conveyance shortcut */
			if (!empty($fetch1['Rider_Status']) && $fetch1['Rider_Status'] === 'rider') {
				echo '<a href="ams_rider.php" class="item"><div class="col"><i class="fas fa-biking icon"></i><strong>Conveyance</strong></div></a>';
			}
			/* My Team link only if the user has subordinates */
			if ($hasTeam) {
				echo '<a href="team.php" class="item"><div class="col"><i class="fas fa-users icon"></i><strong>My Team</strong></div></a>';
			}
		?>
    </div>
	
	<script src="../assets/js/lib/bootstrap.bundle.min.js"></script>
 
	<script src="../assets/js/base.js"></script>
</body>

</html>

<script>
/* Keep these disabled by default; uncomment if you need hard client-side restrictions.
document.addEventListener('contextmenu', event => event.preventDefault());
document.addEventListener('keydown', function(event) {
    if (event.ctrlKey || event.key === "F12") {
        event.preventDefault();
    }
});
*/
</script>
