<?php
/* ============================================================================
 * File : header.php  (robust version)
 * Goal : Avoid "Undefined variable $fetch1" and "Trying to access array offset"
 * Tech : Core PHP + MySQLi (NO PDO). DB in ../config.php
 * DB   : utf8mb4 / utf8mb4_general_ci
 * ========================================================================== */

if (session_status() === PHP_SESSION_NONE) { @session_start(); }

/* Ensure DB connection exists (mysqli) */
if (!isset($conn) || !($conn instanceof mysqli)) {
    $cfg = dirname(__DIR__) . '/config.php'; // ../config.php from /ams/user/
    if (is_file($cfg)) { include_once($cfg); }
}

/* Enforce charset/collation */
if (isset($conn) && $conn instanceof mysqli) {
    @mysqli_set_charset($conn, 'utf8mb4');
    @mysqli_query($conn, "SET NAMES 'utf8mb4' COLLATE 'utf8mb4_general_ci'");
    @mysqli_query($conn, "SET collation_connection='utf8mb4_general_ci'");
}

/* If parent page didn't provide $fetch1, fetch a minimal row now */
if (!isset($fetch1) || !is_array($fetch1)) {
    $fetch1 = ['empid'=>'', 'Employee_Full_Name'=>'', 'Team_Name'=>''];
    $uid = isset($_SESSION['user_id1']) ? (string)$_SESSION['user_id1'] : '';
    if ($uid !== '' && isset($conn) && $conn instanceof mysqli) {
        $q = mysqli_query(
            $conn,
            "SELECT empid, Employee_Full_Name, Team_Name
             FROM hr_dump
             WHERE empid='".mysqli_real_escape_string($conn, $uid)."' LIMIT 1"
        );
        if ($q && mysqli_num_rows($q) > 0) {
            $fetch1 = array_merge($fetch1, mysqli_fetch_assoc($q));
        }
    }
}

/* Safe values for echo */
$empidSafe  = htmlspecialchars($fetch1['empid'] ?? '', ENT_QUOTES, 'UTF-8');
$nameSafe   = htmlspecialchars($fetch1['Employee_Full_Name'] ?? '', ENT_QUOTES, 'UTF-8');
$teamSafe   = htmlspecialchars($fetch1['Team_Name'] ?? '', ENT_QUOTES, 'UTF-8');
?>
  <meta name="description" content="BroRiser Attendance Management System">
  <meta name="keywords" content="BroRiser AMS, BroRiser Attendance Management System" />
  <link rel="icon" type="image/png" href="../assets/img/logo.png" sizes="32x32">
  <link rel="apple-touch-icon" sizes="180x180" href="../assets/img/logo.png">
  <link rel="stylesheet" href="../assets/css/bootstrap.css">
  <link rel="stylesheet" href="../assets/css/style.css">
  <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
</head>

<body>
	<div id="loader">
		<img src="../assets/img/loading-icon.png" alt="icon" class="loading-icon">
	</div>
	<div class="appHeader bg-wrapper d-bg-dark text-white">
		<div class="left">
			<a href="#" class="headerButton" data-bs-toggle="modal" data-bs-target="#sidebarPanel"><i class="fas fa-bars"></i></a>
		</div>
		<div class="pageTitle">
			<h3>AMS</h3>
		</div>
		<div class="right">
			<a href="../../" class="headerButton"><span class="sm-btc blink">Back to CRM</span><i class="fas fa-home"></i></a>
		</div>
	</div>

	<div class="modal fade panelbox panelbox-left" id="sidebarPanel" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
      <div class="modal-content">
        <div class="modal-body p-0">
			<div class="profileBox">
				<div class="image-wrapper">
				  <img src="../assets/img/logo.png" alt="image" class="imaged w64">
				</div>
				<div class="in">
					<strong>Welcome : <?php echo $empidSafe; ?></strong>
					<div class="text-muted"><?php echo $nameSafe; ?></div>
					<?php echo $teamSafe; ?>
				</div>
				<a href="#" class="btn btn-icon sidebar-close" data-bs-dismiss="modal"><i class="fas fa-times-circle"></i></a>
			</div>
			<div class="sidebar-balance">
				<div class="in"><h5 class="amount">Manage Attendance</h5></div>
			</div>
			<div class="action-group">
				<a href="viewcurrent.php" class="action-button"><div class="in"><div class="iconbox bg-warning"><i class="fas fa-eye"></i></div>Current<br>Month</div></a>
				<a href="viewlast.php" class="action-button"><div class="in"><div class="iconbox bg-danger"><i class="fas fa-scroll"></i></div>Last<br>Month</div></a>
				
				<a href="leave.php" class="action-button">
				  <div class="in">
					<div class="iconbox bg-success"><i class="fas fa-business-time"></i></div>Leave<br>Dashboard
				  </div>
				</a>
			</div>
					
			<div class="listview-title mt-1">Menu</div>
			  <ul class="listview flush transparent no-line image-listview">
				<li>
				  <a href="notification-list.php" class="item">
					<div class="icon-box d-bg-dark"><i class="fas fa-bell"></i></div><div class="in">Notification</div>
				  </a>
				</li>
				<li>
				  <a href="support.php" class="item">
					<div class="icon-box d-bg-dark"><i class="fas fa-headset"></i></div><div class="in">Support</div>
				  </a>
				</li>
			  </ul>			  
		</div>
      </div>
    </div>
  </div>
