<?php
/* -------------------------------------------------------------------------
 * AMS • Notifications
 * Stack : Core PHP + MySQLi (NO PDO)
 * DB    : Collation utf8mb4_general_ci (set via config.php)
 * Notes : Fixes "Trying to access array offset on value of type null" by
 *         guarding empty queries and always using assoc fetch.
 * ---------------------------------------------------------------------- */
date_default_timezone_set('Asia/Kolkata');
include('../config.php');
@mysqli_set_charset($conn, 'utf8mb4');
@mysqli_query($conn, "SET NAMES 'utf8mb4' COLLATE 'utf8mb4_general_ci'");
@mysqli_query($conn, "SET collation_connection='utf8mb4_general_ci'");

@session_start();
@$user_id1   = $_SESSION['user_id1'];
@$idvfied1   = $_SESSION['idverified1'];
@$namevfied1 = $_SESSION['namevfied1'];

if (!isset($_SESSION['user_id1'])) {
    header("Location: index.php");
    exit;
}

/* --- Extend session cookie --- */
$timeout = 60 * 60 * 24 * 365;
$s_name  = session_name();
if (isset($_COOKIE[$s_name])) {
    setcookie($s_name, $_COOKIE[$s_name], time() + $timeout, '/');
}

/* --- Load current employee row (may be missing) --- */
$fetch1 = null;
$sel1   = mysqli_query($conn, "SELECT * FROM hr_dump WHERE empid='" . mysqli_real_escape_string($conn, (string)$user_id1) . "' LIMIT 1");
if ($sel1 && mysqli_num_rows($sel1) > 0) {
    $fetch1 = mysqli_fetch_assoc($sel1);
}

/* --- Safe values (avoid "array offset on null") --- */
$employeeNumber = $fetch1 && isset($fetch1['Employee_Number']) ? $fetch1['Employee_Number'] : '';
$hasEmployeeRow = ($employeeNumber !== '');

/* --- Optional: counts for team approvals (guarded) --- */
$pending_team_leaves = 0;
if ($hasEmployeeRow) {
    $q1 = mysqli_query($conn,
        "SELECT COUNT(*) AS c FROM emp_leave 
         WHERE Functional_Reporting='" . mysqli_real_escape_string($conn, $employeeNumber) . "'
           AND (Approval_Status IS NULL OR Approval_Status='Pending')");
    if ($q1) {
        $r1 = mysqli_fetch_assoc($q1);
        $pending_team_leaves = (int)($r1['c'] ?? 0);
    }
}

/* --- You had two queries named $queryFR then overwritten; removed as unused.
 *     If needed later, always guard with $hasEmployeeRow.
 */
?>
<!doctype html>
<html lang="en">
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1, minimum-scale=1, maximum-scale=1, viewport-fit=cover" />
    <meta name="apple-mobile-web-app-capable" content="yes" />
    <meta name="apple-mobile-web-app-status-bar-style" content="black-translucent">
    <title>Dashboard IC AMS</title>
    <?php include('header.php'); ?>
</head>
<body>

<div id="appCapsule">
    <div class="section full">
        <?php if (!$hasEmployeeRow): ?>
            <div class="px-3 py-2">
                <div class="alert alert-warning small mb-2" role="alert" style="border-radius:12px;">
                    Employee mapping not found for your login (empid: <?php echo htmlspecialchars((string)$user_id1, ENT_QUOTES, 'UTF-8'); ?>).
                    Notifications below are generic. Please contact HR to link your Employee Number.
                </div>
            </div>
        <?php endif; ?>

        <ul class="listview image-listview flush">
            <li>
                <a href="javascript:void(0)" class="item">
                    <div class="icon-box bg-primary"><i class="fas fa-check"></i></div>
                    <div class="in">
                        <div>
                            <div class="mb-05"><strong>May'2023 Attendance Alert</strong></div>
                            <div class="text-small mb-05">
                                Check your attendance and mark ODs / Leaves, if any, for the month of May-2023 immediately
                                to avoid any deduction in salary due to unauthorized absence, approved on or before 31st of May ‘2023. <br>
                                All HOD/supervisors are also requested to approve or reject Leave / ODs of your respective team
                                members as any unapproved leaves / OD lead to deduction in their salaries.
                            </div>
                            <div class="text-xsmall">2023/05/15 10:30 AM</div>
                        </div>
                    </div>
                </a>
            </li>

            <li class="active">
                <a href="javascript:void(0)" class="item">
                    <div class="icon-box bg-warning"><i class="fas fa-check"></i></div>
                    <div class="in">
                        <div>
                            <div class="mb-05"><strong>Password changed</strong></div>
                            <div class="text-small mb-05">Your password has been changed</div>
                            <div class="text-xsmall">2023/05/12 10:30 AM</div>
                        </div>
                    </div>
                </a>
            </li>

            <li>
                <a href="javascript:void(0)" class="item">
                    <div class="icon-box bg-success"><i class="fas fa-check"></i></div>
                    <div class="in">
                        <div>
                            <div class="mb-05"><strong>Public Holiday on account of Elections in Uttar Pradesh</strong></div>
                            <div class="text-small mb-05">
                                Uttar Pradesh Govt. has declared public holiday on 4th &amp; 11th May 2023, on account of General
                                Election of Municipal Corporations, Councils &amp; Panchayats.
                            </div>
                            <div class="text-xsmall">2023/05/10 10:30 AM</div>
                        </div>
                    </div>
                </a>
            </li>

            <?php if ($hasEmployeeRow): ?>
                <li>
                    <a href="javascript:void(0)" class="item">
                        <div class="icon-box bg-danger"><i class="fas fa-users"></i></div>
                        <div class="in">
                            <div>
                                <div class="mb-05"><strong>Pending Team Leaves</strong></div>
                                <div class="text-small mb-05">
                                    <?php echo (int)$pending_team_leaves; ?> request(s) awaiting your approval.
                                </div>
                                <div class="text-xsmall"><?php echo date('Y/m/d h:i A'); ?></div>
                            </div>
                        </div>
                    </a>
                </li>
            <?php endif; ?>
        </ul>
    </div>

    <?php include('include/copyright.php'); ?>
</div>

<?php include('footer.php'); ?>
</body>
</html>
