<?php
date_default_timezone_set('Asia/Kolkata'); 
include ('../config.php');
@session_start();
@$user_id1 = $_SESSION['user_id1'];
@$idvfied1 = $_SESSION['idverified1'];
@$namevfied1 = $_SESSION['namevfied1'];

if (!isset($_SESSION['user_id1'])) {
    header("Location: index.php");
    exit;
}

$timeout = 60 * 60 * 24 * 365;
$s_name = session_name();
if (isset($_COOKIE[$s_name])) {
    setcookie($s_name, $_COOKIE[$s_name], time() + $timeout, '/');
}

$sel1 = mysqli_query($conn,"SELECT * FROM hr_dump WHERE empid='".mysqli_real_escape_string($conn,$user_id1)."'");
$fetch1 = mysqli_fetch_array($sel1);

$connemp = mysqli_query($conn,"SELECT * FROM hr_dump WHERE empid='".mysqli_real_escape_string($conn,$_GET['empid'])."'");
$empdata = mysqli_fetch_array($connemp);
?>
<!doctype html>
<html lang="en">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<meta name="viewport" content="width=device-width, initial-scale=1, minimum-scale=1, maximum-scale=1, viewport-fit=cover" />
<title>View Team Attendance</title>
<?php include('header.php'); ?>
<div id="appCapsule">
    <div class="section wallet-card-section pt-1">
        <div class="wallet-card">
            <?php include('include/wallet-balance.php'); ?>
            <div class="row text-center mb-4">
                <h6 class="text-center">
                    <?php echo htmlspecialchars($empdata['Employee_Full_Name'] ?? 'Unknown'); ?> : Current Month
                </h6>
                <div class="table">
                    <table class="table table-striped table-bordered bootstrap-datatable datatable responsive">
                        <thead>
                            <tr>
                                <th>Date</th>
                                <th>Status</th>
                                <th>Office In - Out</th>
                                <th>Approval</th>
                                <th>In Location</th>
                                <th>Out Location</th>
                            </tr>
                        </thead>
                        <tbody>
                        <?php 
                        $sn = date('Y-m-01');
                        $tn = date('Y-m-t');
                        while ($sn <= $tn) {
                            $cmsql = mysqli_query($conn,"SELECT * FROM ams_final WHERE empid='".mysqli_real_escape_string($conn,$_GET['empid'])."' AND OfficeDate='$sn'");
                            $cmdata = mysqli_fetch_array($cmsql);
                        ?>
                        <tr class="text-center">
                            <td><?php echo $sn; ?></td>
                            <td><?php echo $cmdata['FinalStatus'] ?? '-'; ?></td>
                            <td><?php echo ($cmdata['InTime'] ?? '-') . " - " . ($cmdata['OutTime'] ?? '-'); ?></td>
                            <td><?php echo $cmdata['Approval_Status'] ?? '-'; ?></td>
                            <td style="min-width:190px; word-wrap:break-word; white-space:normal !important;">
                                <?php echo $cmdata['location'] ?? '-'; ?>
                            </td>
                            <td><?php echo $cmdata['out_location'] ?? '-'; ?></td>
                        </tr>
                        <?php 
                            $sn = date('Y-m-d', strtotime($sn . ' +1 day'));
                        } 
                        ?>
                        </tbody>
                    </table>
                </div>

                <h4>Attendance: 
                <?php
                    $now = new DateTime();
                    $firstDayOfCurrentMonth = new DateTime($now->format('Y-m-01'));
                    $lastDayOfPreviousMonth = $firstDayOfCurrentMonth->sub(new DateInterval('P1D'));
                    $lastM = $lastDayOfPreviousMonth->format('Y-m');
                    echo $lastDayOfPreviousMonth->format('M-Y');
                ?>
                </h4>

                <div class="table">
                    <table class="table table-striped table-bordered bootstrap-datatable datatable responsive">
                        <thead>
                            <tr>
                                <th>Date</th>
                                <th>Office In</th>
                                <th>Office Out</th>
                            </tr>
                        </thead>
                        <tbody>
                        <?php 
                        $query = "SELECT * FROM ams_final WHERE empid='".mysqli_real_escape_string($conn,$_GET['empid'])."' AND OfficeDate LIKE '%$lastM%' ORDER BY OfficeDate ASC";
                        if ($result = @mysqli_query($conn,$query)) {
                            while ($data = mysqli_fetch_assoc($result)) {
                        ?>
                            <tr>
                                <td><?php echo $data['OfficeDate']; ?></td>
                                <td><?php echo $data['InTime']; ?></td>
                                <td><?php echo $data['OutTime']; ?></td>
                            </tr>
                        <?php 
                            } 
                        } else {
                            echo "<tr><td colspan='3'>No records found / Table missing</td></tr>";
                        }
                        ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    <?php include('include/copyright.php'); ?>
</div>
<?php include('footer.php'); ?>
