<?php
$base_dir = __DIR__ . '/Base';
$static_url = '/Resido/assets'; // Ensure this is the correct path

// Include the common navlink content
ob_start();
include "$base_dir/navbar.php"; // This file contains the shared navlink content
$navlink_content = ob_get_clean(); // Capture the navlink content
$page= 'nav';
$fpage= 'foot';

// Optionally define the Hero block content
ob_start();
?>
			
<!-- ============================ Page Title Start================================== -->
<div class="page-title">
	<div class="container">
		<div class="row">
			<div class="col-lg-12 col-md-12">
				
				<h2 class="ipt-title">Components</h2>
				<span class="ipn-subtitle">Lists of all used components</span>
				
			</div>
		</div>
	</div>
</div>
<!-- ============================ Page Title End ================================== -->

<!-- ============================ Agency List Start ================================== -->
<section>

	<div class="container">

		<!-- row Start -->
		<div class="row mt-4">
		
			<div class="col-lg-6 col-md-12 col-sm-12">
				<h4>Typography</h4>
					<h1>Heading One</h1>
					<h2>Heading Two</h2>
					<h3>Heading Three</h3>
					<h4>Heading Four</h4>
					<h5>Heading Five</h5>
					<h6>Heading Six</h6>
			</div>
			
			<div class="col-lg-6 col-md-12 col-sm-12">
				<h4 class="mb-4">Buttons</h4>
				<button type="submit" class="btn btn-primary mb-3">Simple button</button></br>
				<button type="submit" class="btn btn-light-primary btn-rounded mb-3 me-2">Simple button</button>
				<button type="submit" class="btn btn-success btn-md mb-3">Midium Button</button></br>
				<button type="submit" class="btn btn-danger btn-lg me-2">Large Button</button>
				<button type="submit" class="btn btn-outline-primary">Outline Button</button></br></br>
				<a href="#" class="btn btn-info rounded-pill mb-3">Simple button</a></br>
				<a href="#" class="btn btn-light-primary rounded-pill mb-3">Simple button</a>
			</div>
			
		</div>
		<!-- /row -->	

		<!-- row Start -->
		<div class="row mt-4">
		
			<div class="col-lg-6 col-md-12 col-sm-12">
				<h4 class="mb-3">Shadow & Simple Inputbox</h4>
				
				<div class="form-group">
					<div class="input-with-icon">
						<input type="text" class="form-control" placeholder="Neighborhood">
						<i class="fa-solid fa-magnifying-glass"></i>
					</div>
				</div>
				<div class="form-group">
					<label class="mb-2">Name</label>
					<input type="text" class="form-control simple">
				</div>
			</div>
			
			<div class="col-lg-6 col-md-12 col-sm-12">
				<h4>Checkbox & Radio buttons</h4>
				<ul class="no-ul-list">
					<li>
						<input id="a-1" class="form-check-input" name="a-1" type="checkbox">
						<label for="a-1" class="form-check-label">Air Condition</label>
					</li>
					<li>
						<input id="a-2" class="form-check-input" name="a-2" type="checkbox">
						<label for="a-2" class="form-check-label">Bedding</label>
					</li>
					
				</ul>
				
				<ul class="no-ul-list">
					<li>
						<input id="a-p" class="form-check-input" name="a-p" type="radio">
						<label for="a-p" class="form-check-label">Air Condition</label>
					</li>
					<li>
						<input id="a-c" class="form-check-input" name="a-c" type="radio">
						<label for="a-c" class="form-check-label">Bedding</label>
					</li>
					
				</ul>
			</div>
			
		</div>
		<!-- /row -->					
		
	</div>
			
</section>
<!-- ============================ Agency List End ================================== -->

<!-- ============================ Call To Action ================================== -->
<section class="bg-primary call-to-act-wrap">
	<div class="container">
		
		<!-- estate-agent code  -->
		<?php
			include "$base_dir/Components/Home/estate-agent.php";
		?>

	</div>
</section>
<!-- ============================ Call To Action End ================================== -->


			

<?php
$hero_content = ob_get_clean(); // Capture the hero content

// Include the base template
include "$base_dir/style/base.php";
?>