<?php

if (session_status() === PHP_SESSION_NONE) { session_start(); }
date_default_timezone_set('Asia/Kolkata');

/* ------------------------- Centralized config ------------------------- */
$cfgs = [
  __DIR__ . '/config.php',
  __DIR__ . '/../config.php',
  __DIR__ . '/../../config.php'
];
$cfgFound = false;
foreach ($cfgs as $c) { if (file_exists($c)) { require_once $c; $cfgFound = true; break; } }
if (!$cfgFound) { http_response_code(500); exit('config.php not found'); }

?>
<?php
$base_dir = __DIR__ . '/Base';
$static_url = '/brocrm/assets'; // Ensure this is the correct path

// Include the common navlink content
ob_start();
include "$base_dir/navbar.php"; // This file contains the shared navlink content
$navlink_content = ob_get_clean(); // Capture the navlink content
$page= 'nav';
$fpage= 'foot';

// Optionally define the Hero block content
ob_start();
?>
			
<!-- ============================ Page Title Start================================== -->
<div class="page-title">
	<div class="container">
		<div class="row">
			<div class="col-lg-12 col-md-12">
				
				<h2 class="ipt-title">Contact Us</h2>
				<span class="ipn-subtitle">Lists of our all Popular agencies</span>
				
			</div>
		</div>
	</div>
</div>
<!-- ============================ Page Title End ================================== -->

<!-- ============================ Agency List Start ================================== -->
<section>

	<div class="container">
	
		<!-- row Start -->
		<div class="row">
		
			<div class="col-lg-7 col-md-7">
                <?php
                $submission_msg = '';
                if ($_SERVER["REQUEST_METHOD"] === "POST" && isset($_POST['send'])) {
                    // Fetch and sanitize form data
                    $name = trim($_POST['name'] ?? '');
                    $contactNumber = trim($_POST['ContactNumber'] ?? '');
                    $email = trim($_POST['email'] ?? '');
                    $subject = trim($_POST['subject'] ?? '');
                    $message = trim($_POST['Message'] ?? '');
                
                    // Get full page URL
                    $page_url = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http");
                    $page_url .= "://{$_SERVER['HTTP_HOST']}{$_SERVER['REQUEST_URI']}";
                
                    $status = 'pending';
                    $created_at = date('Y-m-d H:i:s');
                
                    if ($name && $contactNumber && $email && $subject) {
                        $stmt = $conn_crmplus->prepare("INSERT INTO contact_requests (`name`, `ContactNumber`, `email`, `subject`, `message`, `page_url`, `status`, `created_at`) VALUES (?, ?, ?, ?, ?, ?, ?, ?)");
                        $stmt->bind_param("ssssssss", $name, $contactNumber, $email, $subject, $message, $page_url, $status, $created_at);
                
                        if ($stmt->execute()) {
                            $submission_msg = '<div class="alert alert-success">Thank you! Your request has been submitted successfully.</div>';
                        } else {
                            $submission_msg = '<div class="alert alert-danger">Error: ' . htmlspecialchars($stmt->error) . '</div>';
                        }
                
                        $stmt->close();
                    } else {
                        $submission_msg = '<div class="alert alert-warning">Please fill all required fields.</div>';
                    }
                }
                ?>
                <!-- Contact Form HTML -->
                <form method="post" name="contact_form" enctype="multipart/form-data" autocomplete="off">
                    <p class="mb-0" id="error-msg"></p>
                    <div id="simple-msg"><?= $submission_msg ?></div>
                    <div class="row">
                        <div class="col-lg-6 col-md-6">
                            <div class="form-group">
                                <label class="mb-2" for="name">Name</label>
                                <input name="name" id="name" type="text" class="form-control simple" placeholder="Enter your full name" required>
                            </div>
                        </div>
                        <div class="col-lg-6 col-md-6">
                            <div class="form-group">
                                <label class="mb-2" for="ContactNumber">Contact Number</label>
                                <input type="tel" class="form-control" name="ContactNumber" pattern="\d{10}" minlength="10" maxlength="10" oninput="this.value = this.value.replace(/\D/g, '').slice(0, 10);" placeholder="Only 10 Digits Mobile No" required>
                            </div>
                        </div>
                        <div class="col-lg-6 col-md-6">
                            <div class="form-group">
                                <label class="mb-2" for="email">Email</label>
                                <input name="email" id="email" type="email" class="form-control simple" placeholder="Enter your email address" required>
                            </div>
                        </div>
                        <div class="col-lg-6 col-md-6">
                            <div class="form-group">
                                <label class="mb-2" for="subject">Subject</label>
                                <input name="subject" id="subject" type="text" class="form-control simple" placeholder="Enter your subject" required>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <label class="mb-2" for="Message">Message</label>
                        <textarea name="Message" id="Message" class="form-control simple" placeholder="Enter your message"></textarea>
                    </div>
                
                    <div class="form-group">
                        <button class="btn btn-primary px-5 rounded" type="submit" id="submit" name="send">
                            Submit Request
                        </button>
                    </div>
                </form>
			</div>
			
			<div class="col-lg-5 col-md-5">
				<div class="contact-info">
					<h2>Get In Touch</h2>
						<?php
							include "$base_dir/Components/Pages/get-in-touch.php";
						?>
				</div>
			</div>
			
		</div>
		<!-- /row -->		
		
	</div>
			
</section>
<!-- ============================ Agency List End ================================== -->

<!-- ============================ Call To Action ================================== -->
<!--<section class="bg-primary call-to-act-wrap">
	<div class="container">
		</?php include "$base_dir/Components/Home/estate-agent.php"; ?>
	</div>
</section> -->
<!-- ============================ Call To Action End ================================== -->


			

<?php
$hero_content = ob_get_clean(); // Capture the hero content

// Include the base template
include "$base_dir/style/base.php";
?>