<?php
/* =============================================================================
 * File   : dst_focus_helper.php
 * Purpose: Auto-scroll + highlight a lead card on dst.php via ?focus={id}
 * Usage  : include __DIR__.'/dst_focus_helper.php'; at the end of dst.php
 * Notes  : Works with:
 *            - <div id="lead-{id}">
 *            - <div data-lead="{id}">
 *            - <div data-lead-id="{id}">
 *            - <div class="lead-card" data-id="{id}">
 *          If only data-lead is present, this script adds id="lead-{id}".
 * ============================================================================= */
?>
<style>
@keyframes focusBlink {
  0%   { box-shadow: 0 0 0 0 rgba(14,165,233,.8); }
  50%  { box-shadow: 0 0 0 10px rgba(14,165,233,.15); }
  100% { box-shadow: 0 0 0 0 rgba(14,165,233,0); }
}
.focus-highlight{
  outline: 2px solid #0ea5e9;
  border-radius: 16px;
  animation: focusBlink 1.2s ease-in-out 0s 3;
  scroll-margin-top: 84px; /* adjust if your fixed header height differs */
}
</style>
<script>
(function(){
  // Resolve id from ?focus=123 or from #lead-123
  var params = new URLSearchParams(location.search);
  var id = params.get('focus');
  if (!id) {
    var m = (location.hash || '').match(/lead-(\d+)/);
    if (m) id = m[1];
  }
  if (!id) return;

  function findCard(){
    // 1) #lead-{id}
    var el = document.getElementById('lead-' + id);
    if (el) return el;

    // 2) [data-lead="{id}"]
    el = document.querySelector('[data-lead="' + id + '"]');
    if (el) return el;

    // 3) [data-lead-id="{id}"]
    el = document.querySelector('[data-lead-id="' + id + '"]');
    if (el) return el;

    // 4) .lead-card[data-id="{id}"]
    el = document.querySelector('.lead-card[data-id="' + id + '"]');
    if (el) return el;

    // 5) Any anchor that contains id={id}; climb to a card-like wrapper
    var link = document.querySelector('a[href*="id=' + encodeURIComponent(id) + '"]');
    if (link){
      var card = link.closest('.crm-card, .card, li, tr, .list-group-item, .media, .row, div');
      if (card) return card;
    }
    return null;
  }

  function highlight(el){
    if (!el) return false;

    // If it's a data-lead element, stamp an id for future anchors
    if (!el.id && el.hasAttribute('data-lead')) {
      el.id = 'lead-' + id;
    }

    if (!el.classList.contains('focus-highlight')) el.classList.add('focus-highlight');

    try { el.scrollIntoView({ behavior: 'smooth', block: 'center' }); }
    catch(e){ el.scrollIntoView(true); }

    setTimeout(function(){ el.classList.remove('focus-highlight'); }, 5000);
    return true;
  }

  // Try immediately; if not found yet, observe mutations + short polling
  if (highlight(findCard())) return;

  var observer = new MutationObserver(function(){
    var el = findCard();
    if (el && highlight(el)) {
      observer.disconnect(); clearInterval(poller);
    }
  });
  observer.observe(document.documentElement, { childList: true, subtree: true });

  var tries = 0, poller = setInterval(function(){
    var el = findCard();
    if (el && highlight(el)) {
      observer.disconnect(); clearInterval(poller);
    } else if (++tries > 50) { // ~5s
      observer.disconnect(); clearInterval(poller);
    }
  }, 100);
})();
</script>
