<?php
/* footer.php - light footer adapted to kit
   - reads ui_footer_nav if present else uses fallback
*/
if(session_status()===PHP_SESSION_NONE)session_start();
require_once __DIR__.'/config.php';
$BASE = defined('BASE_URL')?BASE_URL:'/';
$theme_mode = $_SESSION['theme_mode'] ?? 'light';
$nav = [];
if(isset($conn) && ($r=@mysqli_query($conn,"SELECT * FROM ui_footer_nav WHERE is_active=1 ORDER BY sort_order ASC"))){
    while($rr=@mysqli_fetch_assoc($r))$nav[]=$rr;
}
if(empty($nav)){
    $nav = [
        ['label'=>'About','href'=>$BASE.'xhtml/about.html'],
        ['label'=>'Contact','href'=>$BASE.'xhtml/contact.html'],
        ['label'=>'Privacy','href'=>$BASE.'xhtml/privacy.html'],
    ];
}
?>
<footer class="site-footer">
  <nav>
    <ul class="d-flex justify-content-center list-unstyled mb-2">
      <?php foreach($nav as $n){ echo '<li class="me-3"><a href="'.htmlspecialchars($n['href']?:'#').'">'.htmlspecialchars($n['label']).'</a></li>'; } ?>
    </ul>
  </nav>
  <div class="text-center small">© <?php echo date('Y'); ?> Your Company</div>
</footer>
<script>
(function(){
  const sidebar   = document.getElementById('mobileSidebar');
  const overlay   = document.querySelector('.dark-overlay');
  const openBtns  = document.querySelectorAll('.menu-toggler');
  const closeBtn  = document.querySelector('.sidebar-close');

  function openMenu(){
    if(!sidebar) return;
    sidebar.classList.add('open');
    if (overlay){ overlay.classList.add('visible'); }
    sidebar.setAttribute('aria-hidden','false');
    document.body.style.overflow='hidden';
  }
  function closeMenu(){
    if(!sidebar) return;
    sidebar.classList.remove('open');
    if (overlay){ overlay.classList.remove('visible'); }
    sidebar.setAttribute('aria-hidden','true');
    document.body.style.overflow='';
  }

  openBtns.forEach(btn => btn.addEventListener('click', openMenu));
  if (overlay) overlay.addEventListener('click', closeMenu);
  if (closeBtn) closeBtn.addEventListener('click', closeMenu);
  document.addEventListener('keydown', (e)=>{ if(e.key==='Escape') closeMenu(); });
})();
</script>
