<?php
/* =============================================================================
 * File   : footer_mobile.php
 * Purpose: Mobile bottom menubar (theme-aware) + role-aware CRM/DST link + AMS
 * Notes  : - Uses mobile/ assets only
 *          - SVGs forced to currentColor
 *          - AMS center button shown only when role_id === 4
 *          - DB charset/collation forced to utf8mb4_general_ci (no PDO)
 *          - Shows "Projects" text under the search icon
 *          - Shows "DST CRM" text when CRM link routes to dst.php (role_id=4)
 * ========================================================================== */

if (session_status() === PHP_SESSION_NONE) session_start();
require_once __DIR__ . '/config.php';

/* --- Enforce charset & collation (utf8mb4_general_ci) -------------------- */
if (isset($conn) && $conn instanceof mysqli) {
    @mysqli_set_charset($conn, 'utf8mb4');
    @mysqli_query($conn, "SET NAMES 'utf8mb4' COLLATE 'utf8mb4_general_ci'");
}
if (isset($conn_crm) && $conn_crm instanceof mysqli) {
    @mysqli_set_charset($conn_crm, 'utf8mb4');
    @mysqli_query($conn_crm, "SET NAMES 'utf8mb4' COLLATE 'utf8mb4_general_ci'");
}
if (isset($conn_crmplus) && $conn_crmplus instanceof mysqli) {
    @mysqli_set_charset($conn_crmplus, 'utf8mb4');
    @mysqli_query($conn_crmplus, "SET NAMES 'utf8mb4' COLLATE 'utf8mb4_general_ci'");
}

/* --- Paths --------------------------------------------------------------- */
$BASE   = defined('BASE_URL') ? rtrim(BASE_URL, '/') . '/' : '/';
$MOBILE = $BASE . 'mobile/';
$ASSET  = $BASE . 'mobile/';

/* --- Helpers ------------------------------------------------------------- */
if (!function_exists('h')) { function h($s){ return htmlspecialchars((string)$s, ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8'); } }

$here = strtolower(basename($_SERVER['PHP_SELF'] ?? 'index.php'));
function is_active($names, $here){
    foreach ((array)$names as $n) {
        $n = strtolower(basename($n));
        if ($here === $n) return ' active';
    }
    return '';
}

/* --- Role-aware CRM/DST route ------------------------------------------- */
$ME = $_SESSION['auth'] ?? [];
$ROLE_ID = isset($ME['role_id']) ? (int)$ME['role_id'] : 0;
$crmHref = $MOBILE . 'crm_mobile.php';
if     ($ROLE_ID === 4) $crmHref = $MOBILE . 'dst.php';
elseif ($ROLE_ID === 6) $crmHref = $MOBILE . 'crm_mobile.php';

/* Label for CRM tile */
$crmLabel = ($ROLE_ID === 4) ? 'DST CRM' : 'CRM';
?>
<!-- ===== Menubar (mobile bottom nav) =================================== -->
<style>
  /* ---------- Theme tokens ---------- */
  :root{
    --menubar-height: 68px;
    --menubar-bg: #FFF7F2;               /* light-mode menubar bg (peachy) */
    --menubar-elev: 0 10px 30px rgba(0,0,0,0.06);
    --icon-tile-bg: rgba(254,144,99,0.10); /* light icon tile */
    --icon-color: #6b7280;                /* inactive icon (light) */
    --icon-active: #fe9063;               /* primary/active */
    --ams-bg: #fe9063;
    --ams-fg: #ffffff;
    --label-color: #6b7280;
    --label-active: #fe9063;
  }

  /* dark theme */
  .theme-dark{
    --menubar-bg: #253251;                /* deep indigo/navy */
    --menubar-elev: 0 8px 28px rgba(0,0,0,0.6);
    --icon-tile-bg: rgba(255,255,255,0.06); /* subtle tile in dark */
    --icon-color: #cbd5e1;                /* lightish icon (dark bg) */
    --icon-active: #FE9063;
    --ams-bg: #fe9063;
    --ams-fg: #0b1220;
    --label-color: #cbd5e1;
    --label-active: #FE9063;
  }

  /* ---------- Menubar layout ---------- */
  .menubar-area {
    position: fixed;
    left: 0;
    right: 0;
    bottom: 0;
    z-index: 9999;
    height: var(--menubar-height);
    display:flex;
    align-items:center;
    justify-content:center;
    padding: 10px calc(12px + env(safe-area-inset-left)) calc(10px + env(safe-area-inset-bottom));
    background: var(--menubar-bg);
    box-shadow: var(--menubar-elev);
    border-top-left-radius:14px;
    border-top-right-radius:14px;
    backdrop-filter: blur(6px);
    -webkit-backdrop-filter: blur(6px);
    background-image: none !important;
  }

  /* keep page content above menubar (so nothing is hidden) */
  .page-content, .content-inner { padding-bottom: calc(var(--menubar-height) + 18px) !important; }

  .toolbar-inner.menubar-nav {
    width:100%;
    max-width:1000px;
    display:flex;
    align-items:center;
    justify-content:space-between;
    gap:6px;
    box-sizing:border-box;
    padding:0 6px;
  }

  /* ---------- Icon tile & svg color ---------- */
  .menubar-area .nav-link {
    text-decoration:none;
    display:inline-flex;
    flex-direction:column;          /* allow label below icon */
    align-items:center;
    justify-content:center;
    width:64px;                     /* a bit wider to fit label */
    height:54px;
    border-radius:10px;
    position:relative;
    color: var(--icon-color) !important;
    transition: color .16s ease, transform .12s ease, box-shadow .12s ease;
    font-size:18px;
    gap:4px;
  }
  .menubar-area .nav-link .icon-tile {
    display:inline-flex;
    width:38px;
    height:38px;
    border-radius:10px;
    align-items:center;
    justify-content:center;
    background: var(--icon-tile-bg);
  }
  .menubar-area .nav-label{
    font-size:10.5px;
    line-height:1;
    color: var(--label-color);
    letter-spacing:.2px;
    user-select:none;
  }

  /* force every svg to follow currentColor */
  .menubar-area svg,
  .menubar-area svg * {
    color: inherit !important;
    fill: currentColor !important;
    stroke: currentColor !important;
  }

  .menubar-area .nav-link.active,
  .menubar-area .nav-link:hover { color: var(--icon-active) !important; }
  .menubar-area .nav-link.active .nav-label,
  .menubar-area .nav-link:hover .nav-label { color: var(--label-active); }

  .menubar-area .nav-link.active::before{
    content:"";
    position:absolute;
    left:50%; top:21px;
    width:42px; height:30px;
    transform:translate(-50%,-50%);
    background: rgba(255,255,255,0.02);
    border-radius:999px;
    z-index:-1;
  }

  /* ---------- Center AMS / Add button ---------- */
  .menubar-area .nav-link.add-post{
    width:64px; height:64px;
    border-radius:14px;
    transform: translateY(-18px);
    box-shadow: 0 14px 30px rgba(20,20,30,0.15);
    display:flex; align-items:center; justify-content:center;
    padding:0; background: transparent;
  }
  .menubar-area .nav-link.add-post .ams-btn {
    width:56px; height:56px;
    border-radius:12px;
    display:flex; align-items:center; justify-content:center; flex-direction:column;
    text-decoration:none;
    background: var(--ams-bg);
    color: var(--ams-fg) !important;
    font-weight:600;
    box-shadow: 0 10px 24px rgba(0,0,0,0.18);
    border: 3px solid rgba(255,255,255,0.06);
    line-height:1;
  }
  .theme-dark .menubar-area .nav-link.add-post .ams-btn { border: 2px solid rgba(255,255,255,0.04); }
  .menubar-area .nav-link.add-post .ams-label {
    display:block;
    font-size:10.5px;
    margin-top:3px;
    color: rgba(255,255,255,0.95);
    letter-spacing:.4px;
    line-height:1;
  }
  .theme-dark .menubar-area .nav-link.add-post .ams-label { color: var(--ams-fg); }

  /* AMS icon dot */
  .ams-ico { width:18px;height:18px;border-radius:50%; background: rgba(255,255,255,0.95); display:block; }

  /* responsive */
  @media (max-width:420px){
    .menubar-area .nav-link { width:58px;height:52px; gap:3px; }
    .menubar-area .nav-link .icon-tile { width:34px; height:34px; border-radius:10px; }
    .menubar-area .nav-link.add-post { width:60px;height:60px; transform:translateY(-20px);}
    .menubar-area .nav-link.add-post .ams-btn { width:52px;height:52px;border-radius:12px;}
    .menubar-area .nav-link.add-post .ams-label { font-size:10px; margin-top:2px; }
    .menubar-area .nav-label{ font-size:10px; }
  }

  html,body{ margin-bottom:0 !important; padding-bottom:0 !important; }
</style>

<div class="menubar-area" role="navigation" aria-label="Mobile menubar">
  <div class="toolbar-inner menubar-nav">

    <!-- Home -->
    <a href="<?php echo h($MOBILE.'index.php'); ?>"
       class="nav-link<?php echo is_active(['index.php','home_unified.php'], $here); ?>"
       aria-label="Home" title="Home">
      <span class="icon-tile" aria-hidden="true">
        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 22 22">
          <path d="M21.44 11.035a.75.75 0 0 1-.69.465H18.5V19A2.25 2.25 0 0 1 16.25 21.25h-3a.75.75 0 0 1-.75-.75V16a.75.75 0 0 0-.75-.75h-1.5a.75.75 0 0 0-.75.75v4.5a.75.75 0 0 1-.75.75h-3A2.25 2.25 0 0 1 3.5 19v-7.5H1.25a.75.75 0 0 1-.69-.465.75.75 0 0 1 .158-.818l9.75-9.75A.75.75 0 0 1 11 .246a.75.75 0 0 1 .533.222l9.75 9.75a.75.75 0 0 1 .158.818z"/>
        </svg>
      </span>
      <!-- (No text label requested for Home) -->
    </a>

    <!-- Search / Projects (with label "Projects") -->
    <a href="<?php echo h($MOBILE.'projects_mobile'); ?>"
       class="nav-link<?php echo is_active(['projects_mobile'], $here); ?>"
       aria-label="Projects / Search" title="Projects">
      <span class="icon-tile" aria-hidden="true">
        <svg width="20" height="20" viewBox="0 0 24 24" aria-hidden="true">
          <path d="M11 19C15.4183 19 19 15.4183 19 11C19 6.58172 15.4183 3 11 3C6.58172 3 3 6.58172 3 11C3 15.4183 6.58172 19 11 19Z" stroke-width="2.2" stroke-linecap="round" stroke-linejoin="round"/>
          <path d="M21 21L16.65 16.65" stroke-width="2.2" stroke-linecap="round" stroke-linejoin="round"/>
        </svg>
      </span>
      <span class="nav-label">Projects</span>
    </a>

    <!-- Add / AMS center button (role-aware) -->
    <?php if ($ROLE_ID === 4): ?>
      <a href="<?php echo h($BASE . 'mobile/ams/user/dashboard.php'); ?>"
         class="nav-link add-post<?php echo is_active(['dashboard.php'], $here); ?>"
         aria-label="AMS - Clock In / Out" title="AMS">
        <span class="ams-btn" role="img" aria-hidden="true">
          <span class="ams-ico"></span>
          <span class="ams-label">AMS</span>
        </span>
      </a>
    <?php else: ?>
      <a href="<?php echo h($MOBILE.'crm_add.php'); ?>"
         class="nav-link add-post<?php echo is_active(['crm_add.php'], $here); ?>"
         aria-label="Add new" title="Add">
        <span class="ams-btn" style="background:var(--icon-tile-bg); color:var(--icon-active); border:0;">
          <i class="fa-solid fa-plus" aria-hidden="true" style="font-size:20px;"></i>
          <span class="ams-label">Add</span>
        </span>
      </a>
    <?php endif; ?>

    <!-- Chat / CRM (label becomes "DST CRM" when role_id=4 / dst.php) -->
    <a href="<?php echo h($crmHref); ?>"
       class="nav-link<?php echo is_active(['crm_mobile.php','dst.php','chat.php'], $here); ?>"
       aria-label="<?php echo h($crmLabel); ?>" title="<?php echo h($crmLabel); ?>">
      <span class="icon-tile" aria-hidden="true">
        <svg width="20" height="20" viewBox="0 0 511.606 511.606" aria-hidden="true">
          <path d="M436.594 74.943c-99.917-99.917-261.637-99.932-361.568 0-80.348 80.347-95.531 199.817-48.029 294.96L.662 485.742c-3.423 15.056 10.071 28.556 25.133 25.133l115.839-26.335c168.429 84.092 369.846-37.653 369.846-228.812 0-68.29-26.595-132.494-74.886-180.785zM309.143 319.394h-160c-11.598 0-21-9.402-21-21s9.402-21 21-21h160c11.598 0 21 9.402 21 21s-9.402 21-21 21zm53.334-85.333H149.143c-11.598 0-21-9.402-21-21s9.402-21 21-21h213.334c11.598 0 21 9.402 21 21s-9.403 21-21 21z"/>
        </svg>
      </span>
      <span class="nav-label"><?php echo h($crmLabel); ?></span>
    </a>

    <!-- Profile -->
    <a href="<?php echo h($MOBILE.'user-add.php'); ?>"
       class="nav-link<?php echo is_active(['user-add.php'], $here); ?>"
       aria-label="Profile" title="Profile">
      <span class="icon-tile" aria-hidden="true">
        <svg width="18" height="18" viewBox="0 0 16 21" aria-hidden="true">
          <path d="M8 7.75a3.75 3.75 0 1 0 0-7.5 3.75 3.75 0 1 0 0 7.5zm7.5 9v1.5a.75.75 0 0 1-.217.532C13.61 20.455 8.57 20.5 8 20.5s-5.61-.045-7.282-1.718A.75.75 0 0 1 .5 18.25v-1.5a7.5 7.5 0 1 1 15 0z"/>
        </svg>
      </span>
      <!-- (No text label requested for Profile) -->
    </a>

  </div>
</div>
<!-- ==================================================================== -->

<!-- ===== Scripts ====================================================== -->
<script src="<?php echo h($ASSET.'assets/js/jquery.js'); ?>"></script>
<script src="<?php echo h($ASSET.'assets/vendor/bootstrap/js/bootstrap.bundle.min.js'); ?>"></script>
<script src="<?php echo h($ASSET.'assets/vendor/swiper/swiper-bundle.min.js'); ?>"></script>
<script src="<?php echo h($ASSET.'assets/vendor/bootstrap-touchspin/dist/jquery.bootstrap-touchspin.min.js'); ?>"></script>
<script src="<?php echo h($ASSET.'assets/js/dz.carousel.js'); ?>"></script>
<script src="<?php echo h($ASSET.'assets/js/settings.js'); ?>"></script>
<script src="<?php echo h($ASSET.'assets/js/custom.js'); ?>"></script>
<script>
  // theme toggle hook (if present in header)
  document.getElementById('toggle-dark-menu')?.addEventListener('change', function(){
    (document.body || document.documentElement).classList.toggle('theme-dark', this.checked);
  });

  // Hide AMS button on its own dashboard page (optional)
  (function(){
    const here = "<?php echo h($here); ?>";
    if (here === 'dashboard.php') {
      document.querySelectorAll('.menubar-area .nav-link.add-post').forEach(n => n.style.display = 'none');
    }
  })();
</script>
