<?php
/* header.php - theme-aware header for Soziety XHTML kit
   - place next to config.php and include in pages
   - honors session-based theme: $_SESSION['theme_mode'] = 'dark'|'light'
*/
if(session_status()===PHP_SESSION_NONE)session_start();
require_once __DIR__.'/config.php';
$BASE = defined('BASE_URL')?BASE_URL:('');
// determine theme (session overrides DB)
$theme_mode = $_SESSION['theme_mode'] ?? null;
if(!$theme_mode){
    // try ui_app_settings.default_theme
    if(isset($conn) && ($r=@mysqli_query($conn,"SELECT setting_val FROM ui_app_settings WHERE setting_key='default_theme' LIMIT 1")) && $row=@mysqli_fetch_assoc($r)){
        $theme_mode = ($row['setting_val']==='dark') ? 'dark' : 'light';
    } else { $theme_mode = 'light'; }
}
// optional header settings from DB
$logo_light = $logo_dark = '';
if(isset($conn) && ($r=@mysqli_query($conn,"SELECT * FROM ui_header_settings WHERE id=1 LIMIT 1")) && ($h=@mysqli_fetch_assoc($r))){
    $logo_light = $h['logo_url_light'] ?? $h['logo_url'] ?? '';
    $logo_dark  = $h['logo_url_dark']  ?? $logo_light;
}
// choose logo path (fall back to kit asset)
$logo = ($theme_mode==='dark') ? ($logo_dark?:$BASE.'xhtml/assets/images/logo-dark.png') : ($logo_light?:$BASE.'xhtml/assets/images/logo.png');
?>
<!-- Header (matches kit markup) -->
<header class="header">
  <div class="container">
    <div class="main-bar">
      <div class="left-content">
        <a href="<?php echo htmlspecialchars($BASE?:'/'); ?>" class="logo-link">
          <img src="<?php echo htmlspecialchars($logo); ?>" alt="logo" class="logo" style="height:36px;">
        </a>
      </div>
      <div class="mid-content"></div>
      <div class="right-content d-flex align-items-center">
        <!-- Theme toggle (JS in kit toggles .theme-dark on body) -->
        <button id="themeToggle" class="theme-btn me-2" type="button" title="Toggle theme" onclick="(function(){var b=document.documentElement||document.body; if(b.classList.contains('theme-dark')){b.classList.remove('theme-dark'); fetch('?set_theme=light',{method:'GET'});}else{b.classList.add('theme-dark'); fetch('?set_theme=dark',{method:'GET'});} })();">
          <span class="light">🌞</span><span class="dark">🌙</span>
        </button>

        <a href="<?php echo htmlspecialchars($BASE.'xhtml/reels.html'); ?>" class="bell-icon me-2"><svg width="22" height="22" viewBox="0 0 24 24" fill="none"><!-- svg --></svg></a>
        <a href="<?php echo htmlspecialchars($BASE.'xhtml/notification.html'); ?>" class="bell-icon me-2"><svg width="22" height="22" viewBox="0 0 24 24" fill="none"><!-- svg --></svg></a>

        <div class="dropdown">
          <a href="#" class="btn btn-sm dropdown-toggle" data-bs-toggle="dropdown">Account</a>
          <ul class="dropdown-menu dropdown-menu-end">
            <li><a class="dropdown-item" href="<?php echo htmlspecialchars($BASE.'xhtml/edit-profile.html'); ?>">Edit profile</a></li>
            <li><a class="dropdown-item" href="<?php echo htmlspecialchars($BASE.'xhtml/change-password.html'); ?>">Change password</a></li>
            <li><hr class="dropdown-divider"></li>
            <li><a class="dropdown-item" href="<?php echo htmlspecialchars($BASE.'xhtml/login.html'); ?>">Logout</a></li>
          </ul>
        </div>
      </div>
    </div>
  </div>
</header>

<?php
// server-side theme setter (keeps it simple)
if(isset($_GET['set_theme'])){
    $t = ($_GET['set_theme']==='dark') ? 'dark' : 'light';
    $_SESSION['theme_mode']=$t;
    // don't redirect - JS toggles immediately; but you may want to persist in DB
}
?>
