<?php
// ============================================================================
// File   : header_mobile.php
// Purpose: Soziety Mobile Header (fixed, auto-colored by theme)
// Notes  : Works with Soziety theme (xhtml/assets/css/style.css)
//          Needs <body class="bg-gradient-2"> and <div class="page-wraper header-fixed">
//          $ASSET should point to xhtml/ (auto-resolved below)
// ============================================================================
if (session_status() === PHP_SESSION_NONE) session_start();
require_once __DIR__ . '/config.php';

if (!function_exists('h')) {
    function h($s){ return htmlspecialchars((string)$s, ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8'); }
}

/* Resolve BASE and ASSET (Soziety lives under xhtml/) */
if (!isset($BASE)) {
    $BASE = defined('BASE_URL') ? rtrim(BASE_URL, '/') . '/' : '/';
}
if (!isset($ASSET) || !$ASSET) {
    $ASSET = $BASE . 'xhtml/';
}

/* Dynamic title if page sets $PAGE_TITLE or $HEADER_TITLE */
$HEADER_TITLE = (isset($HEADER_TITLE) && $HEADER_TITLE) ? $HEADER_TITLE
               : ((isset($PAGE_TITLE) && $PAGE_TITLE) ? $PAGE_TITLE : 'Home');
?>
<!-- ============================= HEADER ============================= -->
<header class="header">
    <div class="container">
        <div class="main-bar">
            <!-- Left -->
            <div class="left-content">
                <h4 class="title mb-0"><?php echo h($HEADER_TITLE); ?></h4>
            </div>

            <!-- Mid (keep empty for centered variants) -->
            <div class="mid-content"></div>

            <!-- Right -->
            <div class="right-content d-flex align-items-center">

                <!-- Reels -->
                <a href="<?php echo h($BASE.'mobile/reels.html'); ?>" class="bell-icon me-2" aria-label="Reels">
                    <svg id="Layer_3" height="24" width="24" viewBox="0 0 22 22" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
                        <g>
                            <path d="m-.0132 8v9a5.0018 5.0018 0 0 0 5 5h12a5.0018 5.0018 0 0 0 5-5v-9zm14.49 6.87-6 3.38a.9472.9472 0 0 1 -.49.13 1.0145 1.0145 0 0 1 -1-1v-6.76a1.0039 1.0039 0 0 1 1.49-.87l6 3.38a.9971.9971 0 0 1 0 1.74z"/>
                            <path d="m6.0968 6h-6.11v-1a4.9909 4.9909 0 0 1 2.27-4.19l1.19 1.62z"/>
                            <path d="m15.1068 6h-6.52l-2.96-4-1.44-1.93a4.2509 4.2509 0 0 1 .8-.07h5.72l1.46 2z"/>
                            <path d="m21.9868 5v1h-4.4l-2.95-4-1.47-2h3.82a5.0018 5.0018 0 0 1 5 5z"/>
                        </g>
                    </svg>
                </a>

                <!-- Notifications -->
                <a href="<?php echo h($BASE.'mobile/notification.html'); ?>" class="bell-icon me-2" aria-label="Notifications">
                    <svg width="24" height="26" viewBox="0 0 24 26" fill="none" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
                        <path fill-rule="evenodd" clip-rule="evenodd"
                              d="M6.99863 5.94146C8.25877 4.69837 9.96789 4 11.75 4C13.5321 4 15.2412 4.69837 16.5014 5.94146C17.7615 7.18456 18.4694 8.87057 18.4694 10.6286C18.4694 13.6602 19.1264 15.5253 19.7182 16.5956C20.3031 17.4826 20.498 17.6854 20.7136 17.8881C21.1638 18.1996 21.3462 18.7128 21.2002 19.1883C21.0523 19.6703 20.6019 20 20.0914 20H3.40862C2.89809 20 2.44774 19.6703 2.2998 19.1883C2.15385 18.7128 2.33617 18.1996 2.74898 17.9176C3.19687 17.4826 3.48428 17.1336 3.78178 16.5956C4.37359 15.5253 5.03055 13.6602 5.03055 10.6286C5.03055 8.87056 5.73849 7.18456 6.99863 5.94146Z"
                              fill="#FE9063"/>
                        <path d="M8.87713 21.1933C9.47825 20.797 10.2482 21.0296 10.5969 21.7127C10.6633 21.8427 10.7586 21.9506 10.8732 22.0256C10.9878 22.1006 11.1177 22.1401 11.25 22.1401C11.3823 22.1401 11.5122 22.1006 11.6268 22.0256C11.7414 21.9506 11.8367 21.8427 11.9031 21.7127C12.2518 21.0296 13.0217 20.797 13.6229 21.1933C14.224 21.5895 14.4286 22.4646 14.0799 23.1477C13.7923 23.7111 13.3795 24.1787 12.8829 24.5038C12.3862 24.8289 11.8231 25 11.25 25C10.6769 25 10.1138 24.8289 9.61711 24.5038C9.12045 24.1787 8.70767 23.7111 8.42008 23.1477C8.07138 22.4646 8.27601 21.5895 8.87713 21.1933Z"
                              fill="#FE9063"/>
                        <circle cx="18" cy="6" r="5" fill="url(#paint0_linear)" stroke="#FEEADF" stroke-width="2"/>
                        <defs>
                            <linearGradient id="paint0_linear" x1="15.8934" y1="-5.17647" x2="23.3834" y2="-3.59332" gradientUnits="userSpaceOnUse">
                                <stop stop-color="#704FFE"/>
                                <stop offset="1" stop-color="#523CAD"/>
                            </linearGradient>
                        </defs>
                    </svg>
                </a>

                <!-- Sidebar menu toggle -->
                <a href="javascript:void(0);" class="bell-icon menu-toggler" aria-label="Open Menu">
                    <svg xmlns="http://www.w3.org/2000/svg" height="24px" width="24px" fill="#000000" viewBox="0 0 24 24" aria-hidden="true">
                        <path d="M5,11h4c1.1,0,2-0.9,2-2V5c0-1.1-0.9-2-2-2H5C3.9,3,3,3.9,3,5v4C3,10.1,3.9,11,5,11z"/>
                        <path d="M5,21h4c1.1,0,2-0.9,2-2v-4c0-1.1-0.9-2-2-2H5c-1.1,0-2,0.9-2,2v4C3,20.1,3.9,21,5,21z"/>
                        <path d="M13,5v4c0,1.1,0.9,2,2,2h4c1.1,0,2-0.9,2-2V5c0-1.1-0.9-2-2-2h-4C13.9,3,13,3.9,13,5z"/>
                        <path d="M15,21h4c1.1,0,2-0.9,2-2v-4c0-1.1-0.9-2-2-2h-4c-1.1,0-2,0.9-2,2v4C13,20.1,13.9,21,15,21z"/>
                    </svg>
                </a>

            </div>
        </div>
    </div>
</header>

<!-- Overlay (click to close) -->
<div class="dark-overlay"></div>

<!-- Fallback safety styles for sidebar + overlay -->
<style>
/* sidebar slides in on mobile when .open is added */
.sidebar{
  position:fixed;left:0;top:0;bottom:0;width:88%;max-width:360px;
  transform:translateX(-100%);transition:transform .2s ease;
  z-index:100002;background:var(--crm-card,#fff);
}
.sidebar.open{ transform:translateX(0); }

/* overlay covers screen when .show is added */
.dark-overlay{
  position:fixed;inset:0;background:transparent;pointer-events:none;
  transition:background .2s ease;z-index:100001;
}
.dark-overlay.show{ background:rgba(0,0,0,.35); pointer-events:auto; }
</style>
<!-- ============================= HEADER END ============================= -->

<script>
/* Sidebar open/close (works regardless of include order) */
document.addEventListener('DOMContentLoaded', function(){
  function getEls(){
    return {
      sidebar: document.querySelector('.sidebar'),
      overlay: document.querySelector('.dark-overlay')
    };
  }
  function openSidebar(){
    const {sidebar, overlay} = getEls();
    sidebar && sidebar.classList.add('open');
    overlay && overlay.classList.add('show');
  }
  function closeSidebar(){
    const {sidebar, overlay} = getEls();
    sidebar && sidebar.classList.remove('open');
    overlay && overlay.classList.remove('show');
  }

  document.querySelectorAll('.menu-toggler').forEach(btn=>{
    btn.addEventListener('click', openSidebar, {passive:true});
  });
  document.addEventListener('click', function(e){
    if (e.target && e.target.classList && e.target.classList.contains('dark-overlay')) {
      closeSidebar();
    }
  });
  document.addEventListener('keydown', function(e){ if(e.key==='Escape') closeSidebar(); });
});
</script>
