<?php
$base_dir = __DIR__ . '/Base';
$static_url = '/Resido/assets'; // Ensure this is the correct path

// Include the common navlink content
ob_start();
include "$base_dir/navbar4.php"; // This file contains the shared navlink content
$navlink_content = ob_get_clean(); // Capture the navlink content
$page= 'nav4';
$fpage= 'foot';

// Optionally define the Hero block content
ob_start();
?>
			
			
<!-- ============================ Hero Banner  Start================================== -->
<div class="light-bg hero-banner">
	<div class="container">
		<div class="row align-items-center">
			<div class="col-xl-7 col-lg-7 col-md-12 col-sm-12">
				<p class="d-inline-flex sm-small text-light rounded-5 px-2 py-1 bg-dark align-items-center">We just launched our service in New York, United States<span class="sm-small px-2 rounded-5 bg-primary text-light ms-2">New</span></p>
				<h2 class="my-3">Find Your Dream House<br>In Europe Now.</h2>
				<p class="small">Find homes in 80+ different countries represented byb 700 leading member brokerages.</p>
				<div class="full-search-2 eclip-search italian-search hero-search-radius mt-5">
					<div class="hero-search-content">
						<div class="row">
						
							<div class="col-xl-3 col-lg-3 col-md-4 col-sm-12 b-r">
								<div class="form-group">
									<div class="choose-propert-type">
										<ul>
											<li>
												<div class="form-check">
													<input class="form-check-input" type="radio" id="typbuy" name="typeprt">
													<label class="form-check-label" for="typbuy">
														Buy
													</label>
												</div>
											</li>
											<li>
												<div class="form-check">
													<input class="form-check-input" type="radio" id="typrent" name="typeprt" checked>
													<label class="form-check-label" for="typrent">
														Rent
													</label>
												</div>
											</li>
										</ul>
									</div>
								</div>
							</div>
							
							<div class="col-xl-7 col-lg-6 col-md-5 col-sm-12 px-xl-0 px-lg-0 px-md-0">
								<div class="form-group border-start borders">
									<div class="position-relative">
										<input type="text" class="form-control border-0 ps-5" placeholder="Search for a location">
										<div class="position-absolute top-50 start-0 translate-middle-y ms-2">
											<span class="svg-icon text-primary svg-icon-2hx">
												<svg width="25" height="25" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
													<path opacity="0.3" d="M18.0624 15.3453L13.1624 20.7453C12.5624 21.4453 11.5624 21.4453 10.9624 20.7453L6.06242 15.3453C4.56242 13.6453 3.76242 11.4453 4.06242 8.94534C4.56242 5.34534 7.46242 2.44534 11.0624 2.04534C15.8624 1.54534 19.9624 5.24534 19.9624 9.94534C20.0624 12.0453 19.2624 13.9453 18.0624 15.3453Z" fill="currentColor"/>
													<path d="M12.0624 13.0453C13.7193 13.0453 15.0624 11.7022 15.0624 10.0453C15.0624 8.38849 13.7193 7.04535 12.0624 7.04535C10.4056 7.04535 9.06241 8.38849 9.06241 10.0453C9.06241 11.7022 10.4056 13.0453 12.0624 13.0453Z" fill="currentColor"/>
												</svg>
											</span>
										</div>
									</div>
								</div>
							</div>
							
							<div class="col-xl-2 col-lg-3 col-md-3 col-sm-12">
								<div class="form-group">
									<button type="button" class="btn btn-dark full-width">Search</button>
								</div>
							</div>
									
						</div>
					</div>
				</div>
				<div class="searches-lists">
					<ul>
						<li><span>Popular Searches:</span></li>
						<li><a href="JavaScript:Void(0);">2 BHK</a></li>
						<li><a href="JavaScript:Void(0);" class="active">Banglaw</a></li>
						<li><a href="JavaScript:Void(0);">Apartment</a></li>
						<li><a href="JavaScript:Void(0);">London</a></li>
						<li><a href="JavaScript:Void(0);">Villa</a></li>
					</ul>
				</div>
				
			</div>
			<div class="col-xl-5 col-lg-5 col-md-12 col-sm-12">
				<div class="">
					<img src="<?php echo $static_url; ?>/img/side-city-1.png" class="img-fluid" alt="" />
				</div>
			</div>
		</div>
	</div>
</div>
<!-- ============================ Hero Banner End ================================== -->


<!-- ============================ Category Start ================================== -->
<section>
	<div class="container">
		
		<div class="row">
			<div class="col-lg-7 col-md-10">
				<div class="sec-heading mb-4 mss">
					<h2>Choose Property Type</h2>
					<p>At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores</p>
				</div>
			</div>
		</div>
		
		<div class="row justify-content-center gx-3 gy-3">
			
			<!-- property-type code  -->
			<?php
				include "$base_dir/Components/Home/property-type.php";
			?>
			
		</div>
		
	</div>
</section>
<div class="clearfix"></div>
<!-- ================================ Category End ======================================== -->


<!-- ================================ All Property ========================================= -->
<section class="gray-simple">
	<div class="container">
	
		<div class="row justify-content-center">
			<div class="col-xl-6 col-lg-7 col-md-10 text-center">
				<div class="sec-heading mss">
					<h2>Featured Property For Sale</h2>
					<p>At vero eos et accusamus dignissimos ducimus</p>
				</div>
			</div>
		</div>
	
		<div class="row justify-content-center g-4">
		
			<!-- featured-propertys2 code  -->
			<?php
				include "$base_dir/Components/Home/featured-propertys2.php";
			?>
			
		</div>
		
		<div class="row align-items-center justify-content-center">
			<div class="col-lg-12 col-md-12 col-sm-12 text-center mt-5">
				<a href="listings-list-with-sidebar.php" class="btn btn-primary px-md-5 rounded">Browse More Properties</a>
			</div>
		</div>
		
	</div>		
</section>
<!-- ============================ All Featured Property ================================== -->


<!-- ============================ Property Location Start ================================== -->
<section>
	<div class="container">
		
		<div class="row justify-content-center">
			<div class="col-xl-6 col-lg-7 col-md-10 text-center">
				<div class="sec-heading center">
					<h2>Find Best Locations</h2>
					<p>At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores</p>
				</div>
			</div>
		</div>
		
		<div class="row justify-content-center g-xl-4 g-md-3 g-4">
		
			<!-- best-locations code  -->
			<?php
				include "$base_dir/Components/Home/best-locations.php";
			?>
			
		</div>
		
		<div class="row">
			<div class="col-lg-12 col-md-12 col-sm-12 text-center mt-5">
				<a href="listings-list-with-sidebar.php" class="btn btn-primary px-md-5 rounded">Browse More Locations</a>
			</div>
		</div>
		
	</div>
</section>
<hr class="opacity-25">
<!-- ============================ Property Location End ================================== -->


<!-- ============================ All Property ================================== -->
<section>
	<div class="container">
	
		<div class="row justify-content-center">
			<div class="col-lg-7 col-md-10 text-center">
				<div class="sec-heading center">
					<h2>Featured Property For Sale</h2>
					<p>At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores</p>
				</div>
			</div>
		</div>
	
		<div class="row list-layout">
			
			<!-- featured-propertys1 code  -->
			<?php
				include "$base_dir/Components/Home/featured-propertys1.php";
			?>						
			
		</div>
				
		<!-- Pagination -->
		<div class="row">
			<div class="col-lg-12 col-md-12 col-sm-12 text-center mt-4">
				<a href="listings-list-with-sidebar.php" class="btn btn-primary px-lg-5 rounded">Browse More Properties</a>
			</div>
		</div>
		
	</div>		
</section>
<!-- ============================ All Featured Property ================================== -->


<!-- ============================ Latest Property For Sale Start ================================== -->
<section class="bg-light">
	<div class="container">
		
		<div class="row align-items-center justify-content-between">
		
			<div class="col-xl-3 col-lg-4 col-md-4 col-sm-12">
				<div class="trustscrore-wrap">
					<div class="trustscrore-title">
						<h2>4.8</h2>
					</div>
					<div class="trustscrore-rates">
						<div class="trustscrore-stars">
							<span><i class="fa-solid fa-star"></i></span>
							<span><i class="fa-solid fa-star"></i></span>
							<span><i class="fa-solid fa-star"></i></span>
							<span><i class="fa-solid fa-star"></i></span>
							<span><i class="fa-solid fa-star"></i></span>
						</div>
						<div class="trustscrore-stars-title"><span>Trustscore on 176 Reviews</span></div>
					</div>
					
					<div class="trustscrore-info">
						<div class="trustscrore-subtitle"><span>Check all reviews on</span></div>
						<div class="trustscrore-brand"><img src="<?php echo $static_url; ?>/img/brand.png" class="img-fluid" alt=""></div>
					</div>
					
				</div>
			</div>
			
			<div class="col-xl-8 col-lg-8 col-md-8 col-sm-12">
				<div class="single-reviews">
					
					<!-- single-reviews code  -->
					<?php
						include "$base_dir/Components/Home/single-reviews.php";
					?>	
				
				</div>
			</div>
			
		</div>
		
		<div class="row align-items-center justify-content-between">
			<div class="col-xl-12 col-lg-12 col-md-12">
				
				<div class="counter-info-groups">
				
					<!-- counter-groups code  -->
					<?php
						include "$base_dir/Components/Home/counter-groups.php";
					?>
				
				</div>
				
			</div>
		</div>
		
	</div>
</section>
<!-- ============================ Latest Property For Sale End ================================== -->


<!-- ============================ Explore Featured Agents Start ================================== -->
<section>
	<div class="container">
		
		<div class="row justify-content-center">
			<div class="col-lg-7 col-md-10 text-center">
				<div class="sec-heading center">
					<h2>Explore Featured Agents</h2>
					<p>At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores</p>
				</div>
			</div>
		</div>

		<div class="row justify-content-center g-4">
			
			<!-- agents code  -->
			<?php
				include "$base_dir/Components/Home/agents.php";
			?>
			
		</div>
		
		<!-- Pagination -->
		<div class="row">
			<div class="col-lg-12 col-md-12 col-sm-12 text-center mt-5">
				<a href="listings-list-with-sidebar.php" class="btn btn-primary px-lg-5 rounded">Explore More Agents</a>
			</div>
		</div>
		
	</div>
</section>
<div class="clearfix"></div>
<!-- ============================ Explore Featured Agents End ================================== -->


<!-- ============================ Smart Testimonials ================================== -->
<section class="gray-bg">
	<div class="container">
	
		<div class="row justify-content-center">
			<div class="col-lg-7 col-md-10 text-center">
				<div class="sec-heading center">
					<h2>Good Reviews by Customers</h2>
					<p>At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores</p>
				</div>
			</div>
		</div>
		
		<div class="row justify-content-center">
			
			<div class="col-lg-12 col-md-12">
				
				<div class="smart-textimonials smart-center" id="smart-textimonials">
					
					<!-- reviews code  -->
					<?php
						include "$base_dir/Components/Home/reviews.php";
					?>
					
				</div>
			</div>
			
		</div>
		
	</div>
</section>
<!-- ============================ Smart Testimonials End ================================== -->


<!-- ================================= Blog Grid ================================== -->
<section>
	<div class="container">
	
		<div class="row justify-content-center">
			<div class="col-lg-7 col-md-10 text-center">
				<div class="sec-heading center">
					<h2>Latest Updates By Resido</h2>
					<p>At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores</p>
				</div>
			</div>
		</div>
		
		<div class="row justify-content-center g-4">
			
			<!-- blog code  -->
			<?php
				include "$base_dir/Components/Home/blog.php";
			?>
			
		</div>
		
	</div>		
</section>
<!-- ============================== Blog Grid End =============================== -->


<!-- ============================ Call To Action ================================== -->
<section class="bg-light">
	<div class="container">
		
		<div class="row align-items-center justify-content-center gx-5 gy-5">
		
			<!-- partners code  -->
			<?php
				include "$base_dir/Components/Home/partners.php";
			?>
			
		</div>
		
		<div class="row align-items-center justify-content-center">
			<div class="col-xl-7 col-lg-11">
				
				<div class="call-to-act-wrap text-center">
					<div class="call-to-act-head mb-2">
						<h2 class="fs-1 mb-3 lh-sm">Subscribe &<br>get special discount</h2>
						<span>At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos molestias excepturi.</span>
					</div>
				</div>
				<div class="call-to-act-form">
					<form class="newsletter-boxes p-2">
						<div class="row m-0 g-0">
							<div class="col-xl-10 col-9">
							<input type="text" class="form-control border-0" placeholder="Subscribe Your Email...">
							</div>
							<div class="col-xl-2 col-3">
							<button type="submit" class="btn btn-primary rounded-pill full-width">Subscribe</button>
							</div>
						</div>
					</form>
				</div>
				
			</div>
		</div>
		
	</div>
</section>
<!-- ============================ Call To Action End ================================== -->


			

<?php
$hero_content = ob_get_clean(); // Capture the hero content

// Include the base template
include "$base_dir/style/base.php";
?>