<?php
$base_dir = __DIR__ . '/Base';
$static_url = '/Resido/assets'; // Ensure this is the correct path

// Include the common navlink content
ob_start();
include "$base_dir/navbar.php"; // This file contains the shared navlink content
$navlink_content = ob_get_clean(); // Capture the navlink content
$page= 'nav4';
$fpage= 'foot';

// Optionally define the Hero block content
ob_start();
?>
			
			
<!-- ============================ Hero Banner  Start================================== -->
<div class="image-cover hero-banner" style="background:#eff6ff url(<?php echo $static_url; ?>/img/city-banner.png) no-repeat;">
	<div class="container">
		<div class="row justify-content-center">
			<div class="col-lg-9 col-md-11 col-sm-12">
				<div class="inner-banner-text text-center">
					<p class="d-inline-flex sm-small text-light rounded-5 px-2 py-1 bg-info align-items-center">We just launched our service in New York, United States<span class="sm-small px-2 rounded-5 bg-white text-dark ms-2">New</span></p>
					<h2>Find <span class="text-primary">Real Properties</span> at Cheapest Price in california</h2>
					<p class="small">At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores occaecati cupiditate quas molestias excepturi</p>
				</div>
				<div class="full-search-2 eclip-search italian-search hero-search-radius shadow-hard mt-5">
					<div class="hero-search-content">
						<div class="row">
						
							<div class="col-xl-3 col-lg-3 col-md-4 col-sm-12 b-r">
								<div class="form-group">
									<div class="choose-propert-type">
										<ul>
											<li>
												<div class="form-check">
													<input class="form-check-input" type="radio" id="typbuy" name="typeprt">
													<label class="form-check-label" for="typbuy">
														For Buy
													</label>
												</div>
											</li>
											<li>
												<div class="form-check">
													<input class="form-check-input" type="radio" id="typrent" name="typeprt" checked>
													<label class="form-check-label" for="typrent">
														For Rent
													</label>
												</div>
											</li>
										</ul>
									</div>
								</div>
							</div>
							
							<div class="col-xl-6 col-lg-6 col-md-4 col-sm-12 p-md-0 elio">
								<div class="form-group border-start borders">
									<div class="position-relative">
										<input type="text" class="form-control border-0 ps-5" placeholder="Search for a location">
										<div class="position-absolute top-50 start-0 translate-middle-y ms-2">
											<span class="svg-icon text-primary svg-icon-2hx">
												<svg width="25" height="25" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
													<path opacity="0.3" d="M18.0624 15.3453L13.1624 20.7453C12.5624 21.4453 11.5624 21.4453 10.9624 20.7453L6.06242 15.3453C4.56242 13.6453 3.76242 11.4453 4.06242 8.94534C4.56242 5.34534 7.46242 2.44534 11.0624 2.04534C15.8624 1.54534 19.9624 5.24534 19.9624 9.94534C20.0624 12.0453 19.2624 13.9453 18.0624 15.3453Z" fill="currentColor"/>
													<path d="M12.0624 13.0453C13.7193 13.0453 15.0624 11.7022 15.0624 10.0453C15.0624 8.38849 13.7193 7.04535 12.0624 7.04535C10.4056 7.04535 9.06241 8.38849 9.06241 10.0453C9.06241 11.7022 10.4056 13.0453 12.0624 13.0453Z" fill="currentColor"/>
												</svg>
											</span>
										</div>
									</div>
								</div>
							</div>
							
							<div class="col-xl-1 col-lg-1 col-md-1 col-sm-2">
								<div class="form-group">
									<a class="collapsed ad-search" data-bs-toggle="collapse" data-bs-parent="#search" data-bs-target="#advance-search" href="javascript:void(0);" aria-expanded="false" aria-controls="advance-search"><i class="fa fa-sliders-h"></i></a>
								</div>
							</div>
							
							<div class="col-xl-2 col-lg-2 col-md-3 col-sm-12">
								<div class="form-group">
									<button type="button" class="btn btn-dark full-width">Search</button>
								</div>
							</div>
									
						</div>
						<!-- Collapse Advance Search Form -->
						<div class="collapse" id="advance-search" aria-expanded="false" role="banner">
				
							<!-- row -->
							<div class="row">
							
								<div class="col-lg-4 col-md-4 col-sm-12">
									<div class="form-group mb-2">
										<div class="input-with-icon">
											<select id="town" class="form-control">
												<option value="">&nbsp;</option>
												<option value="1">Any Town</option>
												<option value="2">Toronto</option>
												<option value="3">Montreal</option>
												<option value="4">Alberta</option>
												<option value="5">Ontario</option>
												<option value="6">Ottawa</option>
											</select>
											<i class="fa-solid fa-location-dot"></i>
										</div>
									</div>
								</div>
								
								<div class="col-lg-4 col-md-4 col-sm-12">
									<div class="form-group mb-2">
										<div class="input-with-icon">
											<select id="bedrooms" class="form-control">
												<option value="">&nbsp;</option>
												<option value="1">1</option>
												<option value="2">2</option>
												<option value="3">3</option>
												<option value="4">4</option>
												<option value="5">5</option>
											</select>
											<i class="fas fa-bed"></i>
										</div>
									</div>
								</div>
								
								<div class="col-lg-4 col-md-4 col-sm-12">
									<div class="form-group mb-2">
										<div class="input-with-icon">
											<select id="bathrooms" class="form-control">
												<option value="">&nbsp;</option>
												<option value="1">1</option>
												<option value="2">2</option>
												<option value="3">3</option>
												<option value="4">4</option>
												<option value="5">5</option>
											</select>
											<i class="fas fa-bath"></i>
										</div>
									</div>
								</div>
								
							</div>
							<!-- /row -->
							
							<!-- row -->
							<div class="row">
							
								<div class="col-lg-3 col-md-6 col-sm-6">
									<div class="form-group mb-2">
										<input type="text" class="form-control" placeholder="min price" />
									</div>
								</div>
								
								<div class="col-lg-3 col-md-6 col-sm-6">
									<div class="form-group mb-2">
										<input type="text" class="form-control" placeholder="max price" />
									</div>
								</div>
								
								<div class="col-lg-3 col-md-6 col-sm-6">
									<div class="form-group mb-2">
										<input type="text" class="form-control" placeholder="min sqft" />
									</div>
								</div>
								
								<div class="col-lg-3 col-md-6 col-sm-6">
									<div class="form-group mb-2">
										<input type="text" class="form-control" placeholder="max sqft" />
									</div>
								</div>
								
							</div>
							<!-- /row -->
							
							<!-- row -->
							<div class="row">
								<div class="col-lg-12 col-md-12 col-sm-12 mt-2">
									<h6>Advance Price</h6>
									<div class="rg-slider">
											<input type="text" class="js-range-slider" name="my_range" value="" />
									</div>
								</div>
							</div>
							<!-- /row -->
							
							<!-- row -->
							<div class="row">
							
								<div class="col-lg-12 col-md-12 col-sm-12 mt-3">
									<h4 class="text-dark">Amenities & Features</h4>
									<ul class="no-ul-list third-row">
										<li>
											<input id="a-1" class="form-check-input" name="a-1" type="checkbox">
											<label for="a-1" class="form-check-label">Air Condition</label>
										</li>
										<li>
											<input id="a-2" class="form-check-input" name="a-2" type="checkbox">
											<label for="a-2" class="form-check-label">Bedding</label>
										</li>
										<li>
											<input id="a-3" class="form-check-input" name="a-3" type="checkbox">
											<label for="a-3" class="form-check-label">Heating</label>
										</li>
										<li>
											<input id="a-4" class="form-check-input" name="a-4" type="checkbox">
											<label for="a-4" class="form-check-label">Internet</label>
										</li>
										<li>
											<input id="a-5" class="form-check-input" name="a-5" type="checkbox">
											<label for="a-5" class="form-check-label">Microwave</label>
										</li>
										<li>
											<input id="a-6" class="form-check-input" name="a-6" type="checkbox">
											<label for="a-6" class="form-check-label">Smoking Allow</label>
										</li>
										<li>
											<input id="a-7" class="form-check-input" name="a-7" type="checkbox">
											<label for="a-7" class="form-check-label">Terrace</label>
										</li>
										<li>
											<input id="a-8" class="form-check-input" name="a-8" type="checkbox">
											<label for="a-8" class="form-check-label">Balcony</label>
										</li>
										<li>
											<input id="a-9" class="form-check-input" name="a-9" type="checkbox">
											<label for="a-9" class="form-check-label">Icon</label>
										</li>
										<li>
											<input id="a-10" class="form-check-input" name="a-10" type="checkbox">
											<label for="a-10" class="form-check-label">Wi-Fi</label>
										</li>
										<li>
											<input id="a-11" class="form-check-input" name="a-11" type="checkbox">
											<label for="a-11" class="form-check-label">Beach</label>
										</li>
										<li>
											<input id="a-12" class="form-check-input" name="a-12" type="checkbox">
											<label for="a-12" class="form-check-label">Parking</label>
										</li>
									</ul>
								</div>
								
							</div>
							<!-- /row -->
							
						</div>
					</div>
				</div>
				
			</div>
		</div>
	</div>
</div>
<!-- ============================ Hero Banner End ================================== -->

<!-- ============================ Category Start ================================== -->
<section>
	<div class="container">
		
		<div class="row justify-content-center">
			<div class="col-lg-7 col-md-10 text-center">
				<div class="sec-heading center mb-4">
					<h2>Explore categories</h2>
					<p>At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores</p>
				</div>
			</div>
		</div>
		
		<div class="row justify-content-center gx-3 gy-3">
			
			<!-- categories code  -->
			<?php
				include "$base_dir/Components/Home/categories.php";
			?>
			
		</div>
		
	</div>
</section>
<div class="clearfix"></div>
<!-- ============================ Category End ================================== -->


<!-- ============================ Property Location Start ================================== -->
<section class="pt-0">
	<div class="container">
		
		<div class="row justify-content-center">
			<div class="col-xl-6 col-lg-7 col-md-10 text-center">
				<div class="sec-heading center">
					<h2>Find Best Locations</h2>
					<p>At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores</p>
				</div>
			</div>
		</div>
		
		<div class="row justify-content-center g-xl-4 g-md-3 g-4">
		
			<!-- best-locations code  -->
			<?php
				include "$base_dir/Components/Home/best-locations.php";
			?>
			
		</div>
		
		<div class="row">
			<div class="col-lg-12 col-md-12 col-sm-12 text-center mt-5">
				<a href="listings-list-with-sidebar.php" class="btn btn-primary px-md-5 rounded">Browse More Locations</a>
			</div>
		</div>
		
	</div>
</section>
<!-- ============================ Property Location End ================================== -->


<!-- ================================ All Property ========================================= -->
<section class="gray-simple">
	<div class="container">
	
		<div class="row justify-content-center">
			<div class="col-xl-6 col-lg-7 col-md-10 text-center">
				<div class="sec-heading mss">
					<h2>Featured Property For Sale</h2>
					<p>At vero eos et accusamus dignissimos ducimus</p>
				</div>
			</div>
		</div>
	
		<div class="row justify-content-center g-4">
		
			<!-- featured-propertys2 code  -->
			<?php
				include "$base_dir/Components/Home/featured-propertys2.php";
			?>
			
		</div>
		
		<div class="row align-items-center justify-content-center">
			<div class="col-lg-12 col-md-12 col-sm-12 text-center mt-5">
				<a href="listings-list-with-sidebar.php" class="btn btn-primary px-md-5 rounded">Browse More Properties</a>
			</div>
		</div>
		
	</div>		
</section>
<!-- ============================ All Featured Property ================================== -->


<!-- ============================ Explore Featured Agents Start ================================== -->
<section>
	<div class="container">
		
		<div class="row justify-content-center">
			<div class="col-lg-7 col-md-10 text-center">
				<div class="sec-heading center">
					<h2>Explore Featured Agents</h2>
					<p>At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores</p>
				</div>
			</div>
		</div>

		<div class="row justify-content-center g-4">
			
			<!-- agents code  -->
			<?php
				include "$base_dir/Components/Home/agents.php";
			?>
			
		</div>
		
		<!-- Pagination -->
		<div class="row">
			<div class="col-lg-12 col-md-12 col-sm-12 text-center mt-5">
				<a href="listings-list-with-sidebar.php" class="btn btn-primary px-lg-5 rounded">Explore More Agents</a>
			</div>
		</div>
		
	</div>
</section>
<div class="clearfix"></div>
<!-- ============================ Explore Featured Agents End ================================== -->


<!-- ============================ Smart Testimonials ================================== -->
<section class="gray-bg">
	<div class="container">
	
		<div class="row justify-content-center">
			<div class="col-lg-7 col-md-10 text-center">
				<div class="sec-heading center">
					<h2>Good Reviews by Customers</h2>
					<p>At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores</p>
				</div>
			</div>
		</div>
		
		<div class="row justify-content-center">
			
			<div class="col-lg-12 col-md-12">
				
				<div class="smart-textimonials smart-center" id="smart-textimonials">
					
					<!-- reviews code  -->
					<?php
						include "$base_dir/Components/Home/reviews.php";
					?>
					
				</div>
			</div>
			
		</div>
		
	</div>
</section>
<!-- ============================ Smart Testimonials End ================================== -->


<!-- ============================ Price Table Start ================================== -->
<section>
	<div class="container">
	
		<div class="row justify-content-center">
			<div class="col-lg-7 col-md-10 text-center">
				<div class="sec-heading center">
					<h2>See our packages</h2>
					<p>At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores</p>
				</div>
			</div>
		</div>
		
		<div class="row align-items-center justify-content-center g-lg-4 g-md-3 g-4">
		
			<!-- packages code  -->
			<?php
				include "$base_dir/Components/Home/packages.php";
			?>
			
		</div>
		
	</div>	
</section>
<!-- ============================ Price Table End ================================== -->


<!-- ========================== Download App Section =============================== -->
<section class="bg-light">
	<div class="container">
		<div class="row align-items-center">
			
			<!-- download-apps code  -->
			<?php
				include "$base_dir/Components/Home/download-apps.php";
			?>	
		
		</div>
	</div>
</section>
<!-- ========================== Download App Section =============================== -->

<!-- ============================ Call To Action ================================== -->
<section class="bg-primary">
	<div class="container">
		
		<div class="row align-items-center justify-content-center gx-5 gy-5">
		
			<!-- partners1 code  -->
			<?php
				include "$base_dir/Components/Home/partners1.php";
			?>	
			
		</div>
		
		<div class="row align-items-center justify-content-center">
			<div class="col-xl-7 col-lg-11">
				
				<div class="call-to-act-wrap text-center">
					<div class="call-to-act-head mb-2">
						<h2 class="fs-1 mb-3 lh-sm text-light">Subscribe &<br>get special discount</h2>
						<span class="text-light opacity-75">At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos molestias excepturi.</span>
					</div>
				</div>
				<div class="call-to-act-form">
					<form class="newsletter-boxes p-2">
						<div class="row m-0 g-0">
							<div class="col-xl-10 col-9">
							<input type="text" class="form-control border-0" placeholder="Subscribe Your Email...">
							</div>
							<div class="col-xl-2 col-3">
							<button type="submit" class="btn btn-dark rounded-pill full-width">Subscribe</button>
							</div>
						</div>
					</form>
				</div>
				
			</div>
		</div>
		
	</div>
</section>
<!-- ============================ Call To Action End ================================== -->


			

<?php
$hero_content = ob_get_clean(); // Capture the hero content

// Include the base template
include "$base_dir/style/base.php";
?>