<?php

if (session_status() === PHP_SESSION_NONE) { session_start(); }
date_default_timezone_set('Asia/Kolkata');

/* ------------------------- Centralized config ------------------------- */
$cfgs = [
  __DIR__ . '/config.php',
  __DIR__ . '/../config.php',
  __DIR__ . '/../../config.php'
];
$cfgFound = false;
foreach ($cfgs as $c) { if (file_exists($c)) { require_once $c; $cfgFound = true; break; } }
if (!$cfgFound) { http_response_code(500); exit('config.php not found'); }

?>
<?php
$base_dir = __DIR__ . '/Base';
$static_url = '/Resido/assets'; // Ensure this is the correct path

// Include the common navlink content
ob_start();
include "$base_dir/navbar.php"; // This file contains the shared navlink content
$navlink_content = ob_get_clean(); // Capture the navlink content
$page= 'nav';
$fpage= 'foot';

// Optionally define the Hero block content
ob_start();


$search_results = [];
$search_query = trim($_POST['q'] ?? '');

if ($search_query !== '') {
    $safe_query = mysqli_real_escape_string($conn_crm, $search_query);

    $sql = "SELECT * FROM projects 
            WHERE 
                title LIKE '%$safe_query%' OR 
                project_name LIKE '%$safe_query%' OR 
                city LIKE '%$safe_query%' OR 
                region LIKE '%$safe_query%' OR 
                location LIKE '%$safe_query%' OR 
                address LIKE '%$safe_query%'
            ORDER BY created_at DESC
            LIMIT 12";

    $res = mysqli_query($conn_crm, $sql);

    if ($res && mysqli_num_rows($res) > 0) {
        while ($row = mysqli_fetch_assoc($res)) {
            $search_results[] = $row;
        }
    }
}
?>
			
			
<!-- ============================ Hero Banner  Start================================== -->
<div class="image-cover hero-banner" style="background:#eff6ff url(<?php echo $static_url; ?>/img/home-2.png) no-repeat;">
	<div class="container">
		<div class="row justify-content-center">
			<div class="col-lg-9 col-md-11 col-sm-12">
				<div class="inner-banner-text text-center">
					<p class="lead-i">Amet consectetur adipisicing <span class="badge badge-success">New</span></p>
					<h2><span class="font-normal">Find Your</span> Perfect Place.</h2>
				</div>
				<div class="full-search-2 eclip-search italian-search hero-search-radius shadow-hard mt-5">
					<div class="hero-search-content">
						<form method="POST" action="">
						<div class="row">
						
							<div class="col-lg-3 col-md-4 col-sm-12 b-r">
								<div class="form-group">
									<div class="choose-propert-type">
										<ul>
											<li>
												<div class="form-check">
													<input class="form-check-input" type="radio" id="typbuy" name="typeprt">
													<label class="form-check-label" for="typbuy">
														For Buy
													</label>
												</div>
											</li>
											<li>
												<div class="form-check">
													<input class="form-check-input" type="radio" id="typrent" name="typeprt" checked>
													<label class="form-check-label" for="typrent">
														For Rent
													</label>
												</div>
											</li>
										</ul>
									</div>
								</div>
							</div>
							
							<div class="col-lg-6 col-md-4 col-sm-12 p-md-0 elio">
								<div class="form-group border-start borders">
									<div class="position-relative">
										<input type="text" class="form-control border-0 ps-5" placeholder="Search for a location" name="q" value="<?= htmlspecialchars($_GET['q'] ?? '') ?>">
										<div class="position-absolute top-50 start-0 translate-middle-y ms-2">
											<span class="svg-icon text-primary svg-icon-2hx">
												<svg width="25" height="25" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
													<path opacity="0.3" d="M18.0624 15.3453L13.1624 20.7453C12.5624 21.4453 11.5624 21.4453 10.9624 20.7453L6.06242 15.3453C4.56242 13.6453 3.76242 11.4453 4.06242 8.94534C4.56242 5.34534 7.46242 2.44534 11.0624 2.04534C15.8624 1.54534 19.9624 5.24534 19.9624 9.94534C20.0624 12.0453 19.2624 13.9453 18.0624 15.3453Z" fill="currentColor"/>
													<path d="M12.0624 13.0453C13.7193 13.0453 15.0624 11.7022 15.0624 10.0453C15.0624 8.38849 13.7193 7.04535 12.0624 7.04535C10.4056 7.04535 9.06241 8.38849 9.06241 10.0453C9.06241 11.7022 10.4056 13.0453 12.0624 13.0453Z" fill="currentColor"/>
												</svg>
											</span>
										</div>
									</div>
								</div>
							</div>
							
							<div class="col-lg-1 col-md-1 col-sm-2">
								<div class="form-group">
									<a class="collapsed ad-search" data-bs-toggle="collapse" data-bs-parent="#search" data-bs-target="#advance-search" href="javascript:void(0);" aria-expanded="false" aria-controls="advance-search"><i class="fa fa-sliders-h"></i></a>
								</div>
							</div>
							
							<div class="col-lg-2 col-md-3 col-sm-12">
								<div class="form-group">
									<button type="submit" class="btn btn-primary full-width">Search</button>
								</div>
							</div>
									
						</div>
						<!-- Collapse Advance Search Form -->
						<div class="collapse" id="advance-search" aria-expanded="false" role="banner">
				
							<!-- row -->
							<div class="row">
							
								<div class="col-lg-4 col-md-4 col-sm-12">
									<div class="form-group mb-2">
										<div class="input-with-icon">
											<select id="town" class="form-control">
												<option value="">&nbsp;</option>
												<option value="1">Any Town</option>
												<option value="2">Toronto</option>
												<option value="3">Montreal</option>
												<option value="4">Alberta</option>
												<option value="5">Ontario</option>
												<option value="6">Ottawa</option>
											</select>
											<i class="fa-solid fa-location-dot"></i>
										</div>
									</div>
								</div>
								
								<div class="col-lg-4 col-md-4 col-sm-12">
									<div class="form-group mb-2">
										<div class="input-with-icon">
											<select id="bedrooms" class="form-control">
												<option value="">&nbsp;</option>
												<option value="1">1</option>
												<option value="2">2</option>
												<option value="3">3</option>
												<option value="4">4</option>
												<option value="5">5</option>
											</select>
											<i class="fas fa-bed"></i>
										</div>
									</div>
								</div>
								
								<div class="col-lg-4 col-md-4 col-sm-12">
									<div class="form-group mb-2">
										<div class="input-with-icon">
											<select id="bathrooms" class="form-control">
												<option value="">&nbsp;</option>
												<option value="1">1</option>
												<option value="2">2</option>
												<option value="3">3</option>
												<option value="4">4</option>
												<option value="5">5</option>
											</select>
											<i class="fas fa-bath"></i>
										</div>
									</div>
								</div>
								
							</div>
							<!-- /row -->
							
							<!-- row -->
							<div class="row">
							
								<div class="col-lg-3 col-md-6 col-sm-6">
									<div class="form-group mb-2">
										<input type="text" class="form-control" placeholder="min price" />
									</div>
								</div>
								
								<div class="col-lg-3 col-md-6 col-sm-6">
									<div class="form-group mb-2">
										<input type="text" class="form-control" placeholder="max price" />
									</div>
								</div>
								
								<div class="col-lg-3 col-md-6 col-sm-6">
									<div class="form-group mb-2">
										<input type="text" class="form-control" placeholder="min sqft" />
									</div>
								</div>
								
								<div class="col-lg-3 col-md-6 col-sm-6">
									<div class="form-group mb-2">
										<input type="text" class="form-control" placeholder="max sqft" />
									</div>
								</div>
								
							</div>
							<!-- /row -->
							
							<!-- row -->
							<div class="row">
								<div class="col-lg-12 col-md-12 col-sm-12 mt-2">
									<h6>Advance Price</h6>
									<div class="rg-slider">
											<input type="text" class="js-range-slider" name="my_range" value="" />
									</div>
								</div>
							</div>
							<!-- /row -->
							
							<!-- row -->
							<div class="row">
							
								<div class="col-lg-12 col-md-12 col-sm-12 mt-3">
									<h4 class="text-dark fs-6 fw-semibold">Amenities & Features</h4>
									<ul class="no-ul-list third-row">
										<li>
											<div class="form-check">
												<input id="a-1" class="form-check-input" name="a-1" type="checkbox">
												<label for="a-1" class="form-check-label">Air Condition</label>
											</div>
										</li>
										<li>
											<div class="form-check">
												<input id="a-2" class="form-check-input" name="a-2" type="checkbox">
												<label for="a-2" class="form-check-label">Bedding</label>
											</div>
										</li>
										<li>
											<input id="a-3" class="form-check-input" name="a-3" type="checkbox">
											<label for="a-3" class="form-check-label">Heating</label>
										</li>
										<li>
											<div class="form-check">
												<input id="a-4" class="form-check-input" name="a-4" type="checkbox">
												<label for="a-4" class="form-check-label">Internet</label>
											</div>
										</li>
										<li>
											<div class="form-check">
												<input id="a-5" class="form-check-input" name="a-5" type="checkbox">
												<label for="a-5" class="form-check-label">Microwave</label>
											</div>
										</li>
										<li>
											<div class="form-check">
												<input id="a-6" class="form-check-input" name="a-6" type="checkbox">
												<label for="a-6" class="form-check-label">Smoking Allow</label>
											</div>	
										</li>
										<li>
											<div class="form-check">
											<input id="a-7" class="form-check-input" name="a-7" type="checkbox">
											<label for="a-7" class="form-check-label">Terrace</label>
										</li>
										<li>
											<div class="form-check">
												<input id="a-8" class="form-check-input" name="a-8" type="checkbox">
												<label for="a-8" class="form-check-label">Balcony</label>
											</div>
										</li>
										<li>
											<div class="form-check">
												<input id="a-9" class="form-check-input" name="a-9" type="checkbox">
												<label for="a-9" class="form-check-label">Icon</label>
											</div>
										</li>
										<li>
											<div class="form-check">
												<input id="a-10" class="form-check-input" name="a-10" type="checkbox">
												<label for="a-10" class="form-check-label">Wi-Fi</label>
											</div>
										</li>
										<li>
											<div class="form-check">
												<input id="a-11" class="form-check-input" name="a-11" type="checkbox">
												<label for="a-11" class="form-check-label">Beach</label>
											</div>
										</li>
										<li>
											<div class="form-check">
												<input id="a-12" class="form-check-input" name="a-12" type="checkbox">
												<label for="a-12" class="form-check-label">Parking</label>
											</div>
										</li>
									</ul>
								</div>
								
							</div>
							<!-- /row -->
							
						</div>
					</div>
					</form>
				</div>
				
			</div>
		</div>
	</div>
</div>
<!-- ============================ Hero Banner End ================================== -->


<?php if ($search_query !== ''): ?>
<section class="pt-5">
	<div class="container">
		<h4 class="mb-4">Showing results for "<strong><?= htmlspecialchars($search_query) ?></strong>"</h4>

		<?php if (!empty($search_results)): ?>
			<div class="row row-cols-lg-3 row-cols-md-2 row-cols-1 g-4">
				<?php foreach ($search_results as $project): ?>
					<div class="col">
						<div class="card border-0 shadow-sm h-100">
							<img 
								src="<?= $project['cover_image'] ? $baseUrl . '/' . htmlspecialchars($project['cover_image']) : $baseUrl . '/img/no-image.jpg' ?>" 
								class="card-img-top" 
								alt="<?= htmlspecialchars($project['title']) ?>"
								style="height: 220px; object-fit: cover;"
							>
							<div class="card-body">
								<h5 class="card-title"><?= htmlspecialchars($project['title']) ?></h5>
								<p class="card-text">
									<?= htmlspecialchars($project['city']) ?>, 
									<?= htmlspecialchars($project['region']) ?><br>
									<span class="text-muted"><?= htmlspecialchars($project['location']) ?></span>
								</p>
								<p class="text-primary fw-bold">
									<?= htmlspecialchars($project['price_text'] ?? 'Price on Request') ?>
								</p>
								<a href="project-details.php?id=<?= $project['id'] ?>" class="btn btn-outline-primary btn-sm">View Details</a>
							</div>
						</div>
					</div>
				<?php endforeach; ?>
			</div>
		<?php else: ?>
			<div class="alert alert-warning mt-4">No matching projects found.</div>
		<?php endif; ?>
	</div>
</section>
<?php endif; ?>

<!-- ============================ Category Start ================================== -->
<section>
	<div class="container">
		
		<div class="row justify-content-center">
			<div class="col-xl-6 col-lg-7 col-md-10">
				<div class="sec-heading text-center">
					<h2>Choose Property Type</h2>
					<p>At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores</p>
				</div>
			</div>
		</div>
		
		<div class="row justify-content-center gx-3 gy-3">
			
			<!-- property-type code  -->
			<?php
				include "$base_dir/Components/Home/property-type.php";
			?>
			
		</div>
		
	</div>
</section>
<div class="clearfix"></div>
<!-- ============================ Category End ================================== -->


<!-- ================= Explore Property ================= -->
<section class="pt-0">
	<div class="container">
		
		<div class="row justify-content-center">
			<div class="col-xl-6 col-lg-7 col-md-10 text-center">
				<div class="sec-heading center">
					<h2>Explore Good places</h2>
					<p>At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores</p>
				</div>
			</div>
		</div>
		
		<div class="row justify-content-center g-4">
			
			<!-- good-places code  -->
			<?php
				include "$base_dir/Components/Home/good-places.php";
			?>
			
		</div>
		
		<div class="row align-items-center justify-content-center">
			<div class="col-lg-12 col-md-12 col-sm-12 text-center mt-5">
				<a href="listings-list-with-sidebar.php" class="btn btn-primary px-md-5 rounded">Browse More Properties</a>
			</div>
		</div>
		
	</div>	
</section>
<!-- ================================= Explore Property =============================== -->

<!-- ============================ Explore Featured Agents Start ================================== -->
<section class="bg-light">
	<div class="container">
		
		<div class="row justify-content-center">
			<div class="col-lg-7 col-md-10 text-center">
				<div class="sec-heading center">
					<h2>Explore Featured Agents</h2>
					<p>At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores</p>
				</div>
			</div>
		</div>

		<div class="row justify-content-center g-4">
			
			<!-- agents code  -->
			<?php
				include "$base_dir/Components/Home/agents.php";
			?>
			
		</div>
		
		<!-- Pagination -->
		<div class="row">
			<div class="col-lg-12 col-md-12 col-sm-12 text-center mt-5">
				<a href="listings-list-with-sidebar.php" class="btn btn-primary px-lg-5 rounded">Explore More Agents</a>
			</div>
		</div>
		
	</div>
</section>
<div class="clearfix"></div>
<!-- ============================ Explore Featured Agents End ================================== -->

<!-- ============================ All Property ================================== -->
<section>
	<div class="container">
	
		<div class="row justify-content-center">
			<div class="col-lg-7 col-md-10 text-center">
				<div class="sec-heading center">
					<h2>Featured Property For Sale</h2>
					<p>At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores</p>
				</div>
			</div>
		</div>
	
		<div class="row list-layout">
			
			<!-- featured-propertys1 code  -->
			<?php
				include "$base_dir/Components/Home/featured-propertys1.php";
			?>						
			
		</div>
				
		<!-- Pagination -->
		<div class="row">
			<div class="col-lg-12 col-md-12 col-sm-12 text-center mt-4">
				<a href="listings-list-with-sidebar.php" class="btn btn-primary px-lg-5 rounded">Browse More Properties</a>
			</div>
		</div>
		
	</div>		
</section>
<!-- ============================ All Featured Property ================================== -->

<!-- ============================ Smart Testimonials ================================== -->
<section class="gray-bg">
	<div class="container">
	
		<div class="row justify-content-center">
			<div class="col-lg-7 col-md-10 text-center">
				<div class="sec-heading center">
					<h2>Good Reviews by Customers</h2>
					<p>At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores</p>
				</div>
			</div>
		</div>
		
		<div class="row justify-content-center">
			
			<div class="col-lg-12 col-md-12">
				
				<div class="smart-textimonials smart-center" id="smart-textimonials">
					
					<!-- reviews code  -->
					<?php
						include "$base_dir/Components/Home/reviews.php";
					?>
					
				</div>
			</div>
			
		</div>
		
	</div>
</section>
<!-- ============================ Smart Testimonials End ================================== -->


<section>
	<div class="container">
	
		<div class="row justify-content-center">
			<div class="col-lg-7 col-md-10 text-center">
				<div class="sec-heading center">
					<h2>Explore Properties in Best Places</h2>
					<p>At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores</p>
				</div>
			</div>
		</div>
		
		<div class="row justify-content-center row-cols-xl-5 row-cols-lg-4 row-cols-md-3 row-cols-sm-2 row-cols-1 g-4">
		
			<!-- best-places code  -->
			<?php
				include "$base_dir/Components/Home/best-places.php";
			?>
			
		</div>
		
	</div>	
</section>


<!-- ========================== Download App Section =============================== -->
<section class="bg-light">
	<div class="container">
		<div class="row align-items-center">
			
			<!-- download-apps code  -->
			<?php
				include "$base_dir/Components/Home/download-apps.php";
			?>

		</div>
	</div>
</section>
<!-- ========================== Download App Section =============================== -->

<!-- ============================ Call To Action ================================== -->
<section class="bg-primary call-to-act-wrap">
	<div class="container">
		
		<!-- estate-agent code  -->
		<?php
			include "$base_dir/Components/Home/estate-agent.php";
		?>

	</div>
</section>
<!-- ============================ Call To Action End ================================== -->


			

<?php
$hero_content = ob_get_clean(); // Capture the hero content

// Include the base template
include "$base_dir/style/base.php";
?>