<?php
//require_once __DIR__ . '/auth_bootstrap.php';
@session_start();
require_once __DIR__ . '/config.php';

/* ------------------------- Choose DB link ------------------------- */
$DB = null;
if (isset($conn_crm) && $conn_crm instanceof mysqli)        { $DB = $conn_crm; }
elseif (isset($conn_crmplus) && $conn_crmplus instanceof mysqli){ $DB = $conn_crmplus; }
elseif (isset($conn) && $conn instanceof mysqli)            { $DB = $conn; }
if (function_exists('_set_charset_and_collation')) { _set_charset_and_collation($DB); }
elseif ($DB instanceof mysqli) { @mysqli_set_charset($DB,'utf8mb4'); }

/* -------------------- Security + Robots -------------------- */
@header('X-Content-Type-Options: nosniff');
@header('Referrer-Policy: strict-origin-when-cross-origin');
@header('X-Robots-Tag: index, follow');

/* ------------------------ Helpers ------------------------- */
function h($s){ return htmlspecialchars((string)$s, ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8'); }
function fetch_all($c,$sql){ $o=[]; if($c && $r=@mysqli_query($c,$sql)){ while($x=mysqli_fetch_assoc($r)){ $o[]=$x; } @mysqli_free_result($r);} return $o; }
function fetch_one($c,$sql){ $row=[]; if($c && ($r=@mysqli_query($c,$sql))){ $row=mysqli_fetch_assoc($r)?:[]; @mysqli_free_result($r);} return $row; }
function tbl_exists($c,$n){ if(!$c) return false; $n=mysqli_real_escape_string($c,$n); $r=@mysqli_query($c,"SHOW TABLES LIKE '{$n}'"); $ok=($r&&mysqli_num_rows($r)>0); if($r) @mysqli_free_result($r); return $ok; }
function col_exists($c,$t,$x){ if(!$c) return false; $t=mysqli_real_escape_string($c,$t); $x=mysqli_real_escape_string($c,$x); $r=@mysqli_query($c,"SHOW COLUMNS FROM `{$t}` LIKE '{$x}'"); $ok=($r&&mysqli_num_rows($r)>0); if($r) @mysqli_free_result($r); return $ok; }
function get_setting($c,$k,$d=null){ if(!$c) return $d; $k=mysqli_real_escape_string($c,$k); $r=@mysqli_query($c,"SELECT setting_val FROM ui_app_settings WHERE setting_key='{$k}' LIMIT 1"); if($r&&($x=mysqli_fetch_assoc($r))){ @mysqli_free_result($r); return $x['setting_val']; } if($r) @mysqli_free_result($r); return $d; }

/* Prefer a local .webp if available (for <picture>) */
function hm_local_webp_or_null($url){
  if(!$url) return null;
  if(strpos($url,'http://')===0 || strpos($url,'https://')===0) return null;
  $p = parse_url($url, PHP_URL_PATH); if(!$p) return null;
  $try = preg_replace('/\.(jpe?g|png)$/i', '.webp', $p);
  if($try!==$p){
    $full = rtrim($_SERVER['DOCUMENT_ROOT']??'','/').$try;
    if(is_file($full)) return $try;
  }
  return null;
}
function hm_picture($url,$alt,$w,$h,$opts=[]){
  $sizes=$opts['sizes']??'100vw';
  $priority=!empty($opts['priority']);
  $loading=$priority?'eager':'lazy';
  $decoding=$priority?'sync':'async';
  $fetch=$priority?'high':'auto';
  $webp=hm_local_webp_or_null($url);
  $wA=$w?' width="'.(int)$w.'"':'';
  $hA=$h?' height="'.(int)$h.'"':'';
  $extra=!empty($opts['extra'])?$opts['extra']:'';
  $html='<picture>';
  if($webp){ $html.='<source type="image/webp" srcset="'.h($webp).'" sizes="'.h($sizes).'">'; }
  $html.='<img src="'.h($url).'" alt="'.h($alt).'" loading="'.$loading.'" decoding="'.$decoding.'" fetchpriority="'.$fetch.'"'.$wA.$hA.' '.$extra.'>';
  $html.='</picture>';
  return $html;
}

/* ----------------------- Theme defaults -------------------- */
$BASE = defined('BASE_URL') ? rtrim(BASE_URL,'/').'/' : '';
$ASSET_PREFIX = $BASE . 'mobile/';
$DEFAULT_THEME = tbl_exists($DB,'ui_app_settings') ? (get_setting($DB,'default_theme','light') ?: 'light') : 'light';
$FORCE_THEME   = tbl_exists($DB,'ui_app_settings') ? (int)(get_setting($DB,'force_theme','0') ?: 0) : 0;

/* Optional tokens */
$TOK=[];
if(tbl_exists($DB,'ui_theme_tokens')){
  foreach(fetch_all($DB,"SELECT token,dark_value,light_value FROM ui_theme_tokens") as $r){
    $k=preg_replace('~[^a-z0-9_-]+~i','',strtolower($r['token']??'')); if($k) $TOK[$k]=['light'=>trim((string)($r['light_value']??'')),'dark'=>trim((string)($r['dark_value']??''))];
  }
}
function token_or($key,$light,$dark=null){ global $TOK,$DEFAULT_THEME,$FORCE_THEME; $dark=$dark??$light; $mode=($FORCE_THEME&&$DEFAULT_THEME==='dark')?'dark':'light'; if(isset($TOK[$key])&&($TOK[$key][$mode]??'')) return $TOK[$key][$mode]; return $mode==='dark'?$dark:$light; }

/* ------------------------ Content -------------------------- */
$rows = tbl_exists($DB,'ui_home') ? fetch_all($DB,"SELECT * FROM ui_home WHERE is_active=1 ORDER BY section, sort_order, id") : [];
$banners=[]; $highlights=[]; $quickActions=[]; $opps=[]; $stats=['matches'=>0,'earnings'=>['currency'=>'₹','amount'=>0]]; $network=null; $grid=[]; $events=[];
foreach($rows as $r){
  $sec=strtolower(trim($r['section']));
  if($sec==='banner') $banners[]=$r;
  elseif($sec==='highlight') $highlights[]=$r;
  elseif($sec==='quick_action') $quickActions[]=$r;
  elseif($sec==='opportunity') $opps[]=$r;
  elseif($sec==='stat'){ $sub=strtolower((string)$r['subtype']); if($sub==='matches') $stats['matches']=(int)$r['count_value']; if($sub==='earnings') $stats['earnings']=['currency'=>$r['currency']?:'₹','amount'=>(float)$r['amount']]; }
  elseif($sec==='network'){ if(!$network) $network=$r; }
  elseif($sec==='grid') $grid[]=$r;
  elseif($sec==='event') $events[]=$r;
}

/* ------------------------ Projects (FORCE specific DB) -------------- */
/* Always read from broriserin_broriserin.projects (columns seen in screenshot) */
$homeProjects=[];
$projects_sql = "
  SELECT 
    id, title, city, region, location, address,
    price_min, price_text, cover_image,
    (CASE WHEN project_tag='Featured' THEN 1 ELSE 0 END) AS is_feat
  FROM broriserin_broriserin.projects
  ORDER BY is_feat DESC, id DESC
  LIMIT 24
";
$rowsP = fetch_all($DB,$projects_sql);
foreach($rowsP as $row){
  $title = $row['title'] ?: 'Untitled Project';
  $city  = trim((string)($row['city'] ?? ''));
  $region= trim((string)($row['region'] ?? ''));
  $loc   = trim((string)($row['location'] ?? ''));
  $addr  = trim((string)($row['address'] ?? ''));
  $sub   = trim(($loc?$loc:'').($city?', '.$city:'').($region?', '.$region:''));
  if(!$sub && $addr) $sub = $addr;

  $price = '';
  if(!empty($row['price_text']))            $price = (string)$row['price_text'];
  elseif($row['price_min']!==''){           $price = 'Rs. '.number_format((float)$row['price_min']).' onwards'; }

  $img = (string)($row['cover_image'] ?? '');
  $url = 'project_details.php?id='.urlencode($row['id']);

  $homeProjects[] = [
    'id'    => $row['id'],
    'title' => $title,
    'sub'   => $sub,
    'price' => $price,
    'img'   => $img,
    'url'   => $url,
  ];
}

/* ------------------------- SEO ----------------------------- */
$metaTitle='Home • Projects, CRM & Network';
if(!empty($network['title'])) $metaTitle=h($network['title']).' • Home';
$metaDesc ='Explore featured projects, quick CRM actions, matches/earnings, and events.';
if(!empty($network['body'])) $metaDesc=h(strip_tags($network['body']));
$ogImage  = (!empty($banners[0]['image_url'])) ? $banners[0]['image_url'] : (!empty($homeProjects[0]['img']) ? $homeProjects[0]['img'] : '');
$scheme   = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS']!=='off') ? 'https' : 'http';
$host     = $_SERVER['HTTP_HOST'] ?? 'localhost';
$uri      = strtok($_SERVER['REQUEST_URI'] ?? '/home_mobile.php','?');
$canonical= $scheme.'://'.$host.$uri;

/* Header/Footer/Sidebar data */
$hdr_cfg=$hdr_menu=$ftr_menu=$sid_menu=[];
if(tbl_exists($DB,'ui_header_settings')) $hdr_cfg=fetch_one($DB,"SELECT * FROM ui_header_settings WHERE id=1");
if(tbl_exists($DB,'ui_header_menu'))     $hdr_menu=fetch_all($DB,"SELECT * FROM ui_header_menu WHERE is_active=1 ORDER BY sort_order,id");
if(tbl_exists($DB,'ui_footer_nav'))      $ftr_menu=fetch_all($DB,"SELECT * FROM ui_footer_nav  WHERE is_active=1 ORDER BY sort_order,id");
if(tbl_exists($DB,'ui_sidebar_menu'))    $sid_menu=fetch_all($DB,"SELECT * FROM ui_sidebar_menu WHERE is_active=1 ORDER BY (group_label IS NULL), group_label, sort_order, id");

/* -------------------- View Router (server) ----------------- */
$force = isset($_GET['view']) ? ($_GET['view']==='mobile'?'mobile':($_GET['view']==='desktop'?'desktop':'')) : '';
if($force){ setcookie('force_view',$force,time()+7*86400,'/'); $_COOKIE['force_view']=$force; }
$chosen = !empty($_COOKIE['force_view']) ? $_COOKIE['force_view'] : '';
if(!$chosen){
  $ua = strtolower($_SERVER['HTTP_USER_AGENT'] ?? '');
  $isMobileUA = preg_match('~(iphone|ipod|ipad|android|blackberry|bb10|windows phone|mobi|opera mobi|mobile)~i',$ua);
  $chosen = $isMobileUA ? 'mobile' : 'desktop';
}

/* ---------------------- Theme session ----------------- */
if(isset($_GET['set_theme'])){ $t = ($_GET['set_theme']==='dark') ? 'dark' : 'light'; $_SESSION['theme_mode']=$t; }
$theme_mode = $_SESSION['theme_mode'] ?? ( ($FORCE_THEME && $DEFAULT_THEME==='dark') ? 'dark' : $DEFAULT_THEME );
$bodyClass = ($theme_mode === 'dark') ? 'theme-dark' : '';

/* ---------------------- Renderers -------------------------- */
function render_mobile($ctx){
  extract($ctx);

  // Ensure $ASSET base
  if (!isset($ASSET)) {
    if (defined('BASE_URL_mobile')) $ASSET = rtrim(BASE_URL_mobile, '/') . '/';
    elseif (defined('BASE_URL')) $ASSET = rtrim(BASE_URL, '/') . '/';
    else $ASSET = 'mobile/';
  }

  $BANNER_H = 260;
  $HIGHLIGHT_THUMB = 92;
  $PROJ_IMG_H = 200;
  ?>
<!doctype html>
<html lang="en">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width,initial-scale=1,viewport-fit=cover">
<title><?php echo h($metaTitle ?? 'Home'); ?></title>
<meta name="description" content="<?php echo h(mb_strimwidth($metaDesc ?? '',0,155,'…','UTF-8')); ?>">
<link rel="canonical" href="<?php echo h($canonical ?? '/'); ?>">

<link rel="stylesheet" href="<?php echo h($ASSET . 'assets/vendor/swiper/swiper-bundle.min.css'); ?>">
<link rel="stylesheet" href="<?php echo h($ASSET . 'assets/css/style.css'); ?>">

<style>
/* ===== Append-only tweaks for mobile ===== */
:root{
  --primary:#FE9063; --muted:#6b7280; --card:#fff; --proj-frame: rgba(23,83,252,.06);
  --card-even:#F9FBFF; --card-odd:#FFF9F4; /* light alternating */
}
.theme-dark:root, body.theme-dark{
  --card:#121723; --proj-frame: rgba(255,255,255,.08);
  --card-even:#101522; --card-odd:#0D1420; /* dark-safe alternates */
}

/* Hide any legacy dot stacks */
.dot,.dots,.legacy-dots,.swiper-dots,.carousel-dots{display:none !important}

/* Banner swiper */
.banner-swiper{position:relative; overflow:hidden; border-radius:12px;}
.banner-swiper .swiper-slide img{width:100%;height:auto;display:block; border-radius:12px;}
.banner-swiper .swiper-pagination{position:absolute;left:50%;transform:translateX(-50%);bottom:12px;display:flex;gap:8px;z-index:20}
.banner-swiper .swiper-pagination-bullet{width:9px;height:9px;border-radius:999px;background:rgba(255,255,255,.7);opacity:1}
.banner-swiper .swiper-pagination-bullet-active{background:var(--primary)}

/* Highlights */
.highlights-swiper .swiper-wrapper{align-items:stretch}
.highlights-swiper .swiper-slide{width:auto !important;display:flex;justify-content:center;align-items:flex-start}
.hl-chip{display:block;width:92px;text-align:center}
.hl-thumb{width:92px;height:92px;border-radius:14px;overflow:hidden;background:#f7f8fb;border:3px solid #fff;box-shadow:0 6px 14px rgba(0,0,0,.06)}
.hl-thumb img{width:100%;height:100%;object-fit:cover;display:block}
.hl-label{font-size:12px;color:var(--muted);margin-top:6px;white-space:nowrap;overflow:hidden;text-overflow:ellipsis}

/* Project cards (image on TOP, text below) + alternating bg */
.project-card{width:86vw;min-width:300px;border-radius:14px;background:var(--card);border:1px solid var(--proj-frame);overflow:hidden;box-shadow:0 6px 18px rgba(0,0,0,.04)}
.project-card.even{background:var(--card-even)}
.project-card.odd {background:var(--card-odd)}
.project-thumb{height:<?php echo (int)$PROJ_IMG_H;?>px;overflow:hidden;background:#f2f5fc}
.project-thumb img{width:100%;height:100%;object-fit:cover;border-radius: 10px;display:block}
.project-body{padding:12px}
.project-title{font-weight:800;color:#0f1724;font-size:15px}
body.theme-dark .project-title{color:#E7EBF3}
.project-sub{color:var(--muted);font-size:13px;margin-top:4px}
.project-price{font-weight:800;color:var(--primary);margin-top:8px;font-size:14px}

/* Events */
.event-card{background:var(--card);border-radius:12px;border:1px solid rgba(0,0,0,.06);overflow:hidden;margin-bottom:12px}
.theme-dark .event-card{border-color:rgba(255,255,255,.08)}
.event-thumb{height:140px;overflow:hidden;background:#eef3ff}
.event-thumb img{width:100%;height:100%;object-fit:cover;display:block}
.event-body{padding:10px}
.event-title{font-weight:800;font-size:15px}
.event-sub{color:var(--muted);font-size:13px;margin-top:6px}

/* Footer/menubar safety */
.page-content{padding-bottom:calc(90px + env(safe-area-inset-bottom,0))}
.menubar-area{position:fixed;left:0;right:0;bottom:0;z-index:99999}
.menubar-area .toolbar-inner{max-width:520px;margin:0 auto;padding-bottom:calc(10px + env(safe-area-inset-bottom,0));background:rgba(255,255,255,.97);box-shadow:0 -8px 26px rgba(0,0,0,.06);border-radius:12px 12px 0 0}
.add-post{transform:translateY(-20px);z-index:100001;box-shadow:0 14px 30px rgba(23,83,252,.18)}
.header .right-content .bell-icon{display:inline-grid;place-items:center;width:38px;height:38px;background:#fff;border-radius:10px;margin-left:8px;box-shadow:0 4px 12px rgba(0,0,0,.04)}
.header .right-content .bell-icon svg{width:22px;height:22px;display:block}
</style>
</head>
<body class="bg-gradient-2 <?php echo h($bodyClass); ?>">
<div class="page-wraper header-fixed">
<?php
if (is_file(__DIR__.'/header_mobile.php')) {
  include __DIR__.'/header_mobile.php';
} else {
?>
<header class="header">
  <div class="container">
    <div class="main-bar">
      <div class="left-content"><h4 class="title mb-0">Home</h4></div>
      <div class="mid-content"></div>
      <div class="right-content d-flex align-items-center">
        <a href="reels.html" class="bell-icon me-2">
          <svg id="Layer_3" height="24" viewBox="0 0 22 22" width="24" xmlns="http://www.w3.org/2000/svg" data-name="Layer 3"><g><path d="m-.0132 8v9a5.0018 5.0018 0 0 0 5 5h12a5.0018 5.0018 0 0 0 5-5v-9zm14.49 6.87-6 3.38a.9472.9472 0 0 1 -.49.13 1.0145 1.0145 0 0 1 -1-1v-6.76a1.0039 1.0039 0 0 1 1.49-.87l6 3.38a.9971.9971 0 0 1 0 1.74z"/><path d="m6.0968 6h-6.11v-1a4.9909 4.9909 0 0 1 2.27-4.19l1.19 1.62z"/><path d="m15.1068 6h-6.52l-2.96-4-1.44-1.93a4.2509 4.2509 0  0 1 .8-.07h5.72l1.46 2z"/><path d="m21.9868 5v1h-4.4l-2.95-4-1.47-2h3.82a5.0018 5.0018 0 0 1 5 5z"/></g></svg>
        </a>
        <a href="notification.html" class="bell-icon me-2">
          <svg width="24" height="26" viewBox="0 0 24 26" fill="none" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" clip-rule="evenodd" d="M6.99863 5.94146C8.25877 4.69837 9.96789 4 11.75 4C13.5321 4 15.2412 4.69837 16.5014 5.94146C17.7615 7.18456 18.4694 8.87057 18.4694 10.6286C18.4694 13.6602 19.1264 15.5253 19.7182 16.5956C20.0157 17.1336 20.3031 17.4826 20.498 17.6854C20.5957 17.7872 20.6709 17.853 20.7136 17.8881C20.7334 17.9044 20.7462 17.9141 20.751 17.9176C21.1638 18.1996 21.3462 18.7128 21.2002 19.1883C21.0523 19.6703 20.6019 20 20.0914 20H3.40862C2.89809 20 2.44774 19.6703 2.2998 19.1883C2.15385 18.7128 2.33617 18.1996 2.74898 17.9176C2.7645 17.9072 2.7645 17.9072 2.76449 17.9072Z" fill="#FE9063"/><path fill-rule="evenodd" clip-rule="evenodd" d="M8.87713 21.1933C9.47825 20.797 10.2482 21.0296 10.5969 21.7127C10.6633 21.8427 10.7586 21.9506 10.8732 22.0256C10.9878 22.1006 11.1177 22.1401 11.25 22.1401C11.3823 22.1401 11.5122 22.1006 11.6268 22.0256C11.7414 21.9506 11.8367 21.8427 11.9031 21.7127C12.2518 21.0296 13.0217 20.797 13.6229 21.1933C14.224 21.5895 14.4286 22.4646 14.0799 23.1477C13.7923 23.7111 13.3795 24.1787 12.8829 24.5038C12.3862 24.8289 11.8231 25 11.25 25C10.6769 25 10.1138 24.8289 9.61711 24.5038C9.12045 24.1787 8.70767 23.7111 8.42008 23.1477C8.07138 22.4646 8.27601 21.5895 8.87713 21.1933Z" fill="#FE9063"/><circle cx="18" cy="6" r="5" fill="url(#g1)" stroke="#FEEADF" stroke-width="2"/><defs><linearGradient id="g1" x1="15.8934" y1="-5.17647" x2="23.3834" y2="-3.59332" gradientUnits="userSpaceOnUse"><stop stop-color="#704FFE"/><stop offset="1" stop-color="#523CAD"/></linearGradient></defs></svg>
        </a>
        <a href="javascript:void(0);" class="bell-icon menu-toggler">
          <svg xmlns="http://www.w3.org/2000/svg" height="24px" viewBox="0 0 24 24" width="24px" fill="#000000"><path d="M5,11h4c1.1,0,2-0.9,2-2V5c0-1.1-0.9-2-2-2H5C3.9,3,3,3.9,3,5v4C3,10.1,3.9,11,5,11z"/><path d="M5,21h4c1.1,0,2-0.9,2-2v-4c0-1.1-0.9-2-2-2H5c-1.1,0-2,0.9-2,2v4C3,20.1,3.9,21,5,21z"/><path d="M13,5v4c0,1.1,0.9,2,2,2h4c1.1,0,2-0.9,2-2V5c0-1.1-0.9-2-2-2h-4C13.9,3,13,3.9,13,5z"/><path d="M15,21h4c1.1,0,2-0.9,2-2v-4c0-1.1-0.9-2-2-2h-4c-1.1,0-2,0-2,2v4C13,20.1,13.9,21,15,21z"/></svg>
        </a>
      </div>
    </div>
  </div></div>
</header>
<?php } ?>

<main class="page-content" style="max-width:520px;margin:0 auto;padding:12px 12px 0">
  <!-- Banner Slider -->
  <section aria-label="Featured banners" style="margin-bottom:12px">
    <div class="swiper banner-swiper" id="bannerSwiper">
      <div class="swiper-wrapper">
        <?php if(!empty($banners)){ foreach($banners as $b){
          $img = $b['image_url'] ?? ''; $link = $b['link_url'] ?: '#'; ?>
          <div class="swiper-slide">
            <a href="<?php echo h($link); ?>" aria-label="<?php echo h($b['title'] ?? 'Banner'); ?>">
              <?php if($img) echo hm_picture($img, $b['title'] ?? 'Banner', 520, $BANNER_H, ['sizes'=>'(max-width:520px) 100vw, 520px']); else echo '<div style="height:'.$BANNER_H.'px;background:#eee;border-radius:12px"></div>'; ?>
            </a>
          </div>
        <?php } } else { ?>
          <div class="swiper-slide"><div style="height:<?php echo $BANNER_H; ?>px;background:#eee;border-radius:12px;display:grid;place-items:center">No banners</div></div>
        <?php } ?>
      </div>
      <div class="swiper-pagination"></div>
    </div>
  </section>

  <!-- Highlights -->
  <section aria-label="Highlights" style="margin-bottom:12px">
    <div style="display:flex;justify-content:space-between;align-items:center;margin-bottom:6px">
      <h3 style="font-size:15px;font-weight:800;margin:0">Highlights</h3>
      <a href="<?php echo h($ASSET . 'highlights.php'); ?>" style="color:var(--primary);font-weight:700">See all</a>
    </div>
    <div class="swiper highlights-swiper" id="highlightsSwiper">
      <div class="swiper-wrapper">
        <?php if(!empty($highlights)){ foreach($highlights as $h){
          $img = $h['image_url'] ?? ''; $label = $h['label'] ?: ($h['title'] ?? ''); $link = $h['link_url'] ?: '#'; ?>
          <div class="swiper-slide">
            <a class="hl-chip" href="<?php echo h($link); ?>">
              <div class="hl-thumb">
                <?php if($img) echo hm_picture($img, $label, $HIGHLIGHT_THUMB, $HIGHLIGHT_THUMB, ['sizes'=>'92px']); else echo '<div style="width:100%;height:100%;background:#f2f2f2"></div>'; ?>
              </div>
              <div class="hl-label"><?php echo h($label); ?></div>
            </a>
          </div>
        <?php } } else { ?>
          <div class="swiper-slide"><div class="hl-chip"><div class="hl-thumb"></div><div class="hl-label">No highlights</div></div></div>
        <?php } ?>
      </div>
      <div class="swiper-pagination"></div>
    </div>
  </section>

  <!-- Projects slider (image on top; alternating light boxes) -->
  <section aria-label="Projects" style="margin-bottom:12px">
    <div style="display:flex;justify-content:space-between;align-items:center;margin-bottom:6px">
      <h3 style="font-size:15px;font-weight:800;margin:0">Projects</h3>
      <a href="<?php echo h($ASSET . 'projects_mobile.php'); ?>" style="color:var(--primary);font-weight:700">View all</a>
    </div>
    <div class="swiper projects-swiper" id="projectsSwiper">
      <div class="swiper-wrapper">
        <?php if(!empty($homeProjects)){ $ix=0; foreach($homeProjects as $p){ $ix++; $even = ($ix%2===0); ?>
          <div class="swiper-slide">
            <a class="project-card <?php echo $even?'even':'odd'; ?>" href="<?php echo h($p['url']); ?>">
              <div class="project-thumb">
                <?php if(!empty($p['img'])) echo hm_picture($p['img'],$p['title'],1200,$PROJ_IMG_H,['sizes'=>'(max-width:520px) 92vw, 520px']); else echo '<div style="height:'.$PROJ_IMG_H.'px;background:#f2f5fc"></div>'; ?>
              </div>
              <div class="project-body">
                <div class="project-title"><?php echo h($p['title']); ?></div>
                <?php if(!empty($p['sub'])){ ?><div class="project-sub"><?php echo h($p['sub']); ?></div><?php } ?>
                <?php if(!empty($p['price'])){ ?><div class="project-price"><?php echo h($p['price']); ?></div><?php } ?>
              </div>
            </a>
          </div>
        <?php } } else { ?>
          <div class="swiper-slide"><div class="project-card odd" style="display:grid;place-items:center;height:160px">No projects</div></div>
        <?php } ?>
      </div>
      <div class="swiper-pagination"></div>
    </div>
  </section>

  <!-- Events -->
  <section aria-label="Events" style="margin-bottom:90px">
    <div style="display:flex;justify-content:space-between;align-items:center;margin-bottom:6px">
      <h3 style="font-size:15px;font-weight:800;margin:0">Events</h3>
      <a href="<?php echo h($ASSET . 'events.php'); ?>" style="color:var(--primary);font-weight:700">All events</a>
    </div>
    <?php if(!empty($events)){ foreach($events as $e){
      $img = $e['image_url'] ?? ''; $title = $e['title'] ?? ''; $loc = $e['location'] ?? ''; $date = !empty($e['event_date']) ? date('d M Y', strtotime($e['event_date'])) : ''; ?>
      <article class="event-card" itemscope itemtype="https://schema.org/Event">
        <div class="event-thumb"><?php if($img) echo hm_picture($img,$title,1200,140,['sizes'=>'(max-width:520px) 100vw, 520px']); else echo '<div style="height:140px;background:#f2f5fc"></div>'; ?></div>
        <div class="event-body">
          <div class="event-title"><?php echo h($title); ?></div>
          <div class="event-sub"><?php echo h($loc); ?><?php if($date) echo ' • '.h($date); ?></div>
        </div>
      </article>
    <?php } } else { ?>
      <div class="event-card"><div class="event-thumb"></div><div class="event-body"><div class="event-title">No events</div></div></div>
    <?php } ?>
  </section>
</main>

<?php if (is_file('footer_mobile.php')) { include 'footer_mobile.php'; } ?>

<script src="<?php echo h($ASSET . 'assets/js/jquery.js'); ?>"></script>
<script src="<?php echo h($ASSET . 'assets/vendor/swiper/swiper-bundle.min.js'); ?>"></script>
<script>
document.addEventListener('DOMContentLoaded', function(){
  document.querySelectorAll('.dot, .dots, .legacy-dots, .swiper-dots, .carousel-dots').forEach(el => el.style.display = 'none');

  if (typeof Swiper !== 'undefined') {
    document.querySelectorAll('.banner-swiper').forEach((node) => {
      new Swiper(node, {
        slidesPerView: 1,
        loop: true,
        autoplay: { delay: 4500, disableOnInteraction: false },
        pagination: { el: node.querySelector('.swiper-pagination'), clickable: true },
      });
    });

    document.querySelectorAll('.highlights-swiper').forEach((node) => {
      new Swiper(node, {
        slidesPerView: 4, slidesPerGroup: 4, spaceBetween: 12, loop: false,
        breakpoints: { 320:{slidesPerView:3,slidesPerGroup:3}, 420:{slidesPerView:4,slidesPerGroup:4}, 768:{slidesPerView:6,slidesPerGroup:6} },
        pagination: { el: node.querySelector('.swiper-pagination'), clickable: true }
      });
    });

    document.querySelectorAll('.projects-swiper').forEach((node) => {
      new Swiper(node, {
        slidesPerView: 1.1, spaceBetween: 12, centeredSlides: false,
        pagination: { el: node.querySelector('.swiper-pagination'), clickable: true }
      });
    });
  }
});
</script>

</body>
</html>
<?php
} // end render_mobile


function render_desktop($ctx){
  extract($ctx);
  $ASSET = $ASSET_PREFIX ?? '';
  $HERO_H     = (int)(tbl_exists($DB,'ui_app_settings') ? (get_setting($DB,'hero_h','620') ?: 620) : 620);
  $PROJ_IMG_H = (int)(tbl_exists($DB,'ui_app_settings') ? (get_setting($DB,'proj_img_h','260') ?: 260) : 260);
  $EVENT_IMG_H= (int)(tbl_exists($DB,'ui_app_settings') ? (get_setting($DB,'event_img_h','260') ?: 260) : 260);
  $AUTOPLAY   = (int)(tbl_exists($DB,'ui_app_settings') ? (get_setting($DB,'autoplay_ms','4500') ?: 4500) : 4500);
  ?>
<!doctype html>
<html lang="en">
<head>
<meta charset="utf-8"><meta name="viewport" content="width=device-width, initial-scale=1, viewport-fit=cover">
<title><?php echo h($metaTitle); ?></title>
<meta name="description" content="<?php echo h(mb_strimwidth($metaDesc,0,160,'…','UTF-8')); ?>"><link rel="canonical" href="<?php echo h($canonical); ?>"><meta name="robots" content="index,follow">
<link rel="stylesheet" href="<?php echo h($ASSET.'assets/vendor/bootstrap/css/bootstrap.min.css'); ?>">
<link rel="stylesheet" href="<?php echo h($ASSET.'assets/css/style.css'); ?>">
<style>
:root{
  --bg:<?php echo h(token_or('bg','#f6f7fb','#0d0f14')); ?>;
  --text:<?php echo h(token_or('text','#121926','#e7ebf3')); ?>;
  --muted:<?php echo h(token_or('muted','#5f6a7d','#9aa4b2')); ?>;
  --primary:<?php echo h(token_or('primary','#1753fc','#3f82ff')); ?>;
  --line:<?php echo h(token_or('line','rgba(0,0,0,.08)','rgba(255,255,255,.10)')); ?>;
  --card:<?php echo h(token_or('card','#ffffff','#121723')); ?>;
  --chip:<?php echo h(token_or('chip','#eef3ff','#0f1a31')); ?>;
  --card-even: #F9FBFF;
  --card-odd:  #FFF9F4;
}
body.theme-dark{ --card-even:#101522; --card-odd:#0D1420; }
.grid-3{display:grid;grid-template-columns:repeat(3,1fr);gap:16px}
@media (max-width:1100px){ .grid-3{grid-template-columns:repeat(2,1fr);} }
@media (max-width:768px){ .grid-3{grid-template-columns:1fr;} }
.post-card{background:var(--card);border-radius:14px;overflow:hidden;box-shadow:0 6px 18px rgba(0,0,0,.06);border:1px solid var(--line);height:100%;display:flex;flex-direction:column}
.post-card.even{background:var(--card-even)}
.post-card.odd{background:var(--card-odd)}
.post-card .dz-media{width:100%;height:<?php echo (int)$PROJ_IMG_H;?>px;overflow:hidden;background:#f2f5fc}
.post-card .dz-media img{width:100%;height:100%;object-fit:cover;display:block}
.post-card .top-meta{padding:12px 12px 0}
.post-card .title{font-weight:800}
.post-card p{padding:8px 12px 12px;margin:0;color:#374151}
</style>
</head>
<body class="<?php echo h($bodyClass); ?>">

<?php
if (is_file(__DIR__.'/header_desktop.php')) {
  include __DIR__.'/header_desktop.php';
} elseif (is_file(__DIR__.'/header.php')) {
  include __DIR__.'/header.php';
} else {
  $logo = $DEFAULT_THEME==='dark' ? ($hdr_cfg['logo_url_dark']??'') : ($hdr_cfg['logo_url_light']??'');
  echo '<div class="topbar"><div class="topinner">';
  echo '<div style="display:flex;align-items:center;gap:14px"><div class="logo">';
  if($logo){ echo '<img src="'.h($logo).'" alt="Logo" style="height:26px">'; } else { echo '<span>Syndicate</span>'; }
  if(!empty($hdr_cfg['version_text'])) echo '<span style="color:var(--muted);font-size:12px">'.h($hdr_cfg['version_text']).'</span>';
  echo '</div><nav class="nav">';
  if($hdr_menu){ foreach($hdr_menu as $m){
    $icon = ($DEFAULT_THEME==='dark') ? ($m['icon_url_dark']??'') : ($m['icon_url_light']??'');
    $iw=(int)($m['icon_w']??18); $ih=(int)($m['icon_h']??18);
    echo '<a href="'.h($m['href']?:'#').'">'.($icon?'<img src="'.h($icon).'" alt="" width="'.max(12,$iw).'" height="'.max(12,$ih).'">':'').'<span>'.h($m['label']?:'').'</span></a>';
  }} else { echo '<a href="projects_desktop.php">Projects</a>'; }
  echo '</nav></div>';
  echo '<button id="openSidebar" class="hamb" aria-label="Open menu"><svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><path d="M3 6h18M3 12h18M3 18h18"/></svg></button>';
  echo '</div></div>';
}

if (!is_file(__DIR__.'/header_desktop.php')) {
  echo '<div class="tabbar"><div class="tabbar-inner">';
  if($ftr_menu){
    foreach($ftr_menu as $m){
      $icon = ($DEFAULT_THEME==='dark') ? ($m['icon_url_dark']??'') : ($m['icon_url_light']??'');
      $iw=(int)($m['icon_w']??18); $ih=(int)($m['icon_h']??18);
      echo '<a class="tab-pill" href="'.h($m['href']?:'#').'">'.($icon?'<img src="'.h($icon).'" alt="" width="'.max(12,$iw).'" height="'.max(12,$ih).'">':'').'<span>'.h($m['label']?:'').'</span></a>';
    }
  } else { echo '<span style="color:var(--muted);font-size:13px">Add footer tabs in ui_footer_nav to show here.</span>'; }
  echo '</div></div>';
}
?>

<div id="sidebarBackdrop" class="backdrop" aria-hidden="true"></div>
<?php
echo '<aside id="sidebar" class="sidebar" role="complementary">';
echo '<div class="side-head">Menu <button id="closeSidebar" class="hamb" aria-label="Close" style="width:28px;height:28px"><svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><path d="M18 6L6 18M6 6l12 12"/></svg></button></div>';
echo '<div class="side-body">';
if (is_file(__DIR__.'/sidebar_desktop.php')) { include __DIR__.'/sidebar_desktop.php'; }
else {
  if($sid_menu){
    $grp=null; foreach($sid_menu as $s){
      if($s['group_label']!==$grp){ $grp=$s['group_label']; echo '<div style="padding:12px;color:var(--muted);font-weight:700">'.h($grp?:'').'</div>'; }
      $icon = ($DEFAULT_THEME==='dark') ? ($s['icon_url_dark']??'') : ($s['icon_url_light']??'');
      $iw=(int)($s['icon_w']??20); $ih=(int)($s['icon_h']??20);
      if(($s['type']??'link')==='label'){ echo '<div style="padding:8px 14px;color:var(--muted)">'.h($s['label']).'</div>'; }
      else { echo '<a href="'.h($s['href']?:'#').'" style="display:flex;gap:10px;align-items:center;padding:10px 14px;border-bottom:1px solid var(--line)">'.($icon?'<img src="'.h($icon).'" alt="" width="'.max(12,$iw).'" height="'.max(12,$ih).'">':'').'<span style="font-weight:600">'.h($s['label']).'</span>'.(!empty($s['subtitle'])?'<small style="color:var(--muted);margin-left:auto">'.h($s['subtitle']).'</small>':'').'</a>'; }
    }
  } else { echo '<div style="padding:12px;color:var(--muted)">Add sidebar items in ui_sidebar_menu.</div>'; }
}
echo '</div></aside>';
?>

<main id="main" class="wrap" role="main">
  <!-- HERO -->
  <section class="section-full hero">
    <div class="slider" id="heroSlider" data-autoplay="<?php echo (int)$AUTOPLAY; ?>">
      <div class="slides">
        <?php if($banners){ foreach($banners as $ix=>$b){ ?>
          <a class="slide" href="<?php echo h($b['link_url'] ?: '#'); ?>" aria-label="<?php echo h(($b['title']?:'Banner').' – open'); ?>">
            <?php $img = $b['image_url'] ?: ($ASSET.'assets/images/bg-shape-dark.png'); echo hm_picture($img, ($b['title']?:'Banner'), 1920, (int)$HERO_H, ['priority'=>$ix===0,'sizes'=>'100vw']); ?>
          </a>
        <?php }} else { ?><div class="slide"><div style="display:grid;place-items:center;height:var(--hero-h);font-weight:900;color:#333">Banner</div></div><?php } ?>
      </div>
      <button class="arrow prev" aria-label="Previous slide" type="button">&#10094;</button>
      <button class="arrow next" aria-label="Next slide" type="button">&#10095;</button>
      <div class="dots" aria-hidden="true"></div>
    </div>
  </section>

  <!-- HIGHLIGHTS -->
  <section class="section-full">
    <div class="slider" id="highlightsSlider" data-autoplay="<?php echo (int)$AUTOPLAY; ?>">
      <div class="slides">
        <?php if($highlights){ foreach($highlights as $h){ ?>
          <div class="slide">
            <a class="hi-card" href="<?php echo h($h['link_url'] ?: '#'); ?>">
              <div class="hi-thumb"><?php if(!empty($h['image_url'])) echo hm_picture($h['image_url'], ($h['label']?:'Highlight'), 120, 86, ['sizes'=>'120px']); ?></div>
              <div>
                <?php if(!empty($h['badge_text'])){ ?><span class="hi-badge"><?php echo h($h['badge_text']); ?></span><?php } ?>
                <span class="hi-title"><?php echo h($h['label'] ?: $h['title'] ?: ''); ?></span>
                <?php if(!empty($h['body'])){ ?><div class="hi-sub"><?php echo h(strip_tags(mb_strimwidth($h['body'],0,140,'…','UTF-8'))); ?></div><?php } ?>
              </div>
            </a>
          </div>
        <?php }} else { ?><div class="slide"><div class="hi-card"><div class="hi-thumb"></div><div><span class="hi-badge">New</span><span class="hi-title">Project</span><div class="hi-sub">Description</div></div></div></div><?php } ?>
      </div>
      <button class="arrow prev" type="button">&#10094;</button><button class="arrow next" type="button">&#10095;</button><div class="dots" aria-hidden="true"></div>
    </div>
  </section>

  <!-- PROJECTS (desktop shows max 3 + View all), image on top, alternating boxes -->
  <section class="section-full">
    <div class="section-inner">
      <div style="display:flex;align-items:center;justify-content:space-between;margin:4px 0 10px">
        <h2 style="margin:0;font-size:20px;font-weight:900">Projects</h2>
        <a href="projects_desktop.php" style="color:var(--primary);font-weight:700">View all</a>
      </div>
      <div class="grid-3">
        <?php
        if($homeProjects){
          $count=0;
          foreach($homeProjects as $p){
            if($count>=3) break;
            $count++;
            $even = ($count%2===0);
        ?>
          <article class="post-card <?php echo $even?'even':'odd'; ?>" itemscope itemtype="https://schema.org/Place">
            <a class="dz-media" href="<?php echo h($p['url']); ?>" aria-label="<?php echo h($p['title'].' – open details'); ?>">
              <?php if(!empty($p['img'])) echo hm_picture($p['img'],$p['title'],1200,(int)$PROJ_IMG_H,['sizes'=>'(min-width:1200px) 33vw, (min-width:768px) 50vw, 100vw']); ?>
            </a>
            <div class="top-meta">
              <h6 class="title mb-0"><a href="<?php echo h($p['url']); ?>"><?php echo h($p['title']); ?></a></h6>
              <?php if(!empty($p['sub'])){ ?>
              <ul class="meta-list"><li>
                <svg width="14" height="14" viewBox="0 0 14 14" fill="none" xmlns="http://www.w3.org/2000/svg">
                  <path d="M12.25 5.83331C12.25 9.91665 7 13.4166 7 13.4166C7 13.4166 1.75 9.91665 1.75 5.83331C1.75 4.44093 2.30312 3.10557 3.28769 2.121C4.27226 1.13644 5.60761 0.583313 7 0.583313C8.39239 0.583313 9.72774 1.13644 10.7123 2.121C11.6969 3.10557 12.25 4.44093 12.25 5.83331Z" stroke="black" stroke-opacity="0.6" stroke-linecap="round" stroke-linejoin="round"/>
                  <path d="M7 7.58331C7.9665 7.58331 8.75 6.79981 8.75 5.83331C8.75 4.86681 7.9665 4.08331 7 4.08331C6.0335 4.08331 5.25 4.86681 5.25 5.83331C5.25 6.79981 6.0335 7.58331 7 7.58331Z" stroke="black" stroke-opacity="0.6" stroke-linecap="round" stroke-linejoin="round"/>
                </svg>
                <?php echo h($p['sub']); ?>
              </li></ul>
              <?php } ?>
            </div>
            <?php if(!empty($p['price'])){ ?><p class="text-black"><?php echo h($p['price']); ?></p><?php } ?>
          </article>
        <?php } } else { ?>
          <article class="post-card odd"><div class="dz-media"></div><div class="top-meta"><h6 class="title mb-0">No projects</h6></div></article>
        <?php } ?>
      </div>
      <div class="text-center mt-3">
        <a class="btn btn-outline-primary" href="projects_desktop.php">View all projects</a>
      </div>
    </div>
  </section>

  <!-- OPPORTUNITY + STATS -->
  <section class="section-full">
    <div class="block">
      <?php $op = $opps ? $opps[0] : null; ?>
      <div style="display:grid;grid-template-columns:2fr 1fr;gap:20px">
        <div>
          <div class="name" style="font-weight:900"><?php echo h($op['title'] ?? 'Discover untapped potential!'); ?></div>
          <div class="sub" style="color:var(--muted);margin-top:6px"><?php echo h($op['body'] ?? 'Start exploring projects today.'); ?></div>
          <a href="<?php echo h($op['link_url'] ?? '#'); ?>" class="badge" style="display:inline-block;margin-top:12px;background:var(--primary);color:#fff;border-color:transparent">Explore Opportunities</a>
        </div>
        <div class="stats">
          <div class="stat"><div class="ring"><span><?php echo (int)$stats['matches']; ?></span></div><div><div style="color:var(--muted);font-size:13px">Explore Matches</div><div style="font-weight:900"><?php echo (int)$stats['matches']; ?></div></div></div>
          <div class="stat"><div class="ring"><span><?php echo h($stats['earnings']['currency']); ?></span></div><div><div style="color:var(--muted);font-size:13px">Earned till date</div><div style="font-weight:900"><?php echo h($stats['earnings']['currency']).number_format((float)$stats['earnings']['amount']); ?></div></div></div>
        </div>
      </div>
    </div>
  </section>

  <!-- NETWORK -->
  <section class="section-full">
    <div class="network">
      <div class="nthumb"><?php if(!empty($network['image_url'])) echo hm_picture($network['image_url'],'Network image',172,172,['sizes'=>'172px']); ?></div>
      <div style="flex:1"><div class="name" style="font-weight:900"><?php echo h($network['title'] ?? 'Syndicate Network'); ?></div><div class="sub" style="color:var(--muted);margin-top:6px"><?php echo h($network['body'] ?? 'Network is net worth. Collaborate and build.'); ?></div></div>
      <a class="badge" style="background:var(--primary);color:#fff;border-color:transparent" href="<?php echo h($network['link_url'] ?? '#'); ?>">Explore</a>
    </div>
  </section>

  <!-- EVENTS -->
  <section class="section-full event">
    <div class="slider" id="eventsSlider" data-autoplay="<?php echo (int)$AUTOPLAY; ?>">
      <div class="slides">
        <?php if($events){ foreach($events as $e){ ?>
          <div class="slide" itemscope itemtype="https://schema.org/Event">
            <div class="event-wrap">
              <div class="event-img"><?php if(!empty($e['image_url'])) echo hm_picture($e['image_url'], ($e['title']?:'Event'), 1200,(int)$EVENT_IMG_H,['sizes'=>'(min-width:1200px) 42vw, 100vw']); ?></div>
              <div class="event-body">
                <div class="event-title" itemprop="name"><?php echo h($e['title'] ?: ''); ?></div>
                <div class="event-sub"><span itemprop="location"><?php echo h($e['location'] ?: ''); ?></span><?php if(!empty($e['event_date'])){ ?><span> • <time itemprop="startDate" datetime="<?php echo h(date('c', strtotime($e['event_date']))); ?>"><?php echo h(date('d M Y', strtotime($e['event_date']))); ?></time></span><?php } ?></div>
              </div>
            </div>
          </div>
        <?php }} else { ?><div class="slide"><div class="event-wrap"><div class="event-img"></div><div class="event-body"><div class="event-title">Event Title</div><div class="event-sub">Location • 01 Jan</div></div></div></div><?php } ?>
      </div>
      <button class="arrow prev" type="button">&#10094;</button><button class="arrow next" type="button">&#10095;</button><div class="dots" aria-hidden="true"></div>
    </div>
  </section>
</main>

<?php
if (is_file(__DIR__.'/footer_desktop.php')) include __DIR__.'/footer_desktop.php';
else echo '<div class="footer">© '.date('Y').' Syndicate</div>';
?>

<script src="<?php echo h($ASSET.'assets/vendor/bootstrap/js/bootstrap.bundle.min.js'); ?>"></script>
<script>
/* Simple slider & sidebar for desktop */
(function(){
  document.querySelectorAll('.slider').forEach(function(root){
    var track=root.querySelector('.slides'); if(!track) return;
    var slides=[].slice.call(track.children);
    var dotsWrap=root.querySelector('.dots');
    var prev=root.querySelector('.prev'); var next=root.querySelector('.next');
    var count=slides.length||1, idx=0, autoplay=parseInt(root.getAttribute('data-autoplay')||'0',10)||0, t;
    function mkDots(){ if(!dotsWrap) return; dotsWrap.innerHTML=''; for(var i=0;i<count;i++){ var d=document.createElement('div'); d.className='dot'+(i===0?' active':''); d.addEventListener('click',(function(k){return function(){go(k); reset();};})(i)); dotsWrap.appendChild(d);} }
    function go(i){ idx=(i+count)%count; track.style.transform='translateX('+(-idx*100)+'%)'; if(dotsWrap){ [].forEach.call(dotsWrap.children,function(d,k){ d.classList.toggle('active',k===idx); }); } }
    function nextF(){ go(idx+1); } function prevF(){ go(idx-1); }
    function play(){ if(!autoplay) return; stop(); t=setInterval(nextF,autoplay); }
    function stop(){ if(t){ clearInterval(t); t=null; } }
    function reset(){ if(!autoplay) return; stop(); play(); }
    if(prev) prev.addEventListener('click',function(){ prevF(); reset(); });
    if(next) next.addEventListener('click',function(){ nextF(); reset(); });
    root.addEventListener('mouseenter',stop); root.addEventListener('mouseleave',play);
    mkDots(); go(0); play();
  });
})();
(function(){
  var sb=document.getElementById('sidebar'), bd=document.getElementById('sidebarBackdrop'), o=document.getElementById('openSidebar'), c=document.getElementById('closeSidebar');
  function open(){ if(sb){ sb.classList.add('open'); if(bd){ bd.classList.add('show'); bd.setAttribute('aria-hidden','false'); } } }
  function close(){ if(sb){ sb.classList.remove('open'); if(bd){ bd.classList.remove('show'); bd.setAttribute('aria-hidden','true'); } } }
  if(o) o.addEventListener('click',open); if(c) c.addEventListener('click',close); if(bd) bd.addEventListener('click',close); document.addEventListener('keydown',e=>{if(e.key==='Escape') close();});
})();
</script>
</body></html>
<?php
}

/* -------------------- Client viewport check ---------------- */
$needsClientCheck = empty($_COOKIE['force_view']);

/* --------------- Dispatch the selected renderer ------------ */
$ctx = compact('DB','DEFAULT_THEME','FORCE_THEME','TOK','banners','highlights','quickActions','opps','stats','network','grid','events','homeProjects','metaTitle','metaDesc','ogImage','canonical','hdr_cfg','hdr_menu','ftr_menu','sid_menu','ASSET_PREFIX','BASE','theme_mode','bodyClass','ASSET');

if ($chosen === 'mobile'){
  render_mobile($ctx);
} else {
  if($needsClientCheck){
    echo '<script>(function(){try{var w=Math.max(document.documentElement.clientWidth,window.innerWidth||0); if(w<992){var u=new URL(window.location.href); u.searchParams.set("view","mobile"); window.location.replace(u.toString());}}catch(e){}})();</script>';
  }
  render_desktop($ctx);
}
