<?php
$base_dir = __DIR__ . '/Base';
$static_url = '/Resido/assets'; // Ensure this is the correct path

// Include the common navlink content
ob_start();
include "$base_dir/navbar.php"; // This file contains the shared navlink content
$navlink_content = ob_get_clean(); // Capture the navlink content
$page= 'nav';
$fpage= 'foot';

// Optionally define the Hero block content
ob_start();
?>
	
			
<!-- ============================ Hero Banner  Start================================== -->
<div class="image-cover hero-banner" style="background:url(<?php echo $static_url; ?>/img/bg-1.jpg) no-repeat;">
	<div class="container">
		<div class="hero-search-wrap">
			<div class="hero-search">
				<h1>Find accessible homes to rent</h1>
			</div>
			<div class="hero-search-content side-form">
				
				<div class="row">
					<div class="col-lg-12 col-md-12 col-sm-12">
						<div class="form-group">
							<div class="input-with-icon">
								<input type="text" class="form-control" placeholder="Search for a location">
								<img src="<?php echo $static_url; ?>/img/pin.svg" width="18" alt="" />
							</div>
						</div>
					</div>
				</div>
				
				<div class="row">
					<div class="col-lg-6 col-md-6 col-sm-6">
						<div class="form-group">
							<label>Min Price</label>
							<select id="minprice" class="form-control">
								<option value="">&nbsp;</option>
								<option value="1">$500</option>
								<option value="2">$1000</option>
								<option value="3">$1500</option>
								<option value="4">2000</option>
								<option value="5">3000</option>
							</select>
						</div>
					</div>
					<div class="col-lg-6 col-md-6 col-sm-6">
						<div class="form-group">
							<label>Max Price</label>
							<select id="maxprice" class="form-control">
								<option value="">&nbsp;</option>
								<option value="1">$1000</option>
								<option value="2">$1500</option>
								<option value="3">$2000</option>
								<option value="4">$3000</option>
								<option value="5">$5000</option>
							</select>
						</div>
					</div>
				</div>
				
				<div class="row">
					<div class="col-lg-6 col-md-6 col-sm-6">
						<div class="form-group">
							<label>Property Type</label>
							<select id="ptypes" class="form-control">
								<option value="">&nbsp;</option>
								<option value="1">Rental</option>
								<option value="2">Villas</option>
								<option value="3">Offices</option>
								<option value="4">Condos</option>
								<option value="5">Studios</option>
							</select>
						</div>
					</div>
					<div class="col-lg-6 col-md-6 col-sm-6">
						<div class="form-group">
							<label>Bed Rooms</label>
							<select id="bedrooms" class="form-control">
								<option value="">&nbsp;</option>
								<option value="1">1</option>
								<option value="2">2</option>
								<option value="3">3</option>
								<option value="4">4</option>
								<option value="5">5</option>
							</select>
						</div>
					</div>
				</div>
				
				<div class="row">
					<div class="col-lg-12 col-md-12 col-sm-12">
						<div class="form-group">
							<label>Property Location</label>
							<select id="cities" class="form-control">
								<option value="">&nbsp;</option>
								<option value="1">Los Angeles, CA</option>
								<option value="2">New York City, NY</option>
								<option value="3">Chicago, IL</option>
								<option value="4">Houston, TX</option>
								<option value="5">Philadelphia, PA</option>
								<option value="6">San Antonio, TX</option>
								<option value="7">San Jose, CA</option>
							</select>
						</div>
					</div>
				</div>
				
			</div>
			<div class="hero-search-action">
				<a href="#" class="btn full-width btn-primary">Search Result</a>
			</div>
		</div>
	</div>
</div>
<!-- ============================ Hero Banner End ================================== -->

<!-- ============================ Step How To Use Start ================================== -->
<section>
	<div class="container">
		
		<div class="row justify-content-center">
			<div class="col-xl-6 col-lg-7 col-md-10 text-center">
				<div class="sec-heading center">
					<h2>How It Works?</h2>
					<p>At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores</p>
				</div>
			</div>
		</div>
		
		<div class="row justify-content-center g-4">
			
			<!-- services code  -->
			<?php
				include "$base_dir/Components/Home/services.php";
			?>

		</div>
		
	</div>
</section>
<div class="clearfix"></div>
<!-- ============================ Step How To Use End ====================== -->


<!-- ========================= Explore Property ========================== -->
<section class="bg-light">
	<div class="container">
		
		<div class="row justify-content-center">
			<div class="col-xl-6 col-lg-7 col-md-10 text-center">
				<div class="sec-heading center">
					<h2>Explore Recent properties</h2>
					<p>At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores</p>
				</div>
			</div>
		</div>
		
		<div class="row justify-content-center g-4">
			
			<!-- properties code  -->
			<?php
				include "$base_dir/Components/Home/properties.php";
			?>
			
		</div>
		
		<div class="row align-items-center justify-content-center">
			<div class="col-lg-12 col-md-12 col-sm-12 text-center mt-5">
				<a href="listings-list-with-sidebar.php" class="btn btn-primary px-md-5 rounded">Browse More Properties</a>
			</div>
		</div>
		
	</div>	
</section>
<!-- ================================= Explore Property =============================== -->


<!-- ============================ Property Location Start ================================== -->
<section>
	<div class="container">
		
		<div class="row justify-content-center">
			<div class="col-xl-6 col-lg-7 col-md-10 text-center">
				<div class="sec-heading center">
					<h2>Find Best Locations</h2>
					<p>At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores</p>
				</div>
			</div>
		</div>
		
		<div class="row justify-content-center g-xl-4 g-md-3 g-4">
		
			<!-- best-locations code  -->
			<?php
				include "$base_dir/Components/Home/best-locations.php";
			?>
			
		</div>
		
		<div class="row">
			<div class="col-lg-12 col-md-12 col-sm-12 text-center mt-5">
				<a href="listings-list-with-sidebar.php" class="btn btn-primary px-md-5 rounded">Browse More Locations</a>
			</div>
		</div>
		
	</div>
</section>
<!-- ============================ Property Location End ================================== -->


<!-- ============================ Smart Testimonials ================================== -->
<section class="gray">
	<div class="container">
	
		<div class="row justify-content-center">
			<div class="col-xl-6 col-lg-7 col-md-10 text-center">
				<div class="sec-heading center">
					<h2>Good Reviews by Customers</h2>
					<p>At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores</p>
				</div>
			</div>
		</div>
		
		<div class="row justify-content-center">
			
			<div class="col-lg-12 col-md-12">
				
				<div class="smart-textimonials smart-center" id="smart-textimonials">
					
					<!-- reviews code  -->
					<?php
						include "$base_dir/Components/Home/reviews.php";
					?>
					
				</div>
			</div>
			
		</div>
	</div>
</section>
<!-- ============================ Smart Testimonials End ================================== -->

<!-- ============================ Price Table Start ================================== -->
<section>
	<div class="container">
	
		<div class="row justify-content-center">
			<div class="col-xl-6 col-lg-7 col-md-10 text-center">
				<div class="sec-heading center">
					<h2>See our packages</h2>
					<p>At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores</p>
				</div>
			</div>
		</div>
		
		<div class="row align-items-center justify-content-center g-lg-4 g-md-3 g-4">
		
			<!-- packages code  -->
			<?php
				include "$base_dir/Components/Home/packages.php";
			?>
			
		</div>
		
	</div>	
</section>
<!-- ============================ Price Table End ================================== -->

<!-- ============================ Call To Action ================================== -->
<section class="bg-primary call-to-act-wrap">
	<div class="container">
		
		<!-- estate-agent code  -->
		<?php
			include "$base_dir/Components/Home/estate-agent.php";
		?>

	</div>
</section>
<!-- ============================ Call To Action End ================================== -->

<?php
$hero_content = ob_get_clean(); // Capture the hero content

// Include the base template
include "$base_dir/style/base.php";
?>