<?php
require_once __DIR__ . '/auth_bootstrap.php';

// Unset all session variables
$_SESSION = [];

// Delete the session cookie if it exists
if (ini_get("session.use_cookies")) {
    $params = session_get_cookie_params();
    setcookie(
        session_name(), 
        '', 
        time() - 42000,
        $params["path"], 
        $params["domain"],
        $params["secure"], 
        $params["httponly"]
    );
}

// Destroy the session
session_destroy();

// Redirect to login page with info message
header('Location: login.php?info=' . urlencode('You have been signed out.'));
exit;
