<?php
// sidebar_desktop.php  — Soziety desktop sidebar
if (session_status() === PHP_SESSION_NONE) session_start();
require_once __DIR__ . '/config.php';
if (!isset($ASSET)) {
    $BASE  = defined('BASE_URL') ? rtrim(BASE_URL, '/') . '/' : '/';
    $ASSET = $BASE . 'xhtml/';
}
if (!function_exists('h')) { function h($s){ return htmlspecialchars((string)$s, ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8'); } }
?>
<!-- Sidebar -->
<div class="sidebar">
    <div class="author-box">
        <div class="dz-media">
            <img src="<?php echo h($ASSET.'assets/images/stories/small/pic1.jpg'); ?>" alt="author-image">
        </div>
        <div class="dz-info">
            <span>Good Morning</span>
            <h5 class="name">Emilla</h5>
        </div>
    </div>
    <ul class="nav navbar-nav">
        <li class="nav-label">Main Menu</li>

        <li><a class="nav-link" href="<?php echo h($ASSET.'welcome.html'); ?>">
            <span class="dz-icon"><!-- svg home icon --></span>
            <span>Welcome</span>
        </a></li>

        <li><a class="nav-link" href="<?php echo h($ASSET.'index.html'); ?>">
            <span class="dz-icon"><!-- svg home icon --></span>
            <span>Home</span>
        </a></li>

        <li><a class="nav-link" href="<?php echo h($ASSET.'pages.html'); ?>">
            <span class="dz-icon"><!-- svg --></span>
            <span>Pages</span>
        </a></li>

        <li><a class="nav-link" href="<?php echo h($ASSET.'ui-components.html'); ?>">
            <span class="dz-icon"></span>
            <span>Components</span>
        </a></li>

        <li><a class="nav-link" href="<?php echo h($ASSET.'notification.html'); ?>">
            <span class="dz-icon"></span>
            <span>Notification</span>
            <span class="badge badge-circle badge-danger">1</span>
        </a></li>

        <li><a class="nav-link" href="<?php echo h($ASSET.'profile.html'); ?>">
            <span class="dz-icon"></span>
            <span>Profile</span>
        </a></li>

        <li><a class="nav-link" href="<?php echo h($ASSET.'chat.html'); ?>">
            <span class="dz-icon"></span>
            <span>Chat</span>
            <span class="badge badge-circle badge-info">5</span>
        </a></li>

        <li class="nav-label">Settings</li>

        <li class="nav-color" data-bs-toggle="offcanvas" data-bs-target="#offcanvasBottom" aria-controls="offcanvasBottom">
            <a href="javascript:void(0);" class="nav-link">
                <span class="dz-icon"><!-- color svg --></span>
                <span>Color Theme</span>
            </a>
        </li>

        <li>
            <div class="mode">
                <span class="dz-icon"><!-- dark svg --></span>
                <span class="text-dark">Dark Mode</span>
                <div class="custom-switch">
                    <input type="checkbox" class="switch-input theme-btn" id="toggle-dark-menu">
                    <label class="custom-switch-label" for="toggle-dark-menu"></label>
                </div>
            </div>
        </li>

        <!-- 🔻 ADD THIS BLOCK: Logout button -->
        <li>
            <a class="nav-link" href="<?php echo h($BASE.'mobile/welcome/login/logout'); ?>" onclick="return confirm('Are you sure you want to logout?');">
                <span class="dz-icon" aria-hidden="true">
                    <!-- Door/exit SVG -->
                    <svg xmlns="http://www.w3.org/2000/svg" width="22" height="22" viewBox="0 0 24 24" fill="none">
                        <path d="M10 3H6a2 2 0 0 0-2 2v14a2 2 0 0 0 2 2h4" stroke="currentColor" stroke-width="1.5" stroke-linecap="round"/>
                        <path d="M14 7l5 5-5 5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                        <path d="M19 12H9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round"/>
                    </svg>
                </span>
                <span>Logout</span>
            </a>
        </li>
        <!-- 🔺 /Logout -->
    </ul>

    <div class="sidebar-bottom">
        <h6 class="name">Soziety - Social Network</h6>
        <span class="ver-info">App Version 1.0</span>
    </div>
</div>
<!-- Sidebar End -->
