<?php
$base_dir = __DIR__ . '/Base';
$static_url = '/Resido/assets'; // Ensure this is the correct path

// Include the common navlink content
ob_start();
include "$base_dir/navbar.php"; // This file contains the shared navlink content
$navlink_content = ob_get_clean(); // Capture the navlink content
$page= 'nav';
$fpage= 'foot';

// Optionally define the Hero block content
ob_start();

$title = isset($_GET['title']) ? $_GET['title'] : '';

$properties = [
    [
        'id' => 1,
        'img' => '/img/p-1.jpg', 
        'img1' => '/img/p-9.jpg', 
        'img2' => '/img/p-10.jpg', 
        'tag' => 'For Rent', 
        'class' => 'label bg-light-success text-success prt-type me-2', 
        'tag1' => 'Apartment', 
        'title' => 'The Green Canton Chrysler', 
        'location' => '210 Zirak Road, Canada', 
        'price' => '$80,000', 
        'span' => 'Verified', 
    ],
    [
        'id' => 2,
        'img' => '/img/p-2.jpg', 
        'img1' => '/img/p-6.jpg', 
        'img2' => '/img/p-8.jpg', 
        'tag' => 'For Sell', 
        'class' => 'label bg-light-danger text-danger prt-type me-2', 
        'tag1' => 'House', 
        'title' => 'Purple Flatiron House', 
        'location' => '210 Zirak Road, Canada', 
        'price' => '$67,000', 
        'span' => 'SuperAgent', 
    ],
    [
        'id' => 3,
        'img' => '/img/p-3.jpg', 
        'img1' => '/img/p-5.jpg', 
        'img2' => '/img/p-7.jpg', 
        'tag' => 'For Rent', 
        'class' => 'label bg-light-success text-success prt-type me-2', 
        'tag1' => 'Building', 
        'title' => 'Rustic Reunion Tower', 
        'location' => '210 Zirak Road, Canada', 
        'price' => '$92,500', 
        'span' => 'New', 
    ],
    [
        'id' => 4,
        'img' => '/img/p-4.jpg', 
        'img1' => '/img/p-6.jpg', 
        'img2' => '/img/p-9.jpg', 
        'tag' => 'For Sell', 
        'class' => 'label bg-light-danger text-danger prt-type me-2', 
        'tag1' => 'Condos', 
        'title' => 'The Red Freedom Tower', 
        'location' => '210 Zirak Road, Canada', 
        'price' => '$89,000', 
        'span' => 'SuperAgent', 
    ],
    [
        'id' => 5,
        'img' => '/img/p-5.jpg', 
        'img1' => '/img/p-12.jpg', 
        'img2' => '/img/p-13.jpg', 
        'tag' => 'For Rent', 
        'class' => 'label bg-light-success text-success prt-type me-2', 
        'tag1' => 'Villa', 
        'title' => 'The Donald Dwelling', 
        'location' => '210 Zirak Road, Canada', 
        'price' => '$88,000', 
        'span' => 'New', 
    ],
    [
        'id' => 6,
        'img' => '/img/p-6.jpg', 
        'img1' => '/img/p-7.jpg', 
        'img2' => '/img/p-11.jpg', 
        'tag' => 'For Sell', 
        'class' => 'label bg-light-danger text-danger prt-type me-2', 
        'tag1' => 'Building', 
        'title' => 'Red Tiny Hearst Castle', 
        'location' => '210 Zirak Road, Canada', 
        'price' => '$10,50000', 
        'span' => 'SuperAgent', 
	],
	[
        'id' => 7,
        'img' => '/img/p-7.jpg', 
        'img1' => '/img/p-16.jpg', 
        'img2' => '/img/p-18.jpg', 
        'tag' => 'For Sell', 
        'class' => 'label bg-light-danger text-danger prt-type me-2', 
        'tag1' => 'Building', 
        'title' => 'Red Tiny Hearst Castle1', 
        'location' => '210 Zirak Road, Canada', 
        'price' => '$10,50000', 
        'span' => 'SuperAgent', 
    ],
	[
        'id' => 8,
        'img' => '/img/slider-1.jpg', 
        'tag' => 'For Sale', 
        'tag1' => 'Featured', 
        'title' => 'Aashirvaad Apartment', 
        'location' => '778 Country St. Panama City, FL', 
        'price' => '$2,580', 
    ],
    [
        'id' => 9,
        'img' => '/img/slider-2.jpg', 
        'tag' => 'For Sale', 
        'tag1' => 'Featured', 
        'title' => 'Aashirvaad Apartment1', 
        'location' => '778 Country St. Panama City, FL', 
        'price' => '$2,580', 
    ],
    [
        'id' => 10,
        'img' => '/img/slider-3.jpg', 
        'tag' => 'For Sale', 
        'tag1' => 'Featured', 
        'title' => 'Aashirvaad Apartment2', 
        'location' => '778 Country St. Panama City, FL', 
        'price' => '$2,580', 
	],
	[
        'id' => 11,
        'img' => '/img/p-1.jpg', 
        'img1' => '/img/p-9.jpg', 
        'img2' => '/img/p-10.jpg', 
        'tag' => 'For Rent', 
        'tag1' => 'Apartment', 
        'title' => 'Equitable Property Group', 
        'location' => '210 Zirak Road, Canada', 
        'price' => '$78,500', 
        'span' => 'Verified', 
        'reviews' => '47 Reviews', 
    ],
	[
        'id' => 12,
        'img' => '/img/p-1.jpg', 
        'img1' => '/img/p-10.jpg', 
        'img2' => '/img/p-15.jpg', 
        'tag' => 'For Sell', 
        'class' => 'label bg-light-danger text-danger me-2', 
        'tag1' => 'Building', 
        'title' => '4789 Resot Relly Market, Montreal Canada, HAQC445', 
        'price' => '$167M', 
        'rate' => '4.7', 
        'style' => 'elio_rate perfect', 
        'span' => 'Verified', 
    ],
    [
        'id' => 13,
        'img' => '/img/p-2.jpg', 
        'img1' => '/img/p-24.jpg', 
        'img2' => '/img/p-13.jpg', 
        'tag' => 'For Rent', 
        'class' => 'label bg-light-seegreen text-seegreen me-2', 
        'tag1' => 'Family', 
        'title' => '6898 Resot Relly Market, Montreal Canada, HAQC445', 
        'price' => '$8,800', 
        'rate' => '4.4', 
        'style' => 'elio_rate good',
        'span' => 'SuperAgent', 
    ],
    [
        'id' => 14,
        'img' => '/img/p-3.jpg', 
        'img1' => '/img/p-19.jpg', 
        'img2' => '/img/p-18.jpg', 
        'tag' => 'For Sell', 
        'class' => 'label bg-light-danger text-danger me-2', 
        'tag1' => 'Condos', 
        'title' => '6987 Resot Relly Market, Montreal Canada, HAQC445', 
        'price' => '$156M', 
        'rate' => '4.9', 
        'style' => 'elio_rate perfect',
        'span' => 'New', 
    ],
    [
        'id' => 15,
        'img' => '/img/p-4.jpg', 
        'img1' => '/img/p-22.jpg', 
        'img2' => '/img/p-17.jpg', 
        'tag' => 'For Rent', 
        'class' => 'label bg-light-seegreen text-seegreen me-2', 
        'tag1' => 'Villa', 
        'title' => '7654 Resot Relly Market, Montreal Canada, HAQC445', 
        'price' => '$9,700', 
        'rate' => '4.3', 
        'style' => 'elio_rate good', 
        'span' => 'New1', 
    ],
    [
        'id' => 16,
        'img' => '/img/p-5.jpg', 
        'img1' => '/img/p-14.jpg', 
        'img2' => '/img/p-16.jpg', 
        'tag' => 'For Rent', 
        'class' => 'label bg-light-seegreen text-seegreen me-2', 
        'tag1' => 'Apartment', 
        'title' => '9875 Resot Relly Market, Montreal Canada, HAQC445', 
        'price' => '$7,800', 
        'rate' => '4.8', 
        'style' => 'elio_rate perfect',
        'span' => 'New', 
    ],
    [
        'id' => 17,
        'img' => '/img/p-6.jpg', 
        'img1' => '/img/p-12.jpg', 
        'img2' => '/img/p-23.jpg', 
        'tag' => 'For Sell', 
        'class' => 'label bg-light-danger text-danger me-2', 
        'tag1' => 'Family', 
        'title' => '1648 Resot Relly Market, Montreal Canada, HAQC445', 
        'price' => '$140M', 
        'rate' => '4.2', 
        'style' => 'elio_rate good',
        'span' => 'SuperAgent', 
    ],
	[
        'id' => 18,
        'img' => '/img/p-8.jpg', 
        'img1' => '/img/p-9.jpg', 
        'img2' => '/img/p-11.jpg', 
        'tag' => 'For Rent', 
        'class' => 'label bg-light-seegreen text-seegreen me-2', 
        'tag1' => 'Villa', 
        'title' => '5690 Resot Relly Market, Montreal Canada, HAQC445', 
        'price' => '$9,200', 
        'span' => 'New', 
    ],
    [
        'id' => 19,
        'img' => '/img/p-7.jpg', 
        'img1' => '/img/p-16.jpg', 
        'img2' => '/img/p-21.jpg', 
        'tag' => 'For Sell', 
        'class' => 'label bg-light-danger text-danger me-2', 
        'tag1' => 'Family', 
        'title' => '4312 Resot Relly Market, Montreal Canada, HAQC445', 
        'price' => '$150M', 
        'span' => 'SuperAgent', 
    ],
	[
        'id' => 20,
        'img' => '/img/p-5.jpg', 
        'img1' => '/img/p-12.jpg', 
        'img2' => '/img/p-13.jpg', 
        'tag' => 'For Rent', 
        'tag1' => 'Apartment', 
        'title' => 'The Donald Dwelling1', 
        'location' => '210 Zirak Road, Canada', 
        'price' => '$78,400', 
        'span' => 'New', 
        'reviews' => '65 Reviews',
    ],
    [
        'id' => 21,
        'img' => '/img/p-6.jpg', 
        'img1' => '/img/p-7.jpg', 
        'img2' => '/img/p-11.jpg', 
        'tag' => 'For Rent', 
        'tag1' => 'Apartment', 
        'title' => 'Red Tiny Hearst Castle2', 
        'location' => '210 Zirak Road, Canada', 
        'price' => '$78,500', 
        'span' => 'SuperAgent', 
        'reviews' => '47 Reviews',
	],
	[
        'id' => 22,
        'img' => '/img/p-4.jpg', 
        'img1' => '/img/p-6.jpg', 
        'img2' => '/img/p-9.jpg', 
        'tag' => 'For Sell', 
        'class' => 'label bg-light-danger text-danger prt-type me-2', 
        'tag1' => 'Condos', 
        'title' => 'The Red Freedom Tower1', 
        'location' => '210 Zirak Road, Canada', 
        'price' => '$89,000', 
        'span' => 'SuperAgent', 
    ],
    [
        'id' => 23,
        'img' => '/img/p-5.jpg', 
        'img1' => '/img/p-12.jpg', 
        'img2' => '/img/p-13.jpg', 
        'tag' => 'For Rent', 
        'class' => 'label bg-light-success text-success prt-type me-2', 
        'tag1' => 'Villa', 
        'title' => 'The Donald Dwelling2', 
        'location' => '210 Zirak Road, Canada', 
        'price' => '$88,000', 
        'span' => 'New', 
    ],
    [
        'id' => 24,
        'img' => '/img/p-6.jpg', 
        'img1' => '/img/p-7.jpg', 
        'img2' => '/img/p-11.jpg', 
        'tag' => 'For Sell', 
        'class' => 'label bg-light-danger text-danger prt-type me-2', 
        'tag1' => 'Building', 
        'title' => 'Red Tiny Hearst Castle3', 
        'location' => '210 Zirak Road, Canada', 
        'price' => '$10,50000', 
        'span' => 'SuperAgent', 
	],
	[
        'id' => 25,
        'img' => '/img/p-4.jpg', 
        'img1' => '/img/p-6.jpg', 
        'img2' => '/img/p-9.jpg', 
        'tag' => 'For Rent', 
        'tag1' => 'Apartment', 
        'title' => 'The Red Freedom Tower2', 
        'location' => '210 Zirak Road, Canada', 
        'price' => '$89,000', 
        'span' => 'SuperAgent', 
        'reviews' => '64 Reviews',
    ],
    [
        'id' => 26,
        'img' => '/img/p-3.jpg', 
        'tag' => 'For Rent', 
        'class' => 'label bg-light-success text-success prt-type me-2', 
        'tag1' => 'Apartment', 
        'title' => 'The Green Canton Chrysler1', 
        'location' => '210 Zirak Road, Canada', 
        'price' => '$80,000', 
        'span' => 'Verified', 
    ],
    [
        'id' => 27,
        'img' => '/img/p-4.jpg', 
        'tag' => 'For Sell', 
        'class' => 'label bg-light-danger text-danger prt-type me-2', 
        'tag1' => 'House', 
        'title' => 'Purple Flatiron House2', 
        'location' => '210 Zirak Road, Canada', 
        'price' => '$67,000', 
        'span' => 'SuperAgent', 
    ],
    [
        'id' => 28,
        'img' => '/img/p-5.jpg', 
        'tag' => 'For Rent', 
        'class' => 'label bg-light-success text-success prt-type me-2', 
        'tag1' => 'Building', 
        'title' => 'Rustic Reunion Tower1', 
        'location' => '210 Zirak Road, Canada', 
        'price' => '$92,500', 
        'span' => 'New', 
    ],
    [
        'id' => 29,
        'img' => '/img/p-6.jpg', 
        'tag' => 'For Sell', 
        'class' => 'label bg-light-danger text-danger prt-type me-2', 
        'tag1' => 'Condos', 
        'title' => 'The Red Freedom Tower3', 
        'location' => '210 Zirak Road, Canada', 
        'price' => '$89,000', 
        'span' => 'SuperAgent', 
    ],
    [
        'id' => 30,
        'img' => '/img/p-7.jpg', 
        'tag' => 'For Rent', 
        'class' => 'label bg-light-success text-success prt-type me-2', 
        'tag1' => 'Villa', 
        'title' => 'The Donald Dwelling3', 
        'location' => '210 Zirak Road, Canada', 
        'price' => '$88,000', 
        'span' => 'New', 
    ],
    [
        'id' => 31,
        'img' => '/img/p-8.jpg', 
        'tag' => 'For Sell', 
        'class' => 'label bg-light-danger text-danger prt-type me-2', 
        'tag1' => 'Building', 
        'title' => 'Red Tiny Hearst Castle4', 
        'location' => '210 Zirak Road, Canada', 
        'price' => '$10,50000', 
        'span' => 'SuperAgent', 
    ]
];

$article = null;
if ($title === '') {
    $article = $properties;

} else {
    // Search for the article by slugified title
    foreach ($properties as $item) {
        $slugifiedTitle = str_replace(' ', '-', strtolower($item['title']));
        if ($slugifiedTitle === $title) {
            $article = $item;
            break;
        }
    }
}

if ($article === null) {
    echo "Article not found.";
    exit;
}
?>
			
			
<!-- ============================ Hero Banner  Start================================== -->
<div class="featured_slick_gallery gray">
	<div class="featured_slick_gallery-slide">
		<div class="featured_slick_padd"><a href="<?php echo !empty($article['img1']) ? $static_url . $article['img1'] : $static_url . '/img/p-1.jpg'; ?>" class="mfp-gallery"><img src="<?php echo !empty($article['img1']) ? $static_url . $article['img1'] : $static_url . '/img/p-1.jpg'; ?>" class="img-fluid mx-auto" alt="" /></a></div>
		<div class="featured_slick_padd"><a href="<?php echo !empty($article['img2']) ? $static_url . $article['img2'] : $static_url . '/img/p-2.jpg'; ?>" class="mfp-gallery"><img src="<?php echo !empty($article['img2']) ? $static_url . $article['img2'] : $static_url . '/img/p-2.jpg'; ?>" class="img-fluid mx-auto" alt="" /></a></div>
		<div class="featured_slick_padd"><a href="<?php echo $static_url; ?>/img/p-3.jpg" class="mfp-gallery"><img src="<?php echo $static_url; ?>/img/p-3.jpg" class="img-fluid mx-auto" alt="" /></a></div>
		<div class="featured_slick_padd"><a href="<?php echo !empty($article['img']) ? $static_url . $article['img'] : $static_url . '/img/p-4.jpg'; ?>" class="mfp-gallery"><img src="<?php echo !empty($article['img']) ? $static_url . $article['img'] : $static_url . '/img/p-4.jpg'; ?>" class="img-fluid mx-auto" alt="" /></a></div>
	</div>
	<a href="JavaScript:Void(0);" class="btn-view-pic">View photos</a>
</div>
<!-- ============================ Hero Banner End ================================== -->

<!-- ============================ Property Detail Start ================================== -->
<section class="gray-simple">
	<div class="container">
		<div class="row">
			
			<!-- property main detail -->
			<div class="col-lg-8 col-md-12 col-sm-12">
			
				<div class="property_block_wrap style-2 p-4">
					<div class="prt-detail-title-desc">
						<span class="label text-light bg-success">
							<?php 
								if (!empty($article['tag'])) {
										echo $article['tag']; 
								} else {
									echo 'For Sale'; 
								}
							?>
						</span>
						<h3 class="mt-3">
							<?php 
								if (!empty($article['title'])) {
										echo $article['title']; 
								} else {
									echo 'Jannat Graynight Mood In Siver Colony, London'; 
								}
							?>
						</h3>
						<span><i class="lni-map-marker"></i> 
							<?php 
								if (!empty($article['location'])) {
										echo $article['location']; 
								} else {
									echo '778 Country St. Panama City, FL'; 
								}
							?>
						</span>
						<h3 class="prt-price-fix text-primary mt-2">
							<?php 
								if (!empty($article['price'])) {
										echo $article['price']; 
								} else {
									echo '$7,600'; 
								}
							?>
						<sub>/month</sub></h3>
						<div class="list-fx-features">
							<div class="listing-card-info-icon">
								<div class="inc-fleat-icon me-1"><img src="<?php echo $static_url; ?>/img/bed.svg" width="13" alt=""></div>3 Beds
							</div>
							<div class="listing-card-info-icon">
								<div class="inc-fleat-icon me-1"><img src="<?php echo $static_url; ?>/img/bathtub.svg" width="13" alt=""></div>1 Bath
							</div>
							<div class="listing-card-info-icon">
								<div class="inc-fleat-icon me-1"><img src="<?php echo $static_url; ?>/img/move.svg" width="13" alt=""></div>800 sqft
							</div>
						</div>
					</div>
				</div>
				
				<!-- single-propertys-1 code  -->
				<?php
					include "$base_dir/Components/Features/single-propertys-1.php";
				?>
				
			</div>
			
			<!-- property Sidebar -->
			<div class="col-lg-4 col-md-12 col-sm-12">
				
				<!-- property-sidebar1 code  -->
				<?php
					include "$base_dir/Components/Features/property-sidebar1.php";
				?>
				
			</div>
			
		</div>
	</div>
</section>
<!-- ============================ Property Detail End ================================== -->

<!-- ============================ Call To Action ================================== -->
<section class="bg-primary call-to-act-wrap">
	<div class="container">
		
		<!-- estate-agent code  -->
		<?php
			include "$base_dir/Components/Home/estate-agent.php";
		?>

	</div>
</section>
<!-- ============================ Call To Action End ================================== -->

<!-- Video Modal -->
<div class="modal fade" id="popup-video" tabindex="-1" role="dialog" aria-labelledby="popupvideo" aria-hidden="true">
	<div class="modal-dialog modal-dialog-centered" role="document">
		<div class="modal-content" id="popupvideo">
			<iframe class="embed-responsive-item" class="full-width" height="480" src="https://www.youtube.com/embed/qN3OueBm9F4?rel=0" frameborder="0" allowfullscreen></iframe>
		</div>
	</div>
</div>
<!-- End Video Modal -->



			

<?php
$hero_content = ob_get_clean(); // Capture the hero content

// Include the base template
include "$base_dir/style/base.php";
?>