<?php
$base_dir = __DIR__ . '/Base';
$static_url = '/Resido/assets'; // Ensure this is the correct path

// Include the common navlink content
ob_start();
include "$base_dir/navbar.php"; // This file contains the shared navlink content
$navlink_content = ob_get_clean(); // Capture the navlink content
$page= 'nav';
$fpage= 'foot';

// Optionally define the Hero block content
ob_start();

$title = isset($_GET['title']) ? $_GET['title'] : '';

$propertys = [
    [
        'id' => 1,
        'img' => '/img/p-1.jpg', 
        'tag' => 'For Sale', 
        'title' => 'Adobe Property Advisors', 
        'reviews' => '(42 Reviews)', 
        'price' => '$120M', 
        'location' => 'Quice Market, Canada', 
    ],
    [
        'id' => 2,
        'img' => '/img/p-2.jpg', 
        'tag' => 'For Sale', 
        'title' => 'Agile Real Estate Group', 
        'reviews' => '(34 Reviews)', 
        'price' => '$132M', 
        'location' => 'Quice Market, Canada', 
    ],
    [
        'id' => 3,
        'img' => '/img/p-3.jpg', 
        'tag' => 'For Sale', 
        'title' => 'Bluebell Real Estate', 
        'reviews' => '(124 Reviews)', 
        'price' => '$127M', 
        'location' => 'Quice Market, Canada', 
    ],
    [
        'id' => 4,
        'img' => '/img/p-4.jpg', 
        'tag' => 'For Sale', 
        'title' => 'Strive Partners Realty', 
        'reviews' => '(56 Reviews)', 
        'price' => '$132M', 
        'location' => 'Quice Market, Canada', 
    ],
    [
        'id' => 5,
        'img' => '/img/p-14.jpg', 
        'tag' => 'For Sale', 
        'title' => 'Agile Real Estate Group1', 
        'reviews' => '(16 Reviews)', 
        'price' => '$117M', 
        'location' => 'Quice Market, Canada', 
    ],
    [
        'id' => 6,
        'img' => '/img/p-18.jpg', 
        'tag' => 'For Sale', 
        'title' => 'Nestled Real Estate', 
        'reviews' => '(123 Reviews)', 
        'price' => '$7,500', 
        'location' => 'Quice Market, Canada', 
    ],
    [
        'id' => 7,
        'img' => '/img/p-16.jpg', 
        'tag' => 'For Sale', 
        'title' => 'Flow Group Real Estate', 
        'reviews' => '(42 Reviews)', 
        'price' => '$112M', 
        'location' => 'Quice Market, Canada', 
	],
	[
        'id' => 8,
        'img' => '/img/p-1.jpg', 
        'tag' => 'For Rent', 
        'class' => 'label bg-light-success text-success d-inline-flex mb-1', 
        'title' => 'Resort Valley Ocs', 
        'reviews' => '(36 Reviews)', 
        'price' => '$8,700', 
        'location' => 'Quice Market, Canada', 
    ],
    [
        'id' => 9,
        'img' => '/img/p-2.jpg', 
        'tag' => 'For Sale', 
        'class' => 'label bg-light-danger text-danger d-inline-flex mb-1', 
        'title' => 'Adobe Property Advisors1', 
        'reviews' => '(42 Reviews)', 
        'price' => '$120M', 
        'location' => 'Quice Market, Canada', 
    ],
	[
        'id' => 10,
        'img' => '/img/p-4.jpg', 
        'tag' => 'For Rent', 
        'class' => 'label bg-light-success text-success d-inline-flex mb-1', 
        'title' => 'Agile Real Estate Group2', 
        'reviews' => '(48 Reviews)', 
        'price' => '$8,000', 
        'location' => 'Quice Market, Canada', 
    ],
    [
        'id' => 11,
        'img' => '/img/p-5.jpg', 
        'tag' => 'For Sale', 
        'class' => 'label bg-light-danger text-danger d-inline-flex mb-1', 
        'title' => 'Nestled Real Estate1', 
        'reviews' => '(15 Reviews)', 
        'price' => '$153M', 
        'location' => 'Quice Market, Canada', 
    ],
    [
        'id' => 12,
        'img' => '/img/p-6.jpg', 
        'tag' => 'For Sale', 
        'class' => 'label bg-light-danger text-danger d-inline-flex mb-1', 
        'title' => 'Flow Group Real Estate1', 
        'reviews' => '(23 Reviews)', 
        'price' => '$140M', 
        'location' => 'Quice Market, Canada', 
    ],
    [
        'id' => 13,
        'img' => '/img/p-7.jpg', 
        'tag' => 'For Rent', 
        'class' => 'label bg-light-success text-success d-inline-flex mb-1', 
        'title' => 'Strive Partners Realty1', 
        'reviews' => '(72 Reviews)', 
        'price' => '$9,500', 
        'location' => 'Quice Market, Canada', 
    ],
    [
        'id' => 14,
        'img' => '/img/p-10.jpg', 
        'tag' => 'For Sale', 
        'class' => 'label bg-light-danger text-danger d-inline-flex mb-1', 
        'title' => 'Black Oak Realty', 
        'reviews' => '(42 Reviews)', 
        'price' => '$147M', 
        'location' => 'Quice Market, Canada', 
    ],
    [
        'id' => 15,
        'img' => '/img/p-17.jpg', 
        'tag' => 'For Rent', 
        'class' => 'label bg-light-success text-success d-inline-flex mb-1', 
        'title' => 'Purple Flatiron House', 
        'reviews' => '(72 Reviews)', 
        'price' => '$9,500', 
        'location' => 'Quice Market, Canada', 
    ],
    [
        'id' => 16,
        'img' => '/img/p-10.jpg', 
        'tag' => 'For Sale', 
        'class' => 'label bg-light-danger text-danger d-inline-flex mb-1', 
        'title' => 'Black Oak Realty1', 
        'reviews' => '(42 Reviews)', 
        'price' => '$147M', 
        'location' => 'Quice Market, Canada', 
    ],
    [
        'id' => 17,
        'img' => '/img/p-13.jpg', 
        'tag' => 'For Rent', 
        'class' => 'label bg-light-success text-success d-inline-flex mb-1', 
        'title' => 'Tiny Hearst Castle', 
        'reviews' => '(65 Reviews)', 
        'price' => '$6,900', 
        'location' => 'Quice Market, Canada', 
    ],
    [
        'id' => 18,
        'img' => '/img/p-22.jpg', 
        'tag' => 'For Sale', 
        'class' => 'label bg-light-danger text-danger d-inline-flex mb-1', 
        'title' => 'The Canton Chrysler', 
        'reviews' => '(15 Reviews)', 
        'price' => '$135M', 
        'location' => 'Quice Market, Canada', 
    ]
];

$article = null;
if ($title === '') {
    $article = $propertys;

} else {
    // Search for the article by slugified title
    foreach ($propertys as $item) {
        $slugifiedTitle = str_replace(' ', '-', strtolower($item['title']));
        if ($slugifiedTitle === $title) {
            $article = $item;
            break;
        }
    }
}

if ($article === null) {
    echo "Article not found.";
    exit;
}
?>
			
			
<!-- ============================ Hero Banner  Start================================== -->
<div class="featured_slick_gallery gray">
	<div class="featured_slick_gallery-slide">
		<div class="featured_slick_padd"><a href="<?php echo $static_url; ?>/img/gl-1.png" class="mfp-gallery"><img src="<?php echo $static_url; ?>/img/gl-1.png" class="img-fluid mx-auto" alt="" /></a></div>
		<div class="featured_slick_padd"><a href="<?php echo $static_url; ?>/img/gl-2.png" class="mfp-gallery"><img src="<?php echo $static_url; ?>/img/gl-2.png" class="img-fluid mx-auto" alt="" /></a></div>
		<div class="featured_slick_padd"><a href="<?php echo $static_url; ?>/img/gl-3.png" class="mfp-gallery"><img src="<?php echo $static_url; ?>/img/gl-3.png" class="img-fluid mx-auto" alt="" /></a></div>
		<div class="featured_slick_padd"><a href="<?php echo $static_url; ?>/img/gl-4.png" class="mfp-gallery"><img src="<?php echo $static_url; ?>/img/gl-4.png" class="img-fluid mx-auto" alt="" /></a></div>
		<div class="featured_slick_padd"><a href="<?php echo $static_url; ?>/img/gl-5.png" class="mfp-gallery"><img src="<?php echo $static_url; ?>/img/gl-5.png" class="img-fluid mx-auto" alt="" /></a></div>
	</div>
	<a href="JavaScript:Void(0);" class="btn-view-pic top">View photos</a>
</div>
<!-- ============================ Hero Banner End ================================== -->

<!-- ============================ Property Header Info Start================================== -->
<section class="gray-simple rtl p-0">
	<div class="container">
		<div class="row justify-content-center">
			<div class="col-lg-11 col-md-12">
		
				<div class="property_block_wrap style-3">
				
					<div class="pbw-flex-1">

					<?php if (!empty($article['img'])): ?>
						<div class="pbw-flex-thumb p-3">
							<img class='h-30' src="<?php echo !empty($article['img']) ? $static_url . $article['img'] : $static_url . 'agency-1.png'; ?>" alt="" />
						</div>
					<?php else: ?>
						<div class="pbw-flex-thumb">
						<img class='img-fluid' src="<?php echo $static_url; ?>/img/agency-1.png" alt="" />
						</div>
					<?php endif; ?>

					</div>
					
					<div class="pbw-flex">
						<div class="prt-detail-title-desc">
							<span class="label text-light bg-success">
								<?php 
									if (!empty($article['tag'])) {
											echo $article['tag']; 
									} else {
										echo 'For Sale'; 
									}
								?>
							</span>
							<h3 class="mt-3">
								<?php 
									if (!empty($article['title'])) {
											echo $article['title']; 
									} else {
										echo 'Jannat Graynight Mood In Siver Colony, London'; 
									}
								?>
							</h3>
							<span><i class="lni-map-marker"></i> 
								<?php 
									if (!empty($article['location'])) {
											echo $article['location']; 
									} else {
										echo '778 Country St. Panama City, FL'; 
									}
								?>
							</span>
							<h3 class="prt-price-fix text-primary mt-2">
								<?php 
									if (!empty($article['price'])) {
											echo $article['price']; 
									} else {
										echo '$7,600'; 
									}
								?>
							<sub>/month</sub></h3>
							<div class="list-fx-features">
								<div class="listing-card-info-icon">
									<div class="inc-fleat-icon me-1"><img src="<?php echo $static_url; ?>/img/bed.svg" width="13" alt=""></div>3 Beds
								</div>
								<div class="listing-card-info-icon">
									<div class="inc-fleat-icon me-1"><img src="<?php echo $static_url; ?>/img/bathtub.svg" width="13" alt=""></div>1 Bath
								</div>
								<div class="listing-card-info-icon">
									<div class="inc-fleat-icon me-1"><img src="<?php echo $static_url; ?>/img/move.svg" width="13" alt=""></div>800 sqft
								</div>
							</div>
						</div>
					</div>
					
				</div>
				
			</div>	
		</div>
	</div>
</section>
<!-- ============================ Property Header Info Start================================== -->


<!-- ============================ Property Detail Start ================================== -->
<section class="gray-simple min">
	<div class="container">
		<div class="row">
			
			<!-- property main detail -->
			<div class="col-lg-8 col-md-12 col-sm-12">
				
				<!-- single-propertys-1 code  -->
				<?php
					include "$base_dir/Components/Features/single-propertys-1.php";
				?>
				
			</div>
			
			<!-- property Sidebar -->
			<div class="col-lg-4 col-md-12 col-sm-12">
				
				<!-- property-sidebar1 code  -->
				<?php
					include "$base_dir/Components/Features/property-sidebar1.php";
				?>
			
			</div>
			
		</div>
	</div>
</section>
<!-- ============================ Property Detail End ================================== -->

<!-- ============================ Call To Action ================================== -->
<section class="bg-primary call-to-act-wrap">
	<div class="container">
		
		<!-- estate-agent code  -->
		<?php
			include "$base_dir/Components/Home/estate-agent.php";
		?>

	</div>
</section>
<!-- ============================ Call To Action End ================================== -->



			

<?php
$hero_content = ob_get_clean(); // Capture the hero content

// Include the base template
include "$base_dir/style/base.php";
?>
