<?php
$base_dir = __DIR__ . '/Base';
$static_url = '/Resido/assets'; // Ensure this is the correct path

// Include the common navlink content
ob_start();
include "$base_dir/navbar6.php"; // This file contains the shared navlink content
$navlink_content = ob_get_clean(); // Capture the navlink content
$page= 'nav6';
$fpage= 'foot';

// Optionally define the Hero block content
ob_start();
?>
			
<!-- ============================ Page Title Start================================== -->
<div class="page-title">
	<div class="container">
		<div class="row">
			<div class="col-lg-12 col-md-12">
				
				<h2 class="ipt-title">Welcome!</h2>
				<span class="ipn-subtitle">Welcome To Your Account</span>
				
			</div>
		</div>
	</div>
</div>
<!-- ============================ Page Title End ================================== -->

<!-- ============================ User Dashboard ================================== -->
<section class="bg-light">
	<div class="container-fluid">
	
		<div class="row">
			<div class="col-lg-12 col-md-12">
				<div class="filter_search_opt">
					<a href="javascript:void(0);" onclick="openFilterSearch()" class="btn btn-dark full-width mb-4">Dashboard Navigation<i class="fa-solid fa-bars ms-2"></i></a>
				</div>
			</div>
		</div>
					
		<div class="row">
			
			<div class="col-lg-3 col-md-12">
				
				<div class="simple-sidebar sm-sidebar" id="filter_search">
					
					<div class="search-sidebar_header">
						<h4 class="ssh_heading">Close Filter</h4>
						<button onclick="closeFilterSearch()" class="w3-bar-item w3-button w3-large"><i class="fa-regular fa-circle-xmark fs-5 text-muted-2"></i></button>
					</div>
					
					<div class="sidebar-widgets">
						<div class="dashboard-navbar">
							
							<div class="d-user-avater">
								<img src="<?php echo $static_url; ?>/img/team-1.jpg" class="img-fluid avater" alt="">
								<h4>Adam Harshvardhan</h4>
								<span>Canada USA</span>
							</div>
							
							<div class="d-navigation">
								<ul>
									<li><a href="dashboard.php"><i class="fa-solid fa-gauge"></i>Dashboard</a></li>
									<li><a href="my-profile.php"><i class="fa-solid fa-address-card"></i>My Profile</a></li>
									<li><a href="bookmark-list.php"><i class="fa-solid fa-bookmark"></i>Bookmarked Listings</a></li>
									<li><a href="my-property.php"><i class="fa-solid fa-building-circle-check"></i>My Properties</a></li>
									<li class="active"><a href="submit-property-dashboard.php"><i class="fa-solid fa-house"></i>Submit New Property</a></li>
									<li><a href="change-password.php"><i class="fa-solid fa-unlock"></i>Change Password</a></li>
									<li><a href="index.php"><i class="fa-solid fa-power-off"></i>Log Out</a></li>
								</ul>
							</div>
							
						</div>
					</div>
					
				</div>
			</div>
			
			<div class="col-lg-9 col-md-12">
				
				<div class="row">
					<div class="col-lg-12 col-md-12 col-sm-12">
						<h4>Your Current Package: <span class="pc-title text-primary">Gold Package</span></h4>
					</div>
				</div>
				
				<div class="row">
		
					<!-- gold-package code  -->
					<?php
						include "$base_dir/Components/Features/gold-package.php";
					?>

				</div>
		
				<div class="dashboard-wraper">
					
					<div class="row">
						
						<!-- Submit Form -->
						<div class="col-lg-12 col-md-12">
						
							<div class="submit-pages">
								
								<!-- Basic Information -->
								<div class="form-submit">	
									<h3>Basic Information</h3>
									<div class="submit-section">
										<div class="row">
										
											<div class="form-group col-md-12">
												<label>Property Title<span class="tip-topdata" data-tip="Property Title"><i class="fa-solid fa-info"></i></span></label>
												<input type="text" class="form-control">
											</div>
											
											<div class="form-group col-md-6">
												<label>Status</label>
												<select id="status" class="form-control">
													<option value="">&nbsp;</option>
													<option value="1">For Rent</option>
													<option value="2">For Sale</option>
												</select>
											</div>
											
											<div class="form-group col-md-6">
												<label>Property Type</label>
												<select id="ptypes" class="form-control">
													<option value="">&nbsp;</option>
													<option value="1">Houses</option>
													<option value="2">Apartment</option>
													<option value="3">Villas</option>
													<option value="4">Commercial</option>
													<option value="5">Offices</option>
													<option value="6">Garage</option>
												</select>
											</div>
											
											<div class="form-group col-md-6">
												<label>Price</label>
												<input type="text" class="form-control" placeholder="USD">
											</div>
											
											<div class="form-group col-md-6">
												<label>Area</label>
												<input type="text" class="form-control">
											</div>
											
											<div class="form-group col-md-6">
												<label>Bedrooms</label>
												<select id="bedrooms" class="form-control">
													<option value="">&nbsp;</option>
													<option value="1">1</option>
													<option value="2">2</option>
													<option value="3">3</option>
													<option value="4">4</option>
													<option value="5">5</option>
												</select>
											</div>
											
											<div class="form-group col-md-6">
												<label>Bathrooms</label>
												<select id="bathrooms" class="form-control">
													<option value="">&nbsp;</option>
													<option value="1">1</option>
													<option value="2">2</option>
													<option value="3">3</option>
													<option value="4">4</option>
													<option value="5">5</option>
												</select>
											</div>
											
										</div>
									</div>
								</div>
								
								<!-- Gallery -->
								<div class="form-submit">	
									<h3>Gallery</h3>
									<div class="submit-section">
										<div class="row">
										
											<div class="form-group col-md-12">
												<label>Upload Gallery</label>
												<form action="/upload-target" class="dropzone dz-clickable primary-dropzone">
													<div class="dz-default dz-message">
														<i class="ti ti-gallery"></i>
														<span>Drag & Drop To Change Logo</span>
													</div>
												</form>
											</div>
											
										</div>
									</div>
								</div>
								
								<!-- Location -->
								<div class="form-submit">	
									<h3>Location</h3>
									<div class="submit-section">
										<div class="row">
										
											<div class="form-group col-md-6">
												<label>Address</label>
												<input type="text" class="form-control">
											</div>
											
											<div class="form-group col-md-6">
												<label>City</label>
												<input type="text" class="form-control">
											</div>
											
											<div class="form-group col-md-6">
												<label>State</label>
												<input type="text" class="form-control">
											</div>
											
											<div class="form-group col-md-6">
												<label>Zip Code</label>
												<input type="text" class="form-control">
											</div>
											
										</div>
									</div>
								</div>
								
								<!-- Detailed Information -->
								<div class="form-submit">	
									<h3>Detailed Information</h3>
									<div class="submit-section">
										<div class="row">
										
											<div class="form-group col-md-12">
												<label>Description</label>
												<textarea class="form-control h-120"></textarea>
											</div>
											
											<div class="form-group col-md-4">
												<label>Building Age (optional)</label>
												<select id="bage" class="form-control">
													<option value="">&nbsp;</option>
													<option value="1">0 - 5 Years</option>
													<option value="2">0 - 10Years</option>
													<option value="3">0 - 15 Years</option>
													<option value="4">0 - 20 Years</option>
													<option value="5">20+ Years</option>
												</select>
											</div>
											
											<div class="form-group col-md-4">
												<label>Garage (optional)</label>
												<select id="garage" class="form-control">
													<option value="">&nbsp;</option>
													<option value="1">1</option>
													<option value="2">2</option>
													<option value="3">3</option>
													<option value="4">4</option>
													<option value="5">5</option>
												</select>
											</div>
											
											<div class="form-group col-md-4">
												<label>Rooms (optional)</label>
												<select id="rooms" class="form-control">
													<option value="">&nbsp;</option>
													<option value="1">1</option>
													<option value="2">2</option>
													<option value="3">3</option>
													<option value="4">4</option>
													<option value="5">5</option>
												</select>
											</div>
											
											<div class="form-group col-md-12">
												<label>Other Features (optional)</label>
												<div class="o-features">
													<ul class="no-ul-list third-row">
														<li>
															<input id="a-1" class="form-check-input" name="a-1" type="checkbox">
															<label for="a-1" class="form-check-label">Air Condition</label>
														</li>
														<li>
															<input id="a-2" class="form-check-input" name="a-2" type="checkbox">
															<label for="a-2" class="form-check-label">Bedding</label>
														</li>
														<li>
															<input id="a-3" class="form-check-input" name="a-3" type="checkbox">
															<label for="a-3" class="form-check-label">Heating</label>
														</li>
														<li>
															<input id="a-4" class="form-check-input" name="a-4" type="checkbox">
															<label for="a-4" class="form-check-label">Internet</label>
														</li>
														<li>
															<input id="a-5" class="form-check-input" name="a-5" type="checkbox">
															<label for="a-5" class="form-check-label">Microwave</label>
														</li>
														<li>
															<input id="a-6" class="form-check-input" name="a-6" type="checkbox">
															<label for="a-6" class="form-check-label">Smoking Allow</label>
														</li>
														<li>
															<input id="a-7" class="form-check-input" name="a-7" type="checkbox">
															<label for="a-7" class="form-check-label">Terrace</label>
														</li>
														<li>
															<input id="a-8" class="form-check-input" name="a-8" type="checkbox">
															<label for="a-8" class="form-check-label">Balcony</label>
														</li>
														<li>
															<input id="a-9" class="form-check-input" name="a-9" type="checkbox">
															<label for="a-9" class="form-check-label">Icon</label>
														</li>
														<li>
															<input id="a-10" class="form-check-input" name="a-10" type="checkbox">
															<label for="a-10" class="form-check-label">Wi-Fi</label>
														</li>
														<li>
															<input id="a-11" class="form-check-input" name="a-11" type="checkbox">
															<label for="a-11" class="form-check-label">Beach</label>
														</li>
														<li>
															<input id="a-12" class="form-check-input" name="a-12" type="checkbox">
															<label for="a-12" class="form-check-label">Parking</label>
														</li>
													</ul>
												</div>
											</div>
											
										</div>
									</div>
								</div>
								
								<!-- Contact Information -->
								<div class="form-submit">	
									<h3>Contact Information</h3>
									<div class="submit-section">
										<div class="row">
										
											<div class="form-group col-md-4">
												<label>Name</label>
												<input type="text" class="form-control">
											</div>
											
											<div class="form-group col-md-4">
												<label>Email</label>
												<input type="text" class="form-control">
											</div>
											
											<div class="form-group col-md-4">
												<label>Phone (optional)</label>
												<input type="text" class="form-control">
											</div>
											
										</div>
									</div>
								</div>
								
								<div class="form-group col-lg-12 col-md-12">
									<label>GDPR Agreement *</label>
									<ul class="no-ul-list">
										<li>
											<input id="aj-1" class="form-check-input" name="aj-1" type="checkbox">
											<label for="aj-1" class="form-check-label">I consent to having this website store my submitted information so they can respond to my inquiry.</label>
										</li>
									</ul>
								</div>
								
								<div class="form-group col-lg-12 col-md-12">
									<button class="btn btn-primary px-5 rounded" type="submit">Submit & Preview</button>
								</div>
											
							</div>
						</div>
						
					</div>
					
				</div>
			</div>
			
		</div>
	</div>
</section>
<!-- ============================ User Dashboard End ================================== -->

<!-- ============================ Call To Action ================================== -->
<section class="bg-primary call-to-act-wrap">
	<div class="container">
		
		<!-- estate-agent code  -->
		<?php
			include "$base_dir/Components/Home/estate-agent.php";
		?>

	</div>
</section>
<!-- ============================ Call To Action End ================================== -->


			

<?php
$hero_content = ob_get_clean(); // Capture the hero content

// Include the base template
include "$base_dir/style/base.php";
?>