<?php
$base_dir = __DIR__ . '/Base';
$static_url = '/Resido/assets'; // Ensure this is the correct path

// Include the common navlink content
ob_start();
include "$base_dir/navbar.php"; // This file contains the shared navlink content
$navlink_content = ob_get_clean(); // Capture the navlink content
$page= 'nav';
$fpage= 'foot';

// Optionally define the Hero block content
ob_start();
?>
			
			
<!-- ============================ Page Title Start================================== -->
<div class="page-title">
	<div class="container">
		<div class="row">
			<div class="col-lg-12 col-md-12">
				
				<h2 class="ipt-title">Submit Property</h2>
				<span class="ipn-subtitle">Just Submit Your Property</span>
				
			</div>
		</div>
	</div>
</div>
<!-- ============================ Page Title End ================================== -->

<!-- ============================ Submit Property Start ================================== -->
<section class="gray-simple">
	<div class="container">
		
		<!-- row Start -->
		<div class="row">
			<div class="col-lg-12 col-md-12">
				<div class="alert bg-success text-light text-center" role="alert">
					Hi Dear, Have you already an account? <a href="#" class="text-warning" data-bs-toggle="collapse" data-bs-target="#login-frm">Please Login</a>
				</div>
			</div>
			
			<div class="col-lg-12 col-md-12">	
				<div id="login-frm" class="collapse mb-5">
					<div class="row">
						
						<div class="col-lg-5 col-md-4 col-sm-6">
							<div class="form-group">
								<div class="input-with-icons">
									<input type="text" class="form-control" placeholder="Username">
								</div>
							</div>
						</div>
						
						<div class="col-lg-5 col-md-4 col-sm-6">
							<div class="form-group">
								<div class="input-with-icons">
									<input type="text" class="form-control" placeholder="*******">
								</div>
							</div>
						</div>
						
						<div class="col-lg-2 col-md-4 col-sm-12">
							<div class="form-group">
								<button type="submit" class="btn btn-primary full-width">Submit</button>
							</div>
						</div>
						
						<div class="col-lg-12 col-md-12 col-sm-12">
							<div class="exclop-wrap d-flex align-items-center justify-content-between">
								<div class="exclop">
									<input id="a-1" class="form-check-input" name="a-1" type="checkbox">
									<label for="a-1" class="form-check-label">Remember Me</label>
								</div>
								<div class="exclop-last">
									<a href="#" class="fw-medium text-primary">Forget Password?</a>
								</div>
							</div>
						</div>
						
					</div>
				</div>
			</div>
		</div>
		<!-- /row -->
		
		<div class="row">
			
			<!-- Submit Form -->
			<div class="col-lg-12 col-md-12">
			
				<div class="submit-page">
					
					<!-- Basic Information -->
					<div class="form-submit">	
						<h3>Basic Information</h3>
						<div class="submit-section">
							<div class="row">
							
								<div class="form-group col-md-12">
									<label class="mb-2">Property Title<span class="tip-topdata" data-tip="Property Title"><i class="fa-solid fa-info"></i></span></label>
									<input type="text" class="form-control">
								</div>
								
								<div class="form-group col-md-6">
									<label class="mb-2">Status</label>
									<select id="status" class="form-control">
										<option value="">&nbsp;</option>
										<option value="1">For Rent</option>
										<option value="2">For Sale</option>
									</select>
								</div>
								
								<div class="form-group col-md-6">
									<label class="mb-2">Property Type</label>
									<select id="ptypes" class="form-control">
										<option value="">&nbsp;</option>
										<option value="1">Houses</option>
										<option value="2">Apartment</option>
										<option value="3">Villas</option>
										<option value="4">Commercial</option>
										<option value="5">Offices</option>
										<option value="6">Garage</option>
									</select>
								</div>
								
								<div class="form-group col-md-6">
									<label class="mb-2">Price</label>
									<input type="text" class="form-control" placeholder="USD">
								</div>
								
								<div class="form-group col-md-6">
									<label class="mb-2">Area</label>
									<input type="text" class="form-control">
								</div>
								
								<div class="form-group col-md-6">
									<label class="mb-2">Bedrooms</label>
									<select id="bedrooms" class="form-control">
										<option value="">&nbsp;</option>
										<option value="1">1</option>
										<option value="2">2</option>
										<option value="3">3</option>
										<option value="4">4</option>
										<option value="5">5</option>
									</select>
								</div>
								
								<div class="form-group col-md-6">
									<label class="mb-2">Bathrooms</label>
									<select id="bathrooms" class="form-control">
										<option value="">&nbsp;</option>
										<option value="1">1</option>
										<option value="2">2</option>
										<option value="3">3</option>
										<option value="4">4</option>
										<option value="5">5</option>
									</select>
								</div>
								
							</div>
						</div>
					</div>
					
					<!-- Gallery -->
					<div class="form-submit">	
						<h3>Gallery</h3>
						<div class="submit-section">
							<div class="row">
							
								<div class="form-group col-md-12">
									<label>Upload Gallery</label>
									<form action="/upload-target" class="dropzone dz-clickable primary-dropzone">
										<div class="dz-default dz-message">
											<i class="fa-solid fa-images"></i>
											<span>Drag & Drop To Change Logo</span>
										</div>
									</form>
								</div>
								
							</div>
						</div>
					</div>
					
					<!-- Location -->
					<div class="form-submit">	
						<h3>Location</h3>
						<div class="submit-section">
							<div class="row">
							
								<div class="form-group col-md-6">
									<label class="mb-2">Address</label>
									<input type="text" class="form-control">
								</div>
								
								<div class="form-group col-md-6">
									<label class="mb-2">City</label>
									<input type="text" class="form-control">
								</div>
								
								<div class="form-group col-md-6">
									<label class="mb-2">State</label>
									<input type="text" class="form-control">
								</div>
								
								<div class="form-group col-md-6">
									<label class="mb-2">Zip Code</label>
									<input type="text" class="form-control">
								</div>
								
							</div>
						</div>
					</div>
					
					<!-- Detailed Information -->
					<div class="form-submit">	
						<h3>Detailed Information</h3>
						<div class="submit-section">
							<div class="row">
							
								<div class="form-group col-md-12">
									<label class="mb-2">Description</label>
									<textarea class="form-control h-120"></textarea>
								</div>
								
								<div class="form-group col-md-4">
									<label class="mb-2">Building Age (optional)</label>
									<select id="bage" class="form-control">
										<option value="">&nbsp;</option>
										<option value="1">0 - 5 Years</option>
										<option value="2">0 - 10Years</option>
										<option value="3">0 - 15 Years</option>
										<option value="4">0 - 20 Years</option>
										<option value="5">20+ Years</option>
									</select>
								</div>
								
								<div class="form-group col-md-4">
									<label class="mb-2">Garage (optional)</label>
									<select id="garage" class="form-control">
										<option value="">&nbsp;</option>
										<option value="1">1</option>
										<option value="2">2</option>
										<option value="3">3</option>
										<option value="4">4</option>
										<option value="5">5</option>
									</select>
								</div>
								
								<div class="form-group col-md-4">
									<label class="mb-2">Rooms (optional)</label>
									<select id="rooms" class="form-control">
										<option value="">&nbsp;</option>
										<option value="1">1</option>
										<option value="2">2</option>
										<option value="3">3</option>
										<option value="4">4</option>
										<option value="5">5</option>
									</select>
								</div>
								
								<div class="form-group col-md-12">
									<label class="mb-2">Other Features (optional)</label>
									<div class="o-features">
										<ul class="no-ul-list third-row">
											<li>
												<input id="a-1" class="form-check-input" name="a-1" type="checkbox">
												<label for="a-1" class="form-check-label">Air Condition</label>
											</li>
											<li>
												<input id="a-2" class="form-check-input" name="a-2" type="checkbox">
												<label for="a-2" class="form-check-label">Bedding</label>
											</li>
											<li>
												<input id="a-3" class="form-check-input" name="a-3" type="checkbox">
												<label for="a-3" class="form-check-label">Heating</label>
											</li>
											<li>
												<input id="a-4" class="form-check-input" name="a-4" type="checkbox">
												<label for="a-4" class="form-check-label">Internet</label>
											</li>
											<li>
												<input id="a-5" class="form-check-input" name="a-5" type="checkbox">
												<label for="a-5" class="form-check-label">Microwave</label>
											</li>
											<li>
												<input id="a-6" class="form-check-input" name="a-6" type="checkbox">
												<label for="a-6" class="form-check-label">Smoking Allow</label>
											</li>
											<li>
												<input id="a-7" class="form-check-input" name="a-7" type="checkbox">
												<label for="a-7" class="form-check-label">Terrace</label>
											</li>
											<li>
												<input id="a-8" class="form-check-input" name="a-8" type="checkbox">
												<label for="a-8" class="form-check-label">Balcony</label>
											</li>
											<li>
												<input id="a-9" class="form-check-input" name="a-9" type="checkbox">
												<label for="a-9" class="form-check-label">Icon</label>
											</li>
											<li>
												<input id="a-10" class="form-check-input" name="a-10" type="checkbox">
												<label for="a-10" class="form-check-label">Wi-Fi</label>
											</li>
											<li>
												<input id="a-11" class="form-check-input" name="a-11" type="checkbox">
												<label for="a-11" class="form-check-label">Beach</label>
											</li>
											<li>
												<input id="a-12" class="form-check-input" name="a-12" type="checkbox">
												<label for="a-12" class="form-check-label">Parking</label>
											</li>
										</ul>
									</div>
								</div>
								
							</div>
						</div>
					</div>
					
					<!-- Contact Information -->
					<div class="form-submit">	
						<h3>Contact Information</h3>
						<div class="submit-section">
							<div class="row">
							
								<div class="form-group col-md-4">
									<label class="mb-2">Name</label>
									<input type="text" class="form-control">
								</div>
								
								<div class="form-group col-md-4">
									<label class="mb-2">Email</label>
									<input type="text" class="form-control">
								</div>
								
								<div class="form-group col-md-4">
									<label class="mb-2">Phone (optional)</label>
									<input type="text" class="form-control">
								</div>
								
							</div>
						</div>
					</div>
					
					<div class="form-group col-lg-12 col-md-12">
						<label>GDPR Agreement *</label>
						<ul class="no-ul-list">
							<li>
								<input id="aj-1" class="form-check-input" name="aj-1" type="checkbox">
								<label for="aj-1" class="form-check-label">I consent to having this website store my submitted information so they can respond to my inquiry.</label>
							</li>
						</ul>
					</div>
					
					<div class="form-group col-lg-12 col-md-12">
						<button class="btn btn-primary fw-medium px-5" type="button">Submit & Preview</button>
					</div>
								
				</div>
			</div>
			
		</div>
	</div>
			
</section>
<!-- ============================ Submit Property End ================================== -->

<!-- ============================ Call To Action ================================== -->
<section class="bg-primary call-to-act-wrap">
	<div class="container">
		
		<!-- estate-agent code  -->
		<?php
			include "$base_dir/Components/Home/estate-agent.php";
		?>

	</div>
</section>
<!-- ============================ Call To Action End ================================== -->


			
<?php
$hero_content = ob_get_clean(); // Capture the hero content

// Include the base template
include "$base_dir/style/base.php";
?>