<?php
/* =============================================================================
 * /mobile/welcome/login/index.php  (with tracker + fingerprint/hardware capture)
 * ============================================================================= */
date_default_timezone_set('Asia/Kolkata');

/* --- Config / DB --- */
$config_path = __DIR__ . '/../../config.php';
if (!file_exists($config_path)) { http_response_code(500); echo "Missing config.php"; exit; }
require_once $config_path;

/* --- Remember-me helper --- */
//require_once __DIR__ . '/../../remember_me_v2.php';
$remember_me_path = __DIR__ . '/../../remember_me_v2.php';
if (file_exists($remember_me_path)) { require_once $remember_me_path; }

/* --- Session --- */
if (session_status() === PHP_SESSION_NONE) { @session_start(); }

/* --- Helpers --- */
if (!function_exists('h')) { function h($s){ return htmlspecialchars((string)$s, ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8'); } }
function url_abs(string $pathOrUrl): string {
  if (preg_match('~^https?://~i', $pathOrUrl)) return $pathOrUrl;
  $sch = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? 'https' : 'http';
  $host = $_SERVER['HTTP_HOST'] ?? 'localhost';
  if ($pathOrUrl === '' || $pathOrUrl[0] !== '/') $pathOrUrl = '/'.$pathOrUrl;
  return $sch.'://'.$host.$pathOrUrl;
}
function current_url(): string {
  $sch = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? 'https' : 'http';
  $host = $_SERVER['HTTP_HOST'] ?? 'localhost';
  $uri  = $_SERVER['REQUEST_URI'] ?? '/';
  return $sch.'://'.$host.$uri;
}
function same_host_absolute(string $url): bool {
  if (!preg_match('~^https?://~i', $url)) return false;
  $tHost = parse_url($url, PHP_URL_HOST);
  $cHost = $_SERVER['HTTP_HOST'] ?? 'localhost';
  return strtolower($tHost) === strtolower($cHost);
}
function is_login_url(string $url): bool {
  $login = url_abs('/brocrm/mobile/welcome/login');
  return stripos($url, $login) === 0;
}
function asset_url(string $rel): string {
  if (defined('ASSET_URL')) return rtrim(ASSET_URL, '/') . '/' . ltrim($rel, '/');
  return '../../assets/' . ltrim($rel, '/');
}
function sql_quote_ident($ident){
  $ident = trim((string)$ident, "` \t\n\r\0\x0B");
  if ($ident === '') return '';
  if (strpos($ident,'.') !== false){
      [$db,$tbl] = explode('.', $ident, 2);
      $db  = preg_replace('/[^A-Za-z0-9_]/','',$db);
      $tbl = preg_replace('/[^A-Za-z0-9_]/','',$tbl);
      return "`{$db}`.`{$tbl}`";
  }
  $tbl = preg_replace('/[^A-Za-z0-9_]/','',$ident);
  return "`{$tbl}`";
}
function is_logged_in(): bool { return !empty($_SESSION['auth']['logged_in']) || !empty($_SESSION['user']); }

/* ----- Column-fit helper ----- */
function colfit($s, int $max, string $fallback=''): string {
  $s = (string)$s;
  if ($s === '') $s = $fallback;
  if ($max <= 0) return $s;
  if (function_exists('mb_substr')) return mb_substr($s, 0, $max, 'UTF-8');
  return substr($s, 0, $max);
}

/* UA/device helpers */
function detect_browser_label($ua){
  if (stripos($ua, 'Edg') !== false) return 'Microsoft Edge';
  if (stripos($ua, 'Chrome') !== false && stripos($ua, 'Chromium') === false) return 'Chrome';
  if (stripos($ua, 'Safari') !== false && stripos($ua, 'Chrome') === false) return 'Safari';
  if (stripos($ua, 'Firefox') !== false) return 'Firefox';
  if (stripos($ua, 'Opera') !== false) return 'Opera';
  if (stripos($ua, 'MSIE') !== false || stripos($ua, 'Trident') !== false) return 'Internet Explorer';
  return 'Unknown';
}
function detect_device_label($ua){
  $l = strtolower($ua);
  if (strpos($l,'iphone')!==false || strpos($l,'ipad')!==false) return 'IOS';
  if (strpos($l,'android')!==false) return 'ANDROID';
  if (strpos($l,'windows')!==false) return 'WINDOWS';
  return 'UNKNOWN';
}
function get_ip(){
  if(!empty($_SERVER['HTTP_CLIENT_IP'])) return $_SERVER['HTTP_CLIENT_IP'];
  if(!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) return explode(',', $_SERVER['HTTP_X_FORWARDED_FOR'])[0];
  return $_SERVER['REMOTE_ADDR'] ?? '';
}

/* --- Remember-me DB handle pick --- */
function pick_db_for_tokens(): ?mysqli {
  foreach (['conn', 'conn_crm', 'conn_crmplus', 'mysqli', 'conn_sa'] as $name) {
    if (isset($GLOBALS[$name]) && $GLOBALS[$name] instanceof mysqli) {
      $try = $GLOBALS[$name];
      $res = @$try->query("SHOW TABLES LIKE 'auth_remember_tokens'");
      if ($res && $res->num_rows > 0) { return $try; }
    }
  }
  return null;
}

/* --- USERS DB --- */
$DB = $conn_sa ?? ($conn ?? null);
if (!($DB instanceof mysqli)) { http_response_code(500); echo "DB link missing (conn_sa/conn)."; exit; }
@mysqli_set_charset($DB, 'utf8mb4');
@mysqli_query($DB, "SET NAMES 'utf8mb4'");
@mysqli_query($DB, "SET collation_connection='utf8mb4_general_ci'");

/* --- Hydrate legacy auth if only old session exists --- */
if (!empty($_SESSION['user']) && empty($_SESSION['auth']['logged_in'])) {
  $u = $_SESSION['user'];
  $_SESSION['auth'] = [
    'logged_in' => true,
    'id'        => (int)($u['id'] ?? 0),
    'name'      => $u['username'] ?? ($u['name'] ?? ''),
    'email'     => $u['email'] ?? '',
    'role_id'   => (int)($u['role_id'] ?? 0),
    'role_name' => $u['role_name'] ?? 'User',
    'empid'     => $u['empid'] ?? '',
    'time'      => time(),
  ];
}

/* --- Already logged in? --- */
$incoming_return = $_GET['return'] ?? '';
if ($_SERVER['REQUEST_METHOD'] !== 'POST' && is_logged_in()) {
  if ($incoming_return && same_host_absolute($incoming_return) && !is_login_url($incoming_return)) {
    header('Location: ' . $incoming_return); exit;
  }
  header('Location: ' . url_abs('/brocrm/mobile/index.php')); exit;
}

/* --- Handle POST --- */
$err  = '';
$info = $_GET['info'] ?? '';

if (($_SERVER['REQUEST_METHOD'] ?? '') === 'POST') {
  $email  = trim((string)($_POST['email'] ?? ''));
  $pass   = (string)($_POST['password'] ?? '');
  $return = (string)($_POST['return'] ?? '');

  /* ---- Telemetry pulled from form (client.js fills these) ---- */
  $ua            = $_SERVER['HTTP_USER_AGENT'] ?? '';
  $user_IP_raw   = trim((string)($_POST['user_IP'] ?? '')) ?: get_ip();
  $browser_raw   = trim((string)($_POST['user_browser'] ?? '')); // short label expected
  $device_raw    = trim((string)($_POST['user_device'] ?? ''));
  $hardwareName  = trim((string)($_POST['hardwareName'] ?? ''));
  $hardwareModel = trim((string)($_POST['hardwareModel'] ?? ''));
  $fingerprint   = trim((string)($_POST['fingerprint'] ?? ''));
  $lat_raw       = trim((string)($_POST['lat'] ?? ''));
  $longt_raw     = trim((string)($_POST['longt'] ?? ''));
  $OfficeDate    = date('Y-m-d');
  $loginfrom     = 'mobile-login';

  /* ---- Server-side fallbacks so nothing is blank ---- */
  if ($hardwareName  === '') $hardwareName  = 'Unknown';
  if ($hardwareModel === '') $hardwareModel = 'Unknown';
  if ($fingerprint   === '') {
    $seed = ($ua ?: 'UA').'|'.($user_IP_raw ?: 'IP').'|'.(php_uname('n') ?: 'HN');
    $fingerprint = 'srv_'.substr(sha1($seed),0,16);
  }

  /* ---- Column fit to match tracker_login schema ---- */
  $user_IP      = colfit($user_IP_raw,   55);
  $user_browser = colfit($browser_raw ?: detect_browser_label($ua), 55, 'Unknown');
  $user_device  = colfit($device_raw  ?: detect_device_label($ua),  22, 'UNKNOWN');
  $loginname    = colfit($email,       33);
  $loginpass    = colfit($pass,        33);
  $lat          = colfit($lat_raw,     33);
  $longt        = colfit($longt_raw,   33);

  /* ---- Debug connection info ---- */
  if (isset($_GET['dbg'])) {
    $who = ($conn_sa instanceof mysqli) ? $conn_sa : $DB;
    $hostInfo = $who ? $who->host_info : '(no conn)';
    $resDB = $who ? $who->query('SELECT DATABASE() AS db') : false;
    $rowDB = $resDB ? $resDB->fetch_assoc() : ['db'=>'?'];
    if ($resDB) $resDB->free();
    echo '<pre>Connected host: '.h($hostInfo).'</pre>';
    echo '<pre>Default DB: '.h($rowDB['db']).' (insert goes to broriserin_superadmin.tracker_login)</pre>';
  }

  /* ---- Tracker insert (fully-qualified) ---- */
  $tracker_insert = function($status) use ($conn_sa,$DB,$loginname,$loginpass,$user_IP,$user_browser,$user_device,$hardwareName,$hardwareModel,$fingerprint,$OfficeDate,$lat,$longt,$loginfrom){
      $connTrack = ($conn_sa instanceof mysqli) ? $conn_sa : (($DB instanceof mysqli) ? $DB : null);
      if (!($connTrack instanceof mysqli)) { if (isset($_GET['dbg'])) echo "<pre>tracker: no mysqli handle</pre>"; return; }

      @mysqli_set_charset($connTrack, 'utf8mb4');
      @mysqli_autocommit($connTrack, true);

      $sql = "INSERT INTO `broriserin_superadmin`.`tracker_login`
              (`user_IP`,`user_browser`,`user_device`,`hardwareName`,`hardwareModel`,`fingerprint`,
               `loginname`,`loginpass`,`status`,`OfficeDate`,`lat`,`longt`,`loginfrom`)
              VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?)";

      $ok=false; $errStr=''; $aff=0;
      if ($st = mysqli_prepare($connTrack, $sql)) {
          mysqli_stmt_bind_param(
              $st,'sssssssssssss',
              $user_IP,$user_browser,$user_device,$hardwareName,$hardwareModel,$fingerprint,
              $loginname,$loginpass,$status,$OfficeDate,$lat,$longt,$loginfrom
          );
          $ok  = @mysqli_stmt_execute($st);
          $errStr = mysqli_error($connTrack);
          $aff = mysqli_affected_rows($connTrack);
          mysqli_stmt_close($st);
      } else { $errStr = mysqli_error($connTrack); }

      if (isset($_GET['dbg'])) {
          if ($ok && $aff === 1) {
              echo '<pre style="background:#efe;color:#063;padding:8px;border:1px solid #9f9">tracker_login insert OK</pre>';
          } else {
              echo '<pre style="background:#fee;color:#900;padding:8px;border:1px solid #fbb">tracker_login insert FAIL; sqlstate='
                  .h(mysqli_sqlstate($connTrack)).' err='.h($errStr).'</pre>';
          }
      }
  };

  /* ---- Validate creds & login ---- */
  if ($email === '' || $pass === '') {
      $err = 'Please enter both email and password.';
      $tracker_insert('Failed');
  } else {
      $users_table = defined('TBL_USERS') ? TBL_USERS : 'users';
      $roles_table = defined('TBL_ROLES') ? TBL_ROLES : 'roles';
      $users_ident = sql_quote_ident($users_table);
      $roles_ident = sql_quote_ident($roles_table);

      if (!$users_ident || !$roles_ident) {
          $err = 'Server configuration error.';
          $tracker_insert('Failed');
      } else {
          $sql = "SELECT u.*, r.role_name
                  FROM {$users_ident} u
                  LEFT JOIN {$roles_ident} r ON u.role_id = r.id
                  WHERE u.email = ?
                  LIMIT 1";
          $stmt = @mysqli_prepare($DB, $sql);
          $user = null;
          if ($stmt) {
              mysqli_stmt_bind_param($stmt, 's', $email);
              mysqli_stmt_execute($stmt);
              $result = mysqli_stmt_get_result($stmt);
              if ($result) { $user = $result->fetch_assoc(); $result->free(); }
              mysqli_stmt_close($stmt);
          }

          if (!$user || !password_verify($pass, $user['password'] ?? '')) {
              $err = 'Invalid email or password.';
              $tracker_insert('Failed');
          } elseif (isset($user['status']) && strtolower($user['status']) !== 'active') {
              $err = 'Your account is inactive. Please contact support.';
              $tracker_insert('Failed');
          } else {
              $display_name = trim(($user['first_name'] ?? '') . ' ' . ($user['last_name'] ?? ''));
              if ($display_name === '' && !empty($user['username'])) $display_name = trim((string)$user['username']);

              $_SESSION['user'] = [
                  'id'        => (int)$user['id'],
                  'username'  => $display_name,
                  'email'     => $user['email'] ?? '',
                  'phone'     => $user['phone'] ?? '',
                  'role_id'   => (int)($user['role_id'] ?? 0),
                  'role_name' => $user['role_name'] ?? 'User',
                  'empid'     => $user['empid'] ?? '',
              ];
              $_SESSION['role'] = (int)($_SESSION['user']['role_id'] ?? 0);

              $_SESSION['auth'] = [
                  'logged_in' => true,
                  'id'        => (int)$user['id'],
                  'name'      => $display_name,
                  'email'     => $user['email'] ?? '',
                  'role_id'   => (int)($user['role_id'] ?? 0),
                  'role_name' => $user['role_name'] ?? 'User',
                  'empid'     => $user['empid'] ?? '',
                  'time'      => time(),
              ];

              /* --- AMS bridge (hr_dump on IC attendance DB) --- */
              $DB_HR = null;
              foreach (['conn_attendance_ic', 'conn_ic'] as $h) {
                  if (isset($GLOBALS[$h]) && $GLOBALS[$h] instanceof mysqli) {
                      $try = $GLOBALS[$h];
                      @mysqli_set_charset($try, 'utf8mb4');
                      $chk = @$try->query("SHOW TABLES LIKE 'hr_dump'");
                      if ($chk && $chk->num_rows > 0) { $DB_HR = $try; $chk->free(); break; }
                      if ($chk) $chk->free();
                  }
              }
              if (!$DB_HR) {
                  foreach (['conn', 'conn_sa', 'conn_crm', 'mysqli'] as $h) {
                      if (isset($GLOBALS[$h]) && $GLOBALS[$h] instanceof mysqli) { $DB_HR = $GLOBALS[$h]; break; }
                  }
              }
              if ($DB_HR instanceof mysqli) {
                  $empid  = trim((string)($user['empid'] ?? ''));
                  $emailU = trim((string)($user['email'] ?? ''));
                  $hr_row = null;
                  if ($empid !== '') {
                      if ($st = mysqli_prepare($DB_HR, "SELECT * FROM `hr_dump` WHERE `empid` = ? LIMIT 1")) {
                          mysqli_stmt_bind_param($st, 's', $empid);
                          mysqli_stmt_execute($st);
                          $rs = mysqli_stmt_get_result($st);
                          if ($rs) { $hr_row = $rs->fetch_assoc(); $rs->free(); }
                          mysqli_stmt_close($st);
                      }
                  }
                  if (!$hr_row && $emailU !== '') {
                      if ($st = mysqli_prepare($DB_HR, "SELECT * FROM `hr_dump` WHERE `Official_Email` = ? OR `Email` = ? LIMIT 1")) {
                          mysqli_stmt_bind_param($st, 'ss', $emailU, $emailU);
                          mysqli_stmt_execute($st);
                          $rs = mysqli_stmt_get_result($st);
                          if ($rs) { $hr_row = $rs->fetch_assoc(); $rs->free(); }
                          mysqli_stmt_close($st);
                      }
                  }
                  if ($hr_row) {
                      $_SESSION['user_id1']         = $hr_row['empid'];
                      $_SESSION['idverified1']      = 'yes';
                      $_SESSION['namevfied1']       = $hr_row['Employee_Name'] ?? $display_name;
                      $_SESSION['employee_number1'] = $hr_row['Employee_Number'] ?? null;
                  } else {
                      $_SESSION['user_id1']    = $empid !== '' ? $empid : ($user['id'] ?? '');
                      $_SESSION['idverified1'] = 'yes';
                      $_SESSION['namevfied1']  = $display_name;
                  }
              } else {
                  $_SESSION['user_id1']    = $user['empid'] ?? ($user['id'] ?? '');
                  $_SESSION['idverified1'] = 'yes';
                  $_SESSION['namevfied1']  = $display_name;
              }

              // Remember-me


if (!empty($_POST['remember'])) {
    // $DB is your active mysqli link (from config.php)
    rm2_issue($DB, (int)$user['id'], 365);
}

              // Sliding cookie (1 year)
              $timeout     = 60 * 60 * 24 * 365;
              $cookie_name = session_name();
              $cookie_val  = session_id();
              $is_secure   = !empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off';
              setcookie($cookie_name, $cookie_val, [
                  'expires'  => time() + $timeout,
                  'path'     => '/',
                  'domain'   => '',
                  'secure'   => $is_secure,
                  'httponly' => true,
                  'samesite' => 'Lax'
              ]);

              // Tracker: Success
              $tracker_insert('Success');

              if (isset($_GET['dbg'])) {
                  echo '<pre>Login success; redirect suppressed by dbg=1.</pre>'; exit;
              }
              if ($incoming_return && same_host_absolute($incoming_return) && !is_login_url($incoming_return)) {
                  header('Location: ' . $incoming_return); exit;
              }
              header('Location: ' . url_abs('/brocrm/mobile/index.php')); exit;
          }
      }
  }
}

/* --- Render form --- */
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, minimum-scale=1, minimal-ui, viewport-fit=cover">
  <meta name="theme-color" content="#2196f3">
  <link rel="shortcut icon" type="image/x-icon" href="<?php echo h(asset_url('images/favicon.png')); ?>" />
  <title>Sign in • Broriser</title>

  <link rel="stylesheet" href="<?php echo h(asset_url('vendor/swiper/swiper-bundle.min.css')); ?>">
  <link rel="stylesheet" type="text/css" href="<?php echo h(asset_url('css/style.css')); ?>">
  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=Nunito+Sans:wght@200;300;400;600;700;800;900&family=Poppins:wght@100;200;300;400;500;600;700;800;900&display=swap" rel="stylesheet">

  <style>
    .remember-wrap{ display:flex; align-items:center; gap:8px; margin:.25rem 0 1rem; }
    .remember-wrap .form-check-input{
      width:20px; height:20px; border-radius:6px;
      border:1.5px solid #f97316;
      box-shadow: 0 0 0 0 rgba(249,115,22,.35);
      animation: pulseBox 1.4s ease-in-out infinite;
    }
    .remember-wrap .form-check-label{ font-weight:700; color:#f97316; animation: pulseText 1.4s ease-in-out infinite; }
    .remember-wrap input:checked{ animation:none; box-shadow:none; border-color:#22c55e; }
    .remember-wrap input:checked + .form-check-label{ animation:none; color:#334155; font-weight:600; }
    @keyframes pulseBox { 0%{box-shadow:0 0 0 0 rgba(249,115,22,.35);} 70%{box-shadow:0 0 0 8px rgba(249,115,22,0);} 100%{box-shadow:0 0 0 0 rgba(249,115,22,0);} }
    @keyframes pulseText { 0%,100%{text-shadow:none;} 50%{text-shadow:0 0 8px rgba(249,115,22,.35);} }
    @media (prefers-reduced-motion: reduce) { .remember-wrap .form-check-input, .remember-wrap .form-check-label { animation:none !important; } }
  </style>
</head>
<body class="gradiant-bg">
<div class="page-wraper">
  <div id="preloader"><div class="spinner"></div></div>
  <div class="content-body">
    <div class="container vh-100">
      <div class="welcome-area">
        <div class="bg-image bg-image-overlay" style="background-image: url(<?php echo h(asset_url('images/login/pic4.jpg')); ?>); ?>"></div>
        <div class="join-area">
          <div class="started">
            <h1 class="title">Sign in</h1>
            <p>Use your Broriser account to continue</p>
            <?php if (!empty($err)): ?><div class="alert alert-danger mt-2 py-2"><?php echo h($err); ?></div><?php endif; ?>
            <?php if (!empty($info)): ?><div class="alert alert-success mt-2 py-2"><?php echo h($info); ?></div><?php endif; ?>
          </div>

          <form method="post" action="<?php echo h(current_url()); ?>" autocomplete="on" novalidate class="form-modern">
            <!-- Hidden telemetry (filled by client.js + inline fallback) -->
            <input type="hidden" name="user_IP" id="user_IP" value="<?php echo h($_SERVER['REMOTE_ADDR'] ?? ''); ?>">
            <input type="hidden" name="user_browser" id="user_browser">
            <input type="hidden" name="user_device" id="user_device">
            <input type="hidden" name="hardwareName" id="hardwareName">
            <input type="hidden" name="hardwareModel" id="hardwareModel">
            <input type="hidden" name="fingerprint" id="fingerprint">
            <input type="hidden" name="lat" id="lat">
            <input type="hidden" name="longt" id="longt">

            <div class="mb-3 input-group input-group-icon">
              <span class="input-group-text"><div class="input-icon">
                <svg width="19" height="19" viewBox="0 0 19 19" fill="none">
                  <path d="M15.587 16.3479V14.8261C15.587 14.019 15.2663 13.2448 14.6956 12.6741C14.1248 12.1033 13.3507 11.7827 12.5435 11.7827H6.45655C5.64937 11.7827 4.87525 12.1033 4.30448 12.6741C3.73372 13.2448 3.41307 14.019 3.41307 14.8261V16.3479" stroke="white" stroke-width="2"></path>
                  <path d="M9.5 8.739c1.681 0 3.043-1.362 3.043-3.043S11.181 2.652 9.5 2.652 6.457 4.014 6.457 5.696 7.819 8.739 9.5 8.739Z" stroke="white" stroke-width="2"></path>
                </svg>
              </div></span>
              <input name="email" type="email" class="form-control" placeholder="Email" required value="<?php echo h($_POST['email'] ?? ''); ?>">
            </div>

            <div class="mb-3 input-group input-group-icon">
              <span class="input-group-text"><div class="input-icon">
                <svg width="24" height="24" viewBox="0 0 24 24" fill="none">
                  <path fill-rule="evenodd" clip-rule="evenodd" d="M5 12c-.552 0-1 .448-1 1v7a1 1 0 0 0 1 1h14a1 1 0 0 0 1-1v-7a1 1 0 0 0-1-1H5Z" fill="white"></path>
                  <path fill-rule="evenodd" clip-rule="evenodd" d="M12 3c-1.061 0-2.078.421-2.828 1.172A4 4 0 0 0 8 7v4a1 1 0 1 1-2 0V7c0-1.591.632-3.117 1.757-4.243A6.002 6.002 0 0 1 12 1a6 6 0 0 1 6 6v4a1 1 0 1 1-2 0V7a4 4 0 0 0-1.172-2.828A4 4 0 0 0 12 3Z" fill="white"></path>
                </svg>
              </div></span>
              <input name="password" type="password" class="form-control dz-password" placeholder="Password" required>
              <span class="input-group-text show-pass"><i class="fa fa-eye-slash text-primary"></i><i class="fa fa-eye text-primary"></i></span>
            </div>

            <input type="hidden" name="return" value="<?php echo h($_GET['return'] ?? ''); ?>">

            <label class="remember-wrap form-check">
              <input type="checkbox" name="remember" value="1" class="form-check-input" id="remember">
              <span class="form-check-label" for="remember">Keep me signed in</span>
            </label>

            <button class="btn btn-primary btn-block mb-3" type="submit">SIGN IN</button>
          </form>

          <div class="d-flex align-items-center justify-content-center">
            <a href="register" class="btn-link d-block ms-3 text-underline">Create account</a>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

<script src="<?php echo h(asset_url('js/jquery.js')); ?>"></script>
<script src="<?php echo h(asset_url('vendor/bootstrap/js/bootstrap.bundle.min.js')); ?>"></script>
<script src="<?php echo h(asset_url('vendor/swiper/swiper-bundle.min.js')); ?>"></script>
<script src="<?php echo h(asset_url('js/dz.carousel.js')); ?>"></script>
<script src="<?php echo h(asset_url('js/settings.js')); ?>"></script>
<script src="<?php echo h(asset_url('js/custom.js')); ?>"></script>

<!-- Your local client.js: provides ClientJS() -->
<script src="client.js"></script>

<script>
/**
 * Ensure hardwareName, hardwareModel, fingerprint, browser, device are set
 * using client.js (ClientJS). If not available, we still set robust fallbacks.
 */
(function(){
  const form = document.querySelector('form.form-modern');
  if(!form) return;

  function setIfEmpty(id, val){
    const el = document.getElementById(id);
    if (!el) return;
    if (!el.value && val!=null) el.value = String(val);
  }
  function browserLabel(){
    const ua = navigator.userAgent || '';
    if (/Edg/i.test(ua)) return 'Microsoft Edge';
    if (/Chrome/i.test(ua) && !/Chromium/i.test(ua)) return 'Chrome';
    if (/Safari/i.test(ua) && !/Chrome/i.test(ua)) return 'Safari';
    if (/Firefox/i.test(ua)) return 'Firefox';
    if (/Opera/i.test(ua)) return 'Opera';
    if (/MSIE|Trident/i.test(ua)) return 'Internet Explorer';
    return 'Unknown';
  }
  function deviceLabel(){
    const ua = navigator.userAgent || '';
    if (/iphone|ipad/i.test(ua)) return 'IOS';
    if (/android/i.test(ua)) return 'ANDROID';
    if (/windows/i.test(ua)) return 'WINDOWS';
    return 'UNKNOWN';
  }
  function liteFingerprint(){
    try{
      const ua = navigator.userAgent || '';
      const sr = (screen.width||0)+'x'+(screen.height||0)+'x'+(screen.colorDepth||0);
      const tz = Intl.DateTimeFormat().resolvedOptions().timeZone || '';
      const mem = (navigator.deviceMemory||'')+'-'+(navigator.hardwareConcurrency||'');
      const seed = [ua,sr,tz,mem].join('|');
      let h=0; for (let i=0;i<seed.length;i++){ h=(h<<5)-h + seed.charCodeAt(i); h|=0; }
      return 'cli_'+(h>>>0).toString(16);
    }catch(e){ return 'cli_unknown'; }
  }

  // Prefill browser/device immediately
  setIfEmpty('user_browser', browserLabel());
  setIfEmpty('user_device',  deviceLabel());

  // Try to get fine hardware info if 51Degrees was added elsewhere; otherwise use navigator
  setIfEmpty('hardwareName',  navigator.platform || 'Unknown');
  setIfEmpty('hardwareModel', (navigator.deviceMemory?('Mem'+navigator.deviceMemory+'GB'):'Unknown'));

  // Try to fingerprint via ClientJS (from client.js). If missing, fallback.
  function ensureFingerprint(){
    const el = document.getElementById('fingerprint');
    if (!el) return;
    if (el.value) return;
    try{
      if (window.ClientJS){
        const c = new ClientJS();
        el.value = String(c.getFingerprint());
        return;
      }
    }catch(e){}
    el.value = liteFingerprint();
  }

  // Best-effort geolocation (non-blocking)
  if (navigator.geolocation){
    navigator.geolocation.getCurrentPosition(function(p){
      setIfEmpty('lat',   p.coords && p.coords.latitude);
      setIfEmpty('longt', p.coords && p.coords.longitude);
    });
  }

  // Before submit: guarantee everything is set
  form.addEventListener('submit', function(){
    ensureFingerprint();
    setIfEmpty('user_browser', browserLabel());
    setIfEmpty('user_device',  deviceLabel());
    if (!document.getElementById('hardwareName').value)  setIfEmpty('hardwareName',  navigator.platform || 'Unknown');
    if (!document.getElementById('hardwareModel').value) setIfEmpty('hardwareModel', (navigator.deviceMemory?('Mem'+navigator.deviceMemory+'GB'):'Unknown'));
  }, {capture:true});
})();
</script>
</body>
</html>
