<?php
/* =============================================================================
 * File   : /brocrm/mobile/remember_me.php
 * Purpose: SHIM that maps the old function names to v2 (no bind_param at all).
 *          Drop this in place of the old file to stop the fatal immediately.
 * DB     : Uses config.php mysqli; table collation utf8mb4_general_ci.
 * ============================================================================= */

declare(strict_types=1);

/* Keep the same constant name other code expects */
if (!defined('AUTH_REMEMBER_TABLE')) {
    define('AUTH_REMEMBER_TABLE', 'broriserin_broriserin.auth_remember_tokens');
}

/* Load the new implementation */
require_once __DIR__ . '/remember_me_v2.php';

/* Map old APIs -> v2 (NO prepared statements called anywhere) */
function sa_remember_issue(mysqli $db, int $user_id, int $days = 365): void {
    rm2_issue($db, (int)$user_id, (int)$days);
}
function sa_remember_clear_all(mysqli $db, int $user_id): void {
    rm2_clear_all($db, (int)$user_id);
}
function sa_remember_autologin(mysqli $db, callable $loadUserById): void {
    rm2_autologin($db, $loadUserById);
}
