<?php
session_start();
require '../../config.php';

/* Standardize charset + collation for this session (as per your stack) */
mysqli_set_charset($conn, 'utf8mb4');
@mysqli_query($conn, "SET collation_connection = 'utf8mb4_general_ci'");

if (!isset($_SESSION['admin']) || !isset($_SESSION['username'])) {
  header("Location: " . BASE_URL . "admin/login");
  exit;
}

$username = mysqli_real_escape_string($conn, $_SESSION['username']);
$admin_q  = mysqli_query($conn, "SELECT * FROM admins WHERE username='{$username}' LIMIT 1");
$admin    = $admin_q ? mysqli_fetch_assoc($admin_q) : null;

/* Fetch all applications */
$applications_q = mysqli_query($conn, "SELECT * FROM employee_applications ORDER BY created_at DESC");

/* Quick stats */
$stat_total_q   = mysqli_query($conn, "SELECT COUNT(*) c FROM employee_applications");
$stat_total     = $stat_total_q ? (int)mysqli_fetch_assoc($stat_total_q)['c'] : 0;

$stat_sub_q     = mysqli_query($conn, "SELECT COUNT(*) c FROM employee_applications WHERE application_status='submitted'");
$stat_sub       = $stat_sub_q ? (int)mysqli_fetch_assoc($stat_sub_q)['c'] : 0;

$stat_prog_q    = mysqli_query($conn, "SELECT COUNT(*) c FROM employee_applications WHERE application_status='in-progress'");
$stat_prog      = $stat_prog_q ? (int)mysqli_fetch_assoc($stat_prog_q)['c'] : 0;

$stat_app_q     = mysqli_query($conn, "SELECT COUNT(*) c FROM employee_applications WHERE application_status='approved'");
$stat_app       = $stat_app_q ? (int)mysqli_fetch_assoc($stat_app_q)['c'] : 0;

$stat_rej_q     = mysqli_query($conn, "SELECT COUNT(*) c FROM employee_applications WHERE application_status='rejected'");
$stat_rej       = $stat_rej_q ? (int)mysqli_fetch_assoc($stat_rej_q)['c'] : 0;
?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>All Applications</title>
  <?php include __DIR__ . '/../partials/head.php'; ?>
  <style>
    .page-title{display:flex;align-items:center;gap:.75rem}
    .page-title .dot{width:10px;height:10px;border-radius:50%;background:var(--bs-primary)}
    .card-soft{border:0;box-shadow:0 4px 18px rgba(0,0,0,.08);border-radius:1rem}
    .toolbar{display:flex;flex-wrap:wrap;gap:.75rem;align-items:center}
    .search-wrap{position:relative;min-width:260px}
    .search-wrap input{padding-left:2.25rem}
    .search-wrap .bi{position:absolute;left:.65rem;top:50%;transform:translateY(-50%);opacity:.6}
    .table thead th{position:sticky;top:0;background:var(--bs-dark);color:#fff;z-index:1}
    .table-hover tbody tr:hover{background:rgba(13,110,253,.04)}
    .chip{display:inline-flex;align-items:center;gap:.5rem;border:1px solid var(--bs-border-color);padding:.35rem .65rem;border-radius:999px;background:#fff}
    .chip .bi{opacity:.7}
    .btn-icon{display:inline-flex;align-items:center;gap:.4rem}
    .status-pill{border-radius:999px;padding:.25rem .65rem;font-size:.75rem;border:1px solid transparent}
    .status-submitted{background:rgba(25,135,84,.12);color:#198754;border-color:rgba(25,135,84,.35)}
    .status-progress{background:rgba(255,193,7,.12);color:#b58100;border-color:rgba(255,193,7,.35)}
    .status-approved{background:rgba(13,110,253,.12);color:#0d6efd;border-color:rgba(13,110,253,.35)}
    .status-rejected{background:rgba(220,53,69,.12);color:#dc3545;border-color:rgba(220,53,69,.35)}
    .status-other{background:rgba(108,117,125,.12);color:#6c757d;border-color:rgba(108,117,125,.3)}
    .avatar-initial{width:34px;height:34px;border-radius:50%;display:inline-grid;place-items:center;background:var(--bs-primary);color:#fff;font-weight:600}
    .filter-group .btn{border-radius:999px}
    @media (max-width: 575.98px){
      .toolbar{flex-direction:column;align-items:stretch}
      .search-wrap{min-width:100%}
    }
    /* Print styles for PDF export */
    @media print {
      .no-print{display:none!important}
      table{font-size:12px}
      .table thead th{background:#000!important;color:#fff!important}
    }
  </style>
</head>
<body class="d-flex flex-column min-vh-100">
  <div class="page-wrapper d-flex flex-column flex-grow-1" id="main-wrapper" data-layout="vertical" data-navbarbg="skin6" data-sidebartype="full" data-sidebar-position="fixed" data-header-position="fixed">
    <?php
      include __DIR__ . '/../partials/header.php';
      include __DIR__ . '/../partials/sidebar.php';
    ?>
    <div class="body-wrapper">
      <div class="body-wrapper-inner container-fluid py-4">
        <div class="d-flex flex-wrap align-items-center justify-content-between mb-4">
          <div class="page-title">
            <span class="dot"></span>
            <div>
              <h2 class="mb-0">All Applications</h2>
              <div class="text-muted small">Review, filter and export every application</div>
            </div>
          </div>
          <div class="d-flex flex-wrap gap-2">
            <span class="chip"><i class="bi bi-collection"></i>Total: <strong><?= number_format($stat_total) ?></strong></span>
            <span class="chip"><i class="bi bi-inbox"></i>Submitted: <strong><?= number_format($stat_sub) ?></strong></span>
            <span class="chip"><i class="bi bi-hourglass-split"></i>In-Progress: <strong><?= number_format($stat_prog) ?></strong></span>
            <span class="chip"><i class="bi bi-patch-check"></i>Approved: <strong><?= number_format($stat_app) ?></strong></span>
            <span class="chip"><i class="bi bi-x-octagon"></i>Rejected: <strong><?= number_format($stat_rej) ?></strong></span>
          </div>
        </div>

        <div class="card card-soft">
          <div class="card-body">
            <div class="toolbar mb-3">
              <div class="filter-group btn-group no-print" role="group" aria-label="Filter">
                <button class="btn btn-sm btn-outline-secondary active" data-filter="all"><i class="bi bi-funnel me-1"></i>All</button>
                <button class="btn btn-sm btn-outline-success" data-filter="submitted">Submitted</button>
                <button class="btn btn-sm btn-outline-warning" data-filter="in-progress">In&nbsp;Progress</button>
                <button class="btn btn-sm btn-outline-primary" data-filter="approved">Approved</button>
                <button class="btn btn-sm btn-outline-danger" data-filter="rejected">Rejected</button>
              </div>

              <div class="search-wrap ms-0 ms-md-2 no-print">
                <i class="bi bi-search"></i>
                <input id="tableSearch" type="text" class="form-control" placeholder="Search name, email, status...">
              </div>

              <div class="d-flex align-items-center gap-2 no-print">
                <label for="rowsPerPage" class="text-muted small mb-0">Rows:</label>
                <select id="rowsPerPage" class="form-select form-select-sm" style="width:auto">
                  <option value="10">10</option>
                  <option value="25">25</option>
                  <option value="50">50</option>
                  <option value="500">500</option>
                  <option value="all">All</option>
                </select>
              </div>

              <div class="ms-auto d-flex flex-wrap gap-2 no-print">
                <div class="btn-group">
                  <button id="btnExportCSV"   class="btn btn-outline-primary btn-icon"><i class="bi bi-filetype-csv"></i><span>CSV</span></button>
                  <button id="btnExportXLS"   class="btn btn-outline-success btn-icon"><i class="bi bi-file-earmark-excel"></i><span>Excel</span></button>
                  <button id="btnExportPDF"   class="btn btn-outline-danger btn-icon"><i class="bi bi-filetype-pdf"></i><span>PDF</span></button>
                </div>
                <button id="btnRefresh" class="btn btn-light btn-icon"><i class="bi bi-arrow-clockwise"></i><span>Refresh</span></button>
              </div>
            </div>

            <div class="table-responsive">
              <table id="appsTable" class="table table-hover align-middle mb-3">
                <thead class="table-dark">
                  <tr>
                    <th style="width:56px">#</th>
                    <th>Applicant</th>
                    <th>Email</th>
                    <th style="width:160px">Submitted</th>
                    <th style="width:140px">Status</th>
                    <th style="width:160px" class="no-print">Action</th>
                  </tr>
                </thead>
                <tbody>
                  <?php
                  $i=1;
                  if ($applications_q && mysqli_num_rows($applications_q)>0):
                    while($app = mysqli_fetch_assoc($applications_q)):
                      $full_name = trim(($app['title'] ? $app['title'].' ' : '').($app['first_name'] ?? '').' '.($app['surname'] ?? ''));
                      $initials  = strtoupper(mb_substr($app['first_name'] ?? 'U',0,1).mb_substr($app['surname'] ?? 'N',0,1));
                      $status    = strtolower(trim($app['application_status'] ?? ''));
                      $createdAt = !empty($app['created_at']) ? date('d M Y, h:i A', strtotime($app['created_at'])) : '-';

                      $statusHtml = '<span class="status-pill status-other">Unknown</span>';
                      if($status==='submitted')   $statusHtml = '<span class="status-pill status-submitted">Submitted</span>';
                      elseif($status==='in-progress') $statusHtml = '<span class="status-pill status-progress">In&nbsp;Progress</span>';
                      elseif($status==='approved') $statusHtml = '<span class="status-pill status-approved">Approved</span>';
                      elseif($status==='rejected') $statusHtml = '<span class="status-pill status-rejected">Rejected</span>';

                      $app_json = htmlspecialchars(json_encode($app, JSON_HEX_TAG|JSON_HEX_APOS|JSON_HEX_QUOT|JSON_HEX_AMP), ENT_QUOTES, 'UTF-8');
                  ?>
                  <tr class="data-row" data-status="<?= htmlspecialchars($status) ?>">
                    <td class="text-muted"><?= $i++; ?></td>
                    <td>
                      <div class="d-flex align-items-center gap-3">
                        <span class="avatar-initial"><?= htmlspecialchars($initials) ?></span>
                        <div class="d-flex flex-column">
                          <span class="fw-semibold"><?= htmlspecialchars($full_name) ?></span>
                          <?php if(!empty($app['country'])): ?>
                            <span class="text-muted small"><i class="bi bi-geo-alt me-1"></i><?= htmlspecialchars($app['country']) ?></span>
                          <?php endif; ?>
                        </div>
                      </div>
                    </td>
                    <td><a href="mailto:<?= htmlspecialchars($app['email']) ?>" class="text-decoration-none"><?= htmlspecialchars($app['email']) ?></a></td>
                    <td class="text-muted small"><?= $createdAt ?></td>
                    <td><?= $statusHtml ?></td>
                    <td class="no-print">
                      <button class="btn btn-sm btn-primary btn-preview" data-app='<?= $app_json ?>'>
                        <i class="bi bi-eye"></i> Preview
                      </button>
                    </td>
                  </tr>
                  <?php endwhile; else: ?>
                  <tr><td colspan="6" class="text-center text-muted py-5">No applications found.</td></tr>
                  <?php endif; ?>
                </tbody>
              </table>
            </div>

            <div class="d-flex flex-wrap align-items-center justify-content-between">
              <div class="small text-muted"><span id="rowsInfo">0</span> rows</div>
              <nav><ul class="pagination mb-0" id="pager"></ul></nav>
            </div>

          </div>
        </div>
      </div>
    </div>
    <?php include __DIR__ . '/../partials/footer.php'; ?>
  </div>

  <!-- Preview Modal -->
  <div class="modal fade" id="detailsModal" tabindex="-1" aria-labelledby="detailsModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-xl modal-dialog-scrollable">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title">Application Details</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
        </div>
        <div class="modal-body p-4">
          <div class="row">
            <div class="col-md-4 border-end">
              <div class="text-center mb-3">
                <img id="modalPassportPhoto" alt="Passport" class="img-thumbnail mb-3" style="max-width:180px;border-radius:15px;">
                <h4 id="modalFullName" class="mb-1"></h4>
                <div class="text-muted mb-3">broriser Applicant</div>
              </div>
              <h5>Contact</h5>
              <p><strong>Email:</strong> <span id="modalEmail"></span></p>
              <p><strong>Mobile:</strong> <span id="modalMobile"></span></p>
              <p><strong>DOB:</strong> <span id="modalDOB"></span></p>
              <p><strong>Gender:</strong> <span id="modalGender"></span></p>
              <p><strong>NEET:</strong> <span id="modalNeetStatus"></span></p>
              <h5 class="mt-4">Identity</h5>
              <p><strong>Language:</strong> <span id="modalPreferredLanguage"></span></p>
              <p><strong>Nationality:</strong> <span id="modalNationality"></span></p>
              <p><strong>Passport:</strong> <span id="modalHasPassport"></span></p>
              <h5 class="mt-4">Address</h5>
              <p id="modalAddress"></p>
            </div>
            <div class="col-md-8 ps-4">
              <h5>Personal Details</h5>
              <p><strong>Nationality:</strong> <span id="modalNationalityRight"></span></p>
              <p><strong>Country of Birth:</strong> <span id="modalCountryOfBirth"></span></p>
              <p><strong>Language Proficiency:</strong> <span id="modalLanguageProficiency"></span></p>

              <h5 class="mt-4">Academic Qualifications</h5>
              <div id="modalAcademicQualifications"></div>

              <h5 class="mt-4">Statement in Support of Application</h5>
              <div id="modalStatement"></div>

              <h5 class="mt-4">Seat-Booking Payment</h5>
              <div id="modalPaymentInfo"></div>

              <h5 class="mt-4">Uploaded Documents</h5>
              <div id="modalUploadedDocs" class="d-flex flex-wrap gap-3"></div>
            </div>
          </div>
        </div>
        <div class="modal-footer"><button class="btn btn-secondary" data-bs-dismiss="modal">Close</button></div>
      </div>
    </div>
  </div>

  <script>
    (function(){
      const table = document.getElementById('appsTable');
      const tbody = table.querySelector('tbody');
      const search = document.getElementById('tableSearch');
      const rowsPerPageSel = document.getElementById('rowsPerPage');
      const pager = document.getElementById('pager');
      const rowsInfo = document.getElementById('rowsInfo');
      const refreshBtn = document.getElementById('btnRefresh');
      const btnCSV  = document.getElementById('btnExportCSV');
      const btnXLS  = document.getElementById('btnExportXLS');
      const btnPDF  = document.getElementById('btnExportPDF');

      let allRows = Array.from(tbody.querySelectorAll('tr.data-row'));
      let filtered = allRows.slice();
      let page = 1;
      let rpp = rowsPerPageSel.value;
      let currentFilter = 'all';

      function normalize(s){ return (s||'').toString().toLowerCase().trim(); }

      function applyFilter(){
        const q = normalize(search.value);
        filtered = allRows.filter(tr=>{
          const statusMatch = (currentFilter==='all') ? true : (tr.dataset.status===currentFilter);
          const textMatch   = q ? normalize(tr.innerText).includes(q) : true;
          return statusMatch && textMatch;
        });
        page = 1;
        render();
      }

      function render(){
        rpp = rowsPerPageSel.value;
        const perPage = (rpp==='all') ? filtered.length || 1 : parseInt(rpp,10);

        allRows.forEach(tr=>tr.style.display='none');

        const total = filtered.length;
        const totalPages = Math.max(1, Math.ceil(total / perPage));
        if(page>totalPages) page = totalPages;
        const start = (page-1)*perPage;
        const end   = (rpp==='all') ? total : Math.min(start+perPage, total);

        for(let i=start;i<end;i++){ filtered[i].style.display=''; }

        rowsInfo.textContent = total;

        pager.innerHTML = '';
        function addItem(txt, p, disabled=false, active=false){
          const li = document.createElement('li');
          li.className = 'page-item' + (disabled?' disabled':'') + (active?' active':'');
          const a = document.createElement('a');
          a.className = 'page-link';
          a.href = '#';
          a.textContent = txt;
          a.onclick = (e)=>{ e.preventDefault(); if(!disabled){ page = p; render(); } };
          li.appendChild(a);
          pager.appendChild(li);
        }
        addItem('«', 1, page===1);
        addItem('‹', Math.max(1,page-1), page===1);
        const windowSize = 5;
        let startP = Math.max(1, page - Math.floor(windowSize/2));
        let endP   = Math.min(totalPages, startP + windowSize - 1);
        startP = Math.max(1, Math.min(startP, endP - windowSize + 1));
        for(let p=startP;p<=endP;p++){ addItem(p, p, false, p===page); }
        addItem('›', Math.min(totalPages,page+1), page===totalPages);
        addItem('»', totalPages, page===totalPages);
      }

      /* Filter buttons */
      document.querySelectorAll('.filter-group .btn').forEach(btn=>{
        btn.addEventListener('click', function(){
          document.querySelectorAll('.filter-group .btn').forEach(b=>b.classList.remove('active'));
          this.classList.add('active');
          currentFilter = this.getAttribute('data-filter');
          applyFilter();
        });
      });

      /* Actions */
      search.addEventListener('input', applyFilter);
      rowsPerPageSel.addEventListener('change', function(){ page=1; render(); });
      refreshBtn.addEventListener('click', function(){ location.reload(); });

      /* CSV Export (filtered rows only) */
      btnCSV.addEventListener('click', function(){
        const headers = ['#','Applicant','Email','Submitted','Status'];
        const lines = [headers.join(',')];
        filtered.forEach(tr=>{
          const tds = Array.from(tr.querySelectorAll('td'));
          const vals = [
            tds[0].innerText,
            tds[1].innerText.replace(/\r?\n|\r/g,' ').trim(),
            tds[2].innerText.trim(),
            tds[3].innerText.trim(),
            tds[4].innerText.trim()
          ].map(v=> `"${v.replace(/"/g,'""')}"`);
          lines.push(vals.join(','));
        });
        const blob = new Blob([lines.join('\n')], {type:'text/csv;charset=utf-8;'});
        const url = URL.createObjectURL(blob);
        const a = document.createElement('a');
        a.href = url; a.download = 'all_applications.csv';
        document.body.appendChild(a); a.click(); document.body.removeChild(a);
        URL.revokeObjectURL(url);
      });

      /* Excel Export (HTML table data URI; works for quick XLS) */
      btnXLS.addEventListener('click', function(){
        // Build a minimal table from filtered rows (exclude Action column)
        let html = '<table><thead><tr><th>#</th><th>Applicant</th><th>Email</th><th>Submitted</th><th>Status</th></tr></thead><tbody>';
        filtered.forEach(tr=>{
          const tds = Array.from(tr.querySelectorAll('td'));
          html += '<tr>'
              + `<td>${tds[0].innerText}</td>`
              + `<td>${tds[1].innerText.replace(/\r?\n|\r/g,' ').trim()}</td>`
              + `<td>${tds[2].innerText.trim()}</td>`
              + `<td>${tds[3].innerText.trim()}</td>`
              + `<td>${tds[4].innerText.trim()}</td>`
              + '</tr>';
        });
        html += '</tbody></table>';
        const blob = new Blob([html], {type: 'application/vnd.ms-excel'});
        const url = URL.createObjectURL(blob);
        const a = document.createElement('a');
        a.href = url; a.download = 'all_applications.xls';
        document.body.appendChild(a); a.click(); document.body.removeChild(a);
        URL.revokeObjectURL(url);
      });

      /* PDF Export (opens print dialog with only the filtered rows) */
      btnPDF.addEventListener('click', function(){
        // Create a printable HTML with filtered rows
        let head = `
          <html><head><title>All Applications</title>
          <style>
            body{font-family:system-ui,-apple-system,Segoe UI,Roboto,Helvetica,Arial,sans-serif;padding:16px}
            h2{margin:0 0 12px 0}
            table{width:100%;border-collapse:collapse}
            th,td{border:1px solid #444;padding:8px;font-size:12px;text-align:left;vertical-align:top}
            thead th{background:#000;color:#fff}
          </style></head><body>
          <h2>All Applications (Export)</h2>
          <table><thead><tr><th>#</th><th>Applicant</th><th>Email</th><th>Submitted</th><th>Status</th></tr></thead><tbody>
        `;
        let body = '';
        filtered.forEach(tr=>{
          const tds = Array.from(tr.querySelectorAll('td'));
          body += '<tr>'
            + `<td>${tds[0].innerText}</td>`
            + `<td>${tds[1].innerText.replace(/\r?\n|\r/g,' ').trim()}</td>`
            + `<td>${tds[2].innerText.trim()}</td>`
            + `<td>${tds[3].innerText.trim()}</td>`
            + `<td>${tds[4].innerText.trim()}</td>`
            + '</tr>';
        });
        let tail = '</tbody></table></body></html>';
        const win = window.open('', '_blank');
        win.document.write(head + body + tail);
        win.document.close();
        win.focus();
        win.print(); // user can "Save as PDF"
      });

      /* Preview modal binding */
      document.querySelectorAll('.btn-preview').forEach(btn=>{
        btn.addEventListener('click', function(){
          const app = JSON.parse(this.getAttribute('data-app'));
          const id = app.id;
          const base = "<?= BASE_URL ?>employee/employee-app/uploads/" + id + "/";
          const text = v => (v && String(v).trim().length>0) ? v : 'N/A';

          document.getElementById('modalFullName').textContent = [app.title, app.first_name, app.surname].filter(Boolean).join(' ');
          document.getElementById('modalEmail').textContent = text(app.email);
          document.getElementById('modalMobile').textContent = text(app.mobile);
          document.getElementById('modalDOB').textContent = text(app.dob);
          document.getElementById('modalGender').textContent = text(app.gender);
          document.getElementById('modalNeetStatus').textContent = (app.marital_status==='Qualified' && app.neet_score) ? `${app.marital_status} (Score: ${app.neet_score})` : text(app.marital_status);
          document.getElementById('modalPreferredLanguage').textContent = text(app.preferred_language);
          document.getElementById('modalNationality').textContent = text(app.nationality);
          document.getElementById('modalHasPassport').textContent = (app.has_passport==1 ? 'Available' : 'Not Available');
          document.getElementById('modalAddress').innerHTML = [app.addr_line1, app.addr_line2, app.city, app.state, app.postal_code, app.country].filter(Boolean).join('<br>') || 'N/A';
          document.getElementById('modalNationalityRight').textContent = text(app.nationality);
          document.getElementById('modalCountryOfBirth').textContent = text(app.country_of_birth);
          document.getElementById('modalLanguageProficiency').textContent = text(app.preferred_language);

          document.getElementById('modalAcademicQualifications').innerHTML = `
            <h6>Secondary School Certificate (SSC / 10th)</h6>
            <p>Year: ${text(app.ssc_year)}<br>School: ${text(app.ssc_school)}<br>Address: ${text(app.ssc_address)}<br>Stream: ${text(app.ssc_stream)}<br>Avg Grade: ${text(app.ssc_avg_grade)}<br>PCB %: ${text(app.ssc_pcb_percent)}<br>Avg %: ${text(app.ssc_avg_percent)}<br>Degree Available: ${text(app.ssc_degree_available)}</p>
            <h6 class="mt-3">Intermediate (Inter / 12th)</h6>
            <p>Year: ${text(app.inter_year)}<br>School: ${text(app.inter_school)}<br>Address: ${text(app.inter_address)}<br>Stream: ${text(app.inter_stream)}<br>Avg Grade: ${text(app.inter_avg_grade)}<br>PCB %: ${text(app.inter_pcb_percent)}<br>Avg %: ${text(app.inter_avg_percent)}<br>Degree Available: ${text(app.inter_degree_available)}</p>
          `;

          document.getElementById('modalStatement').innerHTML =
            (app.experience_details ? `<p>${app.experience_details}</p>` : '<p>No statement provided.</p>')
            + (app.experience_letter ? `<p><a href="${base + app.experience_letter}" target="_blank">View Statement File</a></p>` : '');

          document.getElementById('modalPaymentInfo').innerHTML =
            (app.payment_proof ? `<a href="${base + app.payment_proof}" target="_blank">View Payment Proof</a>` : 'No payment info available.');

          const docsContainer = document.getElementById('modalUploadedDocs');
          docsContainer.innerHTML = '';
          const docMap = { passport_copy:'Passport Copy', aadhar_front:'Aadhar Front', aadhar_back:'Aadhar Back' };
          Object.entries(docMap).forEach(([key,label])=>{
            if(app[key]){
              const wrap = document.createElement('div');
              wrap.innerHTML = `<div><p class="mb-1"><strong>${label}</strong></p><img src="${base + app[key]}" alt="${label}" style="max-width:160px;border:1px solid #e5e5e5;border-radius:8px"></div>`;
              docsContainer.appendChild(wrap);
            }
          });

          document.getElementById('modalPassportPhoto').setAttribute('src', base + (app.passport_photo || 'user-1.jpg'));

          const modal = new bootstrap.Modal(document.getElementById('detailsModal'));
          modal.show();
        });
      });

      /* init */
      applyFilter();
    })();
  </script>
</body>
</html>
