<?php
session_start();
require '../../config.php';

mysqli_set_charset($conn, 'utf8mb4');
@mysqli_query($conn, "SET collation_connection = 'utf8mb4_general_ci'");

if (!isset($_SESSION['admin']) || !isset($_SESSION['username'])) {
  header("Location: " . BASE_URL . "admin/login");
  exit;
}

$username = mysqli_real_escape_string($conn, $_SESSION['username']);
$admin_q  = mysqli_query($conn, "SELECT * FROM admins WHERE username='{$username}' LIMIT 1");
$admin    = $admin_q ? mysqli_fetch_assoc($admin_q) : null;

$applications_q = mysqli_query($conn, "SELECT * FROM employee_applications WHERE application_status='in-progress' ORDER BY created_at DESC");
?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8" /><meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>In-Progress Applications</title>
  <?php include __DIR__ . '/../partials/head.php'; ?>
  <style>
    .page-title{display:flex;align-items:center;gap:.75rem}
    .page-title .dot{width:10px;height:10px;border-radius:50%;background:var(--bs-warning)}
    .card-soft{border:0;box-shadow:0 4px 18px rgba(0,0,0,.08);border-radius:1rem}
    .toolbar{display:flex;flex-wrap:wrap;gap:.75rem;align-items:center}
    .search-wrap{position:relative;min-width:260px}
    .search-wrap input{padding-left:2.25rem}
    .search-wrap .bi{position:absolute;left:.65rem;top:50%;transform:translateY(-50%);opacity:.6}
    .table thead th{position:sticky;top:0;background:var(--bs-dark);color:#fff;z-index:1}
    .table-hover tbody tr:hover{background:rgba(13,110,253,.04)}
    .avatar-initial{width:34px;height:34px;border-radius:50%;display:inline-grid;place-items:center;background:var(--bs-primary);color:#fff;font-weight:600}
    .badge-pending{display:inline-block;border-radius:999px;padding:.15rem .5rem;font-size:.75rem;background:rgba(255,193,7,.15);color:#b58100;border:1px solid rgba(255,193,7,.35);animation:pulse 1.2s infinite}
    @keyframes pulse{0%{box-shadow:0 0 0 0 rgba(255,193,7,.6)}70%{box-shadow:0 0 0 8px rgba(255,193,7,0)}100%{box-shadow:0 0 0 0 rgba(255,193,7,0)}}
    .note-muted{color:#6c757d}
    @media (max-width: 575.98px){ .toolbar{flex-direction:column;align-items:stretch}.search-wrap{min-width:100%} }
  </style>
</head>
<body class="d-flex flex-column min-vh-100">
  <div class="page-wrapper d-flex flex-column flex-grow-1" id="main-wrapper" data-layout="vertical" data-navbarbg="skin6" data-sidebartype="full" data-sidebar-position="fixed" data-header-position="fixed">
    <?php include __DIR__ . '/../partials/header.php'; include __DIR__ . '/../partials/sidebar.php'; ?>
    <div class="body-wrapper">
      <div class="body-wrapper-inner container-fluid py-4">
        <div class="d-flex flex-wrap align-items-center justify-content-between mb-4">
          <div class="page-title">
            <span class="dot"></span>
            <div><h2 class="mb-0">In-Progress Applications</h2><div class="text-muted small">Preview sections — missing info or attachments are flagged as <strong>Pending</strong></div></div>
          </div>
          <div class="d-flex flex-wrap gap-2">
            <span class="badge-pending">Incomplete items will be highlighted</span>
          </div>
        </div>

        <div class="card card-soft">
          <div class="card-body">
            <div class="toolbar mb-3">
              <div class="search-wrap"><i class="bi bi-search"></i><input id="tableSearch" type="text" class="form-control" placeholder="Search name, email..."></div>
              <div class="d-flex align-items-center gap-2"><label for="rowsPerPage" class="text-muted small mb-0">Rows:</label>
                <select id="rowsPerPage" class="form-select form-select-sm" style="width:auto"><option value="10">10</option><option value="25">25</option><option value="50">50</option><option value="500">500</option><option value="all">All</option></select>
              </div>
              <div class="ms-auto d-flex gap-2"><button id="btnRefresh" class="btn btn-light btn-icon"><i class="bi bi-arrow-clockwise"></i><span>Refresh</span></button></div>
            </div>

            <div class="table-responsive">
              <table id="appsTable" class="table table-hover align-middle mb-3">
                <thead class="table-dark">
                  <tr><th style="width:56px">#</th><th>Applicant</th><th>Email</th><th style="width:160px">Last Update</th><th style="width:160px" class="no-print">Action</th></tr>
                </thead>
                <tbody>
                  <?php
                  $i=1;
                  if ($applications_q && mysqli_num_rows($applications_q)>0):
                    while($app = mysqli_fetch_assoc($applications_q)):
                      $full_name = trim(($app['title'] ? $app['title'].' ' : '').($app['first_name'] ?? '').' '.($app['surname'] ?? ''));
                      $initials  = strtoupper(mb_substr($app['first_name'] ?? 'U',0,1).mb_substr($app['surname'] ?? 'N',0,1));
                      $updatedAt = !empty($app['updated_at']) ? date('d M Y, h:i A', strtotime($app['updated_at'])) : (!empty($app['created_at']) ? date('d M Y, h:i A', strtotime($app['created_at'])) : '-');
                      $resume = null;
                      $app_email_safe = mysqli_real_escape_string($conn, $app['email']);
                      $resume_q = mysqli_query($conn, "SELECT resume FROM user_pif WHERE email='{$app_email_safe}' LIMIT 1");
                      if ($resume_q && mysqli_num_rows($resume_q) > 0) {
                          $resume_row = mysqli_fetch_assoc($resume_q);
                          $resume = $resume_row['resume'] ?? null;
                      }
                      $app['resume'] = $resume;
                      $app_json = htmlspecialchars(json_encode($app, JSON_HEX_TAG | JSON_HEX_APOS | JSON_HEX_QUOT | JSON_HEX_AMP), ENT_QUOTES, 'UTF-8');
                  ?>
                  <tr class="data-row">
                    <td class="text-muted"><?= $i++; ?></td>
                    <td>
                      <div class="d-flex align-items-center gap-3">
                        <span class="avatar-initial"><?= htmlspecialchars($initials) ?></span>
                        <div class="d-flex flex-column">
                          <span class="fw-semibold"><?= htmlspecialchars($full_name) ?></span>
                          <?php if(!empty($app['country'])): ?><span class="note-muted small"><i class="bi bi-geo-alt me-1"></i><?= htmlspecialchars($app['country']) ?></span><?php endif; ?>
                        </div>
                      </div>
                    </td>
                    <td><a href="mailto:<?= htmlspecialchars($app['email']) ?>" class="text-decoration-none"><?= htmlspecialchars($app['email']) ?></a></td>
                    <td class="text-muted small"><?= $updatedAt ?></td>
                    <td><button class="btn btn-sm btn-primary btn-preview" data-app='<?= $app_json ?>'><i class="bi bi-eye"></i> Preview</button></td>
                  </tr>
                  <?php endwhile; else: ?>
                  <tr><td colspan="5" class="text-center text-muted py-5">No applications found.</td></tr>
                  <?php endif; ?>
                </tbody>
              </table>
            </div>

            <div class="d-flex flex-wrap align-items-center justify-content-between">
              <div class="small text-muted"><span id="rowsInfo">0</span> rows</div>
              <nav><ul class="pagination mb-0" id="pager"></ul></nav>
            </div>

          </div>
        </div>
      </div>
    </div>
    <?php include __DIR__ . '/../partials/footer.php'; ?>
  </div>

  <!-- Preview Modal (flags Pending where NA/missing) -->
  <div class="modal fade" id="detailsModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-xl modal-dialog-scrollable">
      <div class="modal-content">
        <div class="modal-header"><h5 class="modal-title">Application Details</h5><button type="button" class="btn-close" data-bs-dismiss="modal"></button></div>
        <div class="modal-body p-4">
          <div class="row">
            <div class="col-md-4 border-end">
              <div class="text-center mb-3">
                <div id="imageContainer">
                  <img id="modalPassportPhoto" alt="Passport" class="img-thumbnail mb-3" style="max-width:180px; border-radius:15px;" src="" onerror="this.style.display='none'; document.getElementById('imageFallbackText').style.display='block';">
                  <div id="imageFallbackText" style="display:none;">
                    <img src="<?= BASE_URL ?>assets/images/profile/no-pic.png" alt="No Image" style="max-width:180px; border-radius:15px;">
                  </div>
                </div>
                <h4 id="modalFullName" class="mb-1"></h4>
                <div class="text-muted mb-3">IC In-Progress Applicantion</div>
              </div>
              <h5>Contact <span id="flagContact" class="ms-2"></span></h5>
              <p><strong>Email:</strong> <span id="modalEmail"></span></p>
              <p><strong>Mobile:</strong> <span id="modalMobile"></span></p>
              <p><strong>DOB:</strong> <span id="modalDOB"></span></p>
              <p><strong>Gender:</strong> <span id="modalGender"></span></p>
              <p><strong>Marital Status:</strong> <span id="modalNeetStatus"></span></p>
              <h5 class="mt-4">Identity <span id="flagIdentity" class="ms-2"></span></h5>
              <p><strong>Language:</strong> <span id="modalPreferredLanguage"></span></p>
              <p><strong>Nationality:</strong> <span id="modalNationality"></span></p>
              <h5 class="mt-4">Address <span id="flagAddress" class="ms-2"></span></h5>
              <p id="modalAddress"></p>
            </div>
            <div class="col-md-8 ps-4">
              <h5>Personal Details</h5>
                <div class="row mb-2">
                    <div class="col-4"><p><strong>Nationality:</strong> <span id="modalNationalityRight"></span></p></div>
                    <div class="col-4"><p><strong>Country of Birth:</strong> <span id="modalCountryOfBirth"></span></p></div>
                    <div class="col-4"><p><strong>Language Proficiency:</strong> <span id="modalLanguageProficiency"></span></p></div>
                </div>
            <h5>Additional Details</h5>
            <div class="row mb-2">
                <div class="col-3"><p><strong>PAN Number:</strong> <span id="modalPanNumber"></span></p></div>
                <div class="col-3"><p><strong>Aadhar Number:</strong> <span id="modalAadharNumber"></span></p></div>
                <div class="col-3"> <p><strong>Father Name:</strong> <span id="modalFatherName"></span></p></div>
                <div class="col-3"> <p><strong>Mother Name:</strong> <span id="modalMotherName"></span></p></div>
            </div>
            <div class="row mb-2">
                <div class="col-3"><p><strong>Emergency Name:</strong> <span id="modalEmergencyName"></span></p> </div>
                <div class="col-3"><p><strong>Emergency Mobile:</strong> <span id="modalEmergencyMobile"></span></p></div>
                <div class="col-3"> <p><strong>Reference 1:</strong> <span id="modalReference1"></span></p> </div>
                <div class="col-3"> <p><strong>Reference 1 Contact:</strong> <span id="modalReference1Contact"></span></p></div>
            </div>
            <div class="row mb-2"> 
                <div class="col-3"><p><strong>Reference 2:</strong> <span id="modalReference2"></span></p></div>
                <div class="col-3"><p><strong>Reference 2 Contact:</strong> <span id="modalReference2Contact"></span></p></div>
            </div>
              <h5 class="mt-4">Bank Details <span id="flagBank" class="ms-2"></span></h5>
              <div id="modalBankDetails"></div>
              <h5 class="mt-4">Academic Qualifications <span id="flagAcademics" class="ms-2"></span></h5>
              <div id="modalAcademicQualifications"></div>

              <h5 class="mt-4">Experience Letter <span id="flagStatement" class="ms-2"></span></h5>
              <div id="modalStatement"></div>

              <!-- <h5 class="mt-4">Seat-Booking Payment <span id="flagPayment" class="ms-2"></span></h5> -->
              <!-- <div id="modalPaymentInfo"></div> -->

              <h5 class="mt-4">Uploaded Documents <span id="flagDocs" class="ms-2"></span></h5>
              <div id="modalUploadedDocs" class="d-flex flex-wrap gap-3"></div>
            </div>
          </div>
        </div>
        <div class="modal-footer"><button class="btn btn-secondary" data-bs-dismiss="modal">Close</button></div>
      </div>
    </div>
  </div>

  <script>
  (function(){
    const table = document.getElementById('appsTable');
    const tbody = table.querySelector('tbody');
    const search = document.getElementById('tableSearch');
    const rowsPerPageSel = document.getElementById('rowsPerPage');
    const pager = document.getElementById('pager');
    const rowsInfo = document.getElementById('rowsInfo');
    const refreshBtn = document.getElementById('btnRefresh');

    let allRows = Array.from(tbody.querySelectorAll('tr.data-row'));
    let filtered = allRows.slice();
    let page = 1;
    let rpp = rowsPerPageSel.value;

    function normalize(s){ return (s||'').toString().toLowerCase().trim(); }
    function applyFilter(){
      const q = normalize(search.value);
      filtered = allRows.filter(tr => q ? normalize(tr.innerText).includes(q) : true);
      page = 1; render();
    }
    function render(){
      rpp = rowsPerPageSel.value;
      const perPage = (rpp==='all') ? filtered.length || 1 : parseInt(rpp,10);
      allRows.forEach(tr=>tr.style.display='none');
      const total = filtered.length;
      const totalPages = Math.max(1, Math.ceil(total / perPage));
      if(page>totalPages) page = totalPages;
      const start = (page-1)*perPage;
      const end   = (rpp==='all') ? total : Math.min(start+perPage, total);
      for(let i=start;i<end;i++){ filtered[i].style.display=''; }
      rowsInfo.textContent = total;
      pager.innerHTML = '';
      function addItem(txt, p, disabled=false, active=false){
        const li = document.createElement('li');
        li.className = 'page-item' + (disabled?' disabled':'') + (active?' active':'');
        const a = document.createElement('a'); a.className='page-link'; a.href='#'; a.textContent=txt;
        a.onclick = (e)=>{ e.preventDefault(); if(!disabled){ page = p; render(); } };
        li.appendChild(a); pager.appendChild(li);
      }
      addItem('«', 1, page===1); addItem('‹', Math.max(1,page-1), page===1);
      const windowSize = 5; let startP = Math.max(1, page - Math.floor(windowSize/2));
      let endP = Math.min(totalPages, startP + windowSize - 1);
      startP = Math.max(1, Math.min(startP, endP - windowSize + 1));
      for(let p=startP;p<=endP;p++){ addItem(p, p, false, p===page); }
      addItem('›', Math.min(totalPages,page+1), page===totalPages); addItem('»', totalPages, page===totalPages);
    }
    search.addEventListener('input', applyFilter);
    rowsPerPageSel.addEventListener('change', function(){ page=1; render(); });
    refreshBtn.addEventListener('click', function(){ location.reload(); });

    function flag(elId, pending){
      const el = document.getElementById(elId);
      if(!el) return;
      if(pending){ el.className='badge-pending'; el.textContent='Pending'; }
      else { el.className=''; el.textContent=''; }
    }
    function isNA(v){ if(v===null || v===undefined) return true; const s=String(v).trim(); return s===''|| s.toLowerCase()==='na' || s.toLowerCase()==='n/a' || s.toLowerCase()==='none'; }
    function anyMissing(arr){ return arr.some(isNA); }

    /* Preview modal binding with Pending flags */
    const modal = new bootstrap.Modal(document.getElementById('detailsModal'));
    document.querySelectorAll('.btn-preview').forEach(btn=>{
      btn.addEventListener('click', function(){
        const app = JSON.parse(this.getAttribute('data-app'));
        const id = app.id;
        const base = "<?= BASE_URL ?>employee/employee-app/uploads/" + id + "/";
        const txt = v => (v && String(v).trim().length>0) ? v : 'NA';

        document.getElementById('modalFullName').textContent = [app.title, app.first_name, app.surname].filter(Boolean).join(' ');
        document.getElementById('modalEmail').textContent = txt(app.email);
        document.getElementById('modalMobile').textContent = txt(app.mobile);
        document.getElementById('modalDOB').textContent = txt(app.dob);
        document.getElementById('modalGender').textContent = txt(app.gender);
        document.getElementById('modalNeetStatus').textContent = (app.marital_status==='Qualified' && app.neet_score) ? `${app.marital_status} (Score: ${app.neet_score})` : txt(app.marital_status);
        document.getElementById('modalPreferredLanguage').textContent = txt(app.preferred_language);
        document.getElementById('modalNationality').textContent = txt(app.nationality);
        document.getElementById('modalAddress').innerHTML = [app.addr_line1, app.addr_line2, app.city, app.state, app.postal_code, app.country].filter(Boolean).join('<br>') || 'NA';
        document.getElementById('modalNationalityRight').textContent = txt(app.nationality);
        document.getElementById('modalCountryOfBirth').textContent = txt(app.country_of_birth);
        document.getElementById('modalLanguageProficiency').textContent = txt(app.preferred_language);
        document.getElementById('modalPanNumber').textContent = txt(app.pan_number);document.getElementById('modalAadharNumber').textContent = txt(app.aadhar_number);document.getElementById('modalFatherName').textContent = txt(app.father_name);document.getElementById('modalMotherName').textContent = txt(app.mother_name);
        document.getElementById('modalEmergencyName').textContent = txt(app.emergency_name);document.getElementById('modalEmergencyMobile').textContent = txt(app.emergency_mobile);
        document.getElementById('modalReference1').textContent = txt(app.reference_1);document.getElementById('modalReference1Contact').textContent = txt(app.reference_1_contact);
        document.getElementById('modalReference2').textContent = txt(app.reference_2);document.getElementById('modalReference2Contact').textContent = txt(app.reference_2_contact);
        function hasAnyUGData(app) {
          return  app.ug_school || app.ug_address || app.ug_stream ||
                app.ug_avg_grade || app.ug_pcb_percent || app.ug_avg_percent || app.ug_degree_available || app.ug_certificate;
        }

        function hasAnyPGData(app) {
          return  app.pg_school || app.pg_stream ||
                app.pg_avg_grade || app.pg_pcb_percent || app.pg_avg_percent || app.pg_degree_available || app.pg_certificate;
        }
        function hasAnyOtherData(app) {
          return  app.other_certificate;
        }
        /* -------- BANK DETAILS -------- */
        document.getElementById('modalBankDetails').innerHTML = `
          <div class="row mt-3">
            <div class="col-md-8">
              <p>
                <strong>Bank Name:</strong> ${txt(app.bank_name)} <br>
                <strong>Account Number:</strong> ${txt(app.account_number)} <br>
                <strong>IFSC Code:</strong> ${txt(app.ifsc_code)} <br>
                <strong>Document Available:</strong> ${app.bank_document && String(app.bank_document).trim() !== "" ? "Yes" : "NA"}
              </p>
            </div>
        
            <div class="col-md-4">
              ${ app.bank_document  ? (() => {
                    const ext = app.bank_document.split('.').pop().toLowerCase();
                    const url = base + app.bank_document;
                    if (['jpg','jpeg','png','webp','gif'].includes(ext)) {
                      return `
                        <div>
                          <p class="mb-1"><strong>Bank Document</strong></p> <img src="${url}" style=" max-width:100%; border:1px solid #ccc; border-radius:8px; cursor:pointer; " />
                        </div>`;
                    } else {
                      return `<div><p class="mb-1"><strong>Bank Document</strong></p>
                      <a href="${url}" target="_blank" download="${app.bank_document}"
                         style=" display:inline-block; padding:8px 12px; border:2px solid #17a2b8; border-radius:6px; font-size:14px; color:#17a2b8; text-decoration:none; cursor:pointer; transition:background-color .3s,color .3s; "
                         onmouseover="this.style.backgroundColor='#17a2b8'; this.style.color='#fff';"
                         onmouseout="this.style.backgroundColor=''; this.style.color='#17a2b8';">
                        Download
                      </a>
                    </div>`;
                    }
                })()
                : '<p class="text-muted small">No bank document uploaded.</p>'
              }
            </div>
          </div>
        `;
        document.getElementById('modalAcademicQualifications').innerHTML = `
        <div class="row">
          <div class="col-md-8">
            <h6>Secondary School Certificate (SSC / 10th)</h6> <p>Year: ${txt(app.ssc_year)}<br> School: ${txt(app.ssc_school)}<br>
            Board: ${txt(app.ssc_board)}<br> Grade / Percentage: ${txt(app.ssc_grade)}<br> Certificate Available: ${ app.ssc_certificate && String(app.ssc_certificate).trim() !== "" ? "Yes" : "NA" }</p>
          </div>
          <div class="col-md-4">${app.ssc_certificate ? (() => { const url = base + app.ssc_certificate; const ext = app.ssc_certificate.split('.').pop().toLowerCase(); return ['jpg','jpeg','png','webp','gif'].includes(ext) ? `<div><p class="mb-1"><strong>SSC Document</strong></p><img src="${url}" style="max-width:100%;border:1px solid #ccc;border-radius:8px;cursor:pointer"/></div>` : `<div><p class="mb-1"><strong>SSC Document</strong></p><a href="${url}" download style="display:inline-block;padding:8px 12px;border:2px solid #007bff;border-radius:6px;font-size:14px;color:#007bff;text-decoration:none;cursor:pointer;">&#128229; Download Document</a></div>`; })() : '<p class="text-muted small">No SSC document uploaded.</p>'}</div>
      </div>

        <div class="row mt-4">
          <div class="col-md-8">
            <h6>Intermediate (Inter / 12th)</h6> <p>Year: ${txt(app.inter_year)}<br> School: ${txt(app.inter_school)}<br> 
            Board: ${txt(app.inter_board)}<br> Grade / Percentage: ${txt(app.inter_grade)}<br> Certificate Available: ${ app.inter_certificate && String(app.inter_certificate).trim() !== "" ? "Yes" : "NA" }</p>
          </div>
          <div class="col-md-4">
          ${ app.inter_certificate ? (() => { const ext = app.inter_certificate.split('.').pop().toLowerCase(); const url = base + app.inter_certificate;
                  if (['jpg', 'jpeg', 'png', 'webp', 'gif'].includes(ext)) { return ` <div> <p class="mb-1"><strong>Inter Document</strong></p> <img src="${url}" style="max-width:100%;border:1px solid #ccc;border-radius:8px;cursor:pointer" /></div>`;
                  } else {
                    return `<div> <p class="mb-1"><strong>Inter Document</strong></p> <a href="${url}" download style="
                            display: inline-block; padding: 8px 12px; border: 2px solid #007bff; border-radius: 6px; font-size: 14px; color: #007bff; text-decoration: none;
                            cursor: pointer; transition: background-color 0.3s, color 0.3s; " onmouseover="this.style.backgroundColor='#007bff'; this.style.color='#fff';" onmouseout="this.style.backgroundColor=''; this.style.color='#007bff';"> Download Document </a> </div>`; } })() : '<p class="text-muted small">No Inter document uploaded.</p>'}
         </div>
      </div>
       ${ hasAnyUGData(app) ? `
            <div class="row mt-4">
              <div class="col-md-8">
                <h6>Graduation</h6>
                <p>
                  Year: ${txt(app.grad_year)}<br>
                  College: ${txt(app.grad_college)}<br>
                  Title: ${txt(app.grad_degree_title)}<br>
                  Grade / Percentage: ${txt(app.grad_grade)}<br>
                  Certificate Available: ${ app.ug_certificate && String(app.ug_certificate).trim() !== "" ? "Yes" : "NA" }
                </p>
              </div>
              <div class="col-md-4">
                ${
                  app.ug_certificate ? (() => {
                    const ext = app.ug_certificate.split('.').pop().toLowerCase();
                    const url = base + app.ug_certificate;
                    if (['jpg', 'jpeg', 'png', 'webp', 'gif'].includes(ext)) {
                      return `<div><p class="mb-1"><strong>Graduation Document</strong></p><img src="${url}" style="max-width:100%;border:1px solid #ccc;border-radius:8px;cursor:pointer"/></div>`;
                    } else {
                      return `<div><p class="mb-1"><strong>Graduation Document</strong></p><a href="${url}" download style="
                        display: inline-block; padding: 8px 12px; border: 2px solid #007bff; border-radius: 6px; font-size: 14px; color: #007bff; text-decoration: none;
                        cursor: pointer; transition: background-color 0.3s, color 0.3s;" 
                        onmouseover="this.style.backgroundColor='#007bff'; this.style.color='#fff';" 
                        onmouseout="this.style.backgroundColor=''; this.style.color='#007bff';"> Download Document </a></div>`;
                    }
                  })() : '<p class="text-muted small">No Graduation document uploaded.</p>'
                }
              </div>
            </div>
          ` : '' }

          ${ hasAnyPGData(app) ? `
            <div class="row mt-4">
              <div class="col-md-8">
                <h6>Post Graduation</h6>
                <p>
                  Year: ${txt(app.pg_year)}<br>
                  College: ${txt(app.pg_college)}<br>
                  Title: ${txt(app.pg_degree_title)}<br>
                  Grade / Percentage: ${txt(app.pg_grade)}<br>
                  Certificate Available: ${ app.pg_certificate && String(app.pg_certificate).trim() !== "" ? "Yes" : "NA" }
                </p>
              </div>
              <div class="col-md-4">
                ${
                  app.pg_certificate ? (() => {
                    const ext = app.pg_certificate.split('.').pop().toLowerCase();
                    const url = base + app.pg_certificate;
                    if (['jpg', 'jpeg', 'png', 'webp', 'gif'].includes(ext)) {
                      return `<div><p class="mb-1"><strong>Post Graduation Document</strong></p><img src="${url}" style="max-width:100%;border:1px solid #ccc;border-radius:8px;cursor:pointer"/></div>`;
                    } else {
                      return `<div><p class="mb-1"><strong>Post Graduation Document</strong></p><a href="${url}" download style="
                        display: inline-block; padding: 8px 12px; border: 2px solid #007bff; border-radius: 6px; font-size: 14px; color: #007bff; text-decoration: none;
                        cursor: pointer; transition: background-color 0.3s, color 0.3s;" 
                        onmouseover="this.style.backgroundColor='#007bff'; this.style.color='#fff';" 
                        onmouseout="this.style.backgroundColor=''; this.style.color='#007bff';"> Download Document </a></div>`;
                    }
                  })() : '<p class="text-muted small">No Post Graduation document uploaded.</p>'
                }
              </div>
            </div>
            ` : '' }
          ${ hasAnyOtherData(app) ? `
            <div class="row mt-3">
              <div class="col-md-8">
                <h6>Other Qualification</h6>
                <p>${txt(app.other_qualification) || '<em>No other qualification description provided.</em>'}</p>
              </div>
              <div class="col-md-4">
                ${
                  (() => {
                    const ext = app.other_certificate.split('.').pop().toLowerCase();
                    const url = base + app.other_certificate;
                    if (['jpg', 'jpeg', 'png', 'webp', 'gif'].includes(ext)) {
                      return `<div><p class="mb-1"><strong>Other Certificate</strong></p><img src="${url}" style="max-width:100%;border:1px solid #ccc;border-radius:8px;cursor:pointer"/></div>`;
                    } else {
                      return `<div><p class="mb-1"><strong>Other Certificate</strong></p><a href="${url}" download style="
                        display: inline-block; padding: 8px 12px; border: 2px solid #28a745; border-radius: 6px; font-size: 14px; color: #28a745; text-decoration: none;
                        cursor: pointer; transition: background-color 0.3s, color 0.3s;" 
                        onmouseover="this.style.backgroundColor='#28a745'; this.style.color='#fff';" 
                        onmouseout="this.style.backgroundColor=''; this.style.color='#28a745';"> Download Document </a></div>`;
                    }
                  })()
                }
              </div>
            </div>
            ` : '' }
        `;
       document.getElementById('modalStatement').innerHTML = `<b>Previous Roles & Responsibilities</b>` +
      (app.experience_details ? `<p>${app.experience_details}</p>` : '<p>NA</p>') +
      (app.experience_letter ? `<p><button onclick="window.open('${base + app.experience_letter}', '_blank')" class="btn btn-sm btn-outline-primary">View Experience Letter</button></p>` : '') +
      (app.resume ? `<p><button onclick="window.open('${base + app.resume}', '_blank')" class="btn btn-sm btn-outline-success">View Resume</button></p>`: '');
            const docsContainer = document.getElementById('modalUploadedDocs');
        const docs = document.getElementById('modalUploadedDocs'); docs.innerHTML='';
        const docMap = { passport_copy:'Passport Copy', aadhar_front:'Aadhar Front', aadhar_back:'Aadhar Back', pan_card:'Pan Card' };
        let missingDoc = false;
        Object.entries(docMap).forEach(([k,l])=>{
          if(app[k]){
            const d=document.createElement('div');
            d.innerHTML=`<div><p class="mb-1"><strong>${l}</strong></p><img src="${base+app[k]}" style="max-width:160px;border:1px solid #e5e5e5;border-radius:8px"></div>`;
            docs.appendChild(d);
          } else { missingDoc = true; }
        });

        // Flagging Pending
        flag('flagContact',  anyMissing([app.email, app.mobile, app.dob, app.gender]));
        flag('flagIdentity', anyMissing([app.preferred_language, app.nationality, app.has_passport==1?'yes':'']));
        flag('flagAddress',  anyMissing([app.addr_line1, app.city, app.state, app.postal_code, app.country]));
        flag('flagPersonal', anyMissing([app.nationality, app.country_of_birth, app.preferred_language]));
        flag('flagAcademics',anyMissing([app.ssc_year, app.ssc_school, app.inter_year, app.inter_school]));
        flag('flagStatement',isNA(app.experience_details) && !app.experience_letter);
        flag('flagPayment',  isNA(app.payment_proof));
        flag('flagDocs',     missingDoc);

        document.getElementById('modalPassportPhoto').setAttribute('src',base+(app.passport_photo||'user-1.jpg'));
        document.getElementById('modalPassportPhoto').style.display = 'inline-block';
        document.getElementById('imageFallbackText').style.display = 'none';
        modal.show();
      });
    });

    /* init */
    render();
  })();
  </script>
</body>
</html>
