<?php
session_start();
require '../../config.php';

mysqli_set_charset($conn, 'utf8mb4');
@mysqli_query($conn, "SET collation_connection = 'utf8mb4_general_ci'");

if (!isset($_SESSION['admin']) || !isset($_SESSION['username'])) {
  header("Location: " . BASE_URL . "admin/login");
  exit;
}

$username = mysqli_real_escape_string($conn, $_SESSION['username']);
$admin_q  = mysqli_query($conn, "SELECT * FROM admins WHERE username='{$username}' LIMIT 1");
$admin    = $admin_q ? mysqli_fetch_assoc($admin_q) : null;

$STATUS      = 'rejected';
$PAGE_TITLE  = 'Rejected Applications';

$applications_q = mysqli_query($conn, "SELECT * FROM employee_applications WHERE application_status='{$STATUS}' ORDER BY created_at DESC");
$stat_total_q   = mysqli_query($conn, "SELECT COUNT(*) c FROM employee_applications WHERE application_status='{$STATUS}'");
$stat_total     = $stat_total_q ? (int)mysqli_fetch_assoc($stat_total_q)['c'] : 0;
?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title><?= htmlspecialchars($PAGE_TITLE) ?></title>
  <?php include __DIR__ . '/../partials/head.php'; ?>
  <style>
    .page-title{display:flex;align-items:center;gap:.75rem}
    .page-title .dot{width:10px;height:10px;border-radius:50%;background:var(--bs-danger)}
    .card-soft{border:0;box-shadow:0 4px 18px rgba(0,0,0,.08);border-radius:1rem}
    .toolbar{display:flex;flex-wrap:wrap;gap:.75rem;align-items:center}
    .search-wrap{position:relative;min-width:260px}
    .search-wrap input{padding-left:2.25rem}
    .search-wrap .bi{position:absolute;left:.65rem;top:50%;transform:translateY(-50%);opacity:.6}
    .table thead th{position:sticky;top:0;background:var(--bs-dark);color:#fff;z-index:1}
    .table-hover tbody tr:hover{background:rgba(13,110,253,.04)}
    .chip{display:inline-flex;align-items:center;gap:.5rem;border:1px solid var(--bs-border-color);padding:.35rem .65rem;border-radius:999px;background:#fff}
    .chip .bi{opacity:.7}
    .btn-icon{display:inline-flex;align-items:center;gap:.4rem}
    .status-pill{border-radius:999px;padding:.25rem .65rem;font-size:.75rem;border:1px solid transparent}
    .status-submitted{background:rgba(25,135,84,.12);color:#198754;border-color:rgba(25,135,84,.35)}
    .status-progress{background:rgba(255,193,7,.12);color:#b58100;border-color:rgba(255,193,7,.35)}
    .status-approved{background:rgba(13,110,253,.12);color:#0d6efd;border-color:rgba(13,110,253,.35)}
    .status-rejected{background:rgba(220,53,69,.12);color:#dc3545;border-color:rgba(220,53,69,.35)}
    .status-other{background:rgba(108,117,125,.12);color:#6c757d;border-color:rgba(108,117,125,.3)}
    .avatar-initial{width:34px;height:34px;border-radius:50%;display:inline-grid;place-items:center;background:var(--bs-primary);color:#fff;font-weight:600}
    @media (max-width: 575.98px){ .toolbar{flex-direction:column;align-items:stretch} .search-wrap{min-width:100%} }
    @media print {.no-print{display:none!important} .table thead th{background:#000!important;color:#fff!important}}
  </style>
</head>
<body class="d-flex flex-column min-vh-100">
  <div class="page-wrapper d-flex flex-column flex-grow-1" id="main-wrapper" data-layout="vertical" data-navbarbg="skin6" data-sidebartype="full" data-sidebar-position="fixed" data-header-position="fixed">
    <?php include __DIR__ . '/../partials/header.php'; ?>
    <?php include __DIR__ . '/../partials/sidebar.php'; ?>

    <div class="body-wrapper">
      <div class="body-wrapper-inner container-fluid py-4">
        <div class="d-flex flex-wrap align-items-center justify-content-between mb-4">
          <div class="page-title">
            <span class="dot"></span>
            <div>
              <h2 class="mb-0"><?= htmlspecialchars($PAGE_TITLE) ?></h2>
              <div class="text-muted small">Review, search and export rejected applications</div>
            </div>
          </div>
          <div class="d-flex flex-wrap gap-2">
            <span class="chip"><i class="bi bi-x-octagon"></i>Total Rejected: <strong><?= number_format($stat_total) ?></strong></span>
          </div>
        </div>

        <div class="card card-soft">
          <div class="card-body">
            <div class="toolbar mb-3">
              <div class="search-wrap">
                <i class="bi bi-search"></i>
                <input id="tableSearch" type="text" class="form-control" placeholder="Search name, email, country...">
              </div>
              <div class="d-flex align-items-center gap-2">
                <label for="rowsPerPage" class="text-muted small mb-0">Rows:</label>
                <select id="rowsPerPage" class="form-select form-select-sm" style="width:auto">
                  <option value="10">10</option><option value="25">25</option><option value="50">50</option><option value="500">500</option><option value="all">All</option>
                </select>
              </div>
              <div class="ms-auto d-flex flex-wrap gap-2 no-print">
                <div class="btn-group">
                  <button id="btnExportCSV" class="btn btn-outline-primary btn-icon"><i class="bi bi-filetype-csv"></i><span>CSV</span></button>
                  <button id="btnExportXLS" class="btn btn-outline-success btn-icon"><i class="bi bi-file-earmark-excel"></i><span>Excel</span></button>
                  <button id="btnExportPDF" class="btn btn-outline-danger btn-icon"><i class="bi bi-filetype-pdf"></i><span>PDF</span></button>
                </div>
                <button id="btnRefresh" class="btn btn-light btn-icon"><i class="bi bi-arrow-clockwise"></i><span>Refresh</span></button>
              </div>
            </div>

            <div class="table-responsive">
              <table id="appsTable" class="table table-hover align-middle mb-3">
                <thead class="table-dark">
                  <tr>
                    <th style="width:56px">#</th>
                    <th>Applicant</th>
                    <th>Email</th>
                    <th style="width:160px">Submitted</th>
                    <th style="width:140px">Status</th>
                    <th style="width:160px" class="no-print">Action</th>
                  </tr>
                </thead>
                <tbody>
                  <?php
                  $i=1;
                  if ($applications_q && mysqli_num_rows($applications_q)>0):
                    while($app = mysqli_fetch_assoc($applications_q)):
                      $full_name = trim(($app['title'] ? $app['title'].' ' : '').($app['first_name'] ?? '').' '.($app['surname'] ?? ''));
                      $initials  = strtoupper(mb_substr($app['first_name'] ?? 'U',0,1).mb_substr($app['surname'] ?? 'N',0,1));
                      $status    = strtolower(trim($app['application_status'] ?? ''));
                      $createdAt = !empty($app['created_at']) ? date('d M Y, h:i A', strtotime($app['created_at'])) : '-';
                      $statusHtml = '<span class="status-pill status-other">Unknown</span>';
                      if($status==='submitted')   $statusHtml = '<span class="status-pill status-submitted">Submitted</span>';
                      elseif($status==='in-progress') $statusHtml = '<span class="status-pill status-progress">In&nbsp;Progress</span>';
                      elseif($status==='approved') $statusHtml = '<span class="status-pill status-approved">Approved</span>';
                      elseif($status==='rejected') $statusHtml = '<span class="status-pill status-rejected">Rejected</span>';
                      $resume = null;
                      $app_email_safe = mysqli_real_escape_string($conn, $app['email']);
                      $resume_q = mysqli_query($conn, "SELECT resume FROM user_pif WHERE email='{$app_email_safe}' LIMIT 1");
                      if ($resume_q && mysqli_num_rows($resume_q) > 0) {
                          $resume_row = mysqli_fetch_assoc($resume_q);
                          $resume = $resume_row['resume'] ?? null;
                      }
                      $app['resume'] = $resume;
                      $app_json = htmlspecialchars(json_encode($app, JSON_HEX_TAG|JSON_HEX_APOS|JSON_HEX_QUOT|JSON_HEX_AMP), ENT_QUOTES, 'UTF-8');
                  ?>
                  <tr class="data-row" data-status="<?= htmlspecialchars($status) ?>">
                    <td class="text-muted"><?= $i++; ?></td>
                    <td>
                      <div class="d-flex align-items-center gap-3">
                        <span class="avatar-initial"><?= htmlspecialchars($initials) ?></span>
                        <div class="d-flex flex-column">
                          <span class="fw-semibold"><?= htmlspecialchars($full_name) ?></span>
                          <?php if(!empty($app['country'])): ?>
                            <span class="text-muted small"><i class="bi bi-geo-alt me-1"></i><?= htmlspecialchars($app['country']) ?></span>
                          <?php endif; ?>
                        </div>
                      </div>
                    </td>
                    <td><a href="mailto:<?= htmlspecialchars($app['email']) ?>" class="text-decoration-none"><?= htmlspecialchars($app['email']) ?></a></td>
                    <td class="text-muted small"><?= $createdAt ?></td>
                    <td><?= $statusHtml ?></td>
                    <td class="no-print">
                      <button class="btn btn-sm btn-primary btn-preview" data-app='<?= $app_json ?>'><i class="bi bi-eye"></i> Preview</button>
                    </td>
                  </tr>
                  <?php endwhile; else: ?>
                  <tr><td colspan="6" class="text-center text-muted py-5">No applications found.</td></tr>
                  <?php endif; ?>
                </tbody>
              </table>
            </div>

            <div class="d-flex flex-wrap align-items-center justify-content-between">
              <div class="small text-muted"><span id="rowsInfo">0</span> rows</div>
              <nav><ul class="pagination mb-0" id="pager"></ul></nav>
            </div>

          </div>
        </div>
      </div>
    </div>
    <?php include __DIR__ . '/../partials/footer.php'; ?>
  </div>

  <?php /* Modal same as above */ ?>
  <div class="modal fade" id="detailsModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-xl modal-dialog-scrollable">
      <div class="modal-content">
        <div class="modal-header"><h5 class="modal-title">Application Details</h5><button type="button" class="btn-close" data-bs-dismiss="modal"></button></div>
        <div class="modal-body p-4">
          <div class="row">
            <div class="col-md-4 border-end">
              <div class="text-center mb-3">
                <div id="imageContainer">
                  <img id="modalPassportPhoto" alt="Passport" class="img-thumbnail mb-3" style="max-width:180px; border-radius:15px;" src="" onerror="this.style.display='none'; document.getElementById('imageFallbackText').style.display='block';">
                  <div id="imageFallbackText" style="display:none;">
                    <img src="<?= BASE_URL ?>assets/images/profile/no-pic.png" alt="No Image" style="max-width:180px; border-radius:15px;">
                  </div>
                </div>
                <h4 id="modalFullName" class="mb-1"></h4>
                <div class="text-muted mb-3">IC Rejected Applicantion</div>
              </div>
              <h5>Contact</h5>
              <p><strong>Email:</strong> <span id="modalEmail"></span></p>
              <p><strong>Mobile:</strong> <span id="modalMobile"></span></p>
              <p><strong>DOB:</strong> <span id="modalDOB"></span></p>
              <p><strong>Gender:</strong> <span id="modalGender"></span></p>
              <p><strong>Marital Status:</strong> <span id="modalNeetStatus"></span></p>
              <h5 class="mt-4">Identity</h5>
              <p><strong>Language:</strong> <span id="modalPreferredLanguage"></span></p>
              <p><strong>Nationality:</strong> <span id="modalNationality"></span></p>
              <h5 class="mt-4">Address</h5>
              <p id="modalAddress"></p>
            </div>
            <div class="col-md-8 ps-4">
              <h5>Personal Details</h5>
                <div class="row mb-2">
                    <div class="col-4"><p><strong>Nationality:</strong> <span id="modalNationalityRight"></span></p></div>
                    <div class="col-4"><p><strong>Country of Birth:</strong> <span id="modalCountryOfBirth"></span></p></div>
                    <div class="col-4"><p><strong>Language Proficiency:</strong> <span id="modalLanguageProficiency"></span></p></div>
                </div>
            <h5>Additional Details</h5>
            <div class="row mb-2">
                <div class="col-3"><p><strong>PAN Number:</strong> <span id="modalPanNumber"></span></p></div>
                <div class="col-3"><p><strong>Aadhar Number:</strong> <span id="modalAadharNumber"></span></p></div>
                <div class="col-3"> <p><strong>Father Name:</strong> <span id="modalFatherName"></span></p></div>
                <div class="col-3"> <p><strong>Mother Name:</strong> <span id="modalMotherName"></span></p></div>
            </div>
            <div class="row mb-2">
                <div class="col-3"><p><strong>Emergency Name:</strong> <span id="modalEmergencyName"></span></p> </div>
                <div class="col-3"><p><strong>Emergency Mobile:</strong> <span id="modalEmergencyMobile"></span></p></div>
                <div class="col-3"> <p><strong>Reference 1:</strong> <span id="modalReference1"></span></p> </div>
                <div class="col-3"> <p><strong>Reference 1 Contact:</strong> <span id="modalReference1Contact"></span></p></div>
            </div>
            <div class="row mb-2"> 
                <div class="col-3"><p><strong>Reference 2:</strong> <span id="modalReference2"></span></p></div>
                <div class="col-3"><p><strong>Reference 2 Contact:</strong> <span id="modalReference2Contact"></span></p></div>
            </div>
              <h5 class="mt-4">Bank Details</h5>
              <div id="modalBankDetails"></div>
              <h5 class="mt-4">Academic Qualifications</h5>
              <div id="modalAcademicQualifications"></div>
              <h5 class="mt-4">Experience Letter</h5>
              <div id="modalStatement"></div>
              <h5 class="mt-4">Uploaded Documents</h5>
              <div id="modalUploadedDocs" class="d-flex flex-wrap gap-3"></div>
            </div>
          </div>
        </div>
        <div class="modal-footer"><button class="btn btn-secondary" data-bs-dismiss="modal">Close</button></div>
</div>
    </div>
  </div>

  <script>
    (function(){
      const table=document.getElementById('appsTable'),tbody=table.querySelector('tbody'),search=document.getElementById('tableSearch'),rowsPerPageSel=document.getElementById('rowsPerPage'),pager=document.getElementById('pager'),rowsInfo=document.getElementById('rowsInfo'),refreshBtn=document.getElementById('btnRefresh'),btnCSV=document.getElementById('btnExportCSV'),btnXLS=document.getElementById('btnExportXLS'),btnPDF=document.getElementById('btnExportPDF');
      let allRows=Array.from(tbody.querySelectorAll('tr.data-row'));let filtered=allRows.slice();let page=1;let rpp=rowsPerPageSel.value;
      function normalize(s){return (s||'').toString().toLowerCase().trim();}
      function applyFilter(){const q=normalize(search.value);filtered=allRows.filter(tr=>q?normalize(tr.innerText).includes(q):true);page=1;render();}
      function render(){rpp=rowsPerPageSel.value;const perPage=(rpp==='all')?filtered.length||1:parseInt(rpp,10);allRows.forEach(tr=>tr.style.display='none');const total=filtered.length;const totalPages=Math.max(1,Math.ceil(total/perPage));if(page>totalPages)page=totalPages;const start=(page-1)*perPage;const end=(rpp==='all')?total:Math.min(start+perPage,total);for(let i=start;i<end;i++){filtered[i].style.display='';}rowsInfo.textContent=total;pager.innerHTML='';function addItem(txt,p,disabled=false,active=false){const li=document.createElement('li');li.className='page-item'+(disabled?' disabled':'')+(active?' active':'');const a=document.createElement('a');a.className='page-link';a.href='#';a.textContent=txt;a.onclick=(e)=>{e.preventDefault();if(!disabled){page=p;render();}};li.appendChild(a);pager.appendChild(li);}addItem('«',1,page===1);addItem('‹',Math.max(1,page-1),page===1);const windowSize=5;let startP=Math.max(1,page-Math.floor(windowSize/2));let endP=Math.min(totalPages,startP+windowSize-1);startP=Math.max(1,Math.min(startP,endP-windowSize+1));for(let p=startP;p<=endP;p++){addItem(p,p,false,p===page);}addItem('›',Math.min(totalPages,page+1),page===totalPages);addItem('»',totalPages,page===totalPages);}
      search.addEventListener('input',applyFilter);rowsPerPageSel.addEventListener('change',function(){page=1;render();});refreshBtn.addEventListener('click',function(){location.reload();});
      btnCSV.addEventListener('click',function(){const headers=['#','Applicant','Email','Submitted','Status'];const lines=[headers.join(',')];filtered.forEach(tr=>{const tds=Array.from(tr.querySelectorAll('td'));const vals=[tds[0].innerText,tds[1].innerText.replace(/\r?\n|\r/g,' ').trim(),tds[2].innerText.trim(),tds[3].innerText.trim(),tds[4].innerText.trim()].map(v=>`"${v.replace(/"/g,'""')}"`);lines.push(vals.join(','));});const blob=new Blob([lines.join('\n')],{type:'text/csv;charset=utf-8;'});const url=URL.createObjectURL(blob);const a=document.createElement('a');a.href=url;a.download='approved_applications.csv';document.body.appendChild(a);a.click();document.body.removeChild(a);URL.revokeObjectURL(url);});
      btnXLS.addEventListener('click',function(){let html='<table><thead><tr><th>#</th><th>Applicant</th><th>Email</th><th>Submitted</th><th>Status</th></tr></thead><tbody>';filtered.forEach(tr=>{const tds=Array.from(tr.querySelectorAll('td'));html+=`<tr><td>${tds[0].innerText}</td><td>${tds[1].innerText.replace(/\r?\n|\r/g,' ').trim()}</td><td>${tds[2].innerText.trim()}</td><td>${tds[3].innerText.trim()}</td><td>${tds[4].innerText.trim()}</td></tr>`;});html+='</tbody></table>';const blob=new Blob([html],{type:'application/vnd.ms-excel'});const url=URL.createObjectURL(blob);const a=document.createElement('a');a.href=url;a.download='approved_applications.xls';document.body.appendChild(a);a.click();document.body.removeChild(a);URL.revokeObjectURL(url);});
      btnPDF.addEventListener('click',function(){let head=`<html><head><title>Approved Applications</title><style>body{font-family:system-ui,-apple-system,Segoe UI,Roboto,Helvetica,Arial,sans-serif;padding:16px}h2{margin:0 0 12px}table{width:100%;border-collapse:collapse}th,td{border:1px solid #444;padding:8px;font-size:12px;text-align:left}thead th{background:#000;color:#fff}</style></head><body><h2>Approved Applications (Export)</h2><table><thead><tr><th>#</th><th>Applicant</th><th>Email</th><th>Submitted</th><th>Status</th></tr></thead><tbody>`;let body='';filtered.forEach(tr=>{const tds=Array.from(tr.querySelectorAll('td'));body+=`<tr><td>${tds[0].innerText}</td><td>${tds[1].innerText.replace(/\r?\n|\r/g,' ').trim()}</td><td>${tds[2].innerText.trim()}</td><td>${tds[3].innerText.trim()}</td><td>${tds[4].innerText.trim()}</td></tr>`;});let tail='</tbody></table></body></html>';const win=window.open('','_blank');win.document.write(head+body+tail);win.document.close();win.focus();win.print();});
      document.querySelectorAll('.btn-preview').forEach(btn=>{btn.addEventListener('click',function(){const app=JSON.parse(this.getAttribute('data-app'));const id=app.id;const base="<?= BASE_URL ?>employee/employee-app/uploads/"+id+"/";const text=v=>(v&&String(v).trim().length>0)?v:'N/A';document.getElementById('modalFullName').textContent=[app.title,app.first_name,app.surname].filter(Boolean).join(' ');document.getElementById('modalEmail').textContent=text(app.email);document.getElementById('modalMobile').textContent=text(app.mobile);document.getElementById('modalDOB').textContent=text(app.dob);document.getElementById('modalGender').textContent=text(app.gender);document.getElementById('modalNeetStatus').textContent=(app.marital_status==='Qualified'&&app.neet_score)?`${app.marital_status} (Score: ${app.neet_score})`:text(app.marital_status);document.getElementById('modalPreferredLanguage').textContent=text(app.preferred_language);document.getElementById('modalNationality').textContent=text(app.nationality);document.getElementById('modalAddress').innerHTML=[app.addr_line1,app.addr_line2,app.city,app.state,app.postal_code,app.country].filter(Boolean).join('<br>')||'N/A';document.getElementById('modalNationalityRight').textContent=text(app.nationality);document.getElementById('modalCountryOfBirth').textContent=text(app.country_of_birth);document.getElementById('modalLanguageProficiency').textContent=text(app.preferred_language);
      document.getElementById('modalPanNumber').textContent = text(app.pan_number);document.getElementById('modalAadharNumber').textContent = text(app.aadhar_number);document.getElementById('modalFatherName').textContent = text(app.father_name);document.getElementById('modalMotherName').textContent = text(app.mother_name);
      document.getElementById('modalEmergencyName').textContent = text(app.emergency_name);document.getElementById('modalEmergencyMobile').textContent = text(app.emergency_mobile);
      document.getElementById('modalReference1').textContent = text(app.reference_1);document.getElementById('modalReference1Contact').textContent = text(app.reference_1_contact);
      document.getElementById('modalReference2').textContent = text(app.reference_2);document.getElementById('modalReference2Contact').textContent = text(app.reference_2_contact);
      document.getElementById('modalBankDetails').innerHTML = `
          <div class="row">
            <div class="col-md-8">
              <p><strong>Bank Name:</strong> ${text(app.bank_name)}</p>
              <p><strong>Account Number:</strong> ${text(app.account_number)}</p>
              <p><strong>IFSC Code:</strong> ${text(app.ifsc_code)}</p>
            </div>
            <div class="col-md-4">
              ${app.bank_document ? (() => {
                  const url = base + app.bank_document;
                  const ext = app.bank_document.split('.').pop().toLowerCase();
                  if (['jpg','jpeg','png','webp','gif'].includes(ext)) {
                    return `<div>
                              <p class="mb-1"><strong>Bank Document</strong></p>
                              <img src="${url}" style="max-width:100%;border:1px solid #ccc;border-radius:8px;cursor:pointer"/>
                            </div>`;
                  } else {
                    return `<div>
                              <p class="mb-1"><strong>Bank Document</strong></p>
                              <a href="${url}" download
                                 style="display:inline-block;padding:8px 12px;border:2px solid #007bff;border-radius:6px;font-size:14px;color:#007bff;text-decoration:none;cursor:pointer;">
                                &#128229; Download Document
                              </a>
                            </div>`;
                  }
              })() : '<p class="text-muted small">No Bank document uploaded.</p>'}
            </div>
          </div>`;
      document.getElementById('modalAcademicQualifications').innerHTML = `
      <div class="row">
        <div class="col-md-8">
          <h6>Secondary School Certificate (SSC / 10th)</h6>
          <p>
            Year: ${text(app.ssc_year)}<br>
            School: ${text(app.ssc_school)}<br>
            Board: ${text(app.ssc_board)}<br>
            Grade / Percentage: ${text(app.ssc_grade)}<br>
            Certificate Available: ${ app.ssc_certificate && String(app.ssc_certificate).trim() !== "" ? "Yes" : "NA" }
          </p>
        </div>
        <div class="col-md-4">${app.ssc_certificate ? (() => { const url = base + app.ssc_certificate; const ext = app.ssc_certificate.split('.').pop().toLowerCase(); return ['jpg','jpeg','png','webp','gif'].includes(ext) ? `<div><p class="mb-1"><strong>SSC Document</strong></p><img src="${url}" style="max-width:100%;border:1px solid #ccc;border-radius:8px;cursor:pointer"/></div>` : `<div><p class="mb-1"><strong>SSC Document</strong></p><a href="${url}" download style="display:inline-block;padding:8px 12px;border:2px solid #007bff;border-radius:6px;font-size:14px;color:#007bff;text-decoration:none;cursor:pointer;">&#128229; Download Document</a></div>`; })() : '<p class="text-muted small">No SSC document uploaded.</p>'}</div>
      </div>

      <div class="row mt-4">
        <div class="col-md-8">
          <h6>Intermediate (Inter / 12th)</h6>
          <p>
            Year: ${text(app.inter_year)}<br>
            School: ${text(app.inter_school)}<br>
            Board: ${text(app.inter_board)}<br>
            Grade / Percentage: ${text(app.inter_grade)}<br>
            Certificate Available: ${ app.inter_certificate && String(app.inter_certificate).trim() !== "" ? "Yes" : "NA" }
          </p>
        </div>
        <div class="col-md-4">
          ${ app.inter_certificate ? (() => { const ext = app.inter_certificate.split('.').pop().toLowerCase(); const url = base + app.inter_certificate;
                  if (['jpg', 'jpeg', 'png', 'webp', 'gif'].includes(ext)) { return ` <div> <p class="mb-1"><strong>Inter Document</strong></p> <img src="${url}" style="max-width:100%;border:1px solid #ccc;border-radius:8px;cursor:pointer" /></div>`;
                  } else {
                    return `<div> <p class="mb-1"><strong>Inter Document</strong></p> <a href="${url}" download style="
                            display: inline-block; padding: 8px 12px; border: 2px solid #007bff; border-radius: 6px; font-size: 14px; color: #007bff; text-decoration: none;
                            cursor: pointer; transition: background-color 0.3s, color 0.3s; " onmouseover="this.style.backgroundColor='#007bff'; this.style.color='#fff';" onmouseout="this.style.backgroundColor=''; this.style.color='#007bff';"> Download Document </a> </div>`; } })() : '<p class="text-muted small">No Inter document uploaded.</p>'}
         </div> 
      </div>
      
      <div class="row mt-4">
        <div class="col-md-8">
          <h6>Graduation</h6>
          <p>
              Year: ${text(app.grad_year)}<br>
              College: ${text(app.grad_college)}<br>
              Title: ${text(app.grad_degree_title)}<br>
              Grade / Percentage: ${text(app.grad_grade)}<br>
              Certificate Available: ${ app.pg_certificate && String(app.pg_certificate).trim() !== "" ? "Yes" : "NA" }
            </p>
        </div>
        <div class="col-md-4">
          ${ app.ug_certificate ? (() => { const ext = app.ug_certificate.split('.').pop().toLowerCase(); const url = base + app.ug_certificate;
                  if (['jpg', 'jpeg', 'png', 'webp', 'gif'].includes(ext)) { return ` <div> <p class="mb-1"><strong>Inter Document</strong></p> <img src="${url}" style="max-width:100%;border:1px solid #ccc;border-radius:8px;cursor:pointer" /></div>`;
                  } else {
                    return `<div> <p class="mb-1"><strong>Graduation Document</strong></p> <a href="${url}" download style="
                            display: inline-block; padding: 8px 12px; border: 2px solid #007bff; border-radius: 6px; font-size: 14px; color: #007bff; text-decoration: none;
                            cursor: pointer; transition: background-color 0.3s, color 0.3s; " onmouseover="this.style.backgroundColor='#007bff'; this.style.color='#fff';" onmouseout="this.style.backgroundColor=''; this.style.color='#007bff';"> Download Document </a> </div>`; } })() : '<p class="text-muted small">No Graduation document uploaded.</p>'}
         </div> 
      </div>
      
      <div class="row mt-4">
        <div class="col-md-8">
          <h6>Post Graduation</h6>
          <p>
              Year: ${text(app.pg_year)}<br>
              College: ${text(app.pg_college)}<br>
              Title: ${text(app.pg_degree_title)}<br>
              Grade / Percentage: ${text(app.pg_grade)}<br>
              Certificate Available: ${ app.pg_certificate && String(app.pg_certificate).trim() !== "" ? "Yes" : "NA" }
            </p>
        </div>
        <div class="col-md-4">
          ${ app.pg_certificate ? (() => { const ext = app.pg_certificate.split('.').pop().toLowerCase(); const url = base + app.pg_certificate;
                  if (['jpg', 'jpeg', 'png', 'webp', 'gif'].includes(ext)) { return ` <div> <p class="mb-1"><strong>Inter Document</strong></p> <img src="${url}" style="max-width:100%;border:1px solid #ccc;border-radius:8px;cursor:pointer" /></div>`;
                  } else {
                    return `<div> <p class="mb-1"><strong>Post Graduation Document</strong></p> <a href="${url}" download style="
                            display: inline-block; padding: 8px 12px; border: 2px solid #007bff; border-radius: 6px; font-size: 14px; color: #007bff; text-decoration: none;
                            cursor: pointer; transition: background-color 0.3s, color 0.3s; " onmouseover="this.style.backgroundColor='#007bff'; this.style.color='#fff';" onmouseout="this.style.backgroundColor=''; this.style.color='#007bff';"> Download Document </a> </div>`; } })() : '<p class="text-muted small">No Post Graduation document uploaded.</p>'}
         </div> 
      </div>`;
      document.getElementById('modalStatement').innerHTML= `<b>Previous Roles & Responsibilities</b>` + (app.experience_details?`<p>${app.experience_details}</p>`:'<p>No statement provided.</p>')+(app.experience_letter?`<p><button onclick="window.open('${base + app.experience_letter}', '_blank')" class="btn btn-sm btn-outline-primary">View Experience Letter</button></p>`:'') +
      (app.resume ? `<p><button onclick="window.open('${base + app.resume}', '_blank')" class="btn btn-sm btn-outline-success">View Resume</button></p>`: ''); const docsContainer=document.getElementById('modalUploadedDocs');docsContainer.innerHTML='';const docMap={passport_copy:'Passport Copy',aadhar_front:'Aadhar Front',aadhar_back:'Aadhar Back', pan_card:'Pan Card'};Object.entries(docMap).forEach(([key,label])=>{if(app[key]){const wrap=document.createElement('div');wrap.innerHTML=`<div><p class="mb-1"><strong>${label}</strong></p><img src="${base+app[key]}" alt="${label}" style="max-width:160px;border:1px solid #e5e5e5;border-radius:8px"></div>`;docsContainer.appendChild(wrap);}});
      document.getElementById('modalPassportPhoto').setAttribute('src',base+(app.passport_photo||'user-1.jpg'));
      document.getElementById('modalPassportPhoto').style.display = 'inline-block';
      document.getElementById('imageFallbackText').style.display = 'none';
      new bootstrap.Modal(document.getElementById('detailsModal')).show();});});
      applyFilter();
    })();
  </script>
</body>
</html>
