<?php
session_start();
require '../../config.php';

if (!isset($_SESSION['admin']) || !isset($_SESSION['username'])) {
  header("Location: " . BASE_URL . "admin/login");
  exit;
}

$username = mysqli_real_escape_string($conn, $_SESSION['username']);
$admin_q  = mysqli_query($conn, "SELECT * FROM admins WHERE username='{$username}' LIMIT 1");
$admin    = $admin_q ? mysqli_fetch_assoc($admin_q) : null;

$applications_q = mysqli_query($conn, "SELECT * FROM employee_applications WHERE application_status='submitted' ORDER BY created_at DESC");

/* Quick stats (for header chips) */
$stat_total_submitted = 0;
$stat_today_submitted = 0;
$stat_inprogress      = 0;
$stat_approved        = 0;
$stat_total_submitted_q = mysqli_query($conn, "SELECT COUNT(*) c FROM employee_applications WHERE application_status='submitted'");
if ($stat_total_submitted_q) { $stat_total_submitted = (int)mysqli_fetch_assoc($stat_total_submitted_q)['c']; }
$stat_today_submitted_q = mysqli_query($conn, "SELECT COUNT(*) c FROM employee_applications WHERE application_status='submitted' AND DATE(created_at)=CURDATE()");
if ($stat_today_submitted_q) { $stat_today_submitted = (int)mysqli_fetch_assoc($stat_today_submitted_q)['c']; }
$stat_inprogress_q = mysqli_query($conn, "SELECT COUNT(*) c FROM employee_applications WHERE application_status='in-progress'");
if ($stat_inprogress_q) { $stat_inprogress = (int)mysqli_fetch_assoc($stat_inprogress_q)['c']; }
$stat_approved_q = mysqli_query($conn, "SELECT COUNT(*) c FROM employee_applications WHERE application_status='approved'");
if ($stat_approved_q) { $stat_approved = (int)mysqli_fetch_assoc($stat_approved_q)['c']; }
?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>Submitted Applications</title>
  <?php include __DIR__ . '/../partials/head.php'; ?>
  <style>
    .page-title{display:flex;align-items:center;gap:.75rem}
    .page-title .dot{width:10px;height:10px;border-radius:50%;background:var(--bs-success)}
    .card-soft{border:0;box-shadow:0 4px 18px rgba(0,0,0,.08);border-radius:1rem}
    .toolbar{display:flex;flex-wrap:wrap;gap:.75rem;align-items:center}
    .search-wrap{position:relative;min-width:240px}
    .search-wrap input{padding-left:2.25rem}
    .search-wrap .bi{position:absolute;left:.65rem;top:50%;transform:translateY(-50%);opacity:.6}
    .table thead th{position:sticky;top:0;background:var(--bs-dark);color:#fff;z-index:1}
    .status-pill{border-radius:999px;padding:.25rem .65rem;font-size:.75rem}
    .status-submitted{background:rgba(25,135,84,.12);color:#198754;border:1px solid rgba(25,135,84,.3)}
    .status-progress{background:rgba(255,193,7,.12);color:#b58100;border:1px solid rgba(255,193,7,.35)}
    .status-other{background:rgba(108,117,125,.12);color:#6c757d;border:1px solid rgba(108,117,125,.3)}
    .avatar-initial{width:34px;height:34px;border-radius:50%;display:inline-grid;place-items:center;background:var(--bs-primary);color:#fff;font-weight:600}
    .table-hover tbody tr:hover{background:rgba(13,110,253,.04)}
    .chip{display:inline-flex;align-items:center;gap:.5rem;border:1px solid var(--bs-border-color);padding:.35rem .65rem;border-radius:999px;background:#fff}
    .chip .bi{opacity:.7}
    .btn-icon{display:inline-flex;align-items:center;gap:.35rem}
    .pagination{margin-bottom:0}
    @media (max-width: 575.98px){
      .toolbar{flex-direction:column;align-items:stretch}
      .search-wrap{min-width:100%}
    }
  </style>
</head>
<body class="d-flex flex-column min-vh-100">
  <div class="page-wrapper d-flex flex-column flex-grow-1" id="main-wrapper" data-layout="vertical" data-navbarbg="skin6" data-sidebartype="full" data-sidebar-position="fixed" data-header-position="fixed">
    <?php
      include __DIR__ . '/../partials/header.php';
      include __DIR__ . '/../partials/sidebar.php';
    ?>
    <div class="body-wrapper">
      <div class="body-wrapper-inner container-fluid py-4">
        <div class="d-flex flex-wrap align-items-center justify-content-between mb-4">
          <div class="page-title">
            <span class="dot"></span>
            <div>
              <h2 class="mb-0">Submitted Applications</h2>
              <div class="text-muted small">Review, search and approve newly submitted applications</div>
            </div>
          </div>
          <div class="d-flex flex-wrap gap-2">
            <span class="chip"><i class="bi bi-inbox"></i>Submitted: <strong><?=
              number_format($stat_total_submitted) ?></strong></span>
            <span class="chip"><i class="bi bi-calendar-check"></i>Today: <strong><?=
              number_format($stat_today_submitted) ?></strong></span>
            <span class="chip"><i class="bi bi-hourglass-split"></i>In-Progress: <strong><?=
              number_format($stat_inprogress) ?></strong></span>
            <span class="chip"><i class="bi bi-patch-check"></i>Approved: <strong><?=
              number_format($stat_approved) ?></strong></span>
          </div>
        </div>

        <div class="card card-soft">
          <div class="card-body">
            <div class="toolbar mb-3">
              <div class="search-wrap">
                <i class="bi bi-search"></i>
                <input id="tableSearch" type="text" class="form-control" placeholder="Search name, email, status...">
              </div>
              <div class="d-flex align-items-center gap-2">
                <label for="rowsPerPage" class="text-muted small mb-0">Rows:</label>
                <select id="rowsPerPage" class="form-select form-select-sm" style="width:auto">
                  <option value="10">10</option>
                  <option value="25">25</option>
                  <option value="50">50</option>
                  <option value="500">500</option>
                  <option value="all">All</option>
                </select>
              </div>
              <div class="ms-auto d-flex gap-2">
                <button id="btnRefresh" class="btn btn-light btn-icon"><i class="bi bi-arrow-clockwise"></i><span>Refresh</span></button>
                <!--<a href="<?= BASE_URL ?>admin/applications-update-bulk" class="btn btn-primary btn-icon"><i class="bi bi-check2-square"></i><span>Bulk Actions</span></a>-->
              </div>
            </div>

            <div class="table-responsive">
              <table id="appsTable" class="table table-hover align-middle mb-3">
                <thead class="table-dark">
                  <tr>
                    <th style="width:56px">#</th>
                    <th>Applicant</th>
                    <th>Email</th>
                    <th style="width:140px">Submitted</th>
                    <th style="width:140px">Status</th>
                    <th style="width:160px">Action</th>
                  </tr>
                </thead>
                <tbody>
                  <?php
                  $i=1;
                  if ($applications_q && mysqli_num_rows($applications_q)>0):
                    while($app = mysqli_fetch_assoc($applications_q)):
                      $full_name = trim(($app['title'] ? $app['title'].' ' : '').$app['first_name'].' '.$app['surname']);
                      $initials  = strtoupper(mb_substr($app['first_name'] ?? 'U',0,1).mb_substr($app['surname'] ?? 'N',0,1));
                      $status    = $app['application_status'];
                      $createdAt = !empty($app['created_at']) ? date('d M Y, h:i A', strtotime($app['created_at'])) : '-';
                      $statusHtml = '<span class="status-pill status-other">Unknown</span>';
                      if ($status==='submitted')   $statusHtml = '<span class="status-pill status-submitted">Submitted</span>';
                      elseif ($status==='in-progress') $statusHtml = '<span class="status-pill status-progress">In&nbsp;Progress</span>';
                      elseif ($status) $statusHtml = '<span class="status-pill status-other">'.htmlspecialchars($status).'</span>';
                  ?>
                  <tr class="data-row">
                    <td class="text-muted"><?= $i++; ?></td>
                    <td>
                      <div class="d-flex align-items-center gap-3">
                        <span class="avatar-initial"><?= htmlspecialchars($initials) ?></span>
                        <div class="d-flex flex-column">
                          <span class="fw-semibold"><?= htmlspecialchars($full_name) ?></span>
                          <?php if(!empty($app['country'])): ?>
                          <span class="text-muted small"><i class="bi bi-geo-alt me-1"></i><?= htmlspecialchars($app['country']) ?></span>
                          <?php endif; ?>
                        </div>
                      </div>
                    </td>
                    <td><a href="mailto:<?= htmlspecialchars($app['email']) ?>" class="text-decoration-none"><?= htmlspecialchars($app['email']) ?></a></td>
                    <td class="text-muted small"><?= $createdAt ?></td>
                    <td><?= $statusHtml ?></td>
                    <td>
                      <?php if ($status==='submitted'): ?>
                        <div class="btn-group">
                          <a href="../applications-update?id=<?= (int)$app['id'] ?>" class="btn btn-sm btn-primary"><i class="bi bi-eye"></i> View &amp; Approve</a>
                          <button type="button" class="btn btn-sm btn-primary dropdown-toggle dropdown-toggle-split" data-bs-toggle="dropdown" aria-expanded="false"><span class="visually-hidden">Toggle</span></button>
                          <ul class="dropdown-menu dropdown-menu-end">
                            <li><a class="dropdown-item" href="../applications-update?id=<?= (int)$app['id'] ?>&action=approve"><i class="bi bi-patch-check me-2"></i>Approve</a></li>
                            <li><a class="dropdown-item" href="../applications-update?id=<?= (int)$app['id'] ?>&action=reject"><i class="bi bi-x-circle me-2"></i>Reject</a></li>
                          </ul>
                        </div>
                      <?php else: ?>
                        <span class="text-muted">—</span>
                      <?php endif; ?>
                    </td>
                  </tr>
                  <?php
                    endwhile;
                  else:
                  ?>
                  <tr><td colspan="6" class="text-center text-muted py-5">No applications found.</td></tr>
                  <?php endif; ?>
                </tbody>
              </table>
            </div>

            <div class="d-flex flex-wrap align-items-center justify-content-between">
              <div class="small text-muted"><span id="rowsInfo">0</span> rows</div>
              <nav>
                <ul class="pagination mb-0" id="pager"></ul>
              </nav>
            </div>

          </div>
        </div>

      </div>
    </div>
    <?php include __DIR__ . '/../partials/footer.php'; ?>
  </div>

  <script>
    (function(){
      const table = document.getElementById('appsTable');
      const tbody = table.querySelector('tbody');
      const search = document.getElementById('tableSearch');
      const rowsPerPageSel = document.getElementById('rowsPerPage');
      const pager = document.getElementById('pager');
      const rowsInfo = document.getElementById('rowsInfo');
      const refreshBtn = document.getElementById('btnRefresh');

      let allRows = Array.from(tbody.querySelectorAll('tr.data-row'));
      let filtered = allRows.slice();
      let page = 1;
      let rpp = rowsPerPageSel.value;

      function normalize(s){ return (s||'').toString().toLowerCase().trim(); }

      function applyFilter(){
        const q = normalize(search.value);
        filtered = allRows.filter(tr=>{
          if(!q) return true;
          return normalize(tr.innerText).includes(q);
        });
        page = 1;
        render();
      }

      function render(){
        // rows per page
        rpp = rowsPerPageSel.value;
        const perPage = (rpp==='all') ? filtered.length || 1 : parseInt(rpp,10);

        // clear tbody
        allRows.forEach(tr=>tr.style.display='none');

        // pagination math
        const total = filtered.length;
        const totalPages = Math.max(1, Math.ceil(total / perPage));
        if(page>totalPages) page = totalPages;
        const start = (page-1)*perPage;
        const end   = (rpp==='all') ? total : Math.min(start+perPage, total);

        // show slice
        for(let i=start;i<end;i++){ filtered[i].style.display=''; }

        // rows info
        rowsInfo.textContent = total;

        // build pager
        pager.innerHTML = '';
        function addItem(txt, p, disabled=false, active=false){
          const li = document.createElement('li');
          li.className = 'page-item' + (disabled?' disabled':'') + (active?' active':'');
          const a = document.createElement('a');
          a.className = 'page-link';
          a.href = '#';
          a.textContent = txt;
          a.onclick = (e)=>{ e.preventDefault(); if(!disabled){ page = p; render(); } };
          li.appendChild(a);
          pager.appendChild(li);
        }
        addItem('«', 1, page===1);
        addItem('‹', Math.max(1,page-1), page===1);
        // windowed pages
        const windowSize = 5;
        let startP = Math.max(1, page - Math.floor(windowSize/2));
        let endP   = Math.min(totalPages, startP + windowSize - 1);
        startP = Math.max(1, Math.min(startP, endP - windowSize + 1));
        for(let p=startP;p<=endP;p++){ addItem(p, p, false, p===page); }
        addItem('›', Math.min(totalPages,page+1), page===totalPages);
        addItem('»', totalPages, page===totalPages);
      }

      search.addEventListener('input', applyFilter);
      rowsPerPageSel.addEventListener('change', function(){ page=1; render(); });
      refreshBtn.addEventListener('click', function(){ location.reload(); });

      // initial
      render();
    })();
  </script>
</body>
</html>
