<?php
session_start();
require '../../config.php';

// Redirect if not logged in as admin
if (!isset($_SESSION['admin']) || !isset($_SESSION['username'])) {
  header("Location: " . BASE_URL . "admin/login");
  exit;
}

// Validate application ID
if (!isset($_GET['id']) || !is_numeric($_GET['id'])) {
  echo "Invalid application ID.";
  exit;
}

$app_id = (int)$_GET['id'];

// Fetch application data
$query = mysqli_query($conn, "SELECT * FROM employee_applications WHERE id = $app_id LIMIT 1");
if (!$query || mysqli_num_rows($query) === 0) {
  echo "Application not found.";
  exit;
}
$app = mysqli_fetch_assoc($query);
?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>Submitted Applications</title>
  <?php include __DIR__ . '/../partials/head.php'; ?>
  <style>
    /* Hide/show fields */
    .d-none { display: none; }
  </style>
</head>
<body class="d-flex flex-column min-vh-100">
  <div class="page-wrapper d-flex flex-column flex-grow-1" id="main-wrapper" data-layout="vertical" data-navbarbg="skin6" data-sidebartype="full" data-sidebar-position="fixed" data-header-position="fixed"> 

    <?php
      include __DIR__ . '/../partials/header.php';
      include __DIR__ . '/../partials/sidebar.php';
    ?>

    <div class="body-wrapper">
	<div class="body-wrapper-inner container-fluid mt-4">
	<!-- BEGIN your form code here -->
	
	<?php
	
	// Helpers for form selections
		$full_name = trim(($app['title'] ?? '') . ' ' . $app['first_name'] . ' ' . $app['surname']);
		$prefSelectValue = $app['preferred_language'] ?? '';
		$prefOtherValue = $app['preferred_language_other'] ?? '';
		$email = $app['email'] ?? '';
		$firstName = $app['first_name'] ?? '';
		$surname = $app['surname'] ?? '';
		$step = isset($_GET['step']) ? (int)$_GET['step'] : 1;
		$isSubmitted = $app['application_status'] === 'submitted';

		// Helper function for file URLs (define or adjust if needed)
		function file_url($id, $filename) {
		  return "/uploads/applications/$id/$filename";
		}


	if ($step === 1 && !$isSubmitted): ?>
	<?php elseif ($step === 2 && !$isSubmitted): ?>
	<!-- Your existing step 2 form here -->
	
	<?php else: ?>
	  <h5 class="mb-3">Application Details (Read-only)</h5>
	  <form>
		<div class="row p-2 g-3 bg-white">
		  <div class="col-md-3 help-wrap">
			<label class="form-label">Title</label>
			<input type="text" class="form-control" value="<?= htmlspecialchars($app['title'] ?? '') ?>" readonly>
		  </div>
		  <div class="col-md-3 help-wrap">
			<label class="form-label">First Name</label>
			<input type="text" class="form-control" value="<?= htmlspecialchars($app['first_name'] ?? '') ?>" readonly>
		  </div>
		  <div class="col-md-3 help-wrap">
			<label class="form-label">Surname</label>
			<input type="text" class="form-control" value="<?= htmlspecialchars($app['surname'] ?? '') ?>" readonly>
		  </div>
		  <div class="col-md-3 help-wrap">
			<label class="form-label">Gender</label>
			<input type="text" class="form-control" value="<?= htmlspecialchars($app['gender'] ?? '') ?>" readonly>
		  </div>

		  <div class="col-md-3 help-wrap">
			<label class="form-label">Preferred Language</label>
			<input type="text" class="form-control" value="<?= 
			  htmlspecialchars($app['preferred_language'] ?? '') .
			  (($app['preferred_language'] ?? '') === 'Others' && !empty($app['preferred_language_other']) ? ' - ' . htmlspecialchars($app['preferred_language_other']) : '')
			?>" readonly>
		  </div>

		  <div class="col-md-3 help-wrap">
			<label class="form-label">NEET Status</label>
			<input type="text" class="form-control" value="<?= htmlspecialchars($app['marital_status'] ?? '') ?>" readonly>
		  </div>
		  <div class="col-md-3 help-wrap">
			<label class="form-label">NEET Score</label>
			<input type="text" class="form-control" value="<?= htmlspecialchars($app['neet_score'] ?? '') ?>" readonly>
		  </div>

		  <div class="col-md-3 help-wrap">
			<label class="form-label">Email</label>
			<input type="email" class="form-control" value="<?= htmlspecialchars($app['email'] ?? '') ?>" readonly>
		  </div>
		  <div class="col-md-3 help-wrap">
			<label class="form-label">Date of Birth</label>
			<input type="date" class="form-control" value="<?= htmlspecialchars($app['dob'] ?? '') ?>" readonly>
		  </div>
		  <div class="col-md-3 help-wrap">
			<label class="form-label">Nationality</label>
			<input type="text" class="form-control" value="<?= htmlspecialchars($app['nationality'] ?? '') ?>" readonly>
		  </div>
		  <div class="col-md-3 help-wrap">
			<label class="form-label">Country of Birth</label>
			<input type="text" class="form-control" value="<?= htmlspecialchars($app['country_of_birth'] ?? '') ?>" readonly>
		  </div>

		  <div class="col-md-3 help-wrap">
			<label class="form-label">Language Proficiency</label>
			<input type="text" class="form-control" value="<?= htmlspecialchars($app['language_proficiency'] ?? '') ?>" readonly>
		  </div>

		  <div class="col-md-3 help-wrap">
			<label class="form-label">Mobile</label>
			<input type="text" class="form-control" value="<?= htmlspecialchars($app['mobile'] ?? '') ?>" readonly>
		  </div>

		  <div class="col-md-3 help-wrap">
			<label class="form-label">Has Passport</label>
			<input type="text" class="form-control" value="<?= ((int)($app['has_passport'] ?? 0) === 1) ? 'Yes' : 'No' ?>" readonly>
		  </div>

		  <?php if ((int)($app['has_passport'] ?? 0) === 1): ?>
			<div class="col-md-3 help-wrap">
			  <label class="form-label">Passport Number</label>
			  <input type="text" class="form-control" value="<?= htmlspecialchars($app['passport_number'] ?? '') ?>" readonly>
			</div>
			<div class="col-md-3 help-wrap">
			  <label class="form-label">Date of Issue</label>
			  <input type="date" class="form-control" value="<?= htmlspecialchars($app['passport_issue_date'] ?? '') ?>" readonly>
			</div>
			<div class="col-md-3 help-wrap">
			  <label class="form-label">Place of Issue</label>
			  <input type="text" class="form-control" value="<?= htmlspecialchars($app['passport_place_of_issue'] ?? '') ?>" readonly>
			</div>
			<div class="col-md-3 help-wrap">
			  <label class="form-label">Expiry Date</label>
			  <input type="date" class="form-control" value="<?= htmlspecialchars($app['passport_expiry'] ?? '') ?>" readonly>
			</div>
		  <?php else: ?>
			<div class="col-md-3 help-wrap">
			  <label class="form-label">Aadhar Number</label>
			  <input type="text" class="form-control" maxlength="12" pattern="\d{12}" inputmode="numeric" 
					 value="<?= htmlspecialchars($app['aadhar_number'] ?? '') ?>" placeholder="12 digits" readonly>
			</div>
		  <?php endif; ?>

		  <div class="col-md-6 help-wrap">
			<label class="form-label">Permanent Home Address (Line 1)</label>
			<input type="text" class="form-control" value="<?= htmlspecialchars($app['addr_line1'] ?? '') ?>" readonly>
		  </div>
		  <div class="col-md-6 help-wrap">
			<label class="form-label">Permanent Home Address (Line 2) (Optional)</label>
			<input type="text" class="form-control" value="<?= htmlspecialchars($app['addr_line2'] ?? '') ?>" readonly>
		  </div>

		  <div class="col-md-3 help-wrap">
			<label class="form-label">City / Town (India)</label>
			<input type="text" class="form-control" value="<?= htmlspecialchars($app['city'] ?? '') ?>" readonly>
		  </div>

		  <div class="col-md-3 help-wrap">
			<label class="form-label">Postal Code</label>
			<input type="text" class="form-control" value="<?= htmlspecialchars($app['postal_code'] ?? '') ?>" readonly>
		  </div>

		  <div class="col-md-3 help-wrap">
			<label class="form-label">Country</label>
			<input type="text" class="form-control" value="<?= htmlspecialchars($app['country'] ?? 'India') ?>" readonly>
		  </div>

		  <div class="col-md-3 help-wrap">
			<label class="form-label">Province / State</label>
			<input type="text" class="form-control" value="<?= htmlspecialchars($app['state'] ?? '') ?>" readonly>
		  </div>
		</div>
	  </form>	  
	<?php endif; ?>
	
        <!-- END your form code here -->

	</div>
    </div>

    <?php include __DIR__ . '/../partials/footer.php'; ?>
  </div>

  <script>
  document.addEventListener('DOMContentLoaded', function () {
    const preferredLanguageSelect = document.getElementById('preferred_language');
    const preferredLanguageOtherInput = document.getElementById('preferred_language_other');
    const neetStatusSelect = document.getElementById('marital_status');
    const neetScoreWrap = document.getElementById('neetScoreWrap');
    const hasPassportRadios = document.querySelectorAll('input[name="has_passport"]');
    const passportFields = document.getElementById('passportFields');

    preferredLanguageSelect?.addEventListener('change', function () {
      if (this.value === 'Others') {
        preferredLanguageOtherInput.classList.remove('d-none');
        preferredLanguageOtherInput.required = true;
      } else {
        preferredLanguageOtherInput.classList.add('d-none');
        preferredLanguageOtherInput.required = false;
        preferredLanguageOtherInput.value = '';
      }
    });

    neetStatusSelect?.addEventListener('change', function () {
      if (this.value === 'Qualified') {
        neetScoreWrap.style.display = 'block';
        document.getElementById('neet_score').required = true;
      } else {
        neetScoreWrap.style.display = 'none';
        document.getElementById('neet_score').required = false;
        document.getElementById('neet_score').value = '';
      }
    });

    hasPassportRadios.forEach(radio => {
      radio.addEventListener('change', function () {
        if (this.value === '1') {
          passportFields.style.display = 'flex';
          passportFields.querySelectorAll('input').forEach(inp => inp.required = true);
        } else {
          passportFields.style.display = 'none';
          passportFields.querySelectorAll('input').forEach(inp => {
            inp.required = false;
            inp.value = '';
          });
        }
      });
    });

  });
  </script>
</body>
</html>
