<?php
// File: admin/applications/review_by_section.php
// Requirements: mysqli only (no PDO), DB conn in ../../config.php, COLLATE=utf8mb4_general_ci.
// Keeps your header/sidebar. Adds SendGrid email on Approve.

session_start();
require '../../config.php';

/* -------------------- Guards -------------------- */
if (!isset($_SESSION['admin']) || !isset($_SESSION['username'])) { header("Location: ".BASE_URL."admin/login"); exit; }
if (!isset($_GET['id']) || !is_numeric($_GET['id'])) { echo "Invalid application ID."; exit; }
$app_id = (int)$_GET['id'];

/* -------------------- Fetch application --------------------- */
$q = mysqli_query($conn, "SELECT * FROM employee_applications WHERE id=$app_id LIMIT 1");
if (!$q || mysqli_num_rows($q)===0){ echo "Application not found."; exit; }
$app = mysqli_fetch_assoc($q);

/* -------------------- Helpers ------------------- */
function h($v){ return htmlspecialchars((string)($v??''), ENT_QUOTES, 'UTF-8'); }
$employee_id = !empty($app['employee_id']) ? $app['employee_id'] : (!empty($app['user_id']) ? $app['user_id'] : $app['id']);
function file_url($sid,$fn){ return "/broriser/employee/employee-app/uploads/".rawurlencode($sid)."/".rawurlencode($fn); }
function is_img($n){ $e=strtolower(pathinfo((string)$n,PATHINFO_EXTENSION)); return in_array($e,['jpg','jpeg','png','gif','webp','bmp','avif']); }
function badge_class($s){ $s=strtolower((string)$s); if($s==='approved')return'bg-success'; if($s==='rejected')return'bg-danger'; if($s==='submitted'||$s==='pending')return'bg-warning text-dark'; return'bg-secondary'; }
$no_img = "/broriser/employee/employee-app/uploads/no-image.png";

/* -------------------- CSRF ---------------------- */
if (empty($_SESSION['csrf_token'])) $_SESSION['csrf_token']=bin2hex(random_bytes(16));
$csrf=$_SESSION['csrf_token'];

/* ---- Load previous SECTION-level decisions ---- */
$sec_prev = ['personal'=>'','academic'=>'','other'=>''];
$r = mysqli_query($conn,"SELECT section_key, section_status FROM application_section_reviews WHERE application_id=$app_id");
if($r){ while($row=mysqli_fetch_assoc($r)){ $sec_prev[$row['section_key']]=$row['section_status']; } }

/* -------------------- Email (SendGrid) ---------------------- */
// function build_pending_requirements($app, $section_status){
//     $items = [];
//     if (isset($section_status['personal']) && $section_status['personal']==='not_ok'){
//         if (!empty($app['passport_copy'])){
//             $items[] = 'Clear Passport Copy';
//         } else {
//             $items[] = 'Aadhaar Front';
//             $items[] = 'Aadhaar Back';
//         }
//         if (empty($app['passport_photo'])) $items[] = 'Recent Passport-size Photograph';
//     }
//     if (isset($section_status['academic']) && $section_status['academic']==='not_ok'){
//         if (empty($app['ssc_certificate']))  $items[] = '10th (SSC) Certificate / Marks';
//         if (empty($app['inter_certificate'])) $items[] = '12th (INTER) Certificate / Marks';
//         if (empty($app['marital_status']) || empty($app['neet_score'])) $items[] = 'NEET Score Card / Result';
//     }
//     if (isset($section_status['other']) && $section_status['other']==='not_ok'){
//         if (empty($app['experience_letter']) && empty($app['experience_details'])) $items[] = 'Statement of Purpose';
//         if (empty($app['payment_proof'])) $items[] = 'Payment Proof Receipt';
//     }
//     $items = array_values(array_unique(array_filter($items)));
//     return $items;
// }
function build_pending_requirements($app, $section_status) {
    $items = [];
    if (empty($app['passport_copy']) && (empty($app['aadhaar_front']) || empty($app['aadhaar_back']))) {
        $items[] = 'Clear Passport Copy or Aadhaar (Front & Back)';
    }
    if (empty($app['passport_photo'])) {
        $items[] = 'Recent Passport-size Photograph';
    }
    if (empty($app['ssc_certificate'])) {
        $items[] = '10th (SSC) Certificate / Marks';
    }
    if (empty($app['inter_certificate'])) {
        $items[] = '12th (INTER) Certificate / Marks';
    }
    if (empty($app['marital_status']) || empty($app['neet_score'])) {
        $items[] = 'NEET Score Card / Result';
    }
    if (empty($app['experience_letter']) && empty($app['experience_details'])) {
        $items[] = 'Statement of Purpose';
    }
    if (empty($app['payment_proof'])) {
        $items[] = 'Payment Proof Receipt';
    }
    $items = array_values(array_unique(array_filter($items)));
    return $items;
}
function send_conditional_approval_mail($app, $section_status){
    if (empty($app['email'])) return ['ok'=>false,'msg'=>'employee email not found'];
    if (!defined('SENDGRID_API_KEY') || !SENDGRID_API_KEY) return ['ok'=>false,'msg'=>'SendGrid API key missing'];
    $toEmail = $app['email'];
    $toName  = trim(($app['first_name'] ?? '').' '.($app['surname'] ?? ''));
    $collegeName = 'Broriser';
    $program = !empty($app['program']) ? $app['program'] : 'MBBS';
    // try to form intake
    $intake = '';
    if (!empty($app['intake_month']) && !empty($app['intake_year'])) { $intake = $app['intake_month'].' '.$app['intake_year']; }
    elseif (!empty($app['intake'])) { $intake = $app['intake']; }
    else { $intake = date('F Y'); }
    $broriserNo = 'KU-'.str_pad((string)($app['id'] ?? ''), 6, '0', STR_PAD_LEFT);
    $approvalDate = date('d M Y');
    $deadlineDate = date('d M Y', strtotime('+10 days'));

    $pending = build_pending_requirements($app, $section_status);
    $pendingHtml = '';
    if (!empty($pending)){
        $pendingHtml .= '<ol style="margin:6px 0 0 18px; padding:0">';
        foreach($pending as $p){ $pendingHtml .= '<li style="margin:2px 0">'.h($p).'</li>'; }
        $pendingHtml .= '</ol>';
    } else {
        $pendingHtml = '<p style="margin:0">— None (all sections marked OK).</p>';
    }

    $subject = 'Conditional broriser Approval – Broriser';

    // HTML email (clean, classy)
    $portalUrl = BASE_URL;
    $html = '
  <div style="font-family:Inter,Arial,sans-serif;background:#f6f7fb;padding:28px 0;color:#0f172a">
    <table role="presentation" cellpadding="0" cellspacing="0" align="center" width="640" style="background:#ffffff;border-radius:14px;overflow:hidden;border:1px solid #e8ecf3">
      <tr>
        <td style="padding:18px 22px;background:#0f172a;color:#fff">
          <div style="font-weight:800;font-size:18px">brorisers</div>
          <div style="opacity:.85;font-size:12px">'.$collegeName.'</div>
        </td>
      </tr>
      <tr><td style="height:10px;background:linear-gradient(90deg,#a2ff00,#00d6c4)"></td></tr>
      <tr>
        <td style="padding:22px">
          <p style="margin:0 0 12px 0;font-size:16px">Dear <strong>'.h($app['first_name'] ?? '').' '.h($app['surname'] ?? '').'</strong>,</p>
          <p style="margin:0 0 14px 0">Greetings from <strong>'.$collegeName.'</strong>!</p>
          <p style="margin:0 0 16px 0">We are pleased to inform you that your application for broriser to <strong>'.$collegeName.'</strong> has been <strong>approved on a conditional basis</strong>.</p>

          <div style="border:1px solid #e8ecf3;border-radius:12px;padding:16px;margin:14px 0">
            <div style="font-weight:800;margin-bottom:10px">Your Conditional broriser Details</div>
            <table cellpadding="0" cellspacing="0" width="100%" style="font-size:14px">
              <tr><td style="padding:6px 0;color:#475569;width:35%">employee Name</td><td style="padding:6px 0">'.h($toName).'</td></tr>
              <tr><td style="padding:6px 0;color:#475569">Program</td><td style="padding:6px 0">'.h($program).'</td></tr>
              <tr><td style="padding:6px 0;color:#475569">Intake</td><td style="padding:6px 0">'.h($intake).'</td></tr>
              <tr><td style="padding:6px 0;color:#475569">Conditional broriser No.</td><td style="padding:6px 0">'.h($broriserNo).'</td></tr>
              <tr><td style="padding:6px 0;color:#475569">Approval Date</td><td style="padding:6px 0">'.h($approvalDate).'</td></tr>
            </table>
          </div>

          <div style="margin:16px 0">
            <div style="font-weight:800;margin-bottom:6px">Conditions to be Fulfilled</div>
            <p style="margin:0 0 6px 0">Please note that this broriser is conditional and will be confirmed upon fulfillment of the following requirements:</p>
            <ul style="margin:0 0 10px 18px;padding:0">
              <li>Submission of the pending documents:' . $pendingHtml . '</li>
              <li>Payment of <strong>USD $1800 + USD $2,500</strong> to Broriser.</li>
              <li>Compliance with Broriser’s academic and visa requirements.</li>
            </ul>
          </div>

          <div style="margin:16px 0">
            <div style="font-weight:800;margin-bottom:6px">Next Steps</div>
            <ol style="margin:0 0 10px 18px;padding:0">
              <li>Submit all pending documents to the brorisers Office by <strong>'.h($deadlineDate).'</strong>.</li>
              <li>Complete the initial payment of <strong>USD $3,300</strong> (or INR equivalent) via your preferred method.</li>
              <li>Await your Final broriser Letter, which will be issued once the above conditions are met.</li>
            </ol>
            <p style="margin:0 0 12px 0"><em>Important:</em> Failure to fulfill the above conditions within the specified timeline may result in cancellation of your conditional broriser.</p>
          </div>

          <div style="border:1px dashed #d8dee9;border-radius:12px;padding:14px;margin:14px 0">
            <div style="font-weight:800;margin-bottom:4px">Need help?</div>
            <div>If you have questions, contact our brorisers Office at <strong>IVR 9643004778</strong>.</div>
          </div>

          <div style="text-align:center;margin:18px 0 6px 0">
            <a href="'.h($portalUrl).'" style="display:inline-block;background:#00d6c4;color:#04222a;text-decoration:none;padding:12px 18px;border-radius:10px;font-weight:800">Go to Applicant Portal</a>
          </div>

          <p style="margin:18px 0 0 0">Warm regards,<br><strong></strong><br> brorisers Officer</p>
        </td>
      </tr>
      <tr><td style="height:10px;background:linear-gradient(90deg,#a2ff00,#00d6c4)"></td></tr>
      <tr><td style="padding:10px;text-align:center;color:#64748b;font-size:12px">© '.date('Y').' Broriser brorisers</td></tr>
    </table>
  </div>';

    $text = "Dear ".$toName.",\n\n".
            "Your application to Broriser has been approved on a conditional basis.\n\n".
            "Conditional broriser Number: ".$broriserNo."\n".
            "Program: ".$program."\n".
            "Intake: ".$intake."\n".
            "Approval Date: ".$approvalDate."\n\n".
            "Pending documents:\n - ".(empty($pending)?'None':implode("\n - ",$pending))."\n\n".
            "Payments: USD $1800 + USD $2,500\n".
            "Deadline: ".$deadlineDate."\n\n".
            "Next steps: submit documents, pay the amount, then await your Final broriser Letter.\n\n".
            "Support: IVR 9643004778\n\n".
            "Warm regards,\n –  brorisers Officer\n";

    // Prepare payload (SendGrid v3 API)
    $payload = [
        "personalizations" => [[ "to" => [[ "email" => $toEmail, "name" => $toName ]] ]],
        "from" => [ "email" => defined('SENDGRID_FROM_EMAIL')?SENDGRID_FROM_EMAIL:"no-reply@example.com",
                    "name"  => defined('SENDGRID_FROM_NAME')?SENDGRID_FROM_NAME:"brorisers" ],
        "subject" => $subject,
        "content" => [
            [ "type" => "text/plain", "value" => $text ],
            [ "type" => "text/html",  "value" => $html ]
        ]
    ];

    $ch = curl_init('https://api.sendgrid.com/v3/mail/send');
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Authorization: Bearer '.SENDGRID_API_KEY,
        'Content-Type: application/json'
    ]);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($payload));
    // curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
    $resp = curl_exec($ch);
    $http = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    $err  = curl_error($ch);
    curl_close($ch);

    if ($http===202) return ['ok'=>true,'msg'=>'Approval email sent'];
    return ['ok'=>false,'msg'=>'Email failed (HTTP '.$http.'). '.($err?$err:$resp)];
}

/* -------------------- POST ---------------------- */
$flash='';
if($_SERVER['REQUEST_METHOD']==='POST' && isset($_POST['csrf']) && $_POST['csrf']===$csrf){
  $act = $_POST['act'] ?? 'save';                     // save | approve | reject
  $section_status = $_POST['section_status'] ?? [];   // per-section radios

  // Save section statuses
  mysqli_query($conn,"DELETE FROM application_section_reviews WHERE application_id=$app_id");
  $stmt=mysqli_prepare($conn,"INSERT INTO application_section_reviews(application_id,section_key,section_label,section_status,reviewer,reviewed_at) VALUES(?,?,?,?,?,?)");
  $now=date('Y-m-d H:i:s'); $rev=$_SESSION['username'];
  if($stmt){
    $labels=['personal'=>'Personal Information','academic'=>'Academic Qualifications','other'=>'Other Details'];
    foreach(['personal','academic','other'] as $k){
      $st=(isset($section_status[$k]) && $section_status[$k]==='ok')?'ok':'not_ok';
      mysqli_stmt_bind_param($stmt,"isssss",$app_id,$k,$labels[$k],$st,$rev,$now);
      mysqli_stmt_execute($stmt);
      $sec_prev[$k]=$st;
    }
    mysqli_stmt_close($stmt);
  }

  // Save remarks + application_status (silently ignore cols if missing)
  $remarks=mysqli_real_escape_string($conn,trim($_POST['remarks']??''));
  $set='';
  if($act==='approve'||$act==='reject'){ $new=($act==='approve'?'approved':'rejected'); $set="application_status='".mysqli_real_escape_string($conn,$new)."',"; }
  @mysqli_query($conn,"UPDATE employee_applications SET $set status_remarks='$remarks', status_date='".date('Y-m-d H:i:s')."' WHERE id=$app_id LIMIT 1");

  if ($act==='approve'){
      $mail = send_conditional_approval_mail($app, $sec_prev);
      $flash = ($mail['ok'] ? "Application approved and email sent." : "Application approved. ".$mail['msg']);
  } elseif ($act==='reject'){
      $flash = "Application rejected.";
  } else {
      $flash = "Review saved.";
  }
}

/* ----------------- Subsection data ----------------- */
/* 1. Personal Information */
$sub_identity = [
  'Title' => $app['title'] ?? '',
  'First Name' => $app['first_name'] ?? '',
  'Surname' => $app['surname'] ?? '',
  'Gender' => $app['gender'] ?? '',
  'Preferred Language' => (function($a){ $b=$a['preferred_language']??''; if($b==='Others' && !empty($a['preferred_language_other'])) $b.=' - '.$a['preferred_language_other']; return $b; })($app),
  'Date of Birth' => $app['dob'] ?? '',
  'Nationality' => $app['nationality'] ?? '',
  'Country of Birth' => $app['country_of_birth'] ?? '',
  'Language Proficiency' => $app['language_proficiency'] ?? '',
];
$sub_contact = [
  'Mobile' => $app['mobile'] ?? '',
  'Email' => $app['email'] ?? '',
  'Address Line 1' => $app['addr_line1'] ?? '',
  'Address Line 2' => $app['addr_line2'] ?? '',
  'City / Town' => $app['city'] ?? '',
  'Postal Code' => $app['postal_code'] ?? '',
  'Country' => $app['country'] ?? 'India',
  'State / Province' => $app['state'] ?? '',
];
$sub_govt = [
  'Aadhar Number' => ((int)($app['has_passport'] ?? 0)===1) ? '' : ($app['aadhar_number'] ?? ''),
  'Passport Number' => ((int)($app['has_passport'] ?? 0)===1) ? ($app['passport_number'] ?? '') : '',
  'Passport Issue Date' => ((int)($app['has_passport'] ?? 0)===1) ? ($app['passport_issue_date'] ?? '') : '',
  'Passport Place of Issue' => ((int)($app['has_passport'] ?? 0)===1) ? ($app['passport_place_of_issue'] ?? '') : '',
  'Passport Expiry' => ((int)($app['has_passport'] ?? 0)===1) ? ($app['passport_expiry'] ?? '') : '',
  'Has Passport' => ((int)($app['has_passport'] ?? 0)===1) ? 'Yes' : 'No',
];
/* Attachments per SUBSECTION */
$att_identity = [ 'Photo' => $app['passport_photo'] ?? '' ];
$att_contact  = []; // per your rule, none here
$att_govt     = [];
if (!empty($app['passport_copy'])) { $att_govt['Passport Copy'] = $app['passport_copy']; }
else {
  $att_govt['Aadhaar Front'] = !empty($app['aadhar_front']) ? $app['aadhar_front'] : ($app['aadhar_copy'] ?? '');
  $att_govt['Aadhaar Back']  = $app['aadhar_back'] ?? '';
}

/* 2. Academic Qualifications */
$sub_entrance = [
  'NEET Status' => $app['marital_status'] ?? '',
  'NEET Score'  => $app['neet_score'] ?? '',
];
$sub_ssc = [
  'SSC Year' => $app['ssc_year'] ?? '',
  'SSC School' => $app['ssc_school'] ?? '',
  'SSC Address' => $app['ssc_address'] ?? '',
  'SSC Stream' => $app['ssc_stream'] ?? '',
  'SSC Average Grade' => $app['ssc_avg_grade'] ?? '',
  'SSC PCB %' => $app['ssc_pcb_percent'] ?? '',
  'SSC Average %' => $app['ssc_avg_percent'] ?? '',
  'SSC Degree Available' => $app['ssc_degree_available'] ?? '',
];
$att_ssc = [ 'SSC Certificate' => $app['ssc_certificate'] ?? '' ];
$sub_inter = [
  'INTER Year' => $app['inter_year'] ?? '',
  'INTER School' => $app['inter_school'] ?? '',
  'INTER Address' => $app['inter_address'] ?? '',
  'INTER Stream' => $app['inter_stream'] ?? '',
  'INTER Average Grade' => $app['inter_avg_grade'] ?? '',
  'INTER PCB %' => $app['inter_pcb_percent'] ?? '',
  'INTER Average %' => $app['inter_avg_percent'] ?? '',
  'INTER Degree Available' => $app['inter_degree_available'] ?? '',
];
$att_inter = [ 'INTER Certificate' => $app['inter_certificate'] ?? '' ];

/* 3. Other Details */
$sub_application = [
  'Application Status' => $app['application_status'] ?? '',
  'Applicant Statement' => $app['experience_details'] ?? '',
];
$att_application = [ 'Statement File' => $app['experience_letter'] ?? '' ];
$sub_payment = [];
if(!empty($app['payment_amount']))    $sub_payment['Payment Amount'] = $app['payment_amount'];
if(!empty($app['payment_reference'])) $sub_payment['Payment Reference'] = $app['payment_reference'];
$att_payment = [ 'Payment Proof'  => $app['payment_proof'] ?? '' ];

/* Meta */
$status = $app['application_status'] ?? 'submitted';
$submitted_at = $app['submitted_at'] ?? '';
$status_date = $app['status_date'] ?? '';

?>
<!doctype html>
<html lang="en">
<head>
<meta charset="utf-8"/><meta name="viewport" content="width=device-width, initial-scale=1"/>
<title>Application #<?= h($app_id) ?> — Section Review</title>
<?php include __DIR__.'/../partials/head.php'; ?>
<style>
.viewer-wrap{display:flex;justify-content:center;padding:22px;background:linear-gradient(180deg,#f5f7ff 0,#fff 100%)}
.doc{background:#fff;color:#111827;width:1240px;max-width:100%;padding:18px;border-radius:16px;border:1px solid rgba(0,0,0,.06);box-shadow:0 14px 34px rgba(0,0,0,.10)}
.doc-head{display:flex;gap:12px;align-items:center;margin-bottom:12px}
.doc-head .title{font-weight:800;font-size:22px}
.doc-head .meta{margin-left:auto;display:flex;gap:8px;align-items:center}
.badge{padding:6px 10px;border-radius:999px;font-weight:700;font-size:12px}

/* Section frame + header + radios */
.section{border:2px solid #6d78ff;border-radius:12px;margin-bottom:16px;box-shadow:0 0 0 6px rgba(109,120,255,.06) inset; page-break-inside: avoid;}
.section.ok{border-color:#10b981;box-shadow:0 0 0 6px rgba(16,185,129,.12) inset}
.section.notok{border-color:#ef4444;box-shadow:0 0 0 6px rgba(239,68,68,.12) inset}
.sec-head{display:flex;align-items:center;gap:12px;padding:12px 14px;border-bottom:1px dashed rgba(0,0,0,.08)}
.sec-title{font-weight:800;font-size:18px}
.sec-radios{margin-left:auto}
.sec-body{padding:6px 10px}

/* SUB-box */
.subbox{margin:10px 0;border:2px solid #dce3ff;border-radius:12px}
.subbox .subbody{display:grid;grid-template-columns:1fr 310px;gap:14px;padding:12px}
.subbox .subhead{display:flex;align-items:center;gap:8px;padding:10px 12px;background:#fbfdff;border-bottom:1px solid #e6ebf5}
.subbox .subhead .label{font-weight:800}

/* Left: values */
.kv{display:grid;grid-template-columns:repeat(4,1fr);gap:12px}
.kv .formish{display:flex;flex-direction:column}
.kv label{font-weight:700;font-size:.9rem;color:#0f172a;margin-bottom:6px}
.kv .ro{background:#fff;border:1px solid #e5e7eb;border-radius:8px;padding:.65rem .8rem;min-height:40px}

/* Right: attachments */
.side{display:flex;flex-direction:column;gap:12px}
.att-card{cursor:pointer;background:#ffffff;border:2px solid #b7eb30;border-radius:14px;padding:8px;box-shadow:0 0 0 6px rgba(183,235,48,.15) inset;text-align:center;transition:.2s}
.att-card:hover{transform:translateY(-1px)}
.att-card .title{font-weight:800;margin-bottom:6px}
.att-card img{width:100%;height:180px;object-fit:cover;border-radius:10px;border:2px solid #fff;background:#f0f7d7}
.file-pill{display:inline-block;border:1px solid #1f2937;border-radius:999px;padding:6px 10px;background:#f9ffe0}
.file-pill a{text-decoration:none;color:#111827}
.muted{color:#475569}

/* --- Reviewer Remarks (styled like your screenshot) --- */
.review-bar{position:sticky;bottom:0;z-index:9;margin-top:18px}
.remark-shell{display:flex;align-items:stretch;background:#0c1324;border:1px solid rgba(255,255,255,.6);border-radius:12px;padding:8px}
.remark-shell .left{flex:1;display:flex;flex-direction:column}
.remark-shell label{color:#e5e7eb;font-weight:700;margin:0 0 6px 4px}
.remark-shell textarea{flex:1;border:0;background:transparent;color:#e5e7eb;resize:vertical;min-height:56px;outline:none}
.remark-shell .btns{display:flex;gap:10px;align-items:center;margin-left:10px}
.remark-shell .btns .btn{border-radius:12px;font-weight:800;padding:.7rem 1.1rem;border:1px solid rgba(255,255,255,.6)}
.remark-shell .btn-save{background:#0c1324;color:#fff}
.remark-shell .btn-reject{background:#ff5aa0;color:#fff;border-color:#ff5aa0}
.remark-shell .btn-approve{background:#00d6c4;color:#04222a;border-color:#00d6c4}

/* Print */
.screen-only{display:block}
.print-only{display:none}
@media print{
  #main-wrapper .app-header,#main-wrapper .left-sidebar,#main-wrapper .app-topstrip,.review-bar,.top-actions,.sec-radios{display:none!important;}
  .viewer-wrap{padding:0;background:#fff}
  .doc{box-shadow:none;border:0}
  #sec-personal{page-break-after: always;}
  #sec-academic{page-break-after: always;}
  #sec-other{page-break-after: always;}
  .print-only{display:block}
  .print-page{page-break-before: always; padding-top:12px;}
  .print-title{font-weight:800;font-size:18px;margin:6px 0 10px 0;}
  .print-grid-2{display:grid;grid-template-columns:1fr 1fr;gap:14px}
  .print-img{width:100%;height:980px;object-fit:contain;border:1px solid #ddd;padding:6px;border-radius:8px}
  .print-box{border:1px solid #ddd;border-radius:8px;padding:10px;height:980px}
}
@media (max-width: 1100px){
  .subbox .subbody{grid-template-columns:1fr}
  .kv{grid-template-columns:repeat(2,1fr)}
}
</style>
</head>
<body class="d-flex flex-column min-vh-100">
<div class="page-wrapper d-flex flex-column flex-grow-1" id="main-wrapper" data-layout="vertical" data-navbarbg="skin6" data-sidebartype="full" data-sidebar-position="fixed" data-header-position="fixed">
<?php include __DIR__.'/../partials/header.php'; include __DIR__.'/../partials/sidebar.php'; ?>

<div class="body-wrapper"><div class="body-wrapper-inner container-fluid">
  <div class="viewer-wrap"><div class="doc">

    <div class="doc-head">
      <div class="title">Application #<?= h($app_id) ?> — Section Review</div>
      <div class="top-actions" style="display:flex;gap:10px"><button type="button" class="btn btn-outline-dark" onclick="window.print()">🖨 Print / Save PDF</button></div>
      <div class="meta">
        <span class="badge <?= h(badge_class($status)) ?>"><?= strtoupper(h($status)) ?></span>
        <?php if($submitted_at){ ?><span class="badge bg-light text-dark">Submitted: <?= h($submitted_at) ?></span><?php } ?>
        <?php if($status_date){ ?><span class="badge bg-light text-dark">Last Action: <?= h($status_date) ?></span><?php } ?>
      </div>
    </div>

    <?php if(!empty($flash)){ ?><div class="alert alert-info py-2 px-3 mb-3 screen-only"><?= h($flash) ?></div><?php } ?>

    <form method="post">
      <input type="hidden" name="csrf" value="<?= h($csrf) ?>">

      <!-- 1. Personal Information -->
      <div class="section <?= ($sec_prev['personal']==='ok'?'ok':($sec_prev['personal']==='not_ok'?'notok':'')) ?>" id="sec-personal">
        <div class="sec-head">
          <div class="sec-title">1. Personal Information</div>
          <div class="sec-radios screen-only">
            <label class="me-2"><input type="radio" name="section_status[personal]" value="ok" <?= ($sec_prev['personal']==='ok'?'checked':'') ?>> OK</label>
            <label><input type="radio" name="section_status[personal]" value="not_ok" <?= ($sec_prev['personal']==='not_ok'?'checked':'') ?>> Not OK</label>
          </div>
        </div>
        <div class="sec-body">

          <!-- A. Identity & Basic Info -->
          <div class="subbox">
            <div class="subhead"><div class="label">A. Identity &amp; Basic Info</div></div>
            <div class="subbody">
              <div>
                <div class="kv">
                  <?php foreach($sub_identity as $lbl=>$val){ ?>
                    <div class="formish"><label><?= h($lbl) ?></label><div class="ro"><?= nl2br(h($val)) ?></div></div>
                  <?php } ?>
                </div>
              </div>
              <aside class="side">
                <?php foreach($att_identity as $label=>$fn){
                  $has=!empty($fn); $url=$has?file_url($employee_id,$fn):''; $is=$has?is_img($fn):false; ?>
                  <div class="att-card" <?= $has?'data-url="'.h($url).'"':'' ?>>
                    <div class="title"><?= h($label) ?></div>
                    <?php if($has && $is){ ?><img src="<?= h($url) ?>" alt="<?= h($label) ?>"><?php }
                          elseif($has){ ?><div class="file-pill"><a href="<?= h($url) ?>" target="_blank" rel="noopener">Open</a></div><?php }
                          else { ?><img src="<?= h($no_img) ?>" alt="No Image"><div class="muted">No Image</div><?php } ?>
                  </div>
                <?php } ?>
              </aside>
            </div>
          </div>

          <!-- B. Contact Information -->
          <div class="subbox">
            <div class="subhead"><div class="label">B. Contact Information</div></div>
            <div class="subbody">
              <div>
                <div class="kv">
                  <?php foreach($sub_contact as $lbl=>$val){ if($lbl==='Address Line 2' && $val==='') continue; ?>
                    <div class="formish"><label><?= h($lbl) ?></label><div class="ro"><?= nl2br(h($val)) ?></div></div>
                  <?php } ?>
                </div>
              </div>
              <aside class="side"><!-- (no attachments here) --></aside>
            </div>
          </div>

          <!-- C. Government IDs -->
          <div class="subbox">
            <div class="subhead"><div class="label">C. Government IDs</div></div>
            <div class="subbody">
              <div>
                <div class="kv">
                  <?php foreach($sub_govt as $lbl=>$val){ if($val===''||$val===null) continue; ?>
                    <div class="formish"><label><?= h($lbl) ?></label><div class="ro"><?= nl2br(h($val)) ?></div></div>
                  <?php } ?>
                </div>
              </div>
              <aside class="side">
                <?php foreach($att_govt as $label=>$fn){
                  $has=!empty($fn); $url=$has?file_url($employee_id,$fn):''; $is=$has?is_img($fn):false; ?>
                  <div class="att-card" <?= $has?'data-url="'.h($url).'"':'' ?>>
                    <div class="title"><?= h($label) ?></div>
                    <?php if($has && $is){ ?><img src="<?= h($url) ?>" alt="<?= h($label) ?>"><?php }
                          elseif($has){ ?><div class="file-pill"><a href="<?= h($url) ?>" target="_blank" rel="noopener">Open</a></div><?php }
                          else { ?><img src="<?= h($no_img) ?>" alt="No Image"><div class="muted">No Image</div><?php } ?>
                  </div>
                <?php } ?>
              </aside>
            </div>
          </div>

        </div>
      </div>

      <!-- 2. Academic Qualifications -->
      <div class="section <?= ($sec_prev['academic']==='ok'?'ok':($sec_prev['academic']==='not_ok'?'notok':'')) ?>" id="sec-academic">
        <div class="sec-head">
          <div class="sec-title">2. Academic Qualifications</div>
          <div class="sec-radios screen-only">
            <label class="me-2"><input type="radio" name="section_status[academic]" value="ok" <?= ($sec_prev['academic']==='ok'?'checked':'') ?>> OK</label>
            <label><input type="radio" name="section_status[academic]" value="not_ok" <?= ($sec_prev['academic']==='not_ok'?'checked':'') ?>> Not OK</label>
          </div>
        </div>
        <div class="sec-body">

          <!-- A. Entrance Exams -->
          <div class="subbox">
            <div class="subhead"><div class="label">A. Entrance Exams</div></div>
            <div class="subbody">
              <div><div class="kv">
                <?php foreach($sub_entrance as $lbl=>$val){ if($val===''||$val===null) continue; ?>
                  <div class="formish"><label><?= h($lbl) ?></label><div class="ro"><?= nl2br(h($val)) ?></div></div>
                <?php } ?>
              </div></div>
              <aside class="side"></aside>
            </div>
          </div>

          <!-- B. Secondary Education (SSC / 10th) -->
          <div class="subbox">
            <div class="subhead"><div class="label">B. Secondary Education (SSC / 10th)</div></div>
            <div class="subbody">
              <div><div class="kv">
                <?php foreach($sub_ssc as $lbl=>$val){ if($val===''||$val===null) continue; ?>
                  <div class="formish"><label><?= h($lbl) ?></label><div class="ro"><?= nl2br(h($val)) ?></div></div>
                <?php } ?>
              </div></div>
              <aside class="side">
                <?php foreach($att_ssc as $label=>$fn){
                  $has=!empty($fn); $url=$has?file_url($employee_id,$fn):''; $is=$has?is_img($fn):false; ?>
                  <div class="att-card" <?= $has?'data-url="'.h($url).'"':'' ?>>
                    <div class="title"><?= h($label) ?></div>
                    <?php if($has && $is){ ?><img src="<?= h($url) ?>" alt="<?= h($label) ?>"><?php }
                          elseif($has){ ?><div class="file-pill"><a href="<?= h($url) ?>" target="_blank" rel="noopener">Open</a></div><?php }
                          else { ?><img src="<?= h($no_img) ?>" alt="No Image"><div class="muted">No Image</div><?php } ?>
                  </div>
                <?php } ?>
              </aside>
            </div>
          </div>

          <!-- C. Higher Secondary Education (Intermediate / 12th) -->
          <div class="subbox">
            <div class="subhead"><div class="label">C. Higher Secondary Education (Intermediate / 12th)</div></div>
            <div class="subbody">
              <div><div class="kv">
                <?php foreach($sub_inter as $lbl=>$val){ if($val===''||$val===null) continue; ?>
                  <div class="formish"><label><?= h($lbl) ?></label><div class="ro"><?= nl2br(h($val)) ?></div></div>
                <?php } ?>
              </div></div>
              <aside class="side">
                <?php foreach($att_inter as $label=>$fn){
                  $has=!empty($fn); $url=$has?file_url($employee_id,$fn):''; $is=$has?is_img($fn):false; ?>
                  <div class="att-card" <?= $has?'data-url="'.h($url).'"':'' ?>>
                    <div class="title"><?= h($label) ?></div>
                    <?php if($has && $is){ ?><img src="<?= h($url) ?>" alt="<?= h($label) ?>"><?php }
                          elseif($has){ ?><div class="file-pill"><a href="<?= h($url) ?>" target="_blank" rel="noopener">Open</a></div><?php }
                          else { ?><img src="<?= h($no_img) ?>" alt="No Image"><div class="muted">No Image</div><?php } ?>
                  </div>
                <?php } ?>
              </aside>
            </div>
          </div>

        </div>
      </div>

      <!-- 3. Other Details -->
      <div class="section <?= ($sec_prev['other']==='ok'?'ok':($sec_prev['other']==='not_ok'?'notok':'')) ?>" id="sec-other">
        <div class="sec-head">
          <div class="sec-title">3. Other Details</div>
          <div class="sec-radios screen-only">
            <label class="me-2"><input type="radio" name="section_status[other]" value="ok" <?= ($sec_prev['other']==='ok'?'checked':'') ?>> OK</label>
            <label><input type="radio" name="section_status[other]" value="not_ok" <?= ($sec_prev['other']==='not_ok'?'checked':'') ?>> Not OK</label>
          </div>
        </div>
        <div class="sec-body">

          <!-- A. Application Process -->
          <div class="subbox">
            <div class="subhead"><div class="label">A. Application Process</div></div>
            <div class="subbody">
              <div><div class="kv">
                <?php foreach($sub_application as $lbl=>$val){ if($val===''||$val===null) continue; ?>
                  <div class="formish" <?= $lbl==='Applicant Statement'?'style="grid-column:1/-1"':'' ?>><label><?= h($lbl) ?></label><div class="ro"><?= nl2br(h($val)) ?></div></div>
                <?php } ?>
              </div></div>
              <aside class="side">
                <?php foreach($att_application as $label=>$fn){
                  $has=!empty($fn); $url=$has?file_url($employee_id,$fn):''; $is=$has?is_img($fn):false; ?>
                  <div class="att-card" <?= $has?'data-url="'.h($url).'"':'' ?>>
                    <div class="title"><?= h($label) ?></div>
                    <?php if($has && $is){ ?><img src="<?= h($url) ?>" alt="<?= h($label) ?>"><?php }
                          elseif($has){ ?><div class="file-pill"><a href="<?= h($url) ?>" target="_blank" rel="noopener">Open</a></div><?php }
                          else { ?><img src="<?= h($no_img) ?>" alt="No Image"><div class="muted">No Image</div><?php } ?>
                  </div>
                <?php } ?>
              </aside>
            </div>
          </div>

          <!-- B. Payment Proof -->
          <div class="subbox">
            <div class="subhead"><div class="label">B. Payment Proof</div></div>
            <div class="subbody">
              <div><div class="kv">
                <?php foreach($sub_payment as $lbl=>$val){ ?>
                  <div class="formish"><label><?= h($lbl) ?></label><div class="ro"><?= nl2br(h($val)) ?></div></div>
                <?php } ?>
              </div></div>
              <aside class="side">
                <?php foreach($att_payment as $label=>$fn){
                  $has=!empty($fn); $url=$has?file_url($employee_id,$fn):''; $is=$has?is_img($fn):false; ?>
                  <div class="att-card" <?= $has?'data-url="'.h($url).'"':'' ?>>
                    <div class="title"><?= h($label) ?></div>
                    <?php if($has && $is){ ?><img src="<?= h($url) ?>" alt="<?= h($label) ?>"><?php }
                          elseif($has){ ?><div class="file-pill"><a href="<?= h($url) ?>" target="_blank" rel="noopener">Open</a></div><?php }
                          else { ?><img src="<?= h($no_img) ?>" alt="No Image"><div class="muted">No Image</div><?php } ?>
                  </div>
                <?php } ?>
              </aside>
            </div>
          </div>

        </div>
      </div>

      <!-- Reviewer Remarks (styled like your screenshot) -->
            <?php
              if ($app['application_status'] !== 'approved' && $app['application_status'] !== 'rejected') {
                ?>
                  <div class="review-bar screen-only">
                    <div class="remark-shell">
                      <div class="left">
                        <label>Reviewer Remarks</label>
                        <textarea name="remarks" placeholder="Notes for approval/rejection..." maxlength="1000"></textarea>
                      </div>
                    
                      <div class="btns">
                        <button type="submit" name="act" value="reject" class="btn btn-reject" onclick="return confirm('Reject this application?');">Reject</button>
                        <button type="submit" name="act" value="approve" class="btn btn-approve" onclick="return confirm('Approve this application and email the employee?');">Approve</button>
                      </div>
                    </div>
                  </div>
                <?php
              }
            ?>
        </div>
      </div>
    </form>

    <!-- =================== PRINT-ONLY ATTACHMENT PAGES =================== -->
    <?php
      $photo_fn       = $app['passport_photo'] ?? '';
      $passport_fn    = $app['passport_copy'] ?? '';
      $a_front_fn     = !empty($app['aadhar_front']) ? $app['aadhar_front'] : ($app['aadhar_copy'] ?? '');
      $a_back_fn      = $app['aadhar_back'] ?? '';
      $ssc_fn         = $app['ssc_certificate'] ?? '';
      $inter_fn       = $app['inter_certificate'] ?? '';
      $statement_fn   = $app['experience_letter'] ?? '';
      $payment_fn     = $app['payment_proof'] ?? '';
      function print_img_or_box($sid,$fn,$title,$no_img){
        if(!empty($fn) && is_img($fn)){ echo '<img class="print-img" src="'.h(file_url($sid,$fn)).'" alt="'.h($title).'">'; }
        elseif(!empty($fn)){ echo '<div class="print-box"><div style="font-weight:700;margin-bottom:6px">'.h($title).'</div><div>File: '.h($fn).'</div><div>URL: '.h(file_url($sid,$fn)).'</div></div>'; }
        else { echo '<img class="print-img" src="'.h($no_img).'" alt="No Image">'; }
      }
    ?>
    <div class="print-only">
      <div class="print-page"><div class="print-title">Photo</div><?php print_img_or_box($employee_id,$photo_fn,'Photo',$no_img); ?></div>
      <div class="print-page">
        <?php if(!empty($passport_fn)){ ?>
          <div class="print-title">Passport Copy</div><?php print_img_or_box($employee_id,$passport_fn,'Passport Copy',$no_img); ?>
        <?php } else { ?>
          <div class="print-title">Aadhaar Front &amp; Back</div>
          <div class="print-grid-2">
            <div><?php print_img_or_box($employee_id,$a_front_fn,'Aadhaar Front',$no_img); ?></div>
            <div><?php print_img_or_box($employee_id,$a_back_fn,'Aadhaar Back',$no_img); ?></div>
          </div>
        <?php } ?>
      </div>
      <div class="print-page"><div class="print-title">10th (SSC) Certificate</div><?php print_img_or_box($employee_id,$ssc_fn,'SSC Certificate',$no_img); ?></div>
      <div class="print-page"><div class="print-title">12th (INTER) Certificate</div><?php print_img_or_box($employee_id,$inter_fn,'INTER Certificate',$no_img); ?></div>
      <div class="print-page"><div class="print-title">Statement File</div><?php print_img_or_box($employee_id,$statement_fn,'Statement File',$no_img); ?></div>
      <div class="print-page"><div class="print-title">Payment Proof</div><?php print_img_or_box($employee_id,$payment_fn,'Payment Proof',$no_img); ?></div>
    </div>
    <!-- =================== /PRINT-ONLY ATTACHMENT PAGES =================== -->

  </div></div>
</div></div>

<?php include __DIR__.'/../partials/footer.php'; ?>
</div>

<script>
// per-section highlight on radio
[['personal','sec-personal'],['academic','sec-academic'],['other','sec-other']].forEach(function(p){
  document.querySelectorAll('input[name="section_status['+p[0]+']"]').forEach(function(r){
    r.addEventListener('change',function(){
      var box=document.getElementById(p[1]); if(!box) return;
      box.classList.remove('ok','notok');
      if(this.value==='ok') box.classList.add('ok'); else box.classList.add('notok');
    });
  });
});
// attachment open in new tab on click
document.querySelectorAll('.att-card').forEach(function(c){
  c.addEventListener('click',function(e){ if(e.target.closest('a')) return; var u=this.getAttribute('data-url'); if(u && u.trim()!=='') window.open(u,'_blank','noopener'); });
});
</script>
</body>
</html>
