<?php
// File: admin/applications/review_by_section.php
// Requirements: mysqli only (no PDO), DB conn in ../../config.php, COLLATE=utf8mb4_general_ci.
// Sends an "Employee Onboarding Approved – Broriser" email on Approve, with dynamic
// "Documents Pending" (shown only for sections marked Not OK). Payment Proof is removed.

session_start();
require '../../config.php';

/* -------------------- Guards -------------------- */
if (!isset($_SESSION['admin']) || !isset($_SESSION['username'])) { header("Location: ".BASE_URL."admin/login"); exit; }
if (!isset($_GET['id']) || !is_numeric($_GET['id'])) { echo "Invalid application ID."; exit; }
$app_id = (int)$_GET['id'];
$username = mysqli_real_escape_string($conn, $_SESSION['username']);
$admin_q  = mysqli_query($conn, "SELECT * FROM admins WHERE username='{$username}' LIMIT 1");
$admin    = $admin_q ? mysqli_fetch_assoc($admin_q) : null;
/* -------------------- Fetch application --------------------- */
$q = mysqli_query($conn, "SELECT * FROM employee_applications WHERE id=$app_id LIMIT 1");
if (!$q || mysqli_num_rows($q)===0){ echo "Application not found."; exit; }
$app = mysqli_fetch_assoc($q);

/* -------------------- Helpers ------------------- */
function h($v){ return htmlspecialchars((string)($v??''), ENT_QUOTES, 'UTF-8'); }
$employee_id = !empty($app['employee_id']) ? $app['employee_id'] : (!empty($app['user_id']) ? $app['user_id'] : $app['id']);
function file_url($sid,$fn){ return "/onboarding/employee/employee-app/uploads/".rawurlencode($sid)."/".rawurlencode($fn); }
function is_img($n){ $e=strtolower(pathinfo((string)$n,PATHINFO_EXTENSION)); return in_array($e,['jpg','jpeg','png','gif','webp','bmp','avif']); }
function badge_class($s){ $s=strtolower((string)$s); if($s==='approved')return'bg-success'; if($s==='rejected')return'bg-danger'; if($s==='submitted'||$s==='pending')return'bg-warning text-dark'; return'bg-secondary'; }
$no_img = "/onboarding/employee/employee-app/uploads/no-image.png";

/* -------------------- CSRF ---------------------- */
if (empty($_SESSION['csrf_token'])) $_SESSION['csrf_token']=bin2hex(random_bytes(16));
$csrf=$_SESSION['csrf_token'];

/* ---- Load previous SECTION-level decisions ---- */
$sec_prev = ['personal'=>'','bank'=>'','academic'=>'','other'=>''];
$r = mysqli_query($conn,"SELECT section_key, section_status FROM application_section_reviews WHERE application_id=$app_id");
if($r){ while($row=mysqli_fetch_assoc($r)){ $sec_prev[$row['section_key']]=$row['section_status']; } }

/* -------------------- Email (SendGrid) ---------------------- */
/* Helper getters + pending builders */
function sg_onboarding_value($app,$keys,$fallback='—'){
    foreach((array)$keys as $k){ if(!empty($app[$k])) return $app[$k]; }
    return $fallback;
}
function build_onboarding_checklist(){
    return [
       
        'Acknowledge company policies (Code of Conduct, IT & Security, NDA)'
        
    ];
}
/** Build pending items per section (only what’s likely missing) */
function build_pending_by_section($app, $sec_status){
    $out = [];

    // PERSONAL
    if (($sec_status['personal'] ?? '') === 'not_ok'){
        $items = [];
        // core personal docs
        if (empty($app['passport_photo'])) $items[] = 'Recent passport-size photograph';
        // IDs shown under Personal in the portal
        $has_passport = !empty($app['passport_copy']);
        $has_aadhaar  = !empty($app['aadhar_front']) && !empty($app['aadhar_back']);
        if (!$has_passport && !$has_aadhaar) $items[] = 'Government ID: Passport copy OR Aadhaar (Front & Back)';
        // key profile fields
        $need_basic = 0;
        foreach(['first_name','surname','dob','gender','nationality'] as $k){ if(empty($app[$k])){ $need_basic=1; break; } }
        if ($need_basic) $items[] = 'Complete basic personal details (name / DOB / gender / nationality)';
        if (!empty($items)) $out['personal']=$items;
    }

    // ACADEMIC
    if (($sec_status['academic'] ?? '') === 'not_ok'){
        $items = [];
        if (empty($app['ssc_certificate']))  $items[] = '10th (SSC) Certificate / Marks';
        if (empty($app['inter_certificate'])) $items[] = '12th (INTER) Certificate / Marks';
        if (empty($app['neet_score'])) $items[] = '';
        if (!empty($items)) $out['academic']=$items;
    }
    if (($sec_status['bank'] ?? '') === 'not_ok'){
        $items = [];
        if (empty($app['bank_name']) || empty($app['account_number']) || empty($app['ifsc_code'])) {
            $items[] = "Bank Name / Account Number / IFSC Code missing";
        }
        if (empty($app['bank_document'])) {
            $items[] = "Bank Document (Passbook / Cheque Copy)";
        }
        if (!empty($items)) $out['bank'] = $items;
    }

    // OTHER
    if (($sec_status['other'] ?? '') === 'not_ok'){
        $items = [];
        if (empty($app['experience_letter']) && empty($app['experience_details'])) $items[] = 'Statement of Purpose (upload file or paste text)';
        if (!empty($items)) $out['other']=$items;
    }

    return $out;
}

function send_onboarding_approval_mail($app, $sec_status, &$err = null){
    if (empty($app['email'])) return ['ok'=>false,'msg'=>'Employee email not found'];
    $apiKey    = defined('SENDGRID_API_KEY') ? SENDGRID_API_KEY : '';
    $fromEmail = defined('SENDGRID_FROM_EMAIL') ? SENDGRID_FROM_EMAIL : '';
    $fromName  = defined('SENDGRID_FROM_NAME') ? SENDGRID_FROM_NAME : 'Investors Clinic HR';
    if ($apiKey === '' || $fromEmail === '') {
        return ['ok'=>false,'msg'=>'Email service not configured (API key or sender email missing)'];
    }

    $toEmail = $app['email'];
    $toName  = trim((string)sg_onboarding_value($app,['first_name'],'')) . ' ' . trim((string)sg_onboarding_value($app,['surname'],''));
    $toName  = trim($toName);

    // Details to show (skip Employee Code / Official Email / Official Phone / Start Date)
    $designation      = sg_onboarding_value($app, ['designation','position','role'], 'Trainee');
    $department       = sg_onboarding_value($app, ['department','dept'], '—');
    $workLocation     = sg_onboarding_value($app, ['work_location','location','office_location'], '—');
    $reportingManager = sg_onboarding_value($app, ['reporting_manager','Functional_Reporting'], '—');
    $officeAddress    = sg_onboarding_value($app, ['office_address'], 'Investors Clinic HQ, Noida');

    $portalBase = (defined('BASE_URL') ? rtrim(BASE_URL,'/').'/' : '/');
    $portalUrl  = $portalBase . "employee/onboarding";
    $today      = date('d M Y');

    $pending_by_section = build_pending_by_section($app, $sec_status);
    $has_pending = !empty($pending_by_section);

    // Section link anchors (adjust if your portal uses different IDs)
    $anchors = [
        'personal' => $portalUrl . '#section-personal',
        'bank'     => $portalUrl . '#section-bank',
        'academic' => $portalUrl . '#section-academic',
        'other'    => $portalUrl . '#section-other',
    ];

    // Build HTML "Documents Pending" block
    $pendingHtml = '';
    if ($has_pending){
        $pendingHtml .= '<div style="background:#fff7ed;border:1px solid #fde7d3;border-radius:12px;padding:14px;margin:14px 0">';
        $pendingHtml .= '<div style="font-weight:800;margin-bottom:6px">Action Required (sections marked <em>Not OK</em>)</div>';
        $pendingHtml .= '<p style="margin:0 0 8px 0">Click a section to open it in the portal and finish the required items.</p><ul style="margin:0 0 0 18px;padding:0">';
        foreach(['personal'=>'Personal Information','bank'=>'Bank Details','academic'=>'Academic Qualifications','other'=>'Other Details'] as $key=>$label){
            if (!isset($pending_by_section[$key])) continue;
            $pendingHtml .= '<li style="margin-top:8px"><strong>'.h($label).'</strong> — <span style="color:#dc2626">Not OK</span>';
            $pendingHtml .= '<ul style="margin:6px 0 10px 18px;padding:0">';
            foreach($pending_by_section[$key] as $it){ $pendingHtml .= '<li>'.h($it).'</li>'; }
            $pendingHtml .= '</ul>';
            $pendingHtml .= '<div><a href="'.h($anchors[$key]).'" style="text-decoration:none">Go to '.h($label).' →</a></div>';
            $pendingHtml .= '</li>';
        }
        $pendingHtml .= '</ul></div>';
    } else {
        $pendingHtml .= '<div style="background:#f0fdf4;border:1px solid #dcfce7;border-radius:12px;padding:14px;margin:14px 0">';
        $pendingHtml .= '<div style="font-weight:800;margin-bottom:6px">All sections are OK</div>';
        $pendingHtml .= '<p style="margin:0">No further documents are required at this time.</p></div>';
    }

    $subject = 'Employee Onboarding Approved – Investors Clinic';

    // HTML email
    $html = '
  <div style="font-family:Inter,Arial,sans-serif;background:#f6f7fb;padding:28px 0;color:#0f172a">
    <table role="presentation" cellpadding="0" cellspacing="0" align="center" width="680" style="background:#ffffff;border-radius:16px;overflow:hidden;border:1px solid #e8ecf3">
      <tr>
        <td style="padding:18px 22px;background:#0f172a;color:#fff">
          <div style="font-weight:800;font-size:18px">Investors Clinic</div>
          <div style="opacity:.85;font-size:12px">Employee Onboarding</div>
        </td>
      </tr>
      <tr><td style="height:10px;background:linear-gradient(90deg,#a2ff00,#00d6c4)"></td></tr>
      <tr>
        <td style="padding:22px">
          <p style="margin:0 0 12px 0;font-size:16px">Dear <strong>'.h($toName).'</strong>,</p>
          <p style="margin:0 0 14px 0">Great news — your <strong>employee onboarding has been approved</strong> at <strong>Investors Clinic</strong> as of <strong>'.h($today).'</strong>.</p>

          <div style="border:1px solid #e8ecf3;border-radius:12px;padding:16px;margin:14px 0">
            <div style="font-weight:800;margin-bottom:10px">Your Onboarding Details</div>
            <table cellpadding="0" cellspacing="0" width="100%" style="font-size:14px">
              <tr><td style="padding:6px 0;color:#475569;width:34%">Employee Name</td><td style="padding:6px 0">'.h(trim(($app['first_name'] ?? '').' '.($app['surname'] ?? ''))).'</td></tr>
              <tr><td style="padding:6px 0;color:#475569">Designation</td><td style="padding:6px 0">'.h($designation).'</td></tr>
              <tr><td style="padding:6px 0;color:#475569">Department</td><td style="padding:6px 0">'.h($department).'</td></tr>
              <tr><td style="padding:6px 0;color:#475569">Reporting Manager</td><td style="padding:6px 0">'.h($reportingManager).'</td></tr>
              <tr><td style="padding:6px 0;color:#475569">Work Location</td><td style="padding:6px 0">'.h($workLocation).'</td></tr>
              <tr><td style="padding:6px 0;color:#475569">Office Address</td><td style="padding:6px 0">'.h($officeAddress).'</td></tr>
            </table>
          </div>

          '.$pendingHtml.'

          <div style="margin:16px 0">
            <div style="font-weight:800;margin-bottom:6px">Next Steps</div>
            <ul style="margin:6px 0 10px 18px;padding:0">';
    foreach(build_onboarding_checklist() as $it){ $html .= '<li>'.h($it).'</li>'; }
    $html .= '
            </ul>
          </div>

          <div style="text-align:center;margin:18px 0 6px 0">
            

          <div style="border:1px dashed #d8dee9;border-radius:12px;padding:14px;margin:16px 0">
            <div style="font-weight:800;margin-bottom:6px">Help &amp; Support</div>
            <div>HR: <strong>hr@investors-clinic.com</strong> </div>
          </div>

          <p style="margin:18px 0 0 0">Welcome to Investors Clinic!<br><strong>HR Team</strong></p>
        </td>
      </tr>
      <tr><td style="height:10px;background:linear-gradient(90deg,#a2ff00,#00d6c4)"></td></tr>
      <tr><td style="padding:10px;text-align:center;color:#64748b;font-size:12px">© '.date('Y').' Investors Clinic</td></tr>
    </table>
  </div>';

    // Plain text
    $text  = "Employee Onboarding Approved – Investors Clinic\n\n";
    $text .= "Dear ".$toName.",\n\n";
    $text .= "Great news — your employee onboarding has been approved as of ".$today.".\n\n";
    $text .= "Onboarding Details:\n";
    $text .= " - Employee Name: ".trim(($app['first_name'] ?? '').' '.($app['surname'] ?? ''))."\n";
    $text .= " - Designation: ".$designation."\n";
    $text .= " - Department: ".$department."\n";
    $text .= " - Reporting Manager: ".$reportingManager."\n";
    $text .= " - Work Location: ".$workLocation."\n";
    $text .= " - Office Address: ".$officeAddress."\n\n";

    if ($has_pending){
        $text .= "Documents Pending (sections marked Not OK):\n";
        foreach(['personal'=>'Personal Information','bank'=>'Bank Details','academic'=>'Academic Qualifications','other'=>'Other Details'] as $key=>$label){
            if (!isset($pending_by_section[$key])) continue;
            $text .= " - ".$label." — Not OK\n";
            foreach($pending_by_section[$key] as $it){ $text .= "   • ".$it."\n"; }
            $text .= "   > Open: ".$anchors[$key]."\n";
        }
        $text .= "\n";
    } else {
        $text .= "All sections are OK — no further documents are required.\n\n";
    }
 
    $text .= "Next Steps:\n";
    foreach(build_onboarding_checklist() as $it){ $text .= " - ".$it."\n"; }
    $text .= "\nOnboarding Portal: ".$portalUrl."\n\n";
    $text .= "Help & Support: hr@investors-clinic.com \n\n";
    $text .= "Welcome to Investors Clinic!\nHR Team\n";

    // Prepare payload (SendGrid v3 API)
    $payload = [
        "from" => ["address" => $fromEmail, "name" => $fromName],
        "to"   => [
            ["email_address" => ["address" => $toEmail, "name" => $toName]]
        ],
        "subject"  => $subject,
        "htmlbody" => $html,
        "textbody" => $text
    ];

    $ch = curl_init("https://api.zeptomail.in/v1.1/email");
    curl_setopt_array($ch, [
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_HTTPHEADER     => [
            "Authorization: Zoho-enczapikey $apiKey",
            "Content-Type: application/json",
            "Accept: application/json"
        ],
        CURLOPT_POST       => true,
        CURLOPT_POSTFIELDS => json_encode($payload, JSON_UNESCAPED_UNICODE),
        CURLOPT_TIMEOUT    => 30,
        CURLOPT_SSL_VERIFYPEER => false,
        CURLOPT_SSL_VERIFYHOST => false
    ]);
    $resp = curl_exec($ch);
    $http = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    $curlErr = curl_error($ch);
    curl_close($ch);
    if ($curlErr){
        return ['ok'=>false,'msg'=>"cURL error: $curlErr"];
    }
    if (!in_array($http, [200,201,202])){
        return ['ok'=>false,'msg'=>"Zoho Mail Error (HTTP $http): ".($resp?:'No response')];
    }
    return ['ok'=>true,'msg'=>'Onboarding approval email sent'];
}

/* -------------------- POST ---------------------- */
$flash='';
if($_SERVER['REQUEST_METHOD']==='POST' && isset($_POST['csrf']) && $_POST['csrf']===$csrf){
  $act = $_POST['act'] ?? 'save';                     // save | approve | reject
  $section_status = $_POST['section_status'] ?? [];   // per-section radios

  // Save section statuses
  mysqli_query($conn,"DELETE FROM application_section_reviews WHERE application_id=$app_id");
  $stmt=mysqli_prepare($conn,"INSERT INTO application_section_reviews(application_id,section_key,section_label,section_status,reviewer,reviewed_at) VALUES(?,?,?,?,?,?)");
  $now=date('Y-m-d H:i:s'); $rev=$_SESSION['username'];
  if($stmt){
    $labels=['personal'=>'Personal Information','bank'=> 'Bank Details','academic'=>'Academic Qualifications','other'=>'Other Details'];
    foreach(['personal','bank','academic','other'] as $k){
      $st=(isset($section_status[$k]) && $section_status[$k]==='ok')?'ok':'not_ok';
      mysqli_stmt_bind_param($stmt,"isssss",$app_id,$k,$labels[$k],$st,$rev,$now);
      mysqli_stmt_execute($stmt);
      $sec_prev[$k]=$st;
    }
    mysqli_stmt_close($stmt);
  }

  // Save remarks + application_status
  $remarks=mysqli_real_escape_string($conn,trim($_POST['remarks']??''));
  $set='';
  if($act==='approve'||$act==='reject'){ $new=($act==='approve'?'approved':'rejected'); $set="application_status='".mysqli_real_escape_string($conn,$new)."',"; }
  @mysqli_query($conn,"UPDATE employee_applications SET $set status_remarks='$remarks', status_date='".date('Y-m-d H:i:s')."' WHERE id=$app_id LIMIT 1");

  if ($act==='approve'){
      $mail = send_onboarding_approval_mail($app, $sec_prev);
      $flash = ($mail['ok'] ? "Application approved and onboarding email sent." : "Application approved. ".$mail['msg']);
  } elseif ($act==='reject'){
      $flash = "Application rejected.";
  } else {
      $flash = "Review saved.";
  }
}
$resume_fn = '';
if (!empty($app['email'])) {
    $email = mysqli_real_escape_string($conn, trim($app['email']));
    $query = "SELECT resume FROM user_pif WHERE email = '$email' LIMIT 1";
    $result = mysqli_query($conn, $query);
    if ($result && mysqli_num_rows($result) > 0) {
        $row = mysqli_fetch_assoc($result);
        if (!empty($row['resume'])) {
            $resume_fn = $row['resume'];
        }
    }
}
/* ----------------- Subsection data (UI stays) ----------------- */
/* 1. Personal Information */
$sub_identity = [
  'Title' => $app['title'] ?? '',
  'First Name' => $app['first_name'] ?? '',
  'Surname' => $app['surname'] ?? '',
  'Gender' => $app['gender'] ?? '',
  'Preferred Language' => (function($a){ $b=$a['preferred_language']??''; if($b==='Others' && !empty($a['preferred_language_other'])) $b.=' - '.$a['preferred_language_other']; return $b; })($app),
  'Date of Birth' => $app['dob'] ?? '',
  'Nationality' => $app['nationality'] ?? '',
  'Country of Birth' => $app['country_of_birth'] ?? '',
];
$sub_contact = [
  'Mobile' => $app['mobile'] ?? '',
  'Email' => $app['email'] ?? '',
  'Address Line 1' => $app['addr_line1'] ?? '',
  'Address Line 2' => $app['addr_line2'] ?? '',
  'City / Town' => $app['city'] ?? '',
  'Postal Code' => $app['postal_code'] ?? '',
  'Country' => $app['country'] ?? 'India',
  'State / Province' => $app['state'] ?? '',
];
$sub_govt = [
  'Aadhar Number' => ((int)($app['has_passport'] ?? 0)===1) ? '' : ($app['aadhar_number'] ?? ''),
  'Pan Number' => ((int)($app['has_passport'] ?? 0)===1) ? '' : ($app['pan_number'] ?? ''),
];

/* Attachments per SUBSECTION */
$att_identity = [ 'Photo' => $app['passport_photo'] ?? '' ];
if (!empty($resume_fn)) {
  $att_identity['Resume'] = $resume_fn;
}
$att_contact  = [];
$att_govt     = [];
if (!empty($app['passport_copy'])) { $att_govt['Passport Copy'] = $app['passport_copy']; }
else {
  $att_govt['Aadhaar Front'] = !empty($app['aadhar_front']) ? $app['aadhar_front'] : ($app['aadhar_copy'] ?? '');
  $att_govt['Aadhaar Back']  = $app['aadhar_back'] ?? '';
  $att_govt['Pan Card'] = $app['pan_card'] ?? '';
}
/* 3. Bank Details */
$sub_bank = [
  'Bank Name'       => $app['bank_name'] ?? '',
  'Account Number'  => $app['account_number'] ?? '',
  'IFSC Code'       => $app['ifsc_code'] ?? '',
  'Document Available' => !empty($app['bank_document']) ? "Yes" : "NA",
];

$att_bank = [
  'Bank Document' => $app['bank_document'] ?? ''
];

/* 2. Academic Qualifications */
$sub_entrance = [
  
];
$sub_ssc = [
  'SSC Year' => $app['ssc_year'] ?? '',
  'SSC School' => $app['ssc_school'] ?? '',
  'SSC Board' => $app['ssc_board'] ?? '',
  'Grade / Percentage' => $app['ssc_grade'] ?? '',
  'SSC Certificate Available' => !empty($app['ssc_certificate']) ? "Yes" : "NA",
];
$att_ssc = [ 'SSC Certificate' => $app['ssc_certificate'] ?? '' ];
$sub_inter = [
  'INTER Year' => $app['inter_year'] ?? '',
  'INTER School' => $app['inter_school'] ?? '',
  'INTER Board' => $app['inter_board'] ?? '',
  'Grade / Percentage' => $app['inter_grade'] ?? '',
  'Inter Certificate Available' => !empty($app['inter_certificate']) ? "Yes" : "NA",
];
$att_inter = [ 'INTER Certificate' => $app['inter_certificate'] ?? '' ];
$sub_ug = [
  'Graduation Year' => $app['grad_year'] ?? '',
  'Graduation College' => $app['grad_college'] ?? '',
  'Title' => $app['grad_title'] ?? '',
  'Grade / Percentage' => $app['grad_grade'] ?? '',
  'Certificate Available' => !empty($app['ug_certificate']) ? "Yes" : "NA",
];
$att_ug = [ 'Graduation Certificate' => $app['ug_certificate'] ?? '' ];
$sub_pg = [
  'Post Graduation Year' => $app['pg_year'] ?? '',
  'PG College' => $app['pg_college'] ?? '',
  'Title' => $app['pg_title'] ?? '',
  'Grade / Percentage' => $app['pg_grade'] ?? '',
  'Certificate Available' => !empty($app['pg_certificate']) ? "Yes" : "NA",
];
$att_pg = [ 'Post Graduation Certificate' => $app['pg_certificate'] ?? '' ];
$att_other = [ 'Other Certificate' => $app['other_certificate'] ?? '' ];
/* 3. Other Details */
$sub_application = [
  'Application Status' => $app['application_status'] ?? '',
  'Previous Roles & Responsibilities' => $app['experience_details'] ?? '',
];
$att_application = 
[ 
  'Experience Letter' => $app['experience_letter'] ?? '',
  'Salary Proof' => $app['salary_proof'] ?? '',
  'Salary Slip' => $app['salary_slip'] ?? '',
  'ITR' => $app['itr'] ?? '',
  'Agreement' => $app['agreement'] ?? '',
  'Payment Proof' => $app['payment_proof'] ?? '',
];

/* Meta */
$status = $app['application_status'] ?? 'submitted';
$submitted_at = $app['submitted_at'] ?? '';
$status_date = $app['status_date'] ?? '';
function has_any_ug_data($app) {
  return !empty($app['ug_school']) || !empty($app['ug_address']) || !empty($app['ug_stream']) ||
         !empty($app['ug_avg_grade']) || !empty($app['ug_pcb_percent']) || !empty($app['ug_avg_percent']) ||
         !empty($app['ug_degree_available']) || !empty($app['ug_certificate']);
}
function has_any_pg_data($app) {
  return !empty($app['pg_school']) || !empty($app['pg_stream']) ||
         !empty($app['pg_avg_grade']) || !empty($app['pg_pcb_percent']) || !empty($app['pg_avg_percent']) ||
         !empty($app['pg_degree_available']) || !empty($app['pg_certificate']);
}
?>
<!doctype html>
<html lang="en">
<head>
<meta charset="utf-8"/><meta name="viewport" content="width=device-width, initial-scale=1"/>
<title>Application #<?= h($app_id) ?> — Section Review</title>
<?php include __DIR__.'/../partials/head.php'; ?>
<style>
.viewer-wrap{display:flex;justify-content:center;padding:22px;background:linear-gradient(180deg,#f5f7ff 0,#fff 100%)}
.doc{background:#fff;color:#111827;width:1240px;max-width:100%;padding:18px;border-radius:16px;border:1px solid rgba(0,0,0,.06);box-shadow:0 14px 34px rgba(0,0,0,.10)}
.doc-head{display:flex;gap:12px;align-items:center;margin-bottom:12px}
.doc-head .title{font-weight:800;font-size:22px}
.doc-head .meta{margin-left:auto;display:flex;gap:8px;align-items:center}
.badge{padding:6px 10px;border-radius:999px;font-weight:700;font-size:12px}

/* Section frame + header + radios */
.section{border:2px solid #6d78ff;border-radius:12px;margin-bottom:16px;box-shadow:0 0 0 6px rgba(109,120,255,.06) inset; page-break-inside: avoid;}
.section.ok{border-color:#10b981;box-shadow:0 0 0 6px rgba(16,185,129,.12) inset}
.section.notok{border-color:#ef4444;box-shadow:0 0 0 6px rgba(239,68,68,.12) inset}
.sec-head{display:flex;align-items:center;gap:12px;padding:12px 14px;border-bottom:1px dashed rgba(0,0,0,.08)}
.sec-title{font-weight:800;font-size:18px}
.sec-radios{margin-left:auto}
.sec-body{padding:6px 10px}

/* SUB-box */
.subbox{margin:10px 0;border:2px solid #dce3ff;border-radius:12px}
.subbox .subbody{display:grid;grid-template-columns:1fr 310px;gap:14px;padding:12px}
.subbox .subhead{display:flex;align-items:center;gap:8px;padding:10px 12px;background:#fbfdff;border-bottom:1px solid #e6ebf5}
.subbox .subhead .label{font-weight:800}

/* Left: values */
.kv{display:grid;grid-template-columns:repeat(4,1fr);gap:12px}
.kv .formish{display:flex;flex-direction:column}
.kv label{font-weight:700;font-size:.9rem;color:#0f172a;margin-bottom:6px}
.kv .ro{background:#fff;border:1px solid #e5e7eb;border-radius:8px;padding:.65rem .8rem;min-height:40px}

/* Right: attachments */
.side{display:flex;flex-direction:column;gap:12px}
.side-new{display:flex;flex-wrap:wrap;gap:12px}
.att-card{cursor:pointer;background:#ffffff;border:2px solid #b7eb30;border-radius:14px;padding:8px;box-shadow:0 0 0 6px rgba(183,235,48,.15) inset;text-align:center;transition:.2s}
.att-card:hover{transform:translateY(-1px)}
.att-card .title{font-weight:800;margin-bottom:6px}
.att-card img{width:100%;height:180px;object-fit:cover;border-radius:10px;border:2px solid #fff;background:#f0f7d7}
.file-pill{display:inline-block;border:1px solid #1f2937;border-radius:999px;padding:6px 10px;background:#f9ffe0}
.file-pill a{text-decoration:none;color:#111827}
.muted{color:#475569}

/* --- Reviewer Remarks --- */
.review-bar{position:sticky;bottom:0;z-index:9;margin-top:18px}
.remark-shell{display:flex;align-items:stretch;background:#0c1324;border:1px solid rgba(255,255,255,.6);border-radius:12px;padding:8px}
.remark-shell .left{flex:1;display:flex;flex-direction:column}
.remark-shell label{color:#e5e7eb;font-weight:700;margin:0 0 6px 4px}
.remark-shell textarea{flex:1;border:0;background:transparent;color:#e5e7eb;resize:vertical;min-height:56px;outline:none}
.remark-shell .btns{display:flex;gap:10px;align-items:center;margin-left:10px}
.remark-shell .btns .btn{border-radius:12px;font-weight:800;padding:.7rem 1.1rem;border:1px solid rgba(255,255,255,.6)}
.remark-shell .btn-reject{background:#ff5aa0;color:#fff;border-color:#ff5aa0}
.remark-shell .btn-approve{background:#00d6c4;color:#04222a;border-color:#00d6c4}

/* Print */
.screen-only{display:block}
.print-only{display:none}
@media print{
  #main-wrapper .app-header,#main-wrapper .left-sidebar,#main-wrapper .app-topstrip,.review-bar,.top-actions,.sec-radios{display:none!important;}
  .viewer-wrap{padding:0;background:#fff}
  .doc{box-shadow:none;border:0}
  #sec-personal{page-break-after: always;}
  #sec-academic{page-break-after: always;}
  #sec-other{page-break-after: always;}
  .print-only{display:block}
  .print-page{page-break-before: always; padding-top:12px;}
  .print-title{font-weight:800;font-size:18px;margin:6px 0 10px 0;}
  .print-grid-2{display:grid;grid-template-columns:1fr 1fr;gap:14px}
  .print-img{width:100%;height:980px;object-fit:contain;border:1px solid #ddd;padding:6px;border-radius:8px}
  .print-box{border:1px solid #ddd;border-radius:8px;padding:10px;height:980px}
}
@media (max-width: 1100px){
  .subbox .subbody{grid-template-columns:1fr}
  .kv{grid-template-columns:repeat(2,1fr)}
}
.new-text-container {
  margin-bottom: 20px;
}
.new-side {
  display: flex;
  flex-wrap: wrap;
  gap: 16px;
  justify-content: flex-start;
}
.new-att-card {
  flex: 1 1 30%;
  max-width: 30%;
  cursor: pointer;
  background: #ffffff;
  border: 2px solid #b7eb30;
  border-radius: 14px;
  padding: 8px;
  box-shadow: 0 0 0 6px rgba(183,235,48,.15) inset;
  text-align: center;
  transition: .2s;
}

.new-att-card:hover {
  transform: translateY(-1px);
}

.new-title {
  font-weight: 800;
  margin-bottom: 6px;
}

.new-img {
  width: 100%;
  height: 180px;
  object-fit: cover;
  border-radius: 10px;
  border: 2px solid #fff;
  background: #f0f7d7;
}

.new-file-pill a {
  color: #1890ff;
  text-decoration: none;
}

.new-muted {
  color: #888;
  font-style: italic;
  margin-top: 4px;
}

@media (max-width: 767px) {
  .new-att-card {
    flex: 1 1 100%;
    max-width: 100%;
  }
}

</style>
</head>
<body class="d-flex flex-column min-vh-100">
<div class="page-wrapper d-flex flex-column flex-grow-1" id="main-wrapper" data-layout="vertical" data-navbarbg="skin6" data-sidebartype="full" data-sidebar-position="fixed" data-header-position="fixed">
<?php include __DIR__.'/../partials/header.php'; include __DIR__.'/../partials/sidebar.php'; ?>

<div class="body-wrapper"><div class="body-wrapper-inner container-fluid">
  <div class="viewer-wrap"><div class="doc">

    <div class="doc-head">
      <div class="title">Application #<?= h($app_id) ?> — Section Review</div>
      <div class="top-actions" style="display:flex;gap:10px"><button type="button" class="btn btn-outline-dark" onclick="window.print()">🖨 Print / Save PDF</button></div>
      <div class="meta">
        <span class="badge <?= h(badge_class($status)) ?>"><?= strtoupper(h($status)) ?></span>
        <?php if($submitted_at){ ?><span class="badge bg-light text-dark">Submitted: <?= h($submitted_at) ?></span><?php } ?>
        <?php if($status_date){ ?><span class="badge bg-light text-dark">Last Action: <?= h($status_date) ?></span><?php } ?>
      </div>
    </div>

    <?php if(!empty($flash)){ ?><div class="alert alert-info py-2 px-3 mb-3 screen-only"><?= h($flash) ?></div><?php } ?>

    <form method="post">
      <input type="hidden" name="csrf" value="<?= h($csrf) ?>">

      <!-- 1. Personal Information -->
      <div class="section <?= ($sec_prev['personal']==='ok'?'ok':($sec_prev['personal']==='not_ok'?'notok':'')) ?>" id="sec-personal">
        <div class="sec-head">
          <div class="sec-title">1. Personal Information</div>
          <div class="sec-radios screen-only">
            <label class="me-2"><input type="radio" name="section_status[personal]" value="ok" <?= ($sec_prev['personal']==='ok'?'checked':'') ?>> OK</label>
            <label><input type="radio" name="section_status[personal]" value="not_ok" <?= ($sec_prev['personal']==='not_ok'?'checked':'') ?>> Not OK</label>
          </div>
        </div>
        <div class="sec-body">

          <!-- A. Identity & Basic Info -->
          <div class="subbox">
            <div class="subhead"><div class="label">A. Identity &amp; Basic Info</div></div>
            <div class="subbody">
              <div>
                <div class="kv">
                  <?php foreach($sub_identity as $lbl=>$val){ ?>
                    <div class="formish"><label><?= h($lbl) ?></label><div class="ro"><?= nl2br(h($val)) ?></div></div>
                  <?php } ?>
                </div>
              </div>
              <aside class="side">
                <?php
                if (!empty($att_identity['Photo'])):
                  $fn = $att_identity['Photo'];
                  $url = file_url($employee_id, $fn);
                  $is_img = is_img($fn);
                  ?>
                  <div class="att-card" data-url="<?= h($url) ?>">
                    <div class="title">Photo</div>
                    <?php if ($is_img): ?>
                      <img src="<?= h($url) ?>" alt="Photo">
                    <?php else: ?>
                      <div class="file-pill"><a href="<?= h($url) ?>" target="_blank" rel="noopener">Open</a></div>
                    <?php endif; ?>
                  </div>
                <?php endif; ?>

                <?php
                if (!empty($att_identity['Resume'])):
                  $resume_fn = $att_identity['Resume'];
                  $resume_url = file_url($employee_id, $resume_fn);
                  ?>
                  <div class="att-card" data-url="<?= h($resume_url) ?>">
                    <div class="title">Resume</div>
                    <div class="file-pill">
                      <a href="<?= h($resume_url) ?>" target="_blank" rel="noopener" class="btn btn-sm btn-outline-primary">View Resume</a>
                    </div>
                  </div>
                <?php endif; ?>
              </aside>
            </div>
          </div>

          <!-- B. Contact Information -->
          <div class="subbox">
            <div class="subhead"><div class="label">B. Contact Information</div></div>
            <div class="subbody">
              <div>
                <div class="kv">
                  <?php foreach($sub_contact as $lbl=>$val){ if($lbl==='Address Line 2' && $val==='') continue; ?>
                    <div class="formish"><label><?= h($lbl) ?></label><div class="ro"><?= nl2br(h($val)) ?></div></div>
                  <?php } ?>
                </div>
              </div>
              <aside class="side"><!-- (no attachments here) --></aside>
            </div>
          </div>

          <!-- C. Government IDs -->
          <div class="subbox new-subbox">
            <div class="subhead new-subhead">
              <div class="label new-label">C. Government IDs</div>
            </div>
            <div class="subbody new-subbody">
                <div class="kv new-kv">
                  <?php foreach($sub_govt as $lbl=>$val){ if($val===''||$val===null) continue; ?>
                    <div class="formish new-formish">
                      <label class="new-label-text"><?= h($lbl) ?></label>
                      <div class="ro new-ro"><?= nl2br(h($val)) ?></div>
                    </div>
                  <?php } ?>
                </div>
              </div>
              <aside class="side-new new-side">
                <?php foreach($att_govt as $label=>$fn){
                  $has=!empty($fn); 
                  $url=$has?file_url($employee_id,$fn):''; 
                  $is=$has?is_img($fn):false; ?>
                  <div class="att-card new-att-card" <?= $has?'data-url="'.h($url).'"':'' ?>>
                    <div class="title new-title"><?= h($label) ?></div>
                    <?php if($has && $is){ ?>
                      <img src="<?= h($url) ?>" alt="<?= h($label) ?>" class="new-img">
                    <?php } elseif($has){ ?>
                      <div class="file-pill new-file-pill"><a href="<?= h($url) ?>" target="_blank" rel="noopener">Open</a></div>
                    <?php } else { ?>
                      <img src="<?= h($no_img) ?>" alt="No Image" class="new-img">
                      <div class="muted new-muted">No Image</div>
                    <?php } ?>
                  </div>
                <?php } ?>
              </aside>
            </div>
          </div>
         </div>
        <!-- 3. Bank Details -->
        <div class="section <?= ($sec_prev['bank']==='ok'?'ok':($sec_prev['bank']==='not_ok'?'notok':'')) ?>" id="sec-bank">
          <div class="sec-head">
            <div class="sec-title">2. Bank Details</div>
            <div class="sec-radios screen-only">
              <label class="me-2"><input type="radio" name="section_status[bank]" value="ok" <?= ($sec_prev['bank']==='ok'?'checked':'') ?>> OK</label>
              <label><input type="radio" name="section_status[bank]" value="not_ok" <?= ($sec_prev['bank']==='not_ok'?'checked':'') ?>> Not OK</label>
            </div>
          </div>
          <div class="sec-body">
            <div class="subbox">
              <div class="subhead"><div class="label">A. Bank Information</div></div>
              <div class="subbody">
                <!-- Left side values -->
                <div>
                  <div class="kv">
                    <?php foreach($sub_bank as $lbl=>$val){ if($val==='' || $val===null) continue; ?>
                      <div class="formish">
                        <label><?= h($lbl) ?></label>
                        <div class="ro"><?= nl2br(h($val)) ?></div>
                      </div>
                    <?php } ?>
                  </div>
                </div>
                <!-- Right side attachment -->
                <aside class="side">
                  <?php foreach($att_bank as $label=>$fn){
                    $has = !empty($fn);
                    $url = $has ? file_url($employee_id,$fn) : '';
                    $is  = $has ? is_img($fn) : false;
                  ?>
                    <div class="att-card" <?= $has?'data-url="'.h($url).'"':'' ?>>
                      <div class="title"><?= h($label) ?></div>
        
                      <?php if($has && $is){ ?>
                          <img src="<?= h($url) ?>" alt="<?= h($label) ?>">
                      <?php } elseif($has){ ?>
                          <div class="file-pill"><a href="<?= h($url) ?>" target="_blank" rel="noopener">Open</a></div>
                      <?php } else { ?>
                          <img src="<?= h($no_img) ?>" alt="No Image">
                          <div class="muted">No Document</div>
                      <?php } ?>
                    </div>
                  <?php } ?>
                </aside>
              </div>
            </div>
          </div>
        </div>
      <!-- 2. Academic Qualifications -->
      <div class="section <?= ($sec_prev['academic']==='ok'?'ok':($sec_prev['academic']==='not_ok'?'notok':'')) ?>" id="sec-academic">
        <div class="sec-head">
          <div class="sec-title">3. Academic Qualifications</div>
          <div class="sec-radios screen-only">
            <label class="me-2"><input type="radio" name="section_status[academic]" value="ok" <?= ($sec_prev['academic']==='ok'?'checked':'') ?>> OK</label>
            <label><input type="radio" name="section_status[academic]" value="not_ok" <?= ($sec_prev['academic']==='not_ok'?'checked':'') ?>> Not OK</label>
          </div>
        </div>
        <div class="sec-body">

          <!-- A. Entrance Exams -->
          <div class="subbox">
            <div class="subhead"><div class="label">A. Entrance Exams</div></div>
            <div class="subbody">
              <div><div class="kv">
                <?php foreach($sub_entrance as $lbl=>$val){ if($val===''||$val===null) continue; ?>
                  <div class="formish"><label><?= h($lbl) ?></label><div class="ro"><?= nl2br(h($val)) ?></div></div>
                <?php } ?>
              </div></div>
              <aside class="side"></aside>
            </div>
          </div>

          <!-- B. Secondary Education (SSC / 10th) -->
          <div class="subbox">
            <div class="subhead"><div class="label">B. Secondary Education (SSC / 10th)</div></div>
            <div class="subbody">
              <div><div class="kv">
                <?php foreach($sub_ssc as $lbl=>$val){ if($val===''||$val===null) continue; ?>
                  <div class="formish"><label><?= h($lbl) ?></label><div class="ro"><?= nl2br(h($val)) ?></div></div>
                <?php } ?>
              </div></div>
              <aside class="side">
                <?php foreach($att_ssc as $label=>$fn){
                  $has=!empty($fn); $url=$has?file_url($employee_id,$fn):''; $is=$has?is_img($fn):false; ?>
                  <div class="att-card" <?= $has?'data-url="'.h($url).'"':'' ?>>
                    <div class="title"><?= h($label) ?></div>
                    <?php if($has && $is){ ?><img src="<?= h($url) ?>" alt="<?= h($label) ?>"><?php }
                          elseif($has){ ?><div class="file-pill"><a href="<?= h($url) ?>" target="_blank" rel="noopener">Open</a></div><?php }
                          else { ?><img src="<?= h($no_img) ?>" alt="No Image"><div class="muted">No Image</div><?php } ?>
                  </div>
                <?php } ?>
              </aside>
            </div>
          </div>

          <!-- C. Higher Secondary Education (Intermediate / 12th) -->
          <div class="subbox">
            <div class="subhead"><div class="label">C. Higher Secondary Education (Intermediate / 12th)</div></div>
            <div class="subbody">
              <div><div class="kv">
                <?php foreach($sub_inter as $lbl=>$val){ if($val===''||$val===null) continue; ?>
                  <div class="formish"><label><?= h($lbl) ?></label><div class="ro"><?= nl2br(h($val)) ?></div></div>
                <?php } ?>
              </div></div>
              <aside class="side">
                <?php foreach($att_inter as $label=>$fn){
                  $has=!empty($fn); $url=$has?file_url($employee_id,$fn):''; $is=$has?is_img($fn):false; ?>
                  <div class="att-card" <?= $has?'data-url="'.h($url).'"':'' ?>>
                    <div class="title"><?= h($label) ?></div>
                    <?php if($has && $is){ ?><img src="<?= h($url) ?>" alt="<?= h($label) ?>"><?php }
                          elseif($has){ ?><div class="file-pill"><a href="<?= h($url) ?>" target="_blank" rel="noopener">Open</a></div><?php }
                          else { ?><img src="<?= h($no_img) ?>" alt="No Image"><div class="muted">No Image</div><?php } ?>
                  </div>
                <?php } ?>
              </aside>
            </div>
          </div>
          <?php if (has_any_ug_data($app)) { ?>
            <!-- D. Graduation -->
            <div class="subbox">
              <div class="subhead"><div class="label">D. Graduation</div></div>
              <div class="subbody">
                <div><div class="kv">
                  <?php foreach($sub_ug as $lbl=>$val){ if($val===''||$val===null) continue; ?>
                    <div class="formish"><label><?= h($lbl) ?></label><div class="ro"><?= nl2br(h($val)) ?></div></div>
                  <?php } ?>
                </div></div>
                <aside class="side">
                  <?php foreach($att_ug as $label=>$fn){
                    $has=!empty($fn); $url=$has?file_url($employee_id,$fn):''; $is=$has?is_img($fn):false; ?>
                    <div class="att-card" <?= $has?'data-url="'.h($url).'"':'' ?>>
                      <div class="title"><?= h($label) ?></div>
                      <?php if($has && $is){ ?><img src="<?= h($url) ?>" alt="<?= h($label) ?>"><?php }
                            elseif($has){ ?><div class="file-pill"><a href="<?= h($url) ?>" target="_blank" rel="noopener">Open</a></div><?php }
                            else { ?><img src="<?= h($no_img) ?>" alt="No Image"><div class="muted">No Image</div><?php } ?>
                    </div>
                  <?php } ?>
                </aside>
              </div>
            </div>
          <?php } ?>
          <?php if (has_any_pg_data($app)) { ?>
            <!-- E. Post Graduation -->
            <div class="subbox">
              <div class="subhead"><div class="label">E. Post Graduation</div></div>
              <div class="subbody">
                <div><div class="kv">
                  <?php foreach($sub_pg as $lbl=>$val){ if($val===''||$val===null) continue; ?>
                    <div class="formish"><label><?= h($lbl) ?></label><div class="ro"><?= nl2br(h($val)) ?></div></div>
                  <?php } ?>
                </div></div>
                <aside class="side">
                  <?php foreach($att_pg as $label=>$fn){
                    $has=!empty($fn); $url=$has?file_url($employee_id,$fn):''; $is=$has?is_img($fn):false; ?>
                    <div class="att-card" <?= $has?'data-url="'.h($url).'"':'' ?>>
                      <div class="title"><?= h($label) ?></div>
                      <?php if($has && $is){ ?><img src="<?= h($url) ?>" alt="<?= h($label) ?>"><?php }
                            elseif($has){ ?><div class="file-pill"><a href="<?= h($url) ?>" target="_blank" rel="noopener">Open</a></div><?php }
                            else { ?><img src="<?= h($no_img) ?>" alt="No Image"><div class="muted">No Image</div><?php } ?>
                    </div>
                  <?php } ?>
                </aside>
              </div>
            </div>
          <?php } ?>
          <?php if (!empty($app['other_certificate']) || !empty($app['other_qualification'])) { 
              $fn = $app['other_certificate'] ?? '';
              $url = $fn ? file_url($employee_id, $fn) : '';
              $is = $fn ? is_img($fn) : false;
            ?>
              <!-- F. Other Certificate -->
              <div class="subbox">
                <div class="subhead"><div class="label">F. Other Qualification / Certificate</div></div>
                <div class="subbody">
                  <div><div class="kv">
                    <?php if (!empty($app['other_qualification'])) { ?>
                      <div class="formish" style="grid-column:1/-1">
                        <label>Other Qualification</label>
                        <div class="ro"><?= nl2br(h($app['other_qualification'])) ?></div>
                      </div>
                    <?php } ?>
                  </div></div>
                  <aside class="side">
                    <?php if (!empty($fn)) { ?>
                      <div class="att-card" data-url="<?= h($url) ?>">
                        <div class="title">Other Certificate</div>
                        <?php if ($is) { ?>
                          <img src="<?= h($url) ?>" alt="Other Certificate">
                        <?php } else { ?>
                          <div class="file-pill"><a href="<?= h($url) ?>" target="_blank" rel="noopener">Open</a></div>
                        <?php } ?>
                      </div>
                    <?php } else { ?>
                      <img src="<?= h($no_img) ?>" alt="No Image">
                      <div class="muted">No Certificate Uploaded</div>
                    <?php } ?>
                  </aside>
                </div>
              </div>
            <?php } ?>
        </div>
      </div>

      <!-- 4. Other Details -->
      <div class="section <?= ($sec_prev['other']==='ok'?'ok':($sec_prev['other']==='not_ok'?'notok':'')) ?>" id="sec-other">
        <div class="sec-head">
          <div class="sec-title">4. Other Details</div>
          <div class="sec-radios screen-only">
            <label class="me-2"><input type="radio" name="section_status[other]" value="ok" <?= ($sec_prev['other']==='ok'?'checked':'') ?>> OK</label>
            <label><input type="radio" name="section_status[other]" value="not_ok" <?= ($sec_prev['other']==='not_ok'?'checked':'') ?>> Not OK</label>
          </div>
        </div>
        <div class="sec-body">

          <!-- A. Application Process -->
          <div class="new-subbox">
            <div class="subhead"><div class="label">A. Application Process</div></div>
            <div class="subbody new-subbody">
              <div><div class="kv">
                <?php foreach($sub_application as $lbl=>$val){ if($val===''||$val===null) continue; ?>
                  <div class="formish" <?= $lbl==='Applicant Statement'?'style="grid-column:1/-1"':'' ?>><label><?= h($lbl) ?></label><div class="ro"><?= nl2br(h($val)) ?></div></div>
                <?php } ?>
              </div></div>
              <aside class="new-side mt-2">
                  <?php foreach($att_application as $label => $fn) {$has = !empty($fn);
                      if (!$has) continue; $url = file_url($employee_id, $fn); $is = is_img($fn); ?>
                      <div class="new-att-card" data-url="<?= h($url) ?>">
                        <div class="new-title"><?= h($label) ?></div>
                        <?php if ($is) { ?><img src="<?= h($url) ?>" alt="<?= h($label) ?>" class="new-img">
                        <?php } else { ?><div class="new-file-pill"><a href="<?= h($url) ?>" target="_blank" rel="noopener">Open</a></div>
                        <?php } ?>
                      </div>
                  <?php } ?>
                </aside>

            </div>
          </div>

          <!-- (Payment Proof section removed) -->

        </div>
      </div>

      <!-- Reviewer Remarks -->
      <?php if (($app['application_status'] ?? '') !== 'approved' && ($app['application_status'] ?? '') !== 'rejected') { ?>
        <div class="review-bar screen-only">
          <div class="remark-shell">
            <div class="left">
              <label>Reviewer Remarks</label>
              <textarea name="remarks" placeholder="Notes for approval/rejection..." maxlength="1000"></textarea>
            </div>
            <div class="btns">
              <button type="submit" name="act" value="reject" class="btn btn-reject" onclick="return confirm('Reject this application?');">Reject</button>
              <button type="submit" name="act" value="approve" class="btn btn-approve" onclick="return confirm('Approve this application and email the employee?');">Approve</button>
            </div>
          </div>
        </div>
      <?php } ?>
        </div>
      </div>
    </form>

    <!-- =================== PRINT-ONLY ATTACHMENT PAGES =================== -->
    <?php
      $photo_fn       = $app['passport_photo'] ?? '';
      $passport_fn    = $app['passport_copy'] ?? '';
      $a_front_fn     = !empty($app['aadhar_front']) ? $app['aadhar_front'] : ($app['aadhar_copy'] ?? '');
      $a_back_fn      = $app['aadhar_back'] ?? '';
      $ssc_fn         = $app['ssc_certificate'] ?? '';
      $inter_fn       = $app['inter_certificate'] ?? '';
      $statement_fn   = $app['experience_letter'] ?? '';
      function print_img_or_box($sid,$fn,$title,$no_img){
        if(!empty($fn) && is_img($fn)){ echo '<img class="print-img" src="'.h(file_url($sid,$fn)).'" alt="'.h($title).'">'; }
        elseif(!empty($fn)){ echo '<div class="print-box"><div style="font-weight:700;margin-bottom:6px">'.h($title).'</div><div>File: '.h($fn).'</div><div>URL: '.h(file_url($sid,$fn)).'</div></div>'; }
        else { echo '<img class="print-img" src="'.h($no_img).'" alt="No Image">'; }
      }
    ?>
    <div class="print-only">
      <div class="print-page"><div class="print-title">Photo</div><?php print_img_or_box($employee_id,$photo_fn,'Photo',$no_img); ?></div>
      <div class="print-page">
        <?php if(!empty($passport_fn)){ ?>
          <div class="print-title">Passport Copy</div><?php print_img_or_box($employee_id,$passport_fn,'Passport Copy',$no_img); ?>
        <?php } else { ?>
          <div class="print-title">Aadhaar Front &amp; Back</div>
          <div class="print-grid-2">
            <div><?php print_img_or_box($employee_id,$a_front_fn,'Aadhaar Front',$no_img); ?></div>
            <div><?php print_img_or_box($employee_id,$a_back_fn,'Aadhaar Back',$no_img); ?></div>
          </div>
        <?php } ?>
      </div>
      <div class="print-page"><div class="print-title">10th (SSC) Certificate</div><?php print_img_or_box($employee_id,$ssc_fn,'SSC Certificate',$no_img); ?></div>
      <div class="print-page"><div class="print-title">12th (INTER) Certificate</div><?php print_img_or_box($employee_id,$inter_fn,'INTER Certificate',$no_img); ?></div>
      <div class="print-page"><div class="print-title">Experience Letter</div><?php print_img_or_box($employee_id,$statement_fn,'Experience Letter',$no_img); ?></div>
      <!-- Payment Proof print page removed -->
    </div>
    <!-- =================== /PRINT-ONLY ATTACHMENT PAGES =================== -->

  </div></div>
</div></div>

<?php include __DIR__.'/../partials/footer.php'; ?>
</div>

<script>
// per-section highlight on radio
[['personal','sec-personal'],['bank','sec-bank'],['academic','sec-academic'],['other','sec-other']].forEach(function(p){
  document.querySelectorAll('input[name="section_status['+p[0]+']"]').forEach(function(r){
    r.addEventListener('change',function(){
      var box=document.getElementById(p[1]); if(!box) return;
      box.classList.remove('ok','notok');
      if(this.value==='ok') box.classList.add('ok'); else box.classList.add('notok');
    });
  });
});
// attachment open in new tab on click
document.querySelectorAll('.att-card').forEach(function(c){
  c.addEventListener('click',function(e){ if(e.target.closest('a')) return; var u=this.getAttribute('data-url'); if(u && u.trim()!=='') window.open(u,'_blank','noopener'); });
});
</script>
</body>
</html>
