<?php
session_start();
require '../../config.php';

/* --- Force connection charset + collation to match your standard --- */
mysqli_set_charset($conn, 'utf8mb4');
@mysqli_query($conn, "SET collation_connection = 'utf8mb4_general_ci'");

if (!isset($_SESSION['admin']) || !isset($_SESSION['username'])) {
  header("Location: " . BASE_URL . "admin/login");
  exit;
}

$username = mysqli_real_escape_string($conn, $_SESSION['username']);
$admin_q  = mysqli_query($conn, "SELECT * FROM admins WHERE username='{$username}' LIMIT 1");
$admin    = $admin_q ? mysqli_fetch_assoc($admin_q) : null;

/**
 * FIX for: Illegal mix of collations (utf8mb4_general_ci vs utf8mb4_0900_ai_ci)
 * We force the collation on both sides of the comparison to utf8mb4_general_ci.
 * Using NOT EXISTS avoids LEFT JOIN NULL-trap and is usually faster with proper indexing.
 */
$sql = "
  SELECT DISTINCT s.id, s.first_name, s.last_name, s.country, s.phone, s.email, s.created_at
  FROM employees s
  WHERE NOT EXISTS (
    SELECT 1
    FROM employee_applications a
    WHERE a.email COLLATE utf8mb4_general_ci = s.email COLLATE utf8mb4_general_ci
  )
  ORDER BY s.created_at DESC, s.id DESC
";
$rows_q = mysqli_query($conn, $sql);
$total_without_app = $rows_q ? mysqli_num_rows($rows_q) : 0;

/* Quick context counts */
$all_employees_q = mysqli_query($conn, "SELECT COUNT(*) c FROM employees");
$all_employees   = $all_employees_q ? (int)mysqli_fetch_assoc($all_employees_q)['c'] : 0;
$all_apps_q     = mysqli_query($conn, "SELECT COUNT(*) c FROM employee_applications");
$all_apps       = $all_apps_q ? (int)mysqli_fetch_assoc($all_apps_q)['c'] : 0;
?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>employees Without Applications</title>
  <?php include __DIR__ . '/../partials/head.php'; ?>
  <style>
    .page-title{display:flex;align-items:center;gap:.75rem}
    .page-title .dot{width:10px;height:10px;border-radius:50%;background:var(--bs-primary)}
    .card-soft{border:0;box-shadow:0 4px 18px rgba(0,0,0,.08);border-radius:1rem}
    .toolbar{display:flex;flex-wrap:wrap;gap:.75rem;align-items:center}
    .search-wrap{position:relative;min-width:240px}
    .search-wrap input{padding-left:2.25rem}
    .search-wrap .bi{position:absolute;left:.65rem;top:50%;transform:translateY(-50%);opacity:.6}
    .table thead th{position:sticky;top:0;background:var(--bs-dark);color:#fff;z-index:1}
    .table-hover tbody tr:hover{background:rgba(13,110,253,.04)}
    .chip{display:inline-flex;align-items:center;gap:.5rem;border:1px solid var(--bs-border-color);padding:.35rem .65rem;border-radius:999px;background:#fff}
    .chip .bi{opacity:.7}
    .btn-icon{display:inline-flex;align-items:center;gap:.35rem}
    .small-muted{font-size:.875rem;color:#6c757d}
    @media (max-width: 575.98px){
      .toolbar{flex-direction:column;align-items:stretch}
      .search-wrap{min-width:100%}
    }
  </style>
</head>
<body class="d-flex flex-column min-vh-100">
  <div class="page-wrapper d-flex flex-column flex-grow-1" id="main-wrapper" data-layout="vertical" data-navbarbg="skin6" data-sidebartype="full" data-sidebar-position="fixed" data-header-position="fixed">
    <?php
      include __DIR__ . '/../partials/header.php';
      include __DIR__ . '/../partials/sidebar.php';
    ?>
    <div class="body-wrapper">
      <div class="body-wrapper-inner container-fluid py-4">
        <div class="d-flex flex-wrap align-items-center justify-content-between mb-4">
          <div class="page-title">
            <span class="dot"></span>
            <div>
              <h2 class="mb-0">employees Without Applications</h2>
              <div class="text-muted small">Emails present in <code>employees</code> but not in <code>employee_applications</code> (collation aligned).</div>
            </div>
          </div>
          <div class="d-flex flex-wrap gap-2">
            <span class="chip"><i class="bi bi-people"></i>Total employees: <strong><?= number_format($all_employees) ?></strong></span>
            <span class="chip"><i class="bi bi-inbox"></i>Total Applications: <strong><?= number_format($all_apps) ?></strong></span>
            <span class="chip"><i class="bi bi-envelope-exclamation"></i>Without Application: <strong><?= number_format($total_without_app) ?></strong></span>
          </div>
        </div>

        <div class="card card-soft">
          <div class="card-body">
            <div class="toolbar mb-3">
              <div class="search-wrap">
                <i class="bi bi-search"></i>
                <input id="tableSearch" type="text" class="form-control" placeholder="Search name, email, country, phone...">
              </div>
              <div class="d-flex align-items-center gap-2">
                <label for="rowsPerPage" class="text-muted small mb-0">Rows:</label>
                <select id="rowsPerPage" class="form-select form-select-sm" style="width:auto">
                  <option value="10">10</option>
                  <option value="25">25</option>
                  <option value="50">50</option>
                  <option value="500">500</option>
                  <option value="all">All</option>
                </select>
              </div>
              <div class="ms-auto d-flex gap-2">
                <button id="btnRefresh" class="btn btn-light btn-icon"><i class="bi bi-arrow-clockwise"></i><span>Refresh</span></button>
                <button id="btnExport" class="btn btn-outline-primary btn-icon"><i class="bi bi-filetype-csv"></i><span>Export CSV</span></button>
              </div>
            </div>

            <div class="table-responsive">
              <table id="employeesTable" class="table table-hover align-middle mb-3">
                <thead class="table-dark">
                  <tr>
                    <th style="width:72px">ID</th>
                    <th>First Name</th>
                    <th>Last Name</th>
                    <th>Country</th>
                    <th>Phone</th>
                    <th>Email</th>
                    <th style="width:210px">Registration Date</th>
                  </tr>
                </thead>
                <tbody>
                  <?php if ($rows_q && mysqli_num_rows($rows_q)>0): ?>
                    <?php while($r = mysqli_fetch_assoc($rows_q)): ?>
                      <tr class="data-row">
                        <td class="text-muted"><?= (int)$r['id'] ?></td>
                        <td class="fw-semibold"><?= htmlspecialchars($r['first_name'] ?? '') ?></td>
                        <td><?= htmlspecialchars($r['last_name'] ?? '') ?></td>
                        <td><span class="small-muted"><?= htmlspecialchars($r['country'] ?? '') ?></span></td>
                        <td><a href="tel:<?= htmlspecialchars($r['phone'] ?? '') ?>" class="text-decoration-none"><?= htmlspecialchars($r['phone'] ?? '') ?></a></td>
                        <td><a href="mailto:<?= htmlspecialchars($r['email'] ?? '') ?>" class="text-decoration-none"><?= htmlspecialchars($r['email'] ?? '') ?></a></td>
                        <td class="text-muted small">
                          <?= !empty($r['created_at']) ? date('d M Y, h:i A', strtotime($r['created_at'])) : '-' ?>
                        </td>
                      </tr>
                    <?php endwhile; ?>
                  <?php else: ?>
                    <tr><td colspan="7" class="text-center text-muted py-5">No records found.</td></tr>
                  <?php endif; ?>
                </tbody>
              </table>
            </div>

            <div class="d-flex flex-wrap align-items-center justify-content-between">
              <div class="small text-muted"><span id="rowsInfo">0</span> rows</div>
              <nav><ul class="pagination mb-0" id="pager"></ul></nav>
            </div>

          </div>
        </div>
      </div>
    </div>
    <?php include __DIR__ . '/../partials/footer.php'; ?>
  </div>

  <script>
    (function(){
      const table = document.getElementById('employeesTable');
      const tbody = table.querySelector('tbody');
      const search = document.getElementById('tableSearch');
      const rowsPerPageSel = document.getElementById('rowsPerPage');
      const pager = document.getElementById('pager');
      const rowsInfo = document.getElementById('rowsInfo');
      const refreshBtn = document.getElementById('btnRefresh');
      const exportBtn = document.getElementById('btnExport');

      let allRows = Array.from(tbody.querySelectorAll('tr.data-row'));
      let filtered = allRows.slice();
      let page = 1;
      let rpp = rowsPerPageSel.value;

      function normalize(s){ return (s||'').toString().toLowerCase().trim(); }

      function applyFilter(){
        const q = normalize(search.value);
        filtered = allRows.filter(tr=>{
          if(!q) return true;
          return normalize(tr.innerText).includes(q);
        });
        page = 1;
        render();
      }

      function render(){
        rpp = rowsPerPageSel.value;
        const perPage = (rpp==='all') ? filtered.length || 1 : parseInt(rpp,10);

        allRows.forEach(tr=>tr.style.display='none');

        const total = filtered.length;
        const totalPages = Math.max(1, Math.ceil(total / perPage));
        if(page>totalPages) page = totalPages;
        const start = (page-1)*perPage;
        const end   = (rpp==='all') ? total : Math.min(start+perPage, total);

        for(let i=start;i<end;i++){ filtered[i].style.display=''; }

        rowsInfo.textContent = total;

        pager.innerHTML = '';
        function addItem(txt, p, disabled=false, active=false){
          const li = document.createElement('li');
          li.className = 'page-item' + (disabled?' disabled':'') + (active?' active':'');
          const a = document.createElement('a');
          a.className = 'page-link';
          a.href = '#';
          a.textContent = txt;
          a.onclick = (e)=>{ e.preventDefault(); if(!disabled){ page = p; render(); } };
          li.appendChild(a);
          pager.appendChild(li);
        }
        addItem('«', 1, page===1);
        addItem('‹', Math.max(1,page-1), page===1);
        const windowSize = 5;
        let startP = Math.max(1, page - Math.floor(windowSize/2));
        let endP   = Math.min(totalPages, startP + windowSize - 1);
        startP = Math.max(1, Math.min(startP, endP - windowSize + 1));
        for(let p=startP;p<=endP;p++){ addItem(p, p, false, p===page); }
        addItem('›', Math.min(totalPages,page+1), page===totalPages);
        addItem('»', totalPages, page===totalPages);
      }

      search.addEventListener('input', applyFilter);
      rowsPerPageSel.addEventListener('change', function(){ page=1; render(); });
      refreshBtn.addEventListener('click', function(){ location.reload(); });

      exportBtn.addEventListener('click', function(){
        const headers = ['ID','First Name','Last Name','Country','Phone','Email','Registration Date'];
        const lines = [headers.join(',')];
        filtered.forEach(tr=>{
          const cells = Array.from(tr.querySelectorAll('td')).map(td=>{
            const v = td.innerText.replace(/\r?\n|\r/g,' ').trim().replace(/"/g,'""');
            return `"${v}"`;
          });
          lines.push(cells.join(','));
        });
        const blob = new Blob([lines.join('\n')], {type:'text/csv;charset=utf-8;'});
        const url = URL.createObjectURL(blob);
        const a = document.createElement('a');
        a.href = url;
        a.download = 'employees_without_applications.csv';
        document.body.appendChild(a);
        a.click();
        document.body.removeChild(a);
        URL.revokeObjectURL(url);
      });

      render();
    })();
  </script>
</body>
</html>
